// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `SentenceBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html) for more information.
 */


export class SentenceBreak {
    #value = undefined;

    static #values = new Map([
        ["Other", 0],
        ["ATerm", 1],
        ["Close", 2],
        ["Format", 3],
        ["Lower", 4],
        ["Numeric", 5],
        ["OLetter", 6],
        ["Sep", 7],
        ["Sp", 8],
        ["STerm", 9],
        ["Upper", 10],
        ["Cr", 11],
        ["Extend", 12],
        ["Lf", 13],
        ["SContinue", 14]
    ]);

    static getAllEntries() {
        return SentenceBreak.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return SentenceBreak.#objectValues[arguments[1]];
        }

        if (value instanceof SentenceBreak) {
            return value;
        }

        let intVal = SentenceBreak.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return SentenceBreak.#objectValues[intVal];
        }

        throw TypeError(value + " is not a SentenceBreak and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new SentenceBreak(value);
    }

    get value(){
        return [...SentenceBreak.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 13),
        new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
    ];

    static Other = SentenceBreak.#objectValues[0];
    static ATerm = SentenceBreak.#objectValues[1];
    static Close = SentenceBreak.#objectValues[2];
    static Format = SentenceBreak.#objectValues[3];
    static Lower = SentenceBreak.#objectValues[4];
    static Numeric = SentenceBreak.#objectValues[5];
    static OLetter = SentenceBreak.#objectValues[6];
    static Sep = SentenceBreak.#objectValues[7];
    static Sp = SentenceBreak.#objectValues[8];
    static STerm = SentenceBreak.#objectValues[9];
    static Upper = SentenceBreak.#objectValues[10];
    static Cr = SentenceBreak.#objectValues[11];
    static Extend = SentenceBreak.#objectValues[12];
    static Lf = SentenceBreak.#objectValues[13];
    static SContinue = SentenceBreak.#objectValues[14];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_SentenceBreak_for_char_mv1(ch);

        try {
            return new SentenceBreak(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_SentenceBreak_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_SentenceBreak_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_SentenceBreak_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_SentenceBreak_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new SentenceBreak(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}