// generated by diplomat-tool
import type { CodePointRangeIterator } from "./CodePointRangeIterator"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { ScriptWithExtensionsBorrowed } from "./ScriptWithExtensionsBorrowed"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X ScriptWithExtensions map object, capable of holding a map of codepoints to scriptextensions values
 *
 * See the [Rust documentation for `ScriptWithExtensions`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensions.html) for more information.
 */


export class ScriptWithExtensions {
    get ffiValue(): pointer;


    /**
     * Create a map for the `Script`/`Script_Extensions` properties, using compiled data.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensions.html#method.new) for more information.
     */
    static createWithProvider(provider: DataProvider): ScriptWithExtensions;

    /**
     * Get the Script property value for a code point
     *
     * See the [Rust documentation for `get_script_val`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensionsBorrowed.html#method.get_script_val) for more information.
     */
    getScriptVal(ch: codepoint): number;

    /**
     * Check if the Script_Extensions property of the given code point covers the given script
     *
     * See the [Rust documentation for `has_script`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensionsBorrowed.html#method.has_script) for more information.
     */
    hasScript(ch: codepoint, script: number): boolean;

    /**
     * Borrow this object for a slightly faster variant with more operations
     *
     * See the [Rust documentation for `as_borrowed`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensions.html#method.as_borrowed) for more information.
     */
    get asBorrowed(): ScriptWithExtensionsBorrowed;

    /**
     * Get a list of ranges of code points that contain this script in their Script_Extensions values
     *
     * See the [Rust documentation for `get_script_extensions_ranges`](https://docs.rs/icu/latest/icu/properties/script/struct.ScriptWithExtensionsBorrowed.html#method.get_script_extensions_ranges) for more information.
     */
    iterRangesForScript(script: number): CodePointRangeIterator;

    constructor();
}