// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { GeneralCategoryGroup } from "./GeneralCategoryGroup"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * A type capable of looking up General Category Group values from a string name.
 *
 * See the [Rust documentation for `PropertyParser`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParser.html) for more information.
 *
 * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
 */


export class GeneralCategoryNameToGroupMapper {
    get ffiValue(): pointer;


    /**
     * Get the mask value matching the given name, using strict matching
     *
     * Returns 0 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_strict`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_strict) for more information.
     */
    getStrict(name: string): GeneralCategoryGroup;

    /**
     * Get the mask value matching the given name, using loose matching
     *
     * Returns 0 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_loose`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_loose) for more information.
     */
    getLoose(name: string): GeneralCategoryGroup;

    /**
     * Create a name-to-mask mapper for the `General_Category` property, using a particular data source.
     *
     * See the [Rust documentation for `GeneralCategoryGroup`](https://docs.rs/icu/latest/icu/properties/props/struct.GeneralCategoryGroup.html) for more information.
     */
    static createWithProvider(provider: DataProvider): GeneralCategoryNameToGroupMapper;

    constructor();
}