// generated by diplomat-tool
import { CollatorAlternateHandling } from "./CollatorAlternateHandling.mjs"
import { CollatorCaseLevel } from "./CollatorCaseLevel.mjs"
import { CollatorMaxVariable } from "./CollatorMaxVariable.mjs"
import { CollatorStrength } from "./CollatorStrength.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `CollatorOptions`](https://docs.rs/icu/latest/icu/collator/options/struct.CollatorOptions.html) for more information.
 */


export class CollatorOptions {
    #strength;
    get strength() {
        return this.#strength;
    }
    set strength(value){
        this.#strength = value;
    }
    #alternateHandling;
    get alternateHandling() {
        return this.#alternateHandling;
    }
    set alternateHandling(value){
        this.#alternateHandling = value;
    }
    #maxVariable;
    get maxVariable() {
        return this.#maxVariable;
    }
    set maxVariable(value){
        this.#maxVariable = value;
    }
    #caseLevel;
    get caseLevel() {
        return this.#caseLevel;
    }
    set caseLevel(value){
        this.#caseLevel = value;
    }
    /** Create `CollatorOptions` from an object that contains all of `CollatorOptions`s fields.
    * Optional fields do not need to be included in the provided object.
    */
    static fromFields(structObj) {
        return new CollatorOptions(structObj);
    }

    #internalConstructor(structObj) {
        if (typeof structObj !== "object") {
            throw new Error("CollatorOptions's constructor takes an object of CollatorOptions's fields.");
        }

        if ("strength" in structObj) {
            this.#strength = structObj.strength;
        } else {
            this.#strength = null;
        }

        if ("alternateHandling" in structObj) {
            this.#alternateHandling = structObj.alternateHandling;
        } else {
            this.#alternateHandling = null;
        }

        if ("maxVariable" in structObj) {
            this.#maxVariable = structObj.maxVariable;
        } else {
            this.#maxVariable = null;
        }

        if ("caseLevel" in structObj) {
            this.#caseLevel = structObj.caseLevel;
        } else {
            this.#caseLevel = null;
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [...diplomatRuntime.optionToArgsForCalling(this.#strength, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]), ...diplomatRuntime.optionToArgsForCalling(this.#alternateHandling, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]), ...diplomatRuntime.optionToArgsForCalling(this.#maxVariable, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]), ...diplomatRuntime.optionToArgsForCalling(this.#caseLevel, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)])]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof CollatorOptions) {
            return obj;
        }

        return CollatorOptions.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 0, this.#strength, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 8, this.#alternateHandling, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 16, this.#maxVariable, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 24, this.#caseLevel, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array));
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("CollatorOptions._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const strengthDeref = ptr;
        structObj.strength = diplomatRuntime.readOption(wasm, strengthDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new CollatorStrength(diplomatRuntime.internalConstructor, deref) });
        const alternateHandlingDeref = ptr + 8;
        structObj.alternateHandling = diplomatRuntime.readOption(wasm, alternateHandlingDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new CollatorAlternateHandling(diplomatRuntime.internalConstructor, deref) });
        const maxVariableDeref = ptr + 16;
        structObj.maxVariable = diplomatRuntime.readOption(wasm, maxVariableDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new CollatorMaxVariable(diplomatRuntime.internalConstructor, deref) });
        const caseLevelDeref = ptr + 24;
        structObj.caseLevel = diplomatRuntime.readOption(wasm, caseLevelDeref, 4, (wasm, offset) => { const deref = diplomatRuntime.enumDiscriminant(wasm, offset); return new CollatorCaseLevel(diplomatRuntime.internalConstructor, deref) });

        return new CollatorOptions(structObj);
    }


    constructor(structObj) {
        return this.#internalConstructor(...arguments)
    }
}