/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.IntKeyMap;

public class AltibasePlanNode
extends AbstractExecutionPlanNode {
    private final AltibaseDataSource dataSource;
    private static final List<String> allowedKind = new ArrayList<String>(Arrays.asList("SCAN", "VIEW", "PROJECT", "FILTER", "SORT", "HASH", "AGGREGATION", "JOIN", "MERGE", "UNION", "CONCATENATION", "GROUP", "INSERT", "UPDATE", "DELETE"));
    private int id;
    private int parentId;
    private int depth;
    private String plan;
    AltibasePlanNode parent;
    private final List<AltibasePlanNode> nested = new ArrayList<AltibasePlanNode>();
    private String operation;
    private String options;

    public AltibasePlanNode(AltibaseDataSource dataSource, int id, int depth, String plan, AltibasePlanNode parent) {
        this.id = id;
        this.dataSource = dataSource;
        this.depth = depth;
        this.plan = plan;
        this.parent = parent;
        if (this.parent == null) {
            this.parentId = 0;
        } else {
            this.parent.addChildNode(this);
            this.parentId = this.parent.getId();
        }
        this.setOperation();
    }

    public AltibasePlanNode(AltibaseDataSource dataSource, IntKeyMap<AltibasePlanNode> prevNodes, Map<String, Object> attributes) {
        this.dataSource = dataSource;
        this.id = JSONUtils.getInteger(attributes, (String)"id");
        this.depth = JSONUtils.getInteger(attributes, (String)"depth");
        this.plan = JSONUtils.getString(attributes, (String)"plan");
        this.setOperation();
        Integer parentIdFromMap = JSONUtils.getInteger(attributes, (String)"parent_id");
        if (parentIdFromMap != null) {
            this.parent = (AltibasePlanNode)((Object)prevNodes.get((Object)parentIdFromMap));
        }
        if (this.parent != null) {
            this.parent.addChildNode(this);
        }
    }

    private void setOperation() {
        if (this.plan.contains("(")) {
            String[] splittedPlan = this.plan.trim().split("\\(");
            this.operation = splittedPlan[0].trim();
            this.options = splittedPlan[1].replace(")", "").trim();
        } else {
            this.operation = this.plan.trim();
            this.options = "";
        }
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void addChildNode(AltibasePlanNode node) {
        this.nested.add(node);
    }

    public String getNodeName() {
        return this.operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOptions() {
        return this.options;
    }

    public DBCPlanNode getParent() {
        return this.parent;
    }

    public Collection<? extends DBCPlanNode> getNested() {
        return this.nested;
    }

    public int getDepth() {
        return this.depth;
    }

    @Property(order=1, viewable=true)
    public String getPlanString() {
        if (this.dataSource.getContainer().getPreferenceStore().getBoolean("altibase.plan.prefix")) {
            return AltibasePlanNode.getPrefix(this.depth) + this.plan;
        }
        return this.plan;
    }

    public String getPlan() {
        return this.plan;
    }

    public String toString() {
        return this.getPlanString();
    }

    private static String getPrefix(int depth) {
        StringBuilder sb = new StringBuilder();
        if (depth > 0) {
            sb.append("\u2514");
            int i = 0;
            while (i < depth) {
                sb.append('-');
                ++i;
            }
        }
        return sb.toString();
    }

    public String toString4Debug() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[depth:%3d] ", this.depth));
        int i = 0;
        while (i < this.depth) {
            sb.append("-");
            ++i;
        }
        sb.append(this.plan).append(AltibaseConstants.NEW_LINE);
        for (AltibasePlanNode node : this.nested) {
            sb.append(node.toString4Debug());
        }
        return sb.toString();
    }

    public AltibasePlanNode getParentNodeAtDepth(int depth) {
        if (this.depth > depth) {
            return this.parent.getParentNodeAtDepth(depth);
        }
        if (this.depth == depth) {
            return this.parent;
        }
        throw new IllegalArgumentException("Argument depth: " + depth + ", this.depth: " + this.depth);
    }

    public String getNodeType() {
        return this.operation;
    }

    public DBCPlanNodeKind getNodeKind() {
        for (String kind : allowedKind) {
            if (!this.operation.contains(kind)) continue;
            switch (kind) {
                case "SCAN": {
                    if (this.options.contains("FULL SCAN")) {
                        return DBCPlanNodeKind.TABLE_SCAN;
                    }
                    return DBCPlanNodeKind.INDEX_SCAN;
                }
                case "VIEW": {
                    return DBCPlanNodeKind.SELECT;
                }
                case "PROJECT": {
                    return DBCPlanNodeKind.SET;
                }
                case "FILTER": {
                    return DBCPlanNodeKind.FILTER;
                }
                case "SORT": {
                    return DBCPlanNodeKind.SORT;
                }
                case "HASH": {
                    return DBCPlanNodeKind.HASH;
                }
                case "GROUP": {
                    return DBCPlanNodeKind.GROUP;
                }
                case "AGGREGATION": {
                    return DBCPlanNodeKind.AGGREGATE;
                }
                case "MERGE": {
                    return DBCPlanNodeKind.MERGE;
                }
                case "JOIN": {
                    return DBCPlanNodeKind.JOIN;
                }
                case "UNION": {
                    return DBCPlanNodeKind.UNION;
                }
                case "UPDATE": 
                case "INERT": 
                case "DELETE": {
                    return DBCPlanNodeKind.MODIFY;
                }
            }
            return DBCPlanNodeKind.DEFAULT;
        }
        return DBCPlanNodeKind.DEFAULT;
    }
}

