/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.HashSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeDriver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeProvider;
import org.jkiss.utils.CommonUtils;

public class SQLContextTypeRegistry
extends ContextTypeRegistry {
    public SQLContextTypeRegistry() {
        this.loadContextTypes();
    }

    private void loadContextTypes() {
        this.addContextType(new SQLContextTypeBase());
        for (DBPDataSourceProviderDescriptor provider : DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders()) {
            if (!provider.isDriversManageable()) {
                SQLContextTypeProvider contextType = new SQLContextTypeProvider(provider);
                this.addContextType(contextType);
                continue;
            }
            HashSet<String> categoriesAdded = new HashSet<String>();
            for (DBPDriver driver : provider.getDrivers()) {
                if (driver.getReplacedBy() != null) continue;
                if (!CommonUtils.isEmpty((String)driver.getCategory())) {
                    if (categoriesAdded.contains(driver.getCategory())) continue;
                    categoriesAdded.add(driver.getCategory());
                }
                SQLContextTypeDriver contextType = new SQLContextTypeDriver(driver);
                this.addContextType(contextType);
            }
        }
    }
}

