/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPTestUtils {
    private LDAPTestUtils() {
    }

    @NotNull
    public static Entry generateDomainEntry(@NotNull String name, @Nullable String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateDomainEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    @NotNull
    public static Entry generateDomainEntry(@NotNull String name, @Nullable String parentDN, @Nullable Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("dc", name, parentDN, new String[]{"top", "domain"}, additionalAttributes);
    }

    @NotNull
    public static Entry generateOrgEntry(@NotNull String name, @Nullable String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateOrgEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    @NotNull
    public static Entry generateOrgEntry(@NotNull String name, @Nullable String parentDN, @Nullable Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("o", name, parentDN, new String[]{"top", "organization"}, additionalAttributes);
    }

    @NotNull
    public static Entry generateOrgUnitEntry(@NotNull String name, @Nullable String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateOrgUnitEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    @NotNull
    public static Entry generateOrgUnitEntry(@NotNull String name, @Nullable String parentDN, @Nullable Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("ou", name, parentDN, new String[]{"top", "organizationalUnit"}, additionalAttributes);
    }

    @NotNull
    public static Entry generateCountryEntry(@NotNull String name, @Nullable String parentDN, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateCountryEntry(name, parentDN, StaticUtils.toList(additionalAttributes));
    }

    @NotNull
    public static Entry generateCountryEntry(@NotNull String name, @Nullable String parentDN, @Nullable Collection<Attribute> additionalAttributes) {
        return LDAPTestUtils.generateEntry("c", name, parentDN, new String[]{"top", "country"}, additionalAttributes);
    }

    @NotNull
    public static Entry generateUserEntry(@NotNull String uid, @Nullable String parentDN, @NotNull String firstName, @NotNull String lastName, @Nullable String password, Attribute ... additionalAttributes) {
        return LDAPTestUtils.generateUserEntry(uid, parentDN, firstName, lastName, password, StaticUtils.toList(additionalAttributes));
    }

    @NotNull
    public static Entry generateUserEntry(@NotNull String uid, @Nullable String parentDN, @NotNull String firstName, @NotNull String lastName, @Nullable String password, @Nullable Collection<Attribute> additionalAttributes) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(4);
        attrList.add(new Attribute("givenName", firstName));
        attrList.add(new Attribute("sn", lastName));
        attrList.add(new Attribute("cn", firstName + ' ' + lastName));
        if (password != null) {
            attrList.add(new Attribute("userPassword", password));
        }
        if (additionalAttributes != null) {
            attrList.addAll(additionalAttributes);
        }
        String[] objectClasses = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"};
        return LDAPTestUtils.generateEntry("uid", uid, parentDN, objectClasses, attrList);
    }

    @NotNull
    public static Entry generateGroupOfNamesEntry(@NotNull String name, @Nullable String parentDN, String ... memberDNs) {
        return LDAPTestUtils.generateGroupOfNamesEntry(name, parentDN, StaticUtils.toList(memberDNs));
    }

    @NotNull
    public static Entry generateGroupOfNamesEntry(@NotNull String name, @Nullable String parentDN, @NotNull Collection<String> memberDNs) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute("member", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), memberDNs));
        return LDAPTestUtils.generateEntry("cn", name, parentDN, new String[]{"top", "groupOfNames"}, attrList);
    }

    @NotNull
    public static Entry generateGroupOfUniqueNamesEntry(@NotNull String name, @Nullable String parentDN, String ... memberDNs) {
        return LDAPTestUtils.generateGroupOfUniqueNamesEntry(name, parentDN, StaticUtils.toList(memberDNs));
    }

    @NotNull
    public static Entry generateGroupOfUniqueNamesEntry(@NotNull String name, @Nullable String parentDN, @NotNull Collection<String> memberDNs) {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute("uniqueMember", (MatchingRule)DistinguishedNameMatchingRule.getInstance(), memberDNs));
        return LDAPTestUtils.generateEntry("cn", name, parentDN, new String[]{"top", "groupOfUniqueNames"}, attrList);
    }

    @NotNull
    private static Entry generateEntry(@NotNull String rdnAttr, @NotNull String rdnValue, @Nullable String parentDN, @NotNull String[] objectClasses, @Nullable Collection<Attribute> additionalAttributes) {
        RDN rdn = new RDN(rdnAttr, rdnValue);
        String dn = parentDN == null || parentDN.trim().isEmpty() ? rdn.toString() : rdn.toString() + ',' + parentDN;
        Entry entry = new Entry(dn, new Attribute("objectClass", objectClasses), new Attribute(rdnAttr, rdnValue));
        if (additionalAttributes != null) {
            for (Attribute a : additionalAttributes) {
                entry.addAttribute(a);
            }
        }
        return entry;
    }

    public static boolean entryExists(@NotNull LDAPInterface conn, @NotNull String dn) throws LDAPException {
        return conn.getEntry(dn, "1.1") != null;
    }

    public static boolean entryExists(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String filter) throws LDAPException {
        try {
            SearchResult searchResult = conn.search(dn, SearchScope.BASE, filter, "1.1");
            return searchResult.getEntryCount() == 1;
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return false;
            }
            throw le;
        }
    }

    public static boolean entryExists(@NotNull LDAPInterface conn, @NotNull Entry entry) throws LDAPException {
        Collection<Attribute> attrs = entry.getAttributes();
        ArrayList<Filter> comps = new ArrayList<Filter>(attrs.size());
        for (Attribute a : attrs) {
            for (byte[] value : a.getValueByteArrays()) {
                comps.add(Filter.createEqualityFilter(a.getName(), value));
            }
        }
        try {
            SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createANDFilter(comps), "1.1");
            return searchResult.getEntryCount() == 1;
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return false;
            }
            throw le;
        }
    }

    public static void assertEntryExists(@NotNull LDAPInterface conn, @NotNull String dn) throws LDAPException, AssertionError {
        if (conn.getEntry(dn, "1.1") == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
    }

    public static void assertEntryExists(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String filter) throws LDAPException, AssertionError {
        try {
            SearchResult searchResult = conn.search(dn, SearchScope.BASE, filter, "1.1");
            if (searchResult.getEntryCount() == 0) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_DOES_NOT_MATCH_FILTER.get(dn, filter));
            }
        }
        catch (LDAPException le) {
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
            }
            throw le;
        }
    }

    public static void assertEntryExists(@NotNull LDAPInterface conn, @NotNull Entry entry) throws LDAPException, AssertionError {
        if (LDAPTestUtils.entryExists(conn, entry)) {
            return;
        }
        Collection<Attribute> attributes = entry.getAttributes();
        ArrayList<String> messages = new ArrayList<String>(attributes.size());
        for (Attribute a : attributes) {
            try {
                SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createPresenceFilter(a.getName()), "1.1");
                if (searchResult.getEntryCount() == 0) {
                    messages.add(UtilityMessages.ERR_TEST_ATTR_MISSING.get(entry.getDN(), a.getName()));
                    continue;
                }
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(entry.getDN()));
                }
                throw le;
            }
            for (byte[] value : a.getValueByteArrays()) {
                SearchResult searchResult = conn.search(entry.getDN(), SearchScope.BASE, Filter.createEqualityFilter(a.getName(), value), "1.1");
                if (searchResult.getEntryCount() != 0) continue;
                messages.add(UtilityMessages.ERR_TEST_VALUE_MISSING.get(entry.getDN(), a.getName(), StaticUtils.toUTF8String(value)));
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    @NotNull
    public static List<String> getMissingEntryDNs(@NotNull LDAPInterface conn, String ... dns) throws LDAPException {
        return LDAPTestUtils.getMissingEntryDNs(conn, StaticUtils.toList(dns));
    }

    @NotNull
    public static List<String> getMissingEntryDNs(@NotNull LDAPInterface conn, @NotNull Collection<String> dns) throws LDAPException {
        ArrayList<String> missingDNs = new ArrayList<String>(dns.size());
        for (String dn : dns) {
            if (conn.getEntry(dn, "1.1") != null) continue;
            missingDNs.add(dn);
        }
        return missingDNs;
    }

    public static void assertEntriesExist(@NotNull LDAPInterface conn, String ... dns) throws LDAPException, AssertionError {
        LDAPTestUtils.assertEntriesExist(conn, StaticUtils.toList(dns));
    }

    public static void assertEntriesExist(@NotNull LDAPInterface conn, @NotNull Collection<String> dns) throws LDAPException, AssertionError {
        List<String> missingDNs = LDAPTestUtils.getMissingEntryDNs(conn, dns);
        if (missingDNs.isEmpty()) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>(missingDNs.size());
        for (String dn : missingDNs) {
            msgList.add(UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        throw new AssertionError((Object)StaticUtils.concatenateStrings(msgList));
    }

    @Nullable
    public static List<String> getMissingAttributeNames(@NotNull LDAPInterface conn, @NotNull String dn, String ... attributeNames) throws LDAPException {
        return LDAPTestUtils.getMissingAttributeNames(conn, dn, StaticUtils.toList(attributeNames));
    }

    @Nullable
    public static List<String> getMissingAttributeNames(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException {
        ArrayList<String> missingAttrs = new ArrayList<String>(attributeNames.size());
        for (String attrName : attributeNames) {
            try {
                SearchResult result = conn.search(dn, SearchScope.BASE, Filter.createPresenceFilter(attrName), new String[0]);
                if (result.getEntryCount() != 0) continue;
                missingAttrs.add(attrName);
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    return null;
                }
                throw le;
            }
        }
        return missingAttrs;
    }

    public static void assertAttributeExists(@NotNull LDAPInterface conn, @NotNull String dn, String ... attributeNames) throws LDAPException, AssertionError {
        LDAPTestUtils.assertAttributeExists(conn, dn, StaticUtils.toList(attributeNames));
    }

    public static void assertAttributeExists(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException, AssertionError {
        List<String> missingAttrs = LDAPTestUtils.getMissingAttributeNames(conn, dn, attributeNames);
        if (missingAttrs == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        if (missingAttrs.isEmpty()) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>(missingAttrs.size());
        for (String attrName : missingAttrs) {
            msgList.add(UtilityMessages.ERR_TEST_ATTR_MISSING.get(dn, attrName));
        }
        throw new AssertionError((Object)StaticUtils.concatenateStrings(msgList));
    }

    @Nullable
    public static List<String> getMissingAttributeValues(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException {
        return LDAPTestUtils.getMissingAttributeValues(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    @Nullable
    public static List<String> getMissingAttributeValues(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException {
        ArrayList<String> missingValues = new ArrayList<String>(attributeValues.size());
        for (String value : attributeValues) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createEqualityFilter(attributeName, value), "1.1");
                if (searchResult.getEntryCount() != 0) continue;
                missingValues.add(value);
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    return null;
                }
                throw le;
            }
        }
        return missingValues;
    }

    public static void assertValueExists(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        LDAPTestUtils.assertValueExists(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public static void assertValueExists(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException, AssertionError {
        List<String> missingValues = LDAPTestUtils.getMissingAttributeValues(conn, dn, attributeName, attributeValues);
        if (missingValues == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
        }
        if (missingValues.isEmpty()) {
            return;
        }
        SearchResultEntry entry = conn.getEntry(dn, attributeName);
        if (entry != null && entry.hasAttribute(attributeName)) {
            Attribute a = entry.getAttribute(attributeName);
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ATTR_MISSING_VALUE.get(dn, attributeName, StaticUtils.concatenateStrings("{", " '", ",", "'", " }", a.getValues()), StaticUtils.concatenateStrings("{", " '", ",", "'", " }", missingValues)));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_ATTR_MISSING.get(dn, attributeName));
    }

    public static void assertEntryMissing(@NotNull LDAPInterface conn, @NotNull String dn) throws LDAPException, AssertionError {
        if (conn.getEntry(dn, "1.1") != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_EXISTS.get(dn));
        }
    }

    public static void assertAttributeMissing(@NotNull LDAPInterface conn, @NotNull String dn, String ... attributeNames) throws LDAPException, AssertionError {
        LDAPTestUtils.assertAttributeMissing(conn, dn, StaticUtils.toList(attributeNames));
    }

    public static void assertAttributeMissing(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException, AssertionError {
        ArrayList<String> messages = new ArrayList<String>(attributeNames.size());
        for (String attrName : attributeNames) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createPresenceFilter(attrName), attrName);
                if (searchResult.getEntryCount() != 1) continue;
                Attribute a = searchResult.getSearchEntries().get(0).getAttribute(attrName);
                if (a == null) {
                    messages.add(UtilityMessages.ERR_TEST_ATTR_EXISTS.get(dn, attrName));
                    continue;
                }
                messages.add(UtilityMessages.ERR_TEST_ATTR_EXISTS_WITH_VALUES.get(dn, attrName, StaticUtils.concatenateStrings("{", " '", ",", "'", " }", a.getValues())));
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
                }
                throw le;
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public static void assertValueMissing(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        LDAPTestUtils.assertValueMissing(conn, dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public static void assertValueMissing(@NotNull LDAPInterface conn, @NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException, AssertionError {
        ArrayList<String> messages = new ArrayList<String>(attributeValues.size());
        for (String value : attributeValues) {
            try {
                SearchResult searchResult = conn.search(dn, SearchScope.BASE, Filter.createEqualityFilter(attributeName, value), "1.1");
                if (searchResult.getEntryCount() != 1) continue;
                messages.add(UtilityMessages.ERR_TEST_VALUE_EXISTS.get(dn, attributeName, value));
            }
            catch (LDAPException le) {
                if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                    throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING.get(dn));
                }
                throw le;
            }
        }
        if (!messages.isEmpty()) {
            throw new AssertionError((Object)StaticUtils.concatenateStrings(messages));
        }
    }

    public static void assertResultCodeEquals(@NotNull LDAPResult result, ResultCode ... acceptableResultCodes) throws AssertionError {
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            return;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(String.valueOf(result), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(String.valueOf(result), Arrays.toString(acceptableResultCodes)));
    }

    public static void assertResultCodeEquals(@NotNull LDAPException exception, ResultCode ... acceptableResultCodes) throws AssertionError {
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(exception.getResultCode())) continue;
            return;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(StaticUtils.getExceptionMessage(exception), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(StaticUtils.getExceptionMessage(exception), Arrays.toString(acceptableResultCodes)));
    }

    @NotNull
    public static LDAPResult assertResultCodeEquals(@NotNull LDAPConnection conn, @NotNull LDAPRequest request, ResultCode ... acceptableResultCodes) throws AssertionError {
        LDAPResult result;
        try {
            result = conn.processOperation(request);
        }
        catch (LDAPException le) {
            result = le.toLDAPResult();
        }
        for (ResultCode rc : acceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            return result;
        }
        if (acceptableResultCodes.length == 1) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_MISSING.get(String.valueOf(result), String.valueOf(acceptableResultCodes[0])));
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_MISSING.get(String.valueOf(result), Arrays.toString(acceptableResultCodes)));
    }

    public static void assertResultCodeNot(@NotNull LDAPResult result, ResultCode ... unacceptableResultCodes) throws AssertionError {
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(String.valueOf(result), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(String.valueOf(result), Arrays.toString(unacceptableResultCodes)));
        }
    }

    public static void assertResultCodeNot(@NotNull LDAPException exception, ResultCode ... unacceptableResultCodes) throws AssertionError {
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(exception.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(StaticUtils.getExceptionMessage(exception), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(StaticUtils.getExceptionMessage(exception), Arrays.toString(unacceptableResultCodes)));
        }
    }

    @NotNull
    public static LDAPResult assertResultCodeNot(@NotNull LDAPConnection conn, @NotNull LDAPRequest request, ResultCode ... unacceptableResultCodes) throws AssertionError {
        LDAPResult result;
        try {
            result = conn.processOperation(request);
        }
        catch (LDAPException le) {
            result = le.toLDAPResult();
        }
        for (ResultCode rc : unacceptableResultCodes) {
            if (!rc.equals(result.getResultCode())) continue;
            if (unacceptableResultCodes.length == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SINGLE_RESULT_CODE_FOUND.get(String.valueOf(result), String.valueOf(unacceptableResultCodes[0])));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MULTI_RESULT_CODE_FOUND.get(String.valueOf(result), Arrays.toString(unacceptableResultCodes)));
        }
        return result;
    }

    public static void assertContainsMatchedDN(@NotNull LDAPResult result) throws AssertionError {
        if (result.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_MATCHED_DN.get(String.valueOf(result)));
        }
    }

    public static void assertContainsMatchedDN(@NotNull LDAPException exception) throws AssertionError {
        if (exception.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingMatchedDN(@NotNull LDAPResult result) throws AssertionError {
        if (result.getMatchedDN() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_MATCHED_DN.get(String.valueOf(result), result.getMatchedDN()));
        }
    }

    public static void assertMissingMatchedDN(@NotNull LDAPException exception) throws AssertionError {
        if (exception.getMatchedDN() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception), exception.getMatchedDN()));
        }
    }

    public static void assertMatchedDNEquals(@NotNull LDAPResult result, @NotNull String matchedDN) throws LDAPException, AssertionError {
        DN expectedDN;
        if (result.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_MATCHED_DN.get(String.valueOf(result), matchedDN));
        }
        DN foundDN = new DN(result.getMatchedDN());
        if (!foundDN.equals(expectedDN = new DN(matchedDN))) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MATCHED_DN_MISMATCH.get(String.valueOf(result), matchedDN, result.getMatchedDN()));
        }
    }

    public static void assertMatchedDNEquals(@NotNull LDAPException exception, @NotNull String matchedDN) throws LDAPException, AssertionError {
        DN expectedDN;
        if (exception.getMatchedDN() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_MATCHED_DN.get(StaticUtils.getExceptionMessage(exception), matchedDN));
        }
        DN foundDN = new DN(exception.getMatchedDN());
        if (!foundDN.equals(expectedDN = new DN(matchedDN))) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_MATCHED_DN_MISMATCH.get(StaticUtils.getExceptionMessage(exception), matchedDN, exception.getMatchedDN()));
        }
    }

    public static void assertContainsDiagnosticMessage(@NotNull LDAPResult result) throws AssertionError {
        if (result.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_DIAGNOSTIC_MESSAGE.get(String.valueOf(result)));
        }
    }

    public static void assertContainsDiagnosticMessage(@NotNull LDAPException exception) throws AssertionError {
        if (exception.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingDiagnosticMessage(@NotNull LDAPResult result) throws AssertionError {
        if (result.getDiagnosticMessage() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_DIAGNOSTIC_MESSAGE.get(String.valueOf(result), result.getDiagnosticMessage()));
        }
    }

    public static void assertMissingDiagnosticMessage(@NotNull LDAPException exception) throws AssertionError {
        if (exception.getDiagnosticMessage() != null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_CONTAINS_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception), exception.getDiagnosticMessage()));
        }
    }

    public static void assertDiagnosticMessageEquals(@NotNull LDAPResult result, @NotNull String diagnosticMessage) throws AssertionError {
        if (result.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_DIAGNOSTIC_MESSAGE.get(String.valueOf(result), diagnosticMessage));
        }
        if (!result.getDiagnosticMessage().equals(diagnosticMessage)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DIAGNOSTIC_MESSAGE_MISMATCH.get(String.valueOf(result), diagnosticMessage, result.getDiagnosticMessage()));
        }
    }

    public static void assertDiagnosticMessageEquals(@NotNull LDAPException exception, @NotNull String diagnosticMessage) throws AssertionError {
        if (exception.getDiagnosticMessage() == null) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_EXPECTED_DIAGNOSTIC_MESSAGE.get(StaticUtils.getExceptionMessage(exception), diagnosticMessage));
        }
        if (!exception.getDiagnosticMessage().equals(diagnosticMessage)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DIAGNOSTIC_MESSAGE_MISMATCH.get(StaticUtils.getExceptionMessage(exception), diagnosticMessage, exception.getDiagnosticMessage()));
        }
    }

    public static void assertHasReferral(@NotNull LDAPResult result) throws AssertionError {
        String[] referralURLs = result.getReferralURLs();
        if (referralURLs == null || referralURLs.length == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_REFERRAL.get(String.valueOf(result)));
        }
    }

    public static void assertHasReferral(@NotNull LDAPException exception) throws AssertionError {
        String[] referralURLs = exception.getReferralURLs();
        if (referralURLs == null || referralURLs.length == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_REFERRAL.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    public static void assertMissingReferral(@NotNull LDAPResult result) throws AssertionError {
        String[] referralURLs = result.getReferralURLs();
        if (referralURLs != null && referralURLs.length > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_REFERRAL.get(String.valueOf(result)));
        }
    }

    public static void assertMissingReferral(@NotNull LDAPException exception) throws AssertionError {
        String[] referralURLs = exception.getReferralURLs();
        if (referralURLs != null && referralURLs.length > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_REFERRAL.get(StaticUtils.getExceptionMessage(exception)));
        }
    }

    @NotNull
    public static Control assertHasControl(@NotNull LDAPResult result, @NotNull String oid) throws AssertionError {
        for (Control c : result.getResponseControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_CONTROL.get(String.valueOf(result), oid));
    }

    @NotNull
    public static Control assertHasControl(@NotNull LDAPException exception, @NotNull String oid) throws AssertionError {
        for (Control c : exception.getResponseControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_MISSING_CONTROL.get(StaticUtils.getExceptionMessage(exception), oid));
    }

    @NotNull
    public static Control assertHasControl(@NotNull SearchResultEntry entry, @NotNull String oid) throws AssertionError {
        for (Control c : entry.getControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_MISSING_CONTROL.get(String.valueOf(entry), oid));
    }

    @NotNull
    public static Control assertHasControl(@NotNull SearchResultReference reference, @NotNull String oid) throws AssertionError {
        for (Control c : reference.getControls()) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_REF_MISSING_CONTROL.get(String.valueOf(reference), oid));
    }

    public static void assertMissingControl(@NotNull LDAPResult result, @NotNull String oid) throws AssertionError {
        for (Control c : result.getResponseControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_CONTROL.get(String.valueOf(result), oid));
            }
        }
    }

    public static void assertMissingControl(@NotNull LDAPException exception, @NotNull String oid) throws AssertionError {
        for (Control c : exception.getResponseControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_RESULT_HAS_CONTROL.get(StaticUtils.getExceptionMessage(exception), oid));
            }
        }
    }

    public static void assertMissingControl(@NotNull SearchResultEntry entry, @NotNull String oid) throws AssertionError {
        for (Control c : entry.getControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_ENTRY_HAS_CONTROL.get(String.valueOf(entry), oid));
            }
        }
    }

    public static void assertMissingControl(@NotNull SearchResultReference reference, @NotNull String oid) throws AssertionError {
        for (Control c : reference.getControls()) {
            if (c.getOID().equals(oid)) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_REF_HAS_CONTROL.get(String.valueOf(reference), oid));
            }
        }
    }

    public static int assertEntryReturned(@NotNull SearchResult result) throws AssertionError {
        if (result.getEntryCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_ENTRIES_RETURNED.get(String.valueOf(result)));
        }
        return result.getEntryCount();
    }

    public static int assertEntryReturned(@NotNull LDAPSearchException exception) throws AssertionError {
        if (exception.getEntryCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_ENTRIES_RETURNED.get(StaticUtils.getExceptionMessage(exception)));
        }
        return exception.getEntryCount();
    }

    @NotNull
    public static SearchResultEntry assertEntryReturned(@NotNull SearchResult result, @NotNull String dn) throws LDAPException, AssertionError {
        DN parsedDN = new DN(dn);
        List<SearchResultEntry> entryList = result.getSearchEntries();
        if (entryList != null) {
            for (SearchResultEntry e : entryList) {
                if (!e.getParsedDN().equals(parsedDN)) continue;
                return e;
            }
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_NOT_RETURNED.get(String.valueOf(result), dn));
    }

    @NotNull
    public static SearchResultEntry assertEntryReturned(@NotNull LDAPSearchException exception, @NotNull String dn) throws LDAPException, AssertionError {
        DN parsedDN = new DN(dn);
        List<SearchResultEntry> entryList = exception.getSearchEntries();
        if (entryList != null) {
            for (SearchResultEntry e : entryList) {
                if (!e.getParsedDN().equals(parsedDN)) continue;
                return e;
            }
        }
        throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_NOT_RETURNED.get(StaticUtils.getExceptionMessage(exception), dn));
    }

    public static void assertNoEntriesReturned(@NotNull SearchResult result) throws AssertionError {
        if (result.getEntryCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRIES_RETURNED.get(String.valueOf(result), result.getEntryCount()));
        }
    }

    public static void assertNoEntriesReturned(@NotNull LDAPSearchException exception) throws AssertionError {
        if (exception.getEntryCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRIES_RETURNED.get(StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
        }
    }

    public static void assertEntriesReturnedEquals(@NotNull SearchResult result, int expectedEntryCount) throws AssertionError {
        if (result.getEntryCount() != expectedEntryCount) {
            if (expectedEntryCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_ONE_EXPECTED.get(String.valueOf(result), result.getEntryCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedEntryCount, String.valueOf(result), result.getEntryCount()));
        }
    }

    public static void assertEntriesReturnedEquals(@NotNull LDAPSearchException exception, int expectedEntryCount) throws AssertionError {
        if (exception.getEntryCount() != expectedEntryCount) {
            if (expectedEntryCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_ONE_EXPECTED.get(StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedEntryCount, StaticUtils.getExceptionMessage(exception), exception.getEntryCount()));
        }
    }

    public static int assertReferenceReturned(@NotNull SearchResult result) throws AssertionError {
        if (result.getReferenceCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_REFS_RETURNED.get(String.valueOf(result)));
        }
        return result.getReferenceCount();
    }

    public static int assertReferenceReturned(@NotNull LDAPSearchException exception) throws AssertionError {
        if (exception.getReferenceCount() == 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_NO_REFS_RETURNED.get(StaticUtils.getExceptionMessage(exception)));
        }
        return exception.getReferenceCount();
    }

    public static void assertNoReferencesReturned(@NotNull SearchResult result) throws AssertionError {
        if (result.getReferenceCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REFS_RETURNED.get(String.valueOf(result), result.getReferenceCount()));
        }
    }

    public static void assertNoReferencesReturned(@NotNull LDAPSearchException exception) throws AssertionError {
        if (exception.getReferenceCount() > 0) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REFS_RETURNED.get(StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
        }
    }

    public static void assertReferencesReturnedEquals(@NotNull SearchResult result, int expectedReferenceCount) throws AssertionError {
        if (result.getReferenceCount() != expectedReferenceCount) {
            if (expectedReferenceCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_ONE_EXPECTED.get(String.valueOf(result), result.getReferenceCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedReferenceCount, String.valueOf(result), result.getReferenceCount()));
        }
    }

    public static void assertReferencesReturnedEquals(@NotNull LDAPSearchException exception, int expectedReferenceCount) throws AssertionError {
        if (exception.getReferenceCount() != expectedReferenceCount) {
            if (expectedReferenceCount == 1) {
                throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_ONE_EXPECTED.get(StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
            }
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_SEARCH_REF_COUNT_MISMATCH_MULTI_EXPECTED.get(expectedReferenceCount, StaticUtils.getExceptionMessage(exception), exception.getReferenceCount()));
        }
    }

    public static void assertDNsEqual(@NotNull String s1, @NotNull String s2) throws AssertionError {
        DN dn2;
        DN dn1;
        try {
            dn1 = new DN(s1);
        }
        catch (Exception e) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_VALUE_NOT_VALID_DN.get(s1, StaticUtils.getExceptionMessage(e)));
        }
        try {
            dn2 = new DN(s2);
        }
        catch (Exception e) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_VALUE_NOT_VALID_DN.get(s2, StaticUtils.getExceptionMessage(e)));
        }
        if (!dn1.equals(dn2)) {
            throw new AssertionError((Object)UtilityMessages.ERR_TEST_DNS_NOT_EQUAL.get(s1, s2));
        }
    }
}

