# Contributing to PhotoQt

Thank you for your interest in contributing to PhotoQt!

Bug reports, feature requests, code contributions - all types of ways of contributing are welcome!

## How to Contribute

1. Fork the repository
2. Create a new branch for your change
3. Make your changes
4. Commit your work to your fork
5. Open a merge request here on GitLab

Please **do not** open a pull request on GitHub. Keep changes focused and include clear commit messages.

## Developer Certificate of Origin (DCO)

This project uses the **Developer Certificate of Origin (DCO)** ([you can find a copy here](https://developercertificate.org/)) to ensure that contributors have the right to submit their work.

By contributing to this project, you certify that:

- You wrote the code yourself, or
- You have the right to submit it under the project’s license (GPL-2+)

### Signing Your Commits

All commits **must be signed off** by adding a `Signed-off-by` line to the commit message:

```Signed-off-by: Your Name your.email@example.com```

You can do this automatically by using: `git commit -s`. Merge requests with unsigned commits will be asked to update their commits to include the sign-off commit message.

## Code of Conduct

Please be respectful and constructive in all interactions. By participating, you agree to uphold the project’s [Code of Conduct](CODE_OF_CONDUCT.md) in all project spaces, including issues, pull requests, and discussions.

---

Thank you for your help in improving PhotoQt!

