/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.intellij.plugins.postcss.lexer.PostCssLexer;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class PostCssHighlightingLexer
extends CssHighlighterLexer {
    private static final int AFTER_AMPERSAND_FLAG = 32;
    private static final int AFTER_NUMBER_FLAG = 64;
    private boolean afterAmpersand;
    private boolean afterNumber;

    public PostCssHighlightingLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            PostCssHighlightingLexer.$$$reportNull$$$0(0);
        }
        super((Lexer)new PostCssLexer(), propertyValues);
        this.afterAmpersand = false;
        this.afterNumber = false;
    }

    public void advance() {
        IElementType type = this.getTokenType();
        if (type == PostCssTokenTypes.POST_CSS_CUSTOM_MEDIA_SYM) {
            this.myAfterMediaOrSupports = true;
            this.myInPropertyValue = true;
            this.myAfterColon = false;
        }
        this.afterAmpersand = PostCssTokenTypes.AMPERSAND == type;
        this.afterNumber = CssElementTypes.CSS_NUMBER == type;
        super.advance();
    }

    protected void initState(int initialState) {
        super.initState(initialState);
        int state = initialState >> 24;
        this.afterAmpersand = (state & 0x20) != 0;
        this.afterNumber = (state & 0x40) != 0;
    }

    public int getState() {
        int state = 0;
        state |= this.afterAmpersand ? 32 : 0;
        return super.getState() | (state |= this.afterAmpersand ? 64 : 0) << 24;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (!(this.myAfterMediaOrSupports || tokenType != CssElementTypes.CSS_IDENT && tokenType != CssElementTypes.CSS_HASH || this.lookAhead(1) != CssElementTypes.CSS_LPAREN)) {
            return CssElementTypes.CSS_FUNCTION_TOKEN;
        }
        return tokenType;
    }

    public boolean isPropertyNameAllowed() {
        boolean isRightContext;
        boolean detachedRuleset = (this.myAfterLeftBrace || this.myAfterSemicolon) && this.myFunctionNestingDepth > 0;
        IElementType next = this.lookAhead(1);
        boolean bl = isRightContext = next == CssElementTypes.CSS_COLON;
        if (this.myAfterMediaOrSupports) {
            isRightContext |= !this.afterNumber && (CssElementTypes.COMPARISON_OPERATORS.contains(next) || next == CssElementTypes.CSS_RPAREN);
        }
        return !this.afterAmpersand && isRightContext && (super.isPropertyNameAllowed() || detachedRuleset);
    }

    public boolean isPropertyValueAllowed() {
        if (this.myAfterMediaOrSupports && this.afterNumber) {
            return true;
        }
        return !(!this.myInPropertyValue && this.myFunctionNestingDepth <= 0 || !this.myInsideBlock && !this.myAfterMediaOrSupports || this.myAfterLeftBrace || this.myAfterSemicolon);
    }

    public boolean isSelectorAllowed() {
        return !this.myInPropertyValue && this.myFunctionNestingDepth <= 0 && !this.myAfterMediaOrSupports && !this.isTerminatedDeclaration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValues", "org/intellij/plugins/postcss/lexer/PostCssHighlightingLexer", "<init>"));
    }
}

