/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDocOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSDelegatingTypeProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSNamespaceProviderStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor {
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected final boolean ecmal4;
    protected final boolean typescript;
    @NotNull
    protected final JSTypeInfo myTypeInfo;
    @NotNull
    protected final PsiElement myContext;
    @NotNull
    protected final PsiFile myTargetFile;
    @Nullable
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    private final NotNullLazyValue<List<JSQualifiedName>> myContextScopesCache;
    protected final boolean myPrivateSharpFieldAccess;
    protected boolean myCheckFileLevelAccess;
    @Nullable
    protected VirtualFile myCurrentFile;
    public static final String[] TS_EXCLUDED = new String[]{"HTMLElementTagNameMap", "HTMLElementDeprecatedTagNameMap", "DocumentEventMap", "HTMLElementEventMap", "WindowEventMap", "GlobalEventHandlersEventMap", "SVGElementTagNameMap", "SVGMatrix", "WebKitCSSMatrix", "DOMMatrix", "DOMMatrixReadOnly", "DOMMatrix2DInit"};
    private final EnumSet<CompleteMatchSign> myCompleteMatchSigns;

    public static boolean isNamedGlobalType(@NotNull String typeString, @NotNull JSContext context2) {
        if (typeString == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(1);
        }
        return JSSymbolUtil.GLOBAL_TYPE_QUALIFIED_NAMES.contains(typeString) && context2 != JSContext.STATIC || JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(typeString);
    }

    public static boolean canBeResolvedToUnqualified(@NotNull JSQualifiedName qualifierNs, @NotNull JSContext jsContext) {
        if (qualifierNs == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(2);
        }
        if (jsContext == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(3);
        }
        return qualifierNs.getParent() == null && (jsContext != JSContext.STATIC && "Window".equals(qualifierNs.getName()) || qualifierNs.getParent() == null && JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(qualifierNs.getName()));
    }

    protected BaseJSSymbolProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context2) {
        if (targetFile == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(5);
        }
        this.myCompleteMatchSigns = EnumSet.noneOf(CompleteMatchSign.class);
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context2;
        this.myTypeInfo = this.createTypeInfo(this.initGlobalStatusHint(context2));
        this.myContextScopesCache = NotNullLazyValue.createValue(() -> JSVisibilityUtil.calculateContextNames(this.getContext()));
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context2);
        this.ecmal4 = holder != null && holder.isECMA4;
        this.typescript = holder != null && holder.isTypeScript;
        this.myPrivateSharpFieldAccess = holder != null && holder.hasFeature(JSLanguageFeature.PRIVATE_SHARP_SYNTAX) && JSUtils.isPrivateNameReference(this.myContext);
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            handler.addContextType(this.myTypeInfo, context2);
        }
        if (context2 instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)context2;
            JSExpression qualifier = JSResolveUtil.getRealRefExprQualifier(refExpr);
            if (!this.typescript && !this.ecmal4 && qualifier == null) {
                JSNamespace ns;
                for (JSQualifiedName globalType : JSSymbolUtil.GLOBAL_TYPES) {
                    ns = JSNamedTypeFactory.createNamespace(globalType, JSContext.INSTANCE, null, true);
                    this.myTypeInfo.addNamespace(ns, false);
                    this.addSupers(ns);
                }
                for (String globalTypeName : JSSymbolUtil.GLOBAL_OBJECT_NAMES) {
                    ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(globalTypeName, null), JSContext.STATIC, null, true);
                    this.myTypeInfo.addNamespace(ns, false);
                    this.addSupers(ns);
                }
            }
        }
    }

    protected JSTypeInfo createTypeInfo(@NotNull JSTypeInfo.GlobalStatusHint globalStatusHint) {
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(6);
        }
        return new JSTypeInfo(globalStatusHint);
    }

    protected boolean isPredefinedExtensibleType(@NotNull JSType type2) {
        if (type2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(7);
        }
        if (this.typescript || !(this.myContext instanceof JSReferenceExpression)) {
            return false;
        }
        if (JSResolveUtil.isFrameworkPredefinedExtensibleType(type2)) {
            return true;
        }
        return JSResolveUtil.isPredefinedExtensibleType(type2) && BaseJSSymbolProcessor.isJavaScriptPredefinedLibraryElement(type2.getSourceElement(), false);
    }

    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context2) {
        boolean withinWithStatement;
        if (!(context2 instanceof JSReferenceExpression)) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(8);
            }
            return globalStatusHint;
        }
        if (((JSReferenceExpression)context2).getQualifier() != null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(9);
            }
            return globalStatusHint;
        }
        boolean bl = withinWithStatement = !JSPsiImplUtils.getWithStatementContexts((JSReferenceExpression)context2).isEmpty();
        if (!withinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)context2) == null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(10);
            }
            return globalStatusHint;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(11);
        }
        return globalStatusHint;
    }

    protected void updateTypeInfoFromThis(@Nullable JSNamespace ns) {
        if (ns != null && JSTypeUtils.isStrictType(ns)) {
            this.setAddOnlyCompleteMatches();
        } else {
            this.myTypeInfo.setForcedUnknownContext();
        }
    }

    public void addTypeHierarchy(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(12);
        }
        this.myTypeInfo.addNamespace(namespace, true);
        this.addSupers(namespace);
    }

    public void addSupers(@NotNull JSNamespace namespace) {
        JSQualifiedName nsName;
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(13);
        }
        if ((nsName = namespace.getQualifiedName()) == null) {
            return;
        }
        JSContext staticOrInstance = namespace.getJSContext();
        SmartList parentClasses = new SmartList();
        Processor baseTypeProcessor = arg_0 -> BaseJSSymbolProcessor.lambda$addSupers$1((List)parentClasses, arg_0);
        Processor baseClassProcessor = arg_0 -> BaseJSSymbolProcessor.lambda$addSupers$2(staticOrInstance, (List)parentClasses, arg_0);
        JSTypeEvaluateManager.iterateTypeHierarchy(namespace, (Processor<JSClass>)baseClassProcessor, (Processor<? super JSType>)baseTypeProcessor, this.myContext, false);
        for (JSNamespace parentClass : this.addGenericArgumentsForParentClasses(namespace, (List<JSNamespace>)parentClasses)) {
            this.myTypeInfo.addNamespace(parentClass, false);
        }
    }

    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(14);
        }
        if (parentClasses == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(15);
        }
        List<JSNamespace> list = parentClasses;
        if (list == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(16);
        }
        return list;
    }

    public abstract String getRequiredName();

    public void forceSetAddOnlyCompleteMatches() {
        this.addCompleteMatchSign(CompleteMatchSign.FORCED_COMPLETE_MATCH);
    }

    public void setAddOnlyCompleteMatches() {
        this.addCompleteMatchSign(CompleteMatchSign.COMPLETE_MATCH);
    }

    public void allowPartialResults() {
        this.addCompleteMatchSign(CompleteMatchSign.INCOMPLETE_MATCH);
    }

    private void addCompleteMatchSign(@NotNull CompleteMatchSign sign) {
        if (sign == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(17);
        }
        this.myCompleteMatchSigns.add(sign);
    }

    public boolean addOnlyCompleteMatches() {
        if (this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.FORCED_COMPLETE_MATCH)) {
            return true;
        }
        return this.addOnlyCompleteMatchesEvaluated();
    }

    private boolean addOnlyCompleteMatchesEvaluated() {
        if (this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.INCOMPLETE_MATCH)) {
            return false;
        }
        return this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.COMPLETE_MATCH);
    }

    protected final boolean isGlobalNS(@NotNull JSNamespace namespace, boolean includeGlobalObjects) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(18);
        }
        return BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, includeGlobalObjects);
    }

    public static boolean isGlobalNS(@NotNull JSNamespace jsNamespace, boolean isTypeScript, boolean includeGlobalObjects) {
        if (jsNamespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(19);
        }
        if (jsNamespace instanceof JSClassExpressionType || jsNamespace.isLocal()) {
            return false;
        }
        if (jsNamespace instanceof JSAnyType) {
            return false;
        }
        JSQualifiedName namespace = jsNamespace.getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (isTypeScript) {
            return false;
        }
        String name = namespace.getName();
        return includeGlobalObjects && (JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(name) && namespace.getParent() == null || JSSymbolUtil.GLOBAL_TYPES.contains(namespace));
    }

    public boolean acceptsFile(PsiFile file) {
        this.myCurrentFile = file.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file.getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected final void initCheckFileLevelAccess() {
        if (this.myTypeInfo.isNonGlobalContext()) {
            return;
        }
        if (this.myTargetFile instanceof JSFile || DialectDetector.isES6(this.myContext) || ES6PsiUtil.findExternalModule(this.myContext) != null) {
            PsiElement resolve2;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = true;
            if (this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve2 = ((JSReferenceExpression)qualifier).resolve()) == null || resolve2 instanceof JSParameter || !resolve2.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public JSResolveResult.ProblemKind isAcceptable(@NotNull JSPsiElementBase element) {
        boolean isExternalModule;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(20);
        }
        if (!this.toCheckFileLevelAccess()) {
            return null;
        }
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return JSResolveResult.ProblemKind.JS_NEED_TO_BE_IMPORTED;
        }
        JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)element);
        boolean bl = isExternalModule = ES6PsiUtil.isExternalModule((PsiElement)exportScope) || exportScope instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)((Object)exportScope)).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.COMMONJS;
        if (exportScope == null || !isExternalModule) {
            return null;
        }
        if (element.getContext() instanceof JSDocComment && this.myTargetFile.equals(element.getContainingFile())) {
            return null;
        }
        JSNamespace jsNamespace = element.getJSNamespace();
        JSQualifiedName namespace = jsNamespace.getQualifiedName();
        boolean isFromExportNamespace = CommonJSUtil.isExportNamespace(jsNamespace);
        boolean isExportedWithModuleExportsCalculatedToTrue = false;
        if (namespace != null && !isFromExportNamespace) {
            boolean isExportedWithModuleExports = CommonJSUtil.isExportedWithModuleExports(element);
            if (!isExportedWithModuleExports) {
                return null;
            }
            isExportedWithModuleExportsCalculatedToTrue = true;
        }
        if (this.myContext instanceof JSReferenceExpression && (element.isExported() || element.isExportedWithDefault() || isFromExportNamespace || (DialectDetector.isES6((PsiElement)element) || DialectDetector.isTypeScript((PsiElement)element)) && (isExportedWithModuleExportsCalculatedToTrue || CommonJSUtil.isExportedWithModuleExports(element)))) {
            if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                return JSResolveResult.ProblemKind.JS_NEED_TO_BE_IMPORTED;
            }
            return null;
        }
        if (jsNamespace.isLocal()) {
            return null;
        }
        return JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED;
    }

    protected void tryAddFunctionType(@NotNull JSType type2) {
        if (type2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(21);
        }
        if (JSTypeUtils.hasFunctionType(type2, false, this.myContext)) {
            this.myTypeInfo.addNamespace(JSTypeUtils.getFunctionTypeName(type2.getSource().getScope(), false), false, JSContext.INSTANCE, type2.isSourceStrict());
        }
    }

    protected boolean isStrictTypingPossible(@NotNull JSType type2) {
        if (type2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(22);
        }
        return !(!type2.isSourceStrict() || type2 instanceof JSObjectType || type2 instanceof JSAnyType || type2 instanceof TypeScriptIndexedAccessJSTypeImpl && !this.typescript || type2 instanceof JSRecordType && !((JSRecordType)type2).hasMembers() && !this.typescript || type2 instanceof TypeScriptNeverType || type2 instanceof JSGenericParameterImpl || type2 instanceof TypeScriptMappedJSTypeImpl && ((TypeScriptMappedJSTypeImpl)type2).hasForeignGenericParameters() || type2 instanceof JSGenericTypeImpl && !this.isStrictGenericType((JSGenericTypeImpl)type2) || this.isPredefinedExtensibleType(type2));
    }

    private boolean isStrictGenericType(@NotNull JSGenericTypeImpl type2) {
        if (type2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(23);
        }
        if (this.typescript) {
            return true;
        }
        if (type2.getType() instanceof JSObjectType) {
            return false;
        }
        for (JSType jsType : type2.getArguments()) {
            if (!(jsType instanceof JSGenericParameterImpl)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(@Nullable JSClass jsClass, @Nullable PsiElement expression) {
        String s;
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null) {
            int index;
            String qName = jsClass.getQualifiedName();
            if (qName != null && !qName.equals(jsClass.getName()) && (index = qName.lastIndexOf(46)) > 0) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else if (expression != null && BaseJSSymbolProcessor.isValidType(s = ActionScriptResolveUtil.findPackageForMxml(expression))) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(s);
        }
    }

    protected List<JSQualifiedName> getContextScopeNames() {
        return (List)this.myContextScopesCache.getValue();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @NotNull
    public JSTypeInfo getTypeInfo() {
        JSTypeInfo jSTypeInfo = this.myTypeInfo;
        if (jSTypeInfo == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(25);
        }
        return jSTypeInfo;
    }

    @NotNull
    protected MatchType isAcceptableQualifiedItem(@NotNull JSPsiElementBase element, @NotNull IntRef typeHierarchyLevel, @NotNull Ref<Boolean> isAccessibleRef) {
        boolean isGlobalIncludeGlobalObjects;
        JSNamespace elementJSNamespace;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(26);
        }
        if (typeHierarchyLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(27);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(28);
        }
        PsiElement parent = element.getContext();
        JSNamespace jSNamespace = elementJSNamespace = this.ecmal4 && parent instanceof JSClass ? JSNamedTypeFactory.buildProvidedNamespace((JSClass)parent, true) : element.getJSNamespace();
        if (elementJSNamespace == null) {
            elementJSNamespace = JSAnyType.get((PsiElement)element);
        }
        JSQualifiedName namespace = elementJSNamespace.getQualifiedName();
        boolean isElementLocal = elementJSNamespace.isLocal();
        boolean isNamespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        boolean isGlobal = this.isGlobalNS(elementJSNamespace, false);
        boolean bl = isGlobalIncludeGlobalObjects = isGlobal || this.isGlobalNS(elementJSNamespace, true);
        if (isGlobalIncludeGlobalObjects && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(29);
            }
            return matchType;
        }
        if (this.myTypeInfo.isNonGlobalContext() && isNamespaceExplicitlyDeclared && isGlobal) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(30);
            }
            return matchType;
        }
        if (isGlobal && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).isUnderCondition() && this.getContext() instanceof JSReferenceExpression && ((JSReferenceExpression)this.getContext()).getQualifier() == null && this.myTargetFile instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)this.myTargetFile).isCommonJSModule()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(31);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalContext() && elementJSNamespace instanceof JSAnyType) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(32);
            }
            return matchType;
        }
        Ref contextLevelRef = Ref.create(null);
        MatchType result2 = this.iterateContextLevels(element, (Ref<JSContextLevel>)contextLevelRef, namespace, elementJSNamespace);
        JSContextLevel contextLevel = (JSContextLevel)contextLevelRef.get();
        if (contextLevel != null) {
            typeHierarchyLevel.set(contextLevel.myRelativeLevel);
            this.updateAccessible(element, isAccessibleRef, contextLevel);
        }
        if (result2 != null) {
            MatchType matchType = result2;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(33);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalContext() && !BaseJSSymbolProcessor.isGlobalNS(elementJSNamespace, this.typescript, true)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(34);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isElementLocal && namespace == null && (!(this.myContext instanceof JSDocTagType) || !(element instanceof JSClass))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(35);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalContext() && (JSClassUtils.isClassMember((PsiElement)element) || element instanceof JSProperty)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(36);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isGlobalIncludeGlobalObjects && this.myTypeInfo.isGlobalContext()) {
            MatchType matchType = MatchType.COMPLETE;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(37);
            }
            return matchType;
        }
        if (namespace != null && !this.typescript && BaseJSSymbolProcessor.isTSExcludedMap(namespace)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(38);
            }
            return matchType;
        }
        MatchType matchType = MatchType.PARTIAL;
        if (matchType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(39);
        }
        return matchType;
    }

    private void updateAccessible(@NotNull JSPsiElementBase element, @NotNull Ref<Boolean> isAccessibleRef, @NotNull JSContextLevel contextLevel) {
        JSAttributeList.AccessType accessType;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(40);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(41);
        }
        if (contextLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(42);
        }
        if ((accessType = this.getElementAccessType(element)) == JSAttributeList.AccessType.PRIVATE || accessType == JSAttributeList.AccessType.PROTECTED) {
            List<JSQualifiedName> scopeNames = this.getContextScopeNames();
            boolean withinScope = false;
            for (JSContextLevel level : this.myTypeInfo.myContextLevels) {
                if (level.myRelativeLevel == 0) {
                    withinScope = false;
                }
                if (!withinScope && scopeNames.contains(level.myNamespace.getQualifiedName())) {
                    withinScope = true;
                }
                if (level != contextLevel) continue;
                PsiFile file1 = element.getContainingFile();
                PsiFile file2 = this.myContext.getContainingFile();
                if (file1 == null || file2 == null) break;
                boolean isAccessible = JSVisibilityUtil.isAccessible(element, accessType, contextLevel.myRelativeLevel == 0, withinScope, file1.isEquivalentTo((PsiElement)file2));
                isAccessibleRef.set((Object)isAccessible);
                break;
            }
        }
    }

    @NotNull
    protected JSAttributeList.AccessType getElementAccessType(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(43);
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (accessType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(44);
        }
        return accessType;
    }

    private static boolean isTSExcludedMap(JSQualifiedName namespace) {
        String qualifiedName = namespace.getQualifiedName();
        for (String map2 : TS_EXCLUDED) {
            if (!qualifiedName.equals(map2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MatchType iterateContextLevels(@NotNull JSPsiElementBase element, @NotNull Ref<JSContextLevel> contextLevelRef, @Nullable JSQualifiedName namespace, @NotNull JSNamespace elementJSNamespace) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(45);
        }
        if (contextLevelRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(46);
        }
        if (elementJSNamespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(47);
        }
        if (this.myTypeInfo.myContextLevels.isEmpty()) {
            return null;
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (JSContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            if (!contextLevel.isElementInScope(element, elementJSNamespace) || !BaseJSSymbolProcessor.isElementFromNamespaceIgnoringJSContext(contextLevel.myNamespace, element, namespace, elementJSNamespace)) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN) continue;
            contextLevelRef.set((Object)contextLevel);
            return contextLevel.myRelativeLevel == 0 && (elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN || contextLevel == JSTypeInfo.GLOBAL_CONTEXT_LEVEL) ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        return jsContextMismatched ? MatchType.NOMATCH : null;
    }

    public static boolean isElementFromNamespaceIgnoringJSContext(@NotNull JSNamespace contextLevelNamespace, @NotNull JSPsiElementBase element, @Nullable JSQualifiedName elementNamespace, @NotNull JSNamespace elementJSNamespace) {
        JSQualifiedName currentNs;
        if (contextLevelNamespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(48);
        }
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(49);
        }
        if (elementJSNamespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(50);
        }
        if (contextLevelNamespace instanceof JSNamespaceProviderStubBasedExpressionType) {
            return elementJSNamespace instanceof JSNamespaceProviderStubBasedExpressionType && Objects.equals(((JSNamespaceProviderStubBasedExpressionType)contextLevelNamespace).getExpressionType(), ((JSNamespaceProviderStubBasedExpressionType)elementJSNamespace).getExpressionType());
        }
        JSQualifiedName currentContextNamespace = JSStubIndexingUtils.getResolvedQualifiedName(contextLevelNamespace);
        if (currentContextNamespace == null && contextLevelNamespace.isSourceStrict() && element instanceof JSProperty && elementNamespace == null && !elementJSNamespace.isSourceStrict()) {
            return false;
        }
        for (currentNs = elementNamespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
        }
        return currentContextNamespace == null && currentNs == null;
    }

    private static boolean isPrivate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(51);
        }
        return element.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Contract(value="null -> null")
    public static JSExpression getOriginalQualifier(@Nullable JSExpression rawqualifier) {
        if (rawqualifier == null) {
            return null;
        }
        JSExpression element = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)rawqualifier);
        return element != null ? element : rawqualifier;
    }

    public static boolean isCompleteOrWithContextMatchType(@Nullable MatchType matchType) {
        return matchType == MatchType.COMPLETE_WITH_CONTEXT || matchType == MatchType.COMPLETE;
    }

    public static void addResolveResultTags(@NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, @Nullable PsiElement element, @NotNull PsiElement context2) {
        if (tags == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(52);
        }
        if (context2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(53);
        }
        if (element instanceof JSElementBase && BaseJSSymbolProcessor.isJavaScriptPredefinedLibraryElement(element, DialectDetector.isTypeScript(context2))) {
            return;
        }
        if (element instanceof JSDocOwner && ((JSDocOwner)element).hasJSDoc()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getJSType() != null) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() || element != null && BaseJSSymbolProcessor.isTooBigForHighlighting(PsiUtilCore.getVirtualFile((PsiElement)element)) || BaseJSSymbolProcessor.isFromMinifiedFile(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
        }
        if (element instanceof JSDefinitionExpression) {
            BaseJSSymbolProcessor.addTagsForDefinitionInClass((JSDefinitionExpression)element, tags);
            if (context2 instanceof JSReferenceExpression && JSResolveUtil.isSameReference((JSReferenceExpression)context2, element)) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.SELF_DEFINITION);
            }
            if (!((JSDefinitionExpression)element).isDeclaration()) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.IS_ASSIGNMENT);
            }
        }
    }

    private static void addTagsForDefinitionInClass(@NotNull JSDefinitionExpression element, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(54);
        }
        if (tags == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(55);
        }
        if (element.getJSNamespace().getTypeContext() != JSTypeContext.PROTOTYPE) {
            return;
        }
        JSQualifiedNamedElement scopeNode = JSPsiImplUtils.getParentFunctionOrClassThroughLambdas((PsiElement)element);
        if (scopeNode == null || !(scopeNode instanceof JSClass) && !JSClassUtils.isClassMember((PsiElement)scopeNode)) {
            return;
        }
        tags.add(JSResolveUtil.isConstructorFunction((PsiElement)scopeNode) ? JSTaggedResolveResult.ResolveResultTag.DEFINITION_IN_CLASS_CONSTRUCTOR : JSTaggedResolveResult.ResolveResultTag.DEFINITION_IN_CLASS_NOT_CONSTRUCTOR);
    }

    public static boolean isTooBigForHighlighting(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return !(file instanceof LightVirtualFile) && VirtualFileUtil.isTooLargeForIntellijSense((VirtualFile)file);
    }

    private static boolean isFromMinifiedFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof JSFile && ((JSFile)file).isMinified();
    }

    protected static boolean isJavaScriptPredefinedLibraryElement(@Nullable PsiElement sourceElement, boolean typescript2) {
        SyntheticLibrary syntheticLibrary;
        ScriptingLibraryModel libraryModel;
        VirtualFile virtualFile;
        if (typescript2 || sourceElement == null) {
            return false;
        }
        if (JSCorePredefinedLibrariesProvider.isLibraryElement(sourceElement)) {
            return true;
        }
        PsiFile file = sourceElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file != null ? file.getVirtualFile() : null;
        if (virtualFile == null) {
            return false;
        }
        return FileIndexFacade.getInstance((Project)sourceElement.getProject()).isInLibrarySource(virtualFile) && (libraryModel = JSLibraryManager.getInstance(sourceElement.getProject()).getLibraryByName("Node.js Core")) instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (syntheticLibrary = ((ScriptingLibraryModelBackedBySyntheticLibrary)libraryModel).getSyntheticLibrary()) != null && VfsUtilCore.isUnder((VirtualFile)virtualFile, new HashSet(syntheticLibrary.getAllRoots()));
    }

    private static /* synthetic */ boolean lambda$addSupers$2(JSContext staticOrInstance, List parentClasses, JSClass clazz) {
        JSNamespace classNs;
        String name = clazz.getQualifiedName();
        if ("Object".equals(name)) {
            return true;
        }
        if (name != null && (classNs = JSNamedTypeFactory.buildProvidedNamespace(clazz, true)) != null && classNs.getQualifiedName() != null) {
            classNs = JSNamedTypeFactory.copyWithJSContext(classNs, staticOrInstance);
            parentClasses.add(classNs);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$addSupers$1(List parentClasses, JSType type2) {
        JSNamespace baseNs = JSTypeUtils.getNamespaceMatchingType(type2, false);
        if (baseNs == null || baseNs instanceof JSObjectType) {
            return true;
        }
        if (baseNs.getQualifiedName() != null) {
            parentClasses.add(baseNs);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 16, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 5: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierNs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalStatusHint";
                break;
            }
            case 7: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNamespace";
                break;
            }
            case 20: 
            case 26: 
            case 40: 
            case 43: 
            case 45: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 28: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAccessibleRef";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevel";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevelRef";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementJSNamespace";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevelNamespace";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "isAcceptableQualifiedItem";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNamedGlobalType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeResolvedToUnqualified";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedExtensibleType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTypeHierarchy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addSupers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatchSign";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalNS";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryAddFunctionType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isStrictGenericType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableQualifiedItem";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateAccessible";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getElementAccessType";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "iterateContextLevels";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromNamespaceIgnoringJSContext";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addResolveResultTags";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addTagsForDefinitionInClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 16, 24, 25, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 44 -> new IllegalStateException(string);
        };
    }

    private static enum CompleteMatchSign {
        COMPLETE_MATCH,
        INCOMPLETE_MATCH,
        FORCED_COMPLETE_MATCH;

    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        PARTIAL,
        NOMATCH;

    }

    public abstract class JSTypeProcessorBase
    implements JSTypeProcessor {
        protected void evaluateQualifier(@NotNull JSExpression qualifier, @NotNull JSExpression originalQualifier) {
            JSNamespace namespace;
            if (qualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(0);
            }
            if (originalQualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(1);
            }
            JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)originalQualifier, JSResolveUtil.getOriginalFile((PsiElement)originalQualifier), (JSTypeProcessor)new JSDelegatingTypeProcessor(this){

                @Override
                public void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
                    if (type2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (evaluateContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (type2 instanceof JSModuleTypeImpl) {
                        BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
                    }
                    super.process(type2, evaluateContext);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "evaluateContext";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            if ((!BaseJSSymbolProcessor.this.addOnlyCompleteMatchesEvaluated() || BaseJSSymbolProcessor.this.myTypeInfo.isEmpty() || qualifier instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)qualifier)) && (namespace = JSSymbolUtil.evaluateNamespaceLocally(qualifier)) != null) {
                BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(namespace, true);
            }
        }

        @Override
        public void processAdditionalType(@NotNull JSType type2, @NotNull JSEvaluateContext context2) {
            if (type2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(3);
            }
            if (!JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
                this.doProcessAdditionalType((JSType)t);
                return true;
            }), type2)) {
                return;
            }
            this.doProcessAdditionalType(type2);
        }

        private void doProcessAdditionalType(@NotNull JSType type2) {
            if (type2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(4);
            }
            if (!(type2 instanceof JSNamespace)) {
                return;
            }
            JSNamespace namespace = (JSNamespace)type2;
            if (namespace.getQualifiedName() == null) {
                return;
            }
            namespace = (JSNamespace)namespace.copyWithStrict(true);
            BaseJSSymbolProcessor.this.addTypeHierarchy(namespace);
            if (CommonJSUtil.isExportNamespace(namespace)) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
            }
        }

        protected final void processCandidate(@NotNull JSType type2, @NotNull JSEvaluateContext context2) {
            if (type2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(5);
            }
            if (context2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(6);
            }
            if (type2 instanceof JSDecoratedType) {
                return;
            }
            this.updateResolveStrictness(type2);
            if (type2 instanceof JSRecordType) {
                BaseJSSymbolProcessor.this.myTypeInfo.addBaseObjectType();
                BaseJSSymbolProcessor.this.myTypeInfo.setTypeWasProcessed();
            }
            if (type2 instanceof JSAnyType) {
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type2, this.isMakeAddedNamespaceStrict());
            if (namespace == null) {
                return;
            }
            BaseJSSymbolProcessor.this.addTypeHierarchy(namespace);
            BaseJSSymbolProcessor.this.tryAddFunctionType(type2);
        }

        protected boolean isMakeAddedNamespaceStrict() {
            return false;
        }

        private void updateResolveStrictness(@NotNull JSType type2) {
            if (type2 == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(7);
            }
            if (type2 instanceof JSAnyType) {
                this.allowPartialResults();
            }
            JSTypeSource typeSource = type2.getSource();
            if (BaseJSSymbolProcessor.this.typescript) {
                if (typeSource.isStrict()) {
                    BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
                } else {
                    this.allowPartialResults();
                }
            } else if (BaseJSSymbolProcessor.this.isStrictTypingPossible(type2)) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
            } else if (!typeSource.isStrict()) {
                this.allowPartialResults();
            }
        }

        protected void allowPartialResults() {
            BaseJSSymbolProcessor.this.allowPartialResults();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalQualifier";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateQualifier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdditionalType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doProcessAdditionalType";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCandidate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateResolveStrictness";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

