/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSFileReference
extends FileReference
implements JSModuleBaseReference {
    public JSFileReference(@NotNull String text, int offset, @NotNull TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (text == null) {
            JSFileReference.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            JSFileReference.$$$reportNull$$$0(1);
        }
        if (fileReferenceSet == null) {
            JSFileReference.$$$reportNull$$$0(2);
        }
        super(fileReferenceSet, textRange, offset, JSStringUtil.unescapeStringLiteralValue(text));
    }

    protected boolean isPreferImplicitExtension() {
        return false;
    }

    @NotNull
    public @NotNull String @NotNull [] getImplicitExtensions() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            JSFileReference.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context2, @NotNull Collection<? super ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSFileReference.$$$reportNull$$$0(5);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(6);
        }
        if (!this.isLast()) {
            this.simpleInnerResolveInContext(referenceText, context2, results, caseSensitive);
            return;
        }
        if (this.isAcceptableEmptyReference(referenceText)) {
            this.innerResolveWithoutImplicitExtensions(referenceText, context2, results, caseSensitive);
            return;
        }
        int size = results.size();
        if (this.isPreferImplicitExtension()) {
            this.innerResolveWithExtensions(referenceText, context2, results, caseSensitive, this.getImplicitExtensions());
            if (size == results.size()) {
                this.innerResolveWithoutImplicitExtensions(referenceText, context2, results, caseSensitive);
            }
        } else {
            this.innerResolveWithoutImplicitExtensions(referenceText, context2, results, caseSensitive);
            if (size == results.size()) {
                this.innerResolveWithExtensions(referenceText, context2, results, caseSensitive, this.getImplicitExtensions());
            }
        }
    }

    protected void innerResolveWithExtensions(@NotNull String referenceText, @NotNull PsiFileSystemItem context2, @NotNull Collection<? super ResolveResult> results, boolean caseSensitive, String @NotNull [] extensions) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            JSFileReference.$$$reportNull$$$0(8);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(9);
        }
        if (extensions == null) {
            JSFileReference.$$$reportNull$$$0(10);
        }
        int size = results.size();
        for (String extension : extensions) {
            if (referenceText.endsWith(extension)) continue;
            this.simpleInnerResolveInContext(referenceText + extension, context2, results, caseSensitive);
            if (size != results.size()) break;
        }
    }

    protected void innerResolveWithoutImplicitExtensions(@NotNull String referenceText, @NotNull PsiFileSystemItem context2, @NotNull Collection<? super ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            JSFileReference.$$$reportNull$$$0(12);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(13);
        }
        SmartList candidates = new SmartList();
        this.simpleInnerResolveInContext(referenceText, context2, (Collection<? super ResolveResult>)candidates, caseSensitive);
        if (!candidates.isEmpty()) {
            this.processExplicitResolveElements((Collection<? extends ResolveResult>)candidates, results);
        }
    }

    protected boolean isAcceptableEmptyReference(@NotNull String referenceText) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(14);
        }
        return referenceText.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed();
    }

    protected final void simpleInnerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context2, @NotNull Collection<? super ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            JSFileReference.$$$reportNull$$$0(16);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(17);
        }
        super.innerResolveInContext(referenceText, context2, results, caseSensitive);
    }

    protected void processExplicitResolveElements(@NotNull Collection<? extends ResolveResult> candidates, @NotNull Collection<? super ResolveResult> results) {
        if (candidates == null) {
            JSFileReference.$$$reportNull$$$0(18);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(19);
        }
        for (ResolveResult resolveResult : candidates) {
            boolean hasNewElements;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiFileSystemItem) || !((PsiFileSystemItem)element).isDirectory()) {
                results.add((ResolveResult)resolveResult);
                continue;
            }
            Collection<ResolveResult> resolvedDirectoryElements = this.resolveDirectory((PsiFileSystemItem)element);
            boolean bl = hasNewElements = !resolvedDirectoryElements.isEmpty();
            if (hasNewElements) {
                results.addAll(resolvedDirectoryElements);
            }
            if (!this.isAllowFolders() || hasNewElements) continue;
            results.add((ResolveResult)resolveResult);
        }
    }

    @NotNull
    protected Collection<ResolveResult> resolveDirectory(@NotNull PsiFileSystemItem directory) {
        if (directory == null) {
            JSFileReference.$$$reportNull$$$0(20);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSFileReference.$$$reportNull$$$0(21);
        }
        return list;
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                JSFileReference.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (this.isLast()) {
            newName = this.fixLastNameForRename(newName);
        }
        return super.rename(this.fixRelativePath(newName));
    }

    @NotNull
    protected String fixLastNameForRename(@NotNull String newName) {
        if (newName == null) {
            JSFileReference.$$$reportNull$$$0(24);
        }
        String string = this.fixExtension(newName);
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    protected String fixRelativePath(String newName) {
        FileReference firstRef;
        String refText;
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (firstRef = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !((String)newName).startsWith("..")) {
            newName = "./" + (String)newName;
        }
        String string = newName;
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    protected String fixExtension(@NotNull String newName) {
        if (newName == null) {
            JSFileReference.$$$reportNull$$$0(27);
        }
        String string = this.fixExtension(newName, this.getText());
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    protected String fixExtension(@NotNull String newName, @NotNull String oldRefText) {
        if (newName == null) {
            JSFileReference.$$$reportNull$$$0(29);
        }
        if (oldRefText == null) {
            JSFileReference.$$$reportNull$$$0(30);
        }
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String newImplicitExtension = JSFileReferencesUtil.findExtension(newName, extensions);
        String textImplicitExtension = JSFileReferencesUtil.findExtension(oldRefText, extensions);
        if (newImplicitExtension != null && textImplicitExtension == null || oldRefText.indexOf(46) == -1) {
            int indexNameWithoutExtension;
            int n = indexNameWithoutExtension = newImplicitExtension != null ? newName.length() - newImplicitExtension.length() : newName.lastIndexOf(46);
            if (indexNameWithoutExtension != -1) {
                int lastIndexOfSeparator = newImplicitExtension != null ? -1 : newName.lastIndexOf(47);
                newName = indexNameWithoutExtension > lastIndexOfSeparator ? newName.substring(0, indexNameWithoutExtension) : newName;
            }
        }
        String string = newName;
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(31);
        }
        return string;
    }

    public String @NotNull [] getSortedByLengthImplicitExtensions() {
        String[] stringArray = JSFileReferencesUtil.getSortedExtensions(this.getImplicitExtensions());
        if (stringArray == null) {
            JSFileReference.$$$reportNull$$$0(32);
        }
        return stringArray;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(33);
        }
        return this.bindToElement(element, absolute, this.isRelativeCommonPath());
    }

    protected PsiElement bindToElement(@NotNull PsiElement element, boolean absolute, boolean isRelativeCommonPath) throws IncorrectOperationException {
        String path2;
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(34);
        }
        if (!isRelativeCommonPath && JSFileReferencesUtil.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        if ((!isRelativeCommonPath || absolute) && (path2 = JSFileReference.getPathFromDefaultContext(this.getFileReferenceSet(), element, absolute)) != null) {
            return this.rename(path2);
        }
        return super.bindToElement(element, absolute);
    }

    protected static String getPathFromDefaultContext(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element, boolean absolute) {
        List filteredContexts;
        VirtualFile dstVFile;
        String path2;
        Collection<PsiFileSystemItem> defaultContexts;
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(35);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(36);
        }
        if (!(defaultContexts = JSFileReference.getDefaultResolveContextsForBind(referenceSet, element)).isEmpty() && (path2 = JSFileReferencesUtil.getShortestPathInContexts(dstVFile = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : null, filteredContexts = ContainerUtil.map(defaultContexts, el -> el.getVirtualFile()), true)) != null) {
            return absolute && referenceSet.absoluteUrlNeedsStartSlash() && !path2.startsWith("/") ? "/" + path2 : path2;
        }
        return null;
    }

    @NotNull
    protected static Collection<PsiFileSystemItem> getDefaultResolveContextsForBind(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element) {
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(37);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(38);
        }
        Collection allDefaultContexts = referenceSet.getDefaultContexts();
        FileReference firstRef = referenceSet.getReference(0);
        PsiFileSystemItem resolvedFirstRef = firstRef.resolve();
        if (resolvedFirstRef != null && resolvedFirstRef != element) {
            PsiFileSystemItem contextDir = resolvedFirstRef.getParent();
            List list = allDefaultContexts.contains(contextDir) ? ContainerUtil.createMaybeSingletonList((Object)contextDir) : ContainerUtil.emptyList();
            if (list == null) {
                JSFileReference.$$$reportNull$$$0(39);
            }
            return list;
        }
        return new LinkedHashSet<PsiFileSystemItem>(allDefaultContexts);
    }

    public boolean isRelativeCommonPath() {
        String path2 = this.getFileReferenceSet().getPathString();
        return path2.startsWith(".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 21, 22, 23, 25, 26, 28, 31, 32, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 3: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRefText";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectory";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLastNameForRename";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fixRelativePath";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "fixExtension";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedByLengthImplicitExtensions";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultResolveContextsForBind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 39: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithExtensions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithoutImplicitExtensions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEmptyReference";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "simpleInnerResolveInContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processExplicitResolveElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fixLastNameForRename";
                break;
            }
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fixExtension";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromDefaultContext";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResolveContextsForBind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 21, 22, 23, 25, 26, 28, 31, 32, 39 -> new IllegalStateException(string);
        };
    }
}

