/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.http.request.HttpRequestPsiConvertersKt;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/actions/generation/UrlChecker;", "", "<init>", "()V", "isValidRequest", "", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "authority", "checkGeneratedUrlIsEqualsTo", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "intellij.restClient"})
final class UrlChecker {
    @NotNull
    public static final UrlChecker INSTANCE = new UrlChecker();

    private UrlChecker() {
    }

    @RequiresReadLock
    public final boolean isValidRequest(@NotNull Project project, @NotNull String url, @NotNull String authority) {
        HttpRequest request;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        String urlToCheck = "http://" + authority + url;
        String dummyRequest = "GET " + urlToCheck;
        HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(project, dummyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestPsiFile), (String)"createDummyFile(...)");
        HttpRequestPsiFile file = httpRequestPsiFile;
        HttpRequest httpRequest = request = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
        return (httpRequest != null ? httpRequest.getRequestTarget() : null) != null && this.checkGeneratedUrlIsEqualsTo(request, urlToCheck) && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)request));
    }

    public static /* synthetic */ boolean isValidRequest$default(UrlChecker urlChecker, Project project, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/intellijRulez";
        }
        if ((n & 4) != 0) {
            string2 = "localhost:8000";
        }
        return urlChecker.isValidRequest(project, string, string2);
    }

    private final boolean checkGeneratedUrlIsEqualsTo(HttpRequest request, String url) {
        String string;
        char[] cArray;
        String actualUrl;
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"empty(...)");
        HttpRequestUrlAccessor httpRequestUrlAccessor = HttpRequestPsiConvertersKt.getFullUrl(request, httpRequestVariableSubstitutor);
        String string2 = actualUrl = httpRequestUrlAccessor != null ? httpRequestUrlAccessor.toUrlString(false) : null;
        if (string2 != null) {
            cArray = new char[]{'/'};
            string = StringsKt.trimEnd((String)string2, (char[])cArray);
        } else {
            string = null;
        }
        String httpPath = string;
        cArray = new char[]{'/'};
        String string3 = StringsKt.trimStart((String)url, (char[])cArray);
        cArray = new char[]{'/'};
        return Intrinsics.areEqual((Object)httpPath, (Object)StringsKt.trimEnd((String)string3, (char[])cArray));
    }
}

