/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0000\u001a&\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0002\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"PREDEFINED_MAPPINGS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "createUrlToLocalMap", "mappings", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "findByName", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "filename", "findByMappings", "parsedUrl", "intellij.javascript.debugger"})
public final class RemoteDebuggingFileFinderKt {
    @NotNull
    private static final Key<BiMap<String, VirtualFile>> PREDEFINED_MAPPINGS_KEY;

    @NotNull
    public static final BiMap<String, VirtualFile> createUrlToLocalMap(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        if (mappings.isEmpty()) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"of(...)");
            return (BiMap)immutableBiMap;
        }
        HashBiMap map = HashBiMap.create((int)mappings.size());
        for (RemoteUrlMappingBean remoteUrlMappingBean : mappings) {
            VirtualFile file = LocalFileFinder.findFile((String)remoteUrlMappingBean.localFilePath);
            if (file == null) continue;
            map.forcePut((Object)remoteUrlMappingBean.getRemoteUrl(), (Object)file);
        }
        Intrinsics.checkNotNull((Object)map);
        return (BiMap)map;
    }

    @Nullable
    public static final VirtualFile findByName(@NotNull Url url, @NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string2 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        if (StringsKt.endsWith$default((CharSequence)string2, (char)'/', (boolean)false, (int)2, null)) {
            string = "";
        } else {
            String string3 = PathUtilRt.getFileName((String)url.getPath());
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileName(...)");
        }
        return RemoteDebuggingFileFinderKt.findByName(string, project, url);
    }

    private static final VirtualFile findByName(String filename, Project project, Url url) {
        List<VirtualFile> files2 = RemoteDebuggingFileFinderKt.findByName(filename, project);
        if (files2.isEmpty()) {
            return null;
        }
        if (files2.size() == 1) {
            return files2.get(0);
        }
        VirtualFile virtualFile = files2.get(0).getCanonicalFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile canonicalFile = virtualFile;
        int size = files2.size();
        for (int i = 1; i < size; ++i) {
            if (Intrinsics.areEqual((Object)canonicalFile, (Object)files2.get(i).getCanonicalFile())) continue;
            return null;
        }
        if (url == null) {
            return files2.get(0);
        }
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        int offset = 0;
        do {
            for (VirtualFile file : files2) {
                String filePath;
                Intrinsics.checkNotNullExpressionValue((Object)file.getPath(), (String)"getPath(...)");
                int length = path.length() - offset;
                if (!StringsKt.regionMatches((String)filePath, (int)(filePath.length() - length), (String)path, (int)offset, (int)length, (boolean)true)) continue;
                return file;
            }
        } while ((offset = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(offset + 1), (boolean)false, (int)4, null)) >= 0);
        return null;
    }

    @NotNull
    public static final List<VirtualFile> findByName(@NotNull String filename, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ReadAction.compute(() -> RemoteDebuggingFileFinderKt.findByName$lambda$0(project, filename));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private static final VirtualFile findByMappings(Url parsedUrl, BiMap<String, VirtualFile> mappings) {
        if (mappings.isEmpty()) {
            return null;
        }
        String url = parsedUrl.trimParameters().toDecodedForm();
        int i = url.length();
        while (i != -1) {
            String prefix;
            Intrinsics.checkNotNull((Object)url);
            Intrinsics.checkNotNullExpressionValue((Object)url.substring(0, i), (String)"substring(...)");
            VirtualFile file = (VirtualFile)mappings.get((Object)prefix);
            if (file != null) {
                if (i == url.length()) {
                    return file;
                }
                if (i + 1 == url.length()) {
                    VirtualFile indexFile = BuiltInWebServerKt.findIndexFile((VirtualFile)file);
                    if (indexFile == null) break;
                    return indexFile;
                }
                String string = url.substring(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String filename = string;
                VirtualFile child = file.findFileByRelativePath(filename);
                if (child == null) break;
                return child;
            }
            i = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)(i - 1), (boolean)false, (int)4, null);
        }
        return null;
    }

    private static final List findByName$lambda$0(Project $project, String $filename) {
        try {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)(((CharSequence)$filename).length() == 0 ? "index.html" : $filename), (GlobalSearchScope)scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Collection files2 = collection;
            if (files2.isEmpty() && ((CharSequence)$filename).length() == 0) {
                files2 = FilenameIndex.getVirtualFilesByName((String)"index.xhtml", (GlobalSearchScope)scope);
            }
            if (files2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            SmartList result = new SmartList();
            for (VirtualFile file : files2) {
                if (projectFileIndex2.isInLibrary(file)) continue;
                result.add((Object)file);
            }
            return (List)result;
        }
        catch (IndexNotReadyException e) {
            DumbService dumbService = DumbService.Companion.getInstance($project);
            String string = JSDebuggerBundle.message("js.file.mapping.indexing", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.RemoteDebuggingFileFinder);
            return CollectionsKt.emptyList();
        }
    }

    public static final /* synthetic */ VirtualFile access$findByMappings(Url parsedUrl, BiMap mappings) {
        return RemoteDebuggingFileFinderKt.findByMappings(parsedUrl, (BiMap<String, VirtualFile>)mappings);
    }

    public static final /* synthetic */ Key access$getPREDEFINED_MAPPINGS_KEY$p() {
        return PREDEFINED_MAPPINGS_KEY;
    }

    public static final /* synthetic */ VirtualFile access$findByName(String filename, Project project, Url url) {
        return RemoteDebuggingFileFinderKt.findByName(filename, project, url);
    }

    static {
        Key key = Key.create((String)"js.debugger.predefined.mappings");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREDEFINED_MAPPINGS_KEY = key;
    }
}

