/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.completion.ml.personalization.session.CompletionSelectionTracker;
import com.intellij.completion.ml.personalization.session.PeriodTracker;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000f\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl;", "Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTracker;", "<init>", "()V", "periodTracker", "Lcom/intellij/completion/ml/personalization/session/PeriodTracker;", "getTotalTimeInSelection", "", "getTimesInSelection", "", "getAverageTimeInSelection", "", "getMaxTimeInSelection", "()Ljava/lang/Long;", "getMinTimeInSelection", "selectionStartedTimestamp", "itemSelected", "", "itemUnselected", "currentSelectionTime", "Companion", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nCompletionSelectionTrackerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSelectionTrackerImpl.kt\ncom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n15#2:45\n*S KotlinDebug\n*F\n+ 1 CompletionSelectionTrackerImpl.kt\ncom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl\n*L\n10#1:45\n*E\n"})
public final class CompletionSelectionTrackerImpl
implements CompletionSelectionTracker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PeriodTracker periodTracker = new PeriodTracker();
    private long selectionStartedTimestamp = -1L;
    @NotNull
    private static final Logger LOG;

    @Override
    public long getTotalTimeInSelection() {
        return this.periodTracker.totalTime(this.currentSelectionTime());
    }

    @Override
    public int getTimesInSelection() {
        return this.periodTracker.count(this.currentSelectionTime());
    }

    @Override
    public double getAverageTimeInSelection() {
        return this.periodTracker.average(this.currentSelectionTime());
    }

    @Override
    @Nullable
    public Long getMaxTimeInSelection() {
        return this.periodTracker.maxDuration(this.currentSelectionTime());
    }

    @Override
    @Nullable
    public Long getMinTimeInSelection() {
        return this.periodTracker.minDuration(this.currentSelectionTime());
    }

    public final void itemSelected() {
        LOG.assertTrue(this.selectionStartedTimestamp == -1L, (Object)"Element already selected");
        this.selectionStartedTimestamp = System.currentTimeMillis();
    }

    public final void itemUnselected() {
        long timestamp = this.selectionStartedTimestamp;
        if (timestamp != -1L) {
            this.periodTracker.addDuration(System.currentTimeMillis() - timestamp);
            this.selectionStartedTimestamp = -1L;
        } else {
            LOG.error("Element should be selected");
        }
    }

    private final Long currentSelectionTime() {
        long selectionStarted = this.selectionStartedTimestamp;
        if (selectionStarted != -1L) {
            return System.currentTimeMillis() - selectionStarted;
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompletionSelectionTrackerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionSelectionTrackerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

