/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.TransferCancelledException;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        Objects.requireNonNull(task, "task cannot be null");
        this.failIfClosed(task);
        this.implPeek(task);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    @Override
    public void get(GetTask task) throws Exception {
        Objects.requireNonNull(task, "task cannot be null");
        this.failIfClosed(task);
        this.implGet(task);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void utilGet(GetTask task, InputStream is, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        try (OutputStream os = task.newOutputStream(resume);){
            task.getListener().transportStarted(resume ? task.getResumeOffset() : 0L, length);
            AbstractTransporter.copy(os, is, task.getListener());
        }
        finally {
            if (close) {
                is.close();
            }
        }
    }

    @Override
    public void put(PutTask task) throws Exception {
        Objects.requireNonNull(task, "task cannot be null");
        this.failIfClosed(task);
        this.implPut(task);
    }

    protected abstract void implPut(PutTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void utilPut(PutTask task, OutputStream os, boolean close) throws IOException, TransferCancelledException {
        try (InputStream is = task.newInputStream();){
            task.getListener().transportStarted(0L, task.getDataLength());
            AbstractTransporter.copy(os, is, task.getListener());
        }
        finally {
            if (close) {
                os.close();
            } else {
                os.flush();
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
    }

    private static void copy(OutputStream os, InputStream is, TransportListener listener2) throws IOException, TransferCancelledException {
        byte[] buffer = new byte[32768];
        int read = is.read(buffer);
        while (read >= 0) {
            os.write(buffer, 0, read);
            listener2.transportProgressed(ByteBuffer.wrap(buffer, 0, read));
            read = is.read(buffer);
        }
    }
}

