/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.DialogVisibilityController;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSqlParametersPanelAction
extends DumbAwareAction {
    private static final Key<ScriptModel.PStorage> PARAM_STORAGE_KEY = Key.create((String)"sql.parameters");
    private static final Key<ParametersHolder> HOLDER_KEY = Key.create((String)"sql.parameters.holder");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        ActionDataContext context;
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(1);
        }
        boolean visible = (context = ShowSqlParametersPanelAction.getActionDataContext(e)) != null;
        e.getPresentation().setVisible(visible);
        boolean enabled = visible && ShowSqlParametersPanelAction.getActionData(e, context) != null;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(2);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ParametersHolder holder = ShowSqlParametersPanelAction.getParametersHolder(e);
        if (holder != null) {
            holder.toggleParamContent(true);
        }
    }

    @NotNull
    public static ScriptModel.PStorage getStorage(@NotNull JdbcConsole console) {
        ScriptModel.PStorage oldStorage;
        if (console == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(3);
        }
        if ((oldStorage = (ScriptModel.PStorage)console.getUserData(PARAM_STORAGE_KEY)) != null) {
            ScriptModel.PStorage pStorage = oldStorage;
            if (pStorage == null) {
                ShowSqlParametersPanelAction.$$$reportNull$$$0(4);
            }
            return pStorage;
        }
        ScriptModel.PStorage newStorage = ScriptModel.PStorage.newStorage();
        console.putUserData(PARAM_STORAGE_KEY, newStorage);
        ScriptModel.PStorage pStorage = newStorage;
        if (pStorage == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(5);
        }
        return pStorage;
    }

    public static void migrate(@Nullable JdbcConsole from, @NotNull JdbcConsole to) {
        ScriptModel.PStorage oldStorage;
        if (to == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(6);
        }
        ScriptModel.PStorage pStorage = oldStorage = from == null ? null : (ScriptModel.PStorage)from.getUserData(PARAM_STORAGE_KEY);
        if (oldStorage != null) {
            to.putUserData(PARAM_STORAGE_KEY, oldStorage);
        }
    }

    @Nullable
    private static ParametersHolder getParametersHolder(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(7);
        }
        ActionData data = ShowSqlParametersPanelAction.getActionData(e);
        Project project = e.getProject();
        return data == null || project == null ? null : ShowSqlParametersPanelAction.getParametersHolder(project, data);
    }

    @NotNull
    static ParametersHolder getParametersHolder(@NotNull Project project, @NotNull ActionData data) {
        ParametersHolder existing2;
        if (project == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(8);
        }
        if (data == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(9);
        }
        if ((existing2 = (ParametersHolder)HOLDER_KEY.get((UserDataHolder)data.console)) != null) {
            ParametersHolder parametersHolder = existing2;
            if (parametersHolder == null) {
                ShowSqlParametersPanelAction.$$$reportNull$$$0(10);
            }
            return parametersHolder;
        }
        Disposable disposable = () -> HOLDER_KEY.set((UserDataHolder)data.console, null);
        DialogVisibilityController controller = new DialogVisibilityController(disposable);
        ScriptModel.PStorage storage = ShowSqlParametersPanelAction.getStorage(data.console);
        MyHelper helper = new MyHelper(data.virtualFile, data.editor);
        ParametersHolder holder = new ParametersHolder(project, storage, data.info.model, helper, controller);
        Disposer.register((Disposable)disposable, (Disposable)holder);
        HOLDER_KEY.set((UserDataHolder)data.console, (Object)holder);
        holder.attachToEditor();
        ParametersHolder parametersHolder = holder;
        if (parametersHolder == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(11);
        }
        return parametersHolder;
    }

    @Nullable
    static ActionData getActionData(@NotNull AnActionEvent e) {
        ActionDataContext context;
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(12);
        }
        return (context = ShowSqlParametersPanelAction.getActionDataContext(e)) != null ? ShowSqlParametersPanelAction.getActionData(e, context) : null;
    }

    @Nullable
    private static ActionData getActionData(@NotNull AnActionEvent e, @NotNull ActionDataContext context) {
        JdbcConsoleProvider.Info info2;
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(14);
        }
        return (info2 = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption(), null)) != null ? new ActionData(context, info2) : null;
    }

    private static ActionDataContext getActionDataContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(15);
        }
        Project project = e.getProject();
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console == null || project == null || virtualFile == null || editor2 == null || !JdbcConsoleProvider.isSqlAtPlace(file, editor2)) {
            return null;
        }
        return new ActionDataContext(editor2, virtualFile, console);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 9, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ShowSqlParametersPanelAction";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParametersHolder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getActionData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getActionDataContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 9, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    private static class ActionDataContext {
        final Editor editor;
        final VirtualFile virtualFile;
        final JdbcConsole console;

        ActionDataContext(@NotNull Editor editor2, @NotNull VirtualFile virtualFile, @NotNull JdbcConsole console) {
            if (editor2 == null) {
                ActionDataContext.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                ActionDataContext.$$$reportNull$$$0(1);
            }
            if (console == null) {
                ActionDataContext.$$$reportNull$$$0(2);
            }
            this.editor = editor2;
            this.virtualFile = virtualFile;
            this.console = console;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction$ActionDataContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ActionData {
        final Editor editor;
        final VirtualFile virtualFile;
        final JdbcConsole console;
        final JdbcConsoleProvider.Info info;

        ActionData(@NotNull ActionDataContext context, @NotNull JdbcConsoleProvider.Info info2) {
            if (context == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            if (info2 == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            this.editor = context.editor;
            this.virtualFile = context.virtualFile;
            this.console = context.console;
            this.info = info2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction$ActionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyHelper
    implements ParametersHolder.Helper {
        private final VirtualFile myVirtualFile;
        private final Editor myEditor;

        MyHelper(@NotNull VirtualFile file, @NotNull Editor editor2) {
            if (file == null) {
                MyHelper.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                MyHelper.$$$reportNull$$$0(1);
            }
            this.myVirtualFile = file;
            this.myEditor = editor2;
        }

        @Override
        @NotNull
        public Document getDocument() {
            Document document = this.myEditor.getDocument();
            if (document == null) {
                MyHelper.$$$reportNull$$$0(2);
            }
            return document;
        }

        @Override
        @NotNull
        public Editor getEditor() {
            Editor editor2 = this.myEditor;
            if (editor2 == null) {
                MyHelper.$$$reportNull$$$0(3);
            }
            return editor2;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                MyHelper.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @Override
        public boolean shouldOpenFileOnEditParameters() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ShowSqlParametersPanelAction$MyHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction$MyHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

