/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.IdatChunkWriter;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.pixels.CompressorStream;
import org.jetbrains.letsPlot.util.pngj.pixels.CompressorStreamDeflater;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\r\b \u0018\u0000 K2\u00020\u0001:\u0001KB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H$J(\u00108\u001a\u0002072\u0006\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u0002072\u0006\u0010<\u001a\u000207H\u0004J\b\u0010=\u001a\u000207H&J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020.J\b\u0010A\u001a\u000204H\u0004J\b\u0010B\u001a\u000204H\u0014J\u000e\u0010C\u001a\u0002042\u0006\u00106\u001a\u000207J\u0010\u0010D\u001a\u0002042\u0006\u0010E\u001a\u000207H\u0004J\u0010\u0010F\u001a\u0002042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010G\u001a\u0002042\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010H\u001a\u0002042\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010I\u001a\u0002042\u0006\u0010J\u001a\u00020.R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u0014R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010)R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006L"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriter;", "", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "buflen", "", "getBuflen", "()I", "bytesPixel", "bytesRow", "compression", "", "getCompression", "()D", "compressorStream", "Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStream;", "currentRow", "getCurrentRow", "setCurrentRow", "(I)V", "defaultFilter", "Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "getDefaultFilter", "()Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "deflaterCompLevel", "getDeflaterCompLevel", "setDeflaterCompLevel", "deflaterStrategy", "filterType", "getFilterType", "setFilterType", "(Lorg/jetbrains/letsPlot/util/pngj/FilterType;)V", "filtersUsed", "", "idatMaxSize", "getImgInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "initdone", "", "getInitdone", "()Z", "setInitdone", "(Z)V", "isDone", "os", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "totalBytesToWrite", "", "getTotalBytesToWrite", "()J", "close", "", "filterAndWrite", "rowb", "", "filterRowWithFilterType", "_filterType", "_rowb", "_rowbprev", "_rowf", "getCurentRowb", "getFiltersUsed", "", "getOs", "init", "initParams", "processRow", "sendToCompressedStream", "rowf", "setCompressorStream", "setDeflaterStrategy", "setIdatMaxSize", "setOs", "datStream", "Companion", "plot-api"})
public abstract class PixelsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageInfo imgInfo;
    private final int buflen;
    private final int bytesPixel;
    private final int bytesRow;
    @Nullable
    private CompressorStream compressorStream;
    private int deflaterCompLevel;
    private int deflaterStrategy;
    private boolean initdone;
    @NotNull
    private FilterType filterType;
    @NotNull
    private final int[] filtersUsed;
    private OutputPngStream os;
    private int idatMaxSize;
    private int currentRow;
    private static final int IDAT_MAX_SIZE_DEFAULT = 32000;

    public PixelsWriter(@NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this.imgInfo = imgInfo;
        this.deflaterCompLevel = 6;
        this.filtersUsed = new int[5];
        this.idatMaxSize = 32000;
        this.bytesRow = this.imgInfo.getBytesPerRow();
        this.buflen = this.bytesRow + 1;
        this.bytesPixel = this.imgInfo.getBytesPixel();
        this.currentRow = -1;
        this.filterType = FilterType.FILTER_DEFAULT;
    }

    @NotNull
    protected final ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    protected final int getBuflen() {
        return this.buflen;
    }

    public final int getDeflaterCompLevel() {
        return this.deflaterCompLevel;
    }

    public final void setDeflaterCompLevel(int n) {
        this.deflaterCompLevel = n;
    }

    protected final boolean getInitdone() {
        return this.initdone;
    }

    protected final void setInitdone(boolean bl) {
        this.initdone = bl;
    }

    @NotNull
    public final FilterType getFilterType() {
        return this.filterType;
    }

    public final void setFilterType(@NotNull FilterType filterType) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"<set-?>");
        this.filterType = filterType;
    }

    protected final int getCurrentRow() {
        return this.currentRow;
    }

    protected final void setCurrentRow(int n) {
        this.currentRow = n;
    }

    public final void processRow(@NotNull byte[] rowb) {
        Intrinsics.checkNotNullParameter((Object)rowb, (String)"rowb");
        if (!this.initdone) {
            this.init();
        }
        int n = this.currentRow;
        this.currentRow = n + 1;
        this.filterAndWrite(rowb);
    }

    protected final void sendToCompressedStream(@NotNull byte[] rowf) {
        Intrinsics.checkNotNullParameter((Object)rowf, (String)"rowf");
        CompressorStream compressorStream = this.compressorStream;
        Intrinsics.checkNotNull((Object)compressorStream);
        compressorStream.write(rowf, 0, rowf.length);
        int[] nArray = this.filtersUsed;
        byte by = rowf[0];
        int n = nArray[by];
        nArray[by] = n + 1;
    }

    protected abstract void filterAndWrite(@NotNull byte[] var1);

    @NotNull
    protected final byte[] filterRowWithFilterType(@NotNull FilterType _filterType, @NotNull byte[] _rowb, @NotNull byte[] _rowbprev, @NotNull byte[] _rowf) {
        Intrinsics.checkNotNullParameter((Object)((Object)_filterType), (String)"_filterType");
        Intrinsics.checkNotNullParameter((Object)_rowb, (String)"_rowb");
        Intrinsics.checkNotNullParameter((Object)_rowbprev, (String)"_rowbprev");
        Intrinsics.checkNotNullParameter((Object)_rowf, (String)"_rowf");
        byte[] _rowf2 = _rowf;
        if (_filterType == FilterType.FILTER_NONE) {
            _rowf2 = _rowb;
        }
        _rowf2[0] = (byte)_filterType.getValue();
        int i = 0;
        int j = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[_filterType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                for (i = 1; i <= this.bytesPixel; ++i) {
                    _rowf2[i] = (byte)PngHelperInternal.INSTANCE.filterRowPaeth(_rowb[i], 0, _rowbprev[i] & 0xFF, 0);
                }
                j = 1;
                i = this.bytesPixel + 1;
                while (i <= this.bytesRow) {
                    _rowf2[i] = (byte)PngHelperInternal.INSTANCE.filterRowPaeth(_rowb[i], _rowb[j] & 0xFF, _rowbprev[i] & 0xFF, _rowbprev[j] & 0xFF);
                    ++i;
                    ++j;
                }
                break;
            }
            case 3: {
                for (i = 1; i <= this.bytesPixel; ++i) {
                    _rowf2[i] = _rowb[i];
                }
                j = 1;
                i = this.bytesPixel + 1;
                while (i <= this.bytesRow) {
                    _rowf2[i] = (byte)(_rowb[i] - _rowb[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case 4: {
                for (i = 1; i <= this.bytesPixel; ++i) {
                    _rowf2[i] = (byte)(_rowb[i] - (_rowbprev[i] & 0xFF) / 2);
                }
                j = 1;
                i = this.bytesPixel + 1;
                while (i <= this.bytesRow) {
                    _rowf2[i] = (byte)(_rowb[i] - ((_rowbprev[i] & 0xFF) + (_rowb[j] & 0xFF)) / 2);
                    ++i;
                    ++j;
                }
                break;
            }
            case 5: {
                for (i = 1; i <= this.bytesRow; ++i) {
                    _rowf2[i] = (byte)(_rowb[i] - _rowbprev[i]);
                }
                break;
            }
            default: {
                throw new PngjOutputException("Filter type not recognized: " + (Object)((Object)_filterType));
            }
        }
        return _rowf2;
    }

    @NotNull
    public abstract byte[] getCurentRowb();

    protected final void init() {
        if (!this.initdone) {
            this.initParams();
            this.initdone = true;
        }
    }

    protected void initParams() {
        OutputPngStream outputPngStream = this.os;
        if (outputPngStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"os");
            outputPngStream = null;
        }
        IdatChunkWriter idatWriter = new IdatChunkWriter(outputPngStream, this.idatMaxSize);
        if (this.compressorStream == null) {
            this.compressorStream = new CompressorStreamDeflater(idatWriter, this.buflen, this.imgInfo.getTotalRawBytes(), this.deflaterCompLevel, this.deflaterStrategy);
        }
    }

    public void close() {
        if (this.compressorStream != null) {
            CompressorStream compressorStream = this.compressorStream;
            Intrinsics.checkNotNull((Object)compressorStream);
            compressorStream.close();
        }
    }

    public final void setDeflaterStrategy(int deflaterStrategy) {
        this.deflaterStrategy = deflaterStrategy;
    }

    public final void setOs(@NotNull OutputPngStream datStream) {
        Intrinsics.checkNotNullParameter((Object)datStream, (String)"datStream");
        this.os = datStream;
    }

    @NotNull
    public final OutputPngStream getOs() {
        OutputPngStream outputPngStream = this.os;
        if (outputPngStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"os");
            outputPngStream = null;
        }
        return outputPngStream;
    }

    public final double getCompression() {
        double d;
        CompressorStream compressorStream = this.compressorStream;
        Intrinsics.checkNotNull((Object)compressorStream);
        if (compressorStream.isDone()) {
            CompressorStream compressorStream2 = this.compressorStream;
            Intrinsics.checkNotNull((Object)compressorStream2);
            d = compressorStream2.getCompressionRatio();
        } else {
            d = 1.0;
        }
        return d;
    }

    public final void setCompressorStream(@Nullable CompressorStream compressorStream) {
        this.compressorStream = compressorStream;
    }

    public final long getTotalBytesToWrite() {
        return this.imgInfo.getTotalRawBytes();
    }

    public final boolean isDone() {
        return this.currentRow == this.imgInfo.getRows() - 1;
    }

    @NotNull
    protected final FilterType getDefaultFilter() {
        return this.imgInfo.getIndexed() || this.imgInfo.getBitDepth() < 8 ? FilterType.FILTER_NONE : (this.imgInfo.getTotalPixels() < 1024L ? FilterType.FILTER_NONE : (this.imgInfo.getRows() == 1 ? FilterType.FILTER_SUB : (this.imgInfo.getCols() == 1 ? FilterType.FILTER_UP : FilterType.FILTER_PAETH)));
    }

    @NotNull
    public final String getFiltersUsed() {
        return "" + ((double)this.filtersUsed[0] * 100.0 / (double)this.imgInfo.getRows() + 0.5) + ',' + ((double)this.filtersUsed[1] * 100.0 / (double)this.imgInfo.getRows() + 0.5) + ',' + ((double)this.filtersUsed[2] * 100.0 / (double)this.imgInfo.getRows() + 0.5) + ',' + ((double)this.filtersUsed[3] * 100.0 / (double)this.imgInfo.getRows() + 0.5) + ',' + ((double)this.filtersUsed[4] * 100.0 / (double)this.imgInfo.getRows() + 0.5);
    }

    public final void setIdatMaxSize(int idatMaxSize) {
        this.idatMaxSize = idatMaxSize;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriter$Companion;", "", "()V", "IDAT_MAX_SIZE_DEFAULT", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterType.values().length];
            try {
                nArray[FilterType.FILTER_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_PAETH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_SUB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_AVERAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

