/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.CustomSuggestion;
import training.featuresSuggester.FeatureSuggestersManagerListener;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.UiSuggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorFocusGainedAction;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.suggesters.FeatureSuggester;
import training.featuresSuggester.ui.NotificationSuggestionPresenter;
import training.featuresSuggester.ui.SuggestionPresenter;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltraining/featuresSuggester/FeatureSuggestersManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "suggestionPresenter", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "actionPerformed", "", "action", "Ltraining/featuresSuggester/actions/Action;", "handleAction", "processSuggester", "suggester", "Ltraining/featuresSuggester/suggesters/FeatureSuggester;", "fireSuggestionFound", "suggestion", "Ltraining/featuresSuggester/UiSuggestion;", "initFocusListener", "dispose", "isEnabled", "", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nFeatureSuggestersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSuggestersManager.kt\ntraining/featuresSuggester/FeatureSuggestersManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n25#2:100\n774#3:101\n865#3,2:102\n774#3:104\n865#3:105\n866#3:107\n1#4:106\n*S KotlinDebug\n*F\n+ 1 FeatureSuggestersManager.kt\ntraining/featuresSuggester/FeatureSuggestersManager\n*L\n40#1:100\n48#1:101\n48#1:102,2\n49#1:104\n49#1:105\n49#1:107\n*E\n"})
public final class FeatureSuggestersManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final SuggestionPresenter suggestionPresenter;

    public FeatureSuggestersManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.suggestionPresenter = new NotificationSuggestionPresenter();
        if (!this.project.isDefault()) {
            this.initFocusListener();
        }
    }

    public final void actionPerformed(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        try {
            this.handleAction(action);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            FeatureSuggestersManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FeatureSuggestersManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("An error occurred during action processing: " + action, t);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleAction(Action action) {
        language = action.getLanguage();
        needSendStatisticsForSwitchedOffCheckers = FeatureSuggesterSettings.Companion.instance().getNeedSendStatisticsForSwitchedOffCheckers();
        var5_4 = FeatureSuggester.Companion.getSuggesters();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (FeatureSuggester)element$iv$iv;
            $i$a$-filter-FeatureSuggestersManager$handleAction$suggesters$1 = false;
            if (!(it.getForceCheckForStatistics() != false && needSendStatisticsForSwitchedOffCheckers != false || this.isEnabled(it) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                it = (FeatureSuggester)element$iv$iv;
                $i$a$-filter-FeatureSuggestersManager$handleAction$suggesters$2 = false;
                var14_14 = it.getLanguages();
                for (T var16_16 : var14_14) {
                    id = (String)var16_16;
                    $i$a$-find-FeatureSuggestersManager$handleAction$suggesters$2$1 = false;
                    if (Intrinsics.areEqual((Object)id, (Object)Language.ANY.getID())) ** GOTO lbl-1000
                    v0 = language;
                    if (Intrinsics.areEqual((Object)id, (Object)(v0 != null ? v0.getID() : null))) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var16_16;
                    break block6;
                }
                v2 = null;
            }
            if (!(v2 != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suggesters = (List)destination$iv$iv;
        for (FeatureSuggester suggester : suggesters) {
            this.processSuggester(suggester, action);
        }
    }

    private final void processSuggester(FeatureSuggester suggester, Action action) {
        Suggestion suggestion = suggester.getSuggestion(action);
        if (suggestion instanceof UiSuggestion) {
            suggester.logStatisticsThatSuggestionIsFound(suggestion);
            if (this.isEnabled(suggester) && (SuggestingUtils.INSTANCE.getForceShowSuggestions() || suggester.isSuggestionNeeded())) {
                UiSuggestion uiSuggestion = (UiSuggestion)suggestion;
                if (uiSuggestion instanceof PopupSuggestion) {
                    this.suggestionPresenter.showSuggestion(this.project, (PopupSuggestion)suggestion, this.coroutineScope);
                } else if (uiSuggestion instanceof CustomSuggestion) {
                    ((CustomSuggestion)suggestion).getActivate().invoke();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.fireSuggestionFound((UiSuggestion)suggestion);
                FeatureSuggesterSettings.Companion.instance().updateSuggestionShownTime(((UiSuggestion)suggestion).getSuggesterId());
            }
        }
    }

    private final void fireSuggestionFound(UiSuggestion suggestion) {
        ((FeatureSuggestersManagerListener)this.project.getMessageBus().syncPublisher(FeatureSuggestersManagerListener.Companion.getTOPIC())).featureFound(suggestion);
    }

    private final void initFocusListener() {
        block0: {
            EditorEventMulticasterEx eventMulticaster;
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            EditorEventMulticasterEx editorEventMulticasterEx = eventMulticaster = editorEventMulticaster instanceof EditorEventMulticasterEx ? (EditorEventMulticasterEx)editorEventMulticaster : null;
            if (editorEventMulticasterEx == null) break block0;
            editorEventMulticasterEx.addFocusChangeListener(new FocusChangeListener(this){
                final /* synthetic */ FeatureSuggestersManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)FeatureSuggestersManager.access$getProject$p(this.this$0)) || !SuggestingUtils.INSTANCE.isActionsProcessingEnabled(FeatureSuggestersManager.access$getProject$p(this.this$0))) {
                        return;
                    }
                    this.this$0.actionPerformed(new EditorFocusGainedAction(editor, System.currentTimeMillis()));
                }
            }, (Disposable)this);
        }
    }

    public void dispose() {
    }

    private final boolean isEnabled(FeatureSuggester $this$isEnabled) {
        return FeatureSuggesterSettings.Companion.instance().isEnabled($this$isEnabled.getId());
    }

    public static final /* synthetic */ Project access$getProject$p(FeatureSuggestersManager $this) {
        return $this.project;
    }
}

