/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath;

import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathIdSegment;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsonPathSpellcheckerStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private final Tokenizer<JsonPathStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonPathStringLiteral>(){

        public void tokenize(@NotNull JsonPathStringLiteral element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    TextRange fragmentRange = (TextRange)fragment.getFirst();
                    String escaped = (String)fragment.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer.consumeToken((PsiElement)element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), (Splitter)textSplitter);
                }
            } else {
                consumer.consumeToken((PsiElement)element, (Splitter)textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathSpellcheckerStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final Tokenizer<JsonPathId> idLiteralTokenizer = new Tokenizer<JsonPathId>(){

        public void tokenize(@NotNull JsonPathId element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                2.$$$reportNull$$$0(1);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            consumer.consumeToken((PsiElement)element, (Splitter)textSplitter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathSpellcheckerStrategy$2";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof JsonPathStringLiteral) {
            Tokenizer<JsonPathStringLiteral> tokenizer = this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonPathSpellcheckerStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof JsonPathId && element.getParent() instanceof JsonPathIdSegment) {
            Tokenizer<JsonPathId> tokenizer = this.idLiteralTokenizer;
            if (tokenizer == null) {
                JsonPathSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JsonPathSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsonpath/JsonPathSpellcheckerStrategy", "getTokenizer"));
    }
}

