/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.BuiltinResourceDownloader;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerResource;
import com.intellij.docker.agent.devcontainers.feautures.DirectTarballResourceDownloader;
import com.intellij.docker.agent.devcontainers.feautures.LocalFeatureDownloader;
import com.intellij.docker.agent.devcontainers.feautures.OCIFeatureDownloader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResourceDownloader;", "", "resource", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "workingDir", "Ljava/nio/file/Path;", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "<init>", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;Ljava/nio/file/Path;Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;)V", "getResource", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "getWorkingDir", "()Ljava/nio/file/Path;", "getProxy", "()Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "downloadAndExtract", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.clouds.docker.agent"})
public abstract class DevcontainerResourceDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevcontainerResource resource;
    @NotNull
    private final Path workingDir;
    @NotNull
    private final DevcontainerDataExchangeProxy proxy;
    @NotNull
    public static final String JSON_CONTENT_TYPE = "application/vnd.oci.image.manifest.v1+json";

    public DevcontainerResourceDownloader(@NotNull DevcontainerResource resource, @NotNull Path workingDir2, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.resource = resource;
        this.workingDir = workingDir2;
        this.proxy = proxy;
    }

    @NotNull
    protected final DevcontainerResource getResource() {
        return this.resource;
    }

    @NotNull
    protected final Path getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    protected final DevcontainerDataExchangeProxy getProxy() {
        return this.proxy;
    }

    @Nullable
    public abstract Object downloadAndExtract(@NotNull Continuation<? super Path> var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResourceDownloader$Companion;", "", "<init>", "()V", "JSON_CONTENT_TYPE", "", "create", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResourceDownloader;", "workingDir", "Ljava/nio/file/Path;", "resource", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource;", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DevcontainerResourceDownloader create(@NotNull Path workingDir2, @NotNull DevcontainerResource resource, @NotNull DevcontainerDataExchangeProxy proxy) {
            Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            return switch (WhenMappings.$EnumSwitchMapping$0[resource.getRef().getSource().ordinal()]) {
                case 1 -> new OCIFeatureDownloader(resource, workingDir2, proxy);
                case 2 -> new LocalFeatureDownloader(resource, workingDir2, proxy);
                case 3 -> new DirectTarballResourceDownloader(resource, workingDir2, proxy);
                case 4 -> new BuiltinResourceDownloader(resource, workingDir2, proxy);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DevcontainerResource.SourceType.values().length];
                try {
                    nArray[DevcontainerResource.SourceType.OCIRegistry.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DevcontainerResource.SourceType.Local.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DevcontainerResource.SourceType.DirectTarball.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DevcontainerResource.SourceType.BuiltIn.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

