/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class UncompressedZipPath
implements Path {
    @NotNull
    private final UncompressedZipFileSystem myFileSystem;
    private final String @NotNull [] myNameElements;
    private final boolean myAbsolute;

    public UncompressedZipPath(@NotNull UncompressedZipFileSystem system, String @NotNull [] elements, boolean absolute) {
        if (system == null) {
            UncompressedZipPath.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            UncompressedZipPath.$$$reportNull$$$0(1);
        }
        this.myFileSystem = system;
        this.myNameElements = elements;
        this.myAbsolute = absolute;
    }

    String @NotNull [] getNameElements() {
        if (this.myNameElements == null) {
            UncompressedZipPath.$$$reportNull$$$0(2);
        }
        return this.myNameElements;
    }

    @Override
    @NotNull
    public UncompressedZipFileSystem getFileSystem() {
        UncompressedZipFileSystem uncompressedZipFileSystem = this.myFileSystem;
        if (uncompressedZipFileSystem == null) {
            UncompressedZipPath.$$$reportNull$$$0(3);
        }
        return uncompressedZipFileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.myAbsolute;
    }

    @Override
    public Path getRoot() {
        return this.isAbsolute() ? new UncompressedZipPath(this.myFileSystem, ArrayUtil.EMPTY_STRING_ARRAY, true) : null;
    }

    @Override
    public Path getFileName() {
        if (this.myNameElements.length == 0) {
            return new UncompressedZipPath(this.myFileSystem, this.myNameElements, false);
        }
        return this.getName(this.getNameCount() - 1);
    }

    @Override
    public Path getParent() {
        if (this.myNameElements.length == 0) {
            throw new AssertionError();
        }
        String[] parentElements = (String[])ArrayUtil.remove((Object[])this.myNameElements, (int)(this.myNameElements.length - 1), (ArrayFactory)ArrayUtil.STRING_ARRAY_FACTORY);
        return new UncompressedZipPath(this.myFileSystem, parentElements, this.myAbsolute);
    }

    @Override
    public int getNameCount() {
        return this.myNameElements.length;
    }

    @Override
    @NotNull
    public Path getName(int index) {
        if (index >= this.myNameElements.length) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " for " + String.valueOf(this));
        }
        return new UncompressedZipPath(this.myFileSystem, new String[]{this.myNameElements[index]}, false);
    }

    @Override
    @NotNull
    public Path subpath(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("subpath operation is not supported for " + String.valueOf(this));
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException("startsWith operation is not supported for " + String.valueOf(this));
    }

    @Override
    public boolean startsWith(@NotNull String other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("startsWith operation is not supported for " + String.valueOf(this));
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("endsWith operation is not supported for " + String.valueOf(this));
    }

    @Override
    public boolean endsWith(@NotNull String other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("endsWith operation is not supported for " + String.valueOf(this));
    }

    @Override
    public Path normalize() {
        String separator = this.myFileSystem.getSeparator();
        String path = FileUtilRt.toCanonicalPath((String)StringUtil.join((String[])this.myNameElements, (String)separator), (char)separator.charAt(0), (boolean)true);
        return new UncompressedZipPath(this.myFileSystem, ArrayUtil.toStringArray((Collection)StringUtil.split((String)path, (String)separator)), this.myAbsolute);
    }

    @Override
    @NotNull
    public Path resolve(@NotNull Path other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(8);
        }
        if (other.isAbsolute()) {
            Path path = other;
            if (path == null) {
                UncompressedZipPath.$$$reportNull$$$0(9);
            }
            return path;
        }
        String[] toAppend = ((UncompressedZipPath)other).myNameElements;
        return new UncompressedZipPath(this.myFileSystem, ArrayUtil.mergeArrays((String[])this.myNameElements, (String[])toAppend), this.myAbsolute);
    }

    @Override
    @NotNull
    public Path resolve(@NotNull String other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(10);
        }
        String[] toAppend = ArrayUtil.toStringArray((Collection)StringUtil.split((String)other, (String)this.myFileSystem.getSeparator()));
        return new UncompressedZipPath(this.myFileSystem, ArrayUtil.mergeArrays((String[])this.myNameElements, (String[])toAppend), this.myAbsolute);
    }

    @Override
    @NotNull
    public Path resolveSibling(@NotNull Path other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(11);
        }
        Path path = this.getParent().resolve(other);
        if (path == null) {
            UncompressedZipPath.$$$reportNull$$$0(12);
        }
        return path;
    }

    @Override
    @NotNull
    public Path resolveSibling(@NotNull String other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(13);
        }
        Path path = this.getParent().resolve(other);
        if (path == null) {
            UncompressedZipPath.$$$reportNull$$$0(14);
        }
        return path;
    }

    @Override
    @NotNull
    public Path relativize(@NotNull Path other) {
        if (other == null) {
            UncompressedZipPath.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException("relativize operation is not supported for " + String.valueOf(this));
    }

    @Override
    @NotNull
    public URI toUri() {
        throw new UnsupportedOperationException("toUri operation is not supported for " + String.valueOf(this));
    }

    @Override
    @NotNull
    public Path toAbsolutePath() {
        String separator = this.myFileSystem.getSeparator();
        String path = FileUtilRt.toCanonicalPath((String)String.join((CharSequence)separator, this.myNameElements), (char)separator.charAt(0), (boolean)true);
        return new UncompressedZipPath(this.myFileSystem, ArrayUtil.toStringArray((Collection)StringUtil.split((String)path, (String)separator)), true);
    }

    @Override
    @NotNull
    public Path toRealPath(LinkOption ... options) {
        if (options == null) {
            UncompressedZipPath.$$$reportNull$$$0(16);
        }
        if (!this.myAbsolute) {
            UncompressedZipPath absolutePath = (UncompressedZipPath)this.toAbsolutePath();
            Path path = absolutePath.toRealPath(options);
            if (path == null) {
                UncompressedZipPath.$$$reportNull$$$0(17);
            }
            return path;
        }
        UncompressedZipPath uncompressedZipPath = this;
        if (uncompressedZipPath == null) {
            UncompressedZipPath.$$$reportNull$$$0(18);
        }
        return uncompressedZipPath;
    }

    @Override
    @NotNull
    public File toFile() {
        throw new UnsupportedOperationException("toFile() operation is not supported for " + String.valueOf(this));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException("Register operation is not supported for " + String.valueOf(this));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        throw new UnsupportedOperationException("Register operation is not supported for " + String.valueOf(this));
    }

    @Override
    @NotNull
    public Iterator<Path> iterator() {
        Iterator<Path> iterator = Stream.of(this.myNameElements).map(n -> new UncompressedZipPath(this.myFileSystem, new String[]{n}, false)).iterator();
        if (iterator == null) {
            UncompressedZipPath.$$$reportNull$$$0(19);
        }
        return iterator;
    }

    @Override
    public int compareTo(Path other) {
        return ArrayUtil.lexicographicCompare((String[])this.myNameElements, (String[])((UncompressedZipPath)other).myNameElements);
    }

    @Override
    public String toString() {
        return StringUtil.join((String[])this.myNameElements, (String)this.myFileSystem.getSeparator());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UncompressedZipPath)) {
            return false;
        }
        UncompressedZipPath other = (UncompressedZipPath)o;
        if (!Objects.equals(this.myFileSystem, other.myFileSystem)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.myNameElements) + 43891 * this.myFileSystem.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 12, 14, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/util/zipFs/UncompressedZipPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSibling";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toRealPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveSibling";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "relativize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toRealPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 12, 14, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

