/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.tree;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SeparatorWithText;
import com.intellij.vcsUtil.Delegates;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitRefType;
import git4idea.branch.GitTagType;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.popup.GitBranchesTreePopupBase;
import git4idea.ui.branch.tree.GitBranchesTreeModel;
import git4idea.ui.branch.tree.GitBranchesTreeModelUtilKt;
import git4idea.ui.branch.tree.LazyRefsSubtreeHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ObservableProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u0012\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010&\u001a\u0004\u0018\u00010\bH\u0014J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0005H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesTreeMultiRepoModel;", "Lgit4idea/ui/branch/tree/GitBranchesTreeModel;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "topLevelActions", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;)V", "branchesSubtreeSeparator", "Lcom/intellij/ui/SeparatorWithText;", "branchManager", "Lgit4idea/ui/branch/GitBranchManager;", "commonLocalBranchesTree", "Lgit4idea/ui/branch/tree/LazyRefsSubtreeHolder;", "Lgit4idea/GitLocalBranch;", "commonRemoteBranchesTree", "Lgit4idea/GitRemoteBranch;", "commonTagsTree", "Lgit4idea/GitTag;", "<set-?>", "", "isPrefixGrouping", "()Z", "setPrefixGrouping", "(Z)V", "isPrefixGrouping$delegate", "Lkotlin/properties/ObservableProperty;", "rebuild", "", "initTags", "matcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "isLeaf", "node", "getChildren", "parent", "getTopLevelNodes", "getBranchTreeNodes", "branchType", "Lgit4idea/branch/GitRefType;", "path", "", "getPreferredSelection", "Ljavax/swing/tree/TreePath;", "getPreferredBranch", "Lgit4idea/GitReference;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreeMultiRepoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeMultiRepoModel.kt\ngit4idea/ui/branch/tree/GitBranchesTreeMultiRepoModel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Delegates.kt\ncom/intellij/vcsUtil/Delegates\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n31#2,2:105\n31#2,2:111\n31#2,2:113\n31#2,2:115\n31#2,2:127\n9#3,4:107\n381#4,7:117\n381#4,3:124\n384#4,4:129\n1#5:133\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreeMultiRepoModel.kt\ngit4idea/ui/branch/tree/GitBranchesTreeMultiRepoModel\n*L\n27#1:105,2\n46#1:111,2\n47#1:113,2\n56#1:115,2\n74#1:127,2\n33#1:107,4\n69#1:117,7\n72#1:124,3\n72#1:129,4\n*E\n"})
public final class GitBranchesTreeMultiRepoModel
extends GitBranchesTreeModel {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitRepository> repositories;
    @NotNull
    private final List<Object> topLevelActions;
    @NotNull
    private final SeparatorWithText branchesSubtreeSeparator;
    @NotNull
    private final GitBranchManager branchManager;
    private LazyRefsSubtreeHolder<GitLocalBranch> commonLocalBranchesTree;
    private LazyRefsSubtreeHolder<? extends GitRemoteBranch> commonRemoteBranchesTree;
    private LazyRefsSubtreeHolder<GitTag> commonTagsTree;
    @NotNull
    private final ObservableProperty isPrefixGrouping$delegate;

    public GitBranchesTreeMultiRepoModel(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull List<? extends Object> topLevelActions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(topLevelActions, (String)"topLevelActions");
        this.project = project;
        this.repositories = repositories;
        this.topLevelActions = topLevelActions;
        this.branchesSubtreeSeparator = GitBranchesTreePopupBase.Companion.createTreeSeparator$intellij_vcs_git$default(GitBranchesTreePopupBase.Companion, null, 1, null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.branchManager = (GitBranchManager)((Object)object);
        $this$service$iv = Delegates.INSTANCE;
        Boolean initialValue$iv = this.branchManager.isGroupingEnabled(GroupingKey.GROUPING_BY_DIRECTORY);
        boolean $i$f$equalVetoingObservable = false;
        this.isPrefixGrouping$delegate = (ObservableProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ GitBranchesTreeMultiRepoModel this$0;
            {
                this.this$0 = gitBranchesTreeMultiRepoModel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected boolean beforeChange(KProperty property, Object oldValue, Object newValue2) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return newValue2 == null || !Intrinsics.areEqual((Object)oldValue, (Object)newValue2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue2) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean it = (Boolean)newValue2;
                boolean bl = false;
                GitBranchesTreeMultiRepoModel.access$rebuild(this.this$0);
            }
        };
        this.rebuild();
    }

    public /* synthetic */ GitBranchesTreeMultiRepoModel(Project project, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(project, list, list2);
    }

    @Override
    public boolean isPrefixGrouping() {
        return (Boolean)this.isPrefixGrouping$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setPrefixGrouping(boolean bl) {
        this.isPrefixGrouping$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private final void rebuild() {
        this.getBranchesTreeCache().keySet().clear();
        List<GitLocalBranch> list = GitBranchUtil.getCommonLocalBranches((Collection<? extends GitRepository>)this.repositories);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCommonLocalBranches(...)");
        List<GitLocalBranch> localBranches2 = list;
        List<GitRemoteBranch> list2 = GitBranchUtil.getCommonRemoteBranches((Collection<? extends GitRepository>)this.repositories);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCommonRemoteBranches(...)");
        List<GitRemoteBranch> remoteBranches2 = list2;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Map map2 = ((GitBranchManager)((Object)object)).getFavoriteBranches(GitBranchType.LOCAL);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getFavoriteBranches(...)");
        Map localFavorites = map2;
        ComponentManager $this$service$iv2 = (ComponentManager)this.project;
        boolean $i$f$service2 = false;
        Class<GitBranchManager> serviceClass$iv2 = GitBranchManager.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        Map map3 = ((GitBranchManager)((Object)object2)).getFavoriteBranches(GitBranchType.REMOTE);
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getFavoriteBranches(...)");
        Map remoteFavorites = map3;
        this.commonLocalBranchesTree = new LazyRefsSubtreeHolder(this.repositories, localBranches2, localFavorites, null, (Function0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).isPrefixGrouping();
            }

            public void set(Object value) {
                ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
            }
        }, null, null, 96, null);
        this.commonRemoteBranchesTree = new LazyRefsSubtreeHolder(this.repositories, remoteBranches2, remoteFavorites, null, (Function0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).isPrefixGrouping();
            }

            public void set(Object value) {
                ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
            }
        }, null, null, 96, null);
        this.initTags(null);
        Object[] objectArray = new GitBranchesTreeModel.TreeRoot[]{this.getRoot()};
        this.treeStructureChanged(new TreePath(objectArray), null, null);
    }

    @Override
    protected void initTags(@Nullable MinusculeMatcher matcher) {
        List<GitTag> list = GitBranchUtil.getCommonTags((Collection<? extends GitRepository>)this.repositories);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCommonTags(...)");
        List<GitTag> tags2 = list;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Map map2 = ((GitBranchManager)((Object)object)).getFavoriteBranches(GitTagType.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getFavoriteBranches(...)");
        Map favoriteTags = map2;
        this.commonTagsTree = new LazyRefsSubtreeHolder(this.repositories, tags2, favoriteTags, null, (Function0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).isPrefixGrouping();
            }

            public void set(Object value) {
                ((GitBranchesTreeMultiRepoModel)((Object)this.receiver)).setPrefixGrouping((Boolean)value);
            }
        }, null, null, 96, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLeaf(@Nullable Object node) {
        if (node instanceof GitReference) return true;
        if (node instanceof GitBranchesTreeModel.RefUnderRepository) return true;
        if (node == GitBranchType.LOCAL) {
            LazyRefsSubtreeHolder<GitLocalBranch> lazyRefsSubtreeHolder = this.commonLocalBranchesTree;
            if (lazyRefsSubtreeHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonLocalBranchesTree");
                lazyRefsSubtreeHolder = null;
            }
            if (lazyRefsSubtreeHolder.isEmpty()) return true;
        }
        if (node == GitBranchType.REMOTE) {
            LazyRefsSubtreeHolder<? extends GitRemoteBranch> lazyRefsSubtreeHolder = this.commonRemoteBranchesTree;
            if (lazyRefsSubtreeHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonRemoteBranchesTree");
                lazyRefsSubtreeHolder = null;
            }
            if (lazyRefsSubtreeHolder.isEmpty()) return true;
        }
        if (node != GitTagType.INSTANCE) return false;
        LazyRefsSubtreeHolder<GitTag> lazyRefsSubtreeHolder = this.commonTagsTree;
        if (lazyRefsSubtreeHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonTagsTree");
            lazyRefsSubtreeHolder = null;
        }
        if (!lazyRefsSubtreeHolder.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Object> getChildren(@Nullable Object parent) {
        List list;
        if (parent == null) {
            return CollectionsKt.emptyList();
        }
        Object object = parent;
        if (Intrinsics.areEqual((Object)object, (Object)GitBranchesTreeModel.TreeRoot.INSTANCE)) {
            list = this.getTopLevelNodes();
        } else if (object instanceof GitRefType) {
            Object object2;
            void $this$getOrPut$iv;
            Map<Object, List<Object>> map2 = this.getBranchesTreeCache();
            Object key$iv = parent;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List<Object> answer$iv = this.getBranchTreeNodes((GitRefType)parent, CollectionsKt.emptyList());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            list = (List)object2;
        } else if (object instanceof GitBranchesTreeModel.BranchesPrefixGroup) {
            List list2;
            Map<Object, List<Object>> $this$getOrPut$iv = this.getBranchesTreeCache();
            Object key$iv = parent;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Iterable iterable = this.getBranchTreeNodes(((GitBranchesTreeModel.BranchesPrefixGroup)parent).getType(), ((GitBranchesTreeModel.BranchesPrefixGroup)parent).getPrefix());
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
                Object object3 = $this$service$iv.getService(serviceClass$iv);
                if (object3 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Map map3 = ((GitBranchManager)((Object)object3)).getFavoriteBranches(((GitBranchesTreeModel.BranchesPrefixGroup)parent).getType());
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getFavoriteBranches(...)");
                List answer$iv = CollectionsKt.sortedWith((Iterable)iterable, GitBranchesTreeModelUtilKt.getSubTreeComparator(map3, this.repositories));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Object> getTopLevelNodes() {
        List localAndRemoteNodes;
        LazyRefsSubtreeHolder<GitTag> lazyRefsSubtreeHolder;
        LazyRefsSubtreeHolder<? extends GitRemoteBranch> lazyRefsSubtreeHolder2;
        List topNodes = CollectionsKt.plus((Collection)this.topLevelActions, (Iterable)this.repositories);
        LazyRefsSubtreeHolder<GitLocalBranch> lazyRefsSubtreeHolder3 = this.commonLocalBranchesTree;
        if (lazyRefsSubtreeHolder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonLocalBranchesTree");
            lazyRefsSubtreeHolder3 = null;
        }
        if ((lazyRefsSubtreeHolder2 = this.commonRemoteBranchesTree) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonRemoteBranchesTree");
            lazyRefsSubtreeHolder2 = null;
        }
        if ((lazyRefsSubtreeHolder = this.commonTagsTree) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonTagsTree");
            lazyRefsSubtreeHolder = null;
        }
        return (localAndRemoteNodes = GitBranchesTreeModelUtilKt.getLocalAndRemoteTopLevelNodes$default(lazyRefsSubtreeHolder3, lazyRefsSubtreeHolder2, lazyRefsSubtreeHolder, null, 8, null)).isEmpty() ? topNodes : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)topNodes, (Object)this.branchesSubtreeSeparator), (Iterable)localAndRemoteNodes);
    }

    private final List<Object> getBranchTreeNodes(GitRefType branchType, List<String> path) {
        Map<String, Object> map2;
        if (GitBranchType.LOCAL == branchType) {
            LazyRefsSubtreeHolder<GitLocalBranch> lazyRefsSubtreeHolder = this.commonLocalBranchesTree;
            if (lazyRefsSubtreeHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonLocalBranchesTree");
                lazyRefsSubtreeHolder = null;
            }
            map2 = lazyRefsSubtreeHolder.getTree();
        } else if (GitBranchType.REMOTE == branchType) {
            LazyRefsSubtreeHolder<? extends GitRemoteBranch> lazyRefsSubtreeHolder = this.commonRemoteBranchesTree;
            if (lazyRefsSubtreeHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonRemoteBranchesTree");
                lazyRefsSubtreeHolder = null;
            }
            map2 = lazyRefsSubtreeHolder.getTree();
        } else if (Intrinsics.areEqual((Object)branchType, (Object)GitTagType.INSTANCE)) {
            LazyRefsSubtreeHolder<GitTag> lazyRefsSubtreeHolder = this.commonTagsTree;
            if (lazyRefsSubtreeHolder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonTagsTree");
                lazyRefsSubtreeHolder = null;
            }
            map2 = lazyRefsSubtreeHolder.getTree();
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map<String, Object> branchesMap = map2;
        return GitBranchesTreeModelUtilKt.buildBranchTreeNodes$default(branchType, branchesMap, path, null, 8, null);
    }

    @Override
    @Nullable
    public TreePath getPreferredSelection() {
        TreePath treePath;
        GitReference gitReference = this.getPreferredBranch();
        if (gitReference != null) {
            GitReference it = gitReference;
            boolean bl = false;
            treePath = GitBranchesTreeModelUtilKt.createTreePathFor(this, it);
        } else {
            treePath = null;
        }
        return treePath;
    }

    private final GitReference getPreferredBranch() {
        LazyRefsSubtreeHolder<GitTag> lazyRefsSubtreeHolder;
        LazyRefsSubtreeHolder<? extends GitRemoteBranch> lazyRefsSubtreeHolder2;
        LazyRefsSubtreeHolder<GitLocalBranch> lazyRefsSubtreeHolder3 = this.commonLocalBranchesTree;
        if (lazyRefsSubtreeHolder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonLocalBranchesTree");
            lazyRefsSubtreeHolder3 = null;
        }
        if ((lazyRefsSubtreeHolder2 = this.commonRemoteBranchesTree) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonRemoteBranchesTree");
            lazyRefsSubtreeHolder2 = null;
        }
        if ((lazyRefsSubtreeHolder = this.commonTagsTree) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonTagsTree");
            lazyRefsSubtreeHolder = null;
        }
        return GitBranchesTreeModelUtilKt.getPreferredBranch$default(this.project, this.repositories, null, lazyRefsSubtreeHolder3, lazyRefsSubtreeHolder2, lazyRefsSubtreeHolder, null, 64, null);
    }

    public static final /* synthetic */ void access$rebuild(GitBranchesTreeMultiRepoModel $this) {
        $this.rebuild();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GitBranchesTreeMultiRepoModel.class, "isPrefixGrouping", "isPrefixGrouping()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

