/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;

public abstract class SassExtension {
    public static final ExtensionPointName<SassExtension> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.sass.extension");
    private static final String SASS_SCRIPT_FUNCTIONS_MODULE = "Sass::Script::Functions";

    @NotNull
    public static Set<String> getAppropriateRubyModules() {
        HashSet appropriateModules = ContainerUtil.newHashSet((Object[])new String[]{SASS_SCRIPT_FUNCTIONS_MODULE});
        for (SassExtension extension : SassExtension.getAllExtensions(null)) {
            appropriateModules.addAll(extension.getRubyModulesWithFunctionExtensions());
        }
        HashSet hashSet = appropriateModules;
        if (hashSet == null) {
            SassExtension.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public abstract String getName();

    @NotNull
    public static Collection<SassExtension> getAllExtensions(@Nullable Module module) {
        LinkedList<SassExtension> result = new LinkedList<SassExtension>();
        for (SassExtension extension : (SassExtension[])EXTENSION_POINT_NAME.getExtensions()) {
            if (module != null && !extension.isAvailableInModule(module)) continue;
            result.add(extension);
        }
        LinkedList<SassExtension> linkedList = result;
        if (linkedList == null) {
            SassExtension.$$$reportNull$$$0(1);
        }
        return linkedList;
    }

    @NotNull
    public static Collection<SassExtensionFunctionInfo> findExtensionFunctionInfos(@NotNull String name, @Nullable PsiElement context, @Nullable Module module) {
        if (name == null) {
            SassExtension.$$$reportNull$$$0(2);
        }
        ArrayList<SassExtensionFunctionInfo> result = new ArrayList<SassExtensionFunctionInfo>();
        if (module != null) {
            PsiFile file = context != null ? context.getContainingFile() : null;
            result.addAll(SassRubyIntegrationHelper.getInstance().findExtensionFunctions(name, module.getProject(), CssUtil.getCompletionAndResolvingScopeForModule((Module)module, (PsiFile)file)));
            result.addAll(SassExtension.findCustomFunctions(name, module));
        } else if (context != null) {
            result.addAll(SassRubyIntegrationHelper.getInstance().findExtensionFunctions(name, context.getProject(), CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context)));
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context.getContainingFile());
            if (module != null) {
                result.addAll(SassExtension.findCustomFunctions(name, module));
            }
        }
        ArrayList<SassExtensionFunctionInfo> arrayList = result;
        if (arrayList == null) {
            SassExtension.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected abstract boolean isAvailableInModule(@NotNull Module var1);

    @Nullable
    public abstract SassExtensionFunctionInfo findCustomFunctionByName(@NotNull String var1);

    @NotNull
    public abstract Collection<SassExtensionFunctionInfo> getCustomFunctions();

    @NotNull
    public abstract Collection<String> getRubyModulesWithFunctionExtensions();

    public static void fillCompletionResultWithExtensionFunctions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            SassExtension.$$$reportNull$$$0(4);
        }
        if (result == null) {
            SassExtension.$$$reportNull$$$0(5);
        }
        SassRubyIntegrationHelper.getInstance().fillCompletionResultWithExtensionFunctions(result, position.getProject(), CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position));
    }

    @NotNull
    public abstract Collection<? extends VirtualFile> getStylesheetsRoots(@NotNull Module var1);

    @NotNull
    private static Collection<SassExtensionFunctionInfo> findCustomFunctions(@NotNull String name, @NotNull Module module) {
        if (name == null) {
            SassExtension.$$$reportNull$$$0(6);
        }
        if (module == null) {
            SassExtension.$$$reportNull$$$0(7);
        }
        name = SASSSCSSLangUtil.normalizeName(name);
        LinkedList<SassExtensionFunctionInfo> result = new LinkedList<SassExtensionFunctionInfo>();
        for (SassExtension sassExtension : SassExtension.getAllExtensions(module)) {
            SassExtensionFunctionInfo customFunction = sassExtension.findCustomFunctionByName(name);
            if (customFunction == null) continue;
            result.add(customFunction);
        }
        LinkedList<SassExtensionFunctionInfo> linkedList = result;
        if (linkedList == null) {
            SassExtension.$$$reportNull$$$0(8);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/SassExtension";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateRubyModules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExtensions";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/SassExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtensionFunctionInfos";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findCustomFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionFunctionInfos";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionResultWithExtensionFunctions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCustomFunctions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

