## RabbitMQ 3.6.15

RabbitMQ 3.6.15 is a maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the
documentation](https://www.rabbitmq.com/upgrade.html) for general
documentation on upgrades.

This release has no known incompatibilities with versions 3.6.7 through
3.6.14. See the upgrade and compatibility sections in the [3.6.7 release
notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7)
if upgrading from an earlier release.

### 3.6.x Series Support Timeline

Please read this node on [RabbitMQ 3.6.x series support
timeline](https://groups.google.com/forum/#!msg/rabbitmq-users/kXkI-f3pgEw/UFowJIK4BQAJ).

### Core Server

#### Bug Fixes

* Avoid infinite loop when dropping entries in the GM.

    GitHub issue: [rabbitmq-server#1431](https://github.com/rabbitmq/rabbitmq-server/pull/1431)

* Various changes to the OCF scripts.

    GitHub issues: [rabbitmq-server-release#66](https://github.com/rabbitmq/rabbitmq-server-release/pull/66),
    [rabbitmq-server-release#67](https://github.com/rabbitmq/rabbitmq-server-release/pull/67),
    [rabbitmq-server-release#73](https://github.com/rabbitmq/rabbitmq-server-release/pull/73)

#### Enhancements

 * [Internal authN backend](https://www.rabbitmq.com/access-control.html) will now prohibit logins with a blank passwords. Such attempts
   are usually made by mistake because a passwordless user that was meant to authenticate
   using [x509 (TLS) certificates](https://github.com/rabbitmq/rabbitmq-auth-mechanism-ssl/) was not configured to use the correct [authentication
   mechanism](https://www.rabbitmq.com/authentication.html).

   Note that the same behavior can already be achieved using a [credential validator](https://www.rabbitmq.com/passwords.html), 
   so this is just an extra safety measure.

   GitHub issue: [rabbitmq-server#1466](https://github.com/rabbitmq/rabbitmq-server/pull/1466)
   

### Management Plugin

#### Bug Fixes

* Multi-input forms (such as message properties) again submit all fields.

    GitHub issues: [rabbitmq-management#511](https://github.com/rabbitmq/rabbitmq-management/issues/511)

 * User update form now successfully updates tags for passwordless users (or if the password is cleared at the same time).
  
   GitHub issue: [rabbitmq-management#533](https://github.com/rabbitmq/rabbitmq-management/issues/533)

* `Content-Type` header was returned twice in API responses.

    GitHub issue: [rabbitmq-management#527](https://github.com/rabbitmq/rabbitmq-management/issues/527)

* Avoid duplicated event handlers in the UI.

    GitHub issue: [rabbitmq-management#516](https://github.com/rabbitmq/rabbitmq-management/pull/516)

* Use `auto` width to make option values fully visible.

    GitHub issue: [rabbitmq-management#519](https://github.com/rabbitmq/rabbitmq-management/issues/519)

### MQTT Plugin

#### Bug Fixes

* Concurrently registering consumers could fail with a "Key exists" exception in the log.

    GitHub issue: [rabbitmq-mqtt#132](https://github.com/rabbitmq/rabbitmq-mqtt/issues/132)

### Federation Plugin

#### Bug Fixes

* Disabling policy (or plugin) now cleans up all internal exchanges and queues used by federation links.

    GitHub issue: [rabbitmq-federation#63](https://github.com/rabbitmq/rabbitmq-federation/issues/63)

### Standalone MacOS Package

#### Bug Fixes

* Standalone MacOS package now ships with Erlang/OTP 20.1 which is compatible with High Sierra.

    GitHub issue: [rabbitmq-server-release#68](https://github.com/rabbitmq/rabbitmq-server-release/issues/68)

### Debian Package

#### Bug Fixes

* Make adm the group owner for RabbitMQ log directories.

    GitHub issue: [rabbitmq-server-release#70](https://github.com/rabbitmq/rabbitmq-server-release/pull/70)

### Web MQTT Plugin

#### Bug Fixes

* `https/web-mqtt` listener displayed incorrect port in management UI.

    GitHub issue: [rabbitmq-web-mqtt#25](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/25)

### Top Plugin

#### Bug Fixes

* Fix node and row selectors after jQuery upgrade to 1.12.

    GitHub issue: [rabbitmq-top#29](https://github.com/rabbitmq/rabbitmq-top/pull/29)

### Erlang Client

#### Buf Fixes

* Enable hostname verification for OTP 19.

    GitHub issue: [rabbitmq-erlang-client#95](https://github.com/rabbitmq/rabbitmq-erlang-client/pull/95)

## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All
configuration and persistent message data are retained. When upgrading
using definitions export/import from versions earlier than 3.6.0, see
http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ
documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains
the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.6.15.tar.xz`.
