# Changelog

This file lists all changes made between the current feature branch and the
previous feature release. It is equivalent to the listings on our
[interactive changelog](https://godotengine.github.io/godot-interactive-changelog/).

Changelogs for earlier feature releases are available in their respective Git
branches, and linked at the [end of this file](#Past-releases).

## 4.6 - 2026-01-26

- [Release announcement](https://godotengine.org/releases/4.6/)
- [Migration guide](https://docs.godotengine.org/en/4.6/tutorials/migrating/upgrading_to_godot_4.6.html)
- [Interactive changelog](https://godotengine.github.io/godot-interactive-changelog/#4.6)
- [Breaking changes](https://github.com/godotengine/godot/pulls?q=is%3Apr+is%3Amerged+label%3A%22breaks+compat%22+milestone%3A4.6)

Table of contents:
- [2D](#2d)
- [3D](#3d)
- [Animation](#animation)
- [Assetlib](#assetlib)
- [Audio](#audio)
- [Buildsystem](#buildsystem)
- [C#](#c)
- [Codestyle](#codestyle)
- [Core](#core)
- [Documentation](#documentation)
- [Editor](#editor)
- [Export](#export)
- [GDExtension](#gdextension)
- [GDScript](#gdscript)
- [GUI](#gui)
- [I18n](#i18n)
- [Import](#import)
- [Input](#input)
- [Multiplayer](#multiplayer)
- [Navigation](#navigation)
- [Network](#network)
- [Particles](#particles)
- [Physics](#physics)
- [Platforms](#platforms)
- [Plugin](#plugin)
- [Rendering](#rendering)
- [Shaders](#shaders)
- [Tests](#tests)
- [Thirdparty](#thirdparty)
- [XR](#xr)

#### 2D

- Fix Atlas Merge Tool crash ([GH-101407](https://github.com/godotengine/godot/pull/101407)).
- Fix smart snapping lines to disappear after using the pivot tool ([GH-105203](https://github.com/godotengine/godot/pull/105203)).
- Add "Use Local Space" option to the 2D editor ([GH-107264](https://github.com/godotengine/godot/pull/107264)).
- Fade TileMap editor overlay when zoomed out ([GH-107573](https://github.com/godotengine/godot/pull/107573)).
- Fix: Tilemap tools not overriding main editor tools ([GH-107843](https://github.com/godotengine/godot/pull/107843)).
- Highlight points on hover in the Polygon2D editor ([GH-107890](https://github.com/godotengine/godot/pull/107890)).
- Reduce TileMapLayerEditor's undo/redo memory usage ([GH-107969](https://github.com/godotengine/godot/pull/107969)).
- Add support for rotating scene tiles in TileMapLayer ([GH-108010](https://github.com/godotengine/godot/pull/108010)).
- Avoid unnecessary updates in `TileMapLayer` ([GH-109243](https://github.com/godotengine/godot/pull/109243)).
- Fix redundant calls of `CanvasItemEditor::_update_lock_and_group_button` on `SceneTreeEditor` node selection ([GH-110320](https://github.com/godotengine/godot/pull/110320)).
- Improve tile source tooltips ([GH-110328](https://github.com/godotengine/godot/pull/110328)).
- Fix nested TileMapLayers highlight rendering in editor ([GH-110768](https://github.com/godotengine/godot/pull/110768)).
- Fix snap Polygon2D editor ([GH-110989](https://github.com/godotengine/godot/pull/110989)).
- Fix game `Camera2D` override from editor and 2D debug templates building ([GH-111149](https://github.com/godotengine/godot/pull/111149)).
- Add zoom to fit functionality to `SpriteFramesEditor` ([GH-111471](https://github.com/godotengine/godot/pull/111471)).
- Fix rotation/scale order in `CanvasItem::draw_set_transform` ([GH-111476](https://github.com/godotengine/godot/pull/111476)).
- Fix Camera2D limit checks for inverted boundaries ([GH-111651](https://github.com/godotengine/godot/pull/111651)).
- Fix "Match Corners" not correctly updating cells when erasing ([GH-112145](https://github.com/godotengine/godot/pull/112145)).
- Fix Polygon2D editor undo crash ([GH-112241](https://github.com/godotengine/godot/pull/112241)).
- Check for tiles outside texture on TileSet atlas settings changes ([GH-112271](https://github.com/godotengine/godot/pull/112271)).
- Fix TileSet editor crash on terrain pick in paint mode ([GH-112349](https://github.com/godotengine/godot/pull/112349)).
- Change `TileSetScenesCollectionSource` raw pointers in the TileSet editor to ref ([GH-112739](https://github.com/godotengine/godot/pull/112739)).
- Prevent translating custom data layers ([GH-112769](https://github.com/godotengine/godot/pull/112769)).
- Fix `TileMapLayer` transformations for `Node2D` scene tiles ([GH-112790](https://github.com/godotengine/godot/pull/112790)).
- FTI: - `Camera2D` accepts resets only after entering tree ([GH-112810](https://github.com/godotengine/godot/pull/112810)).
- Fix `display_placeholder` not persisting ([GH-112828](https://github.com/godotengine/godot/pull/112828)).
- Enable Vertical orientation for TileMap Dock ([GH-113128](https://github.com/godotengine/godot/pull/113128)).
- Fix TileMap Dock button placement and errors ([GH-113594](https://github.com/godotengine/godot/pull/113594)).
- Fix `get_scene_tile_display_placeholder` erroring for transformed scene tiles ([GH-113856](https://github.com/godotengine/godot/pull/113856)).
- Fix incorrect error message placement in TileMap Dock ([GH-113870](https://github.com/godotengine/godot/pull/113870)).
- Fix undo/redo for adding scene tiles ([GH-114604](https://github.com/godotengine/godot/pull/114604)).
- Fix pattern corruption in `TileMapLayer` ([GH-114653](https://github.com/godotengine/godot/pull/114653)).
- Geometry2D: Remove `arc_tolerance` scaling and the comment related to that ([GH-115293](https://github.com/godotengine/godot/pull/115293)).

#### 3D

- Commit transforms done with editor gizmo on tool mode switch ([GH-86930](https://github.com/godotengine/godot/pull/86930)).
- Fix 3D editor Emulate Numpad setting having no effect when previewing a camera ([GH-93724](https://github.com/godotengine/godot/pull/93724)).
- Get `Node3D.global_rotation` from orthonormalized global basis ([GH-95075](https://github.com/godotengine/godot/pull/95075)).
- Rename Select Mode to Transform Mode, and create a new Select Mode without transform gizmo ([GH-101168](https://github.com/godotengine/godot/pull/101168)).
- Fix viewport rotation gizmo aligned axis reversing ([GH-101209](https://github.com/godotengine/godot/pull/101209)).
- Move editor viewport gizmos visibility logic out of process notification ([GH-102020](https://github.com/godotengine/godot/pull/102020)).
- Remove redundant line when toggling cinematic preview ([GH-102021](https://github.com/godotengine/godot/pull/102021)).
- Condition editor viewport nav modifier checks on freelook / mouse is captured ([GH-102055](https://github.com/godotengine/godot/pull/102055)).
- TextureEditors: Compile shader/material only once ([GH-104488](https://github.com/godotengine/godot/pull/104488)).
- GridMap: fix cell scale not applying to the cursor mesh ([GH-104510](https://github.com/godotengine/godot/pull/104510)).
- Add Bresenham Line Algorithm to GridMap Drawing ([GH-105292](https://github.com/godotengine/godot/pull/105292)).
- Fix ghost collisions in `segment_intersects_convex()` ([GH-106084](https://github.com/godotengine/godot/pull/106084)).
- Change snap settings to not use LineEdits ([GH-106684](https://github.com/godotengine/godot/pull/106684)).
- Always use a dark background for 3D editor overlays even with light theme ([GH-107154](https://github.com/godotengine/godot/pull/107154)).
- Visual feedback update for viewport rotation gizmo ([GH-107343](https://github.com/godotengine/godot/pull/107343)).
- Do not require editor restart when changing Path 3d Tilt Disk Size setting ([GH-108546](https://github.com/godotengine/godot/pull/108546)).
- Do not require editor restart when changing manipulator gizmo opacity setting ([GH-108549](https://github.com/godotengine/godot/pull/108549)).
- Create a rotation arc showing accumulated rotation when using transform gizmo ([GH-108576](https://github.com/godotengine/godot/pull/108576)).
- Make rotation gizmo white outline a 4th handle that rotates around the camera's view-axis ([GH-108608](https://github.com/godotengine/godot/pull/108608)).
- Fix jump when cutting a selection in Gridmap ([GH-108743](https://github.com/godotengine/godot/pull/108743)).
- Remove spurious `Curve3D` `changed` signals ([GH-109220](https://github.com/godotengine/godot/pull/109220)).
- Move `Lock View Rotation` label logic out of process notification ([GH-109490](https://github.com/godotengine/godot/pull/109490)).
- Remove unused editor setting `editors/grid_map/palette_min_width` ([GH-109582](https://github.com/godotengine/godot/pull/109582)).
- GLTF export: use ORM texture for occlusion/metallicRoughnessTexture if it exists ([GH-109845](https://github.com/godotengine/godot/pull/109845)).
- Fix `GridMap` Move Action Undo/Redo/Cancel ([GH-109878](https://github.com/godotengine/godot/pull/109878)).
- Fix numpad emulation in 3d navigation shortcuts ([GH-110428](https://github.com/godotengine/godot/pull/110428)).
- Remove `pixel_size` precision limit in Sprite3D ([GH-111491](https://github.com/godotengine/godot/pull/111491)).
- Implement orbit snapping in 3D viewport ([GH-111509](https://github.com/godotengine/godot/pull/111509)).
- Improve Transform dialog ([GH-111600](https://github.com/godotengine/godot/pull/111600)).
- Fix the material preview sphere model ([GH-112046](https://github.com/godotengine/godot/pull/112046)).
- Fix `CollisionPolygon3D` debug shape rendering ([GH-112285](https://github.com/godotengine/godot/pull/112285)).
- Fix GridMap `cursor_instance` transparency error spam ([GH-112301](https://github.com/godotengine/godot/pull/112301)).
- Remove undefined method `Skeleton3D::remove_bone` ([GH-112402](https://github.com/godotengine/godot/pull/112402)).
- Don't redraw `Sprite3D`/`AnimatedSprite3D` outside the tree ([GH-112593](https://github.com/godotengine/godot/pull/112593)).
- Add MeshInstance3D upgrade code ([GH-112607](https://github.com/godotengine/godot/pull/112607)).
- Fix wrong AABB when selecting Node3D gizmo in editor ([GH-112666](https://github.com/godotengine/godot/pull/112666)).
- Fix preview CSG interfering with itself during drag and drop ([GH-112861](https://github.com/godotengine/godot/pull/112861)).
- Default the 3D editor to Transform mode to restore 4.5 behavior ([GH-113458](https://github.com/godotengine/godot/pull/113458)).
- Prevent BonePropertiesEditor crash due to skeleton use-after-release ([GH-113631](https://github.com/godotengine/godot/pull/113631)).
- Node3DEditorViewport: Prevent crash while handling input ([GH-113895](https://github.com/godotengine/godot/pull/113895)).
- Debugger: Fix 3D disabled builds ([GH-113962](https://github.com/godotengine/godot/pull/113962)).
- Fix `sorting_offset` property flags for `Decal` ([GH-114335](https://github.com/godotengine/godot/pull/114335)).
- Fix rotation gizmo line position ([GH-114408](https://github.com/godotengine/godot/pull/114408)).
- Fix crash when selecting SplineIK3D ([GH-114668](https://github.com/godotengine/godot/pull/114668)).
- Keep other parts of transform gizmo visible when rotating in local mode ([GH-114714](https://github.com/godotengine/godot/pull/114714)).
- Fix `Sprite3D` modulate propagation on reparenting ([GH-115037](https://github.com/godotengine/godot/pull/115037)).

#### Animation

- Fix animation loop import hints becoming lost ([GH-91634](https://github.com/godotengine/godot/pull/91634)).
- Add tests for `AnimationPlayer` ([GH-92649](https://github.com/godotengine/godot/pull/92649)).
- Use `LocalVector` in `Animation` ([GH-101285](https://github.com/godotengine/godot/pull/101285)).
- Minor Animation Player workflow enhancements ([GH-103416](https://github.com/godotengine/godot/pull/103416)).
- Fix issue of `AnimationPlayer` hiding bezier editor when re-selecting it ([GH-104371](https://github.com/godotengine/godot/pull/104371)).
- Add `interpolate_via_rest()` static func to Animation class ([GH-107423](https://github.com/godotengine/godot/pull/107423)).
- Display AnimationTree editor warnings when the node is disabled ([GH-107468](https://github.com/godotengine/godot/pull/107468)).
- Add toggle for inserting keys/markers at current time vs mouse cursor's position ([GH-107511](https://github.com/godotengine/godot/pull/107511)).
- Add ability to copy and paste animations in SpriteFrames ([GH-107887](https://github.com/godotengine/godot/pull/107887)).
- Add "Go to Next/Previous Keyframe" to Animation Edit menu ([GH-107959](https://github.com/godotengine/godot/pull/107959)).
- Propagate `Tween.kill()` to subtweens ([GH-108227](https://github.com/godotengine/godot/pull/108227)).
- Fix missing shortcuts for play buttons in SpriteFrames Editor ([GH-109422](https://github.com/godotengine/godot/pull/109422)).
- Allow reconnecting AnimationNodeStateMachine transitions ([GH-109534](https://github.com/godotengine/godot/pull/109534)).
- Correctly reset StateMachine opacity when a node is played or renamed ([GH-109605](https://github.com/godotengine/godot/pull/109605)).
- Make BlendSpace selection tool consistent with StateMachine/BlendTree functionality ([GH-109792](https://github.com/godotengine/godot/pull/109792)).
- Double-click BlendSpace points to open their editor ([GH-109839](https://github.com/godotengine/godot/pull/109839)).
- Expose `get_fading_...` methods for `AnimationNodeStateMachinePlayback` ([GH-109986](https://github.com/godotengine/godot/pull/109986)).
- Add `SkeletonModifier3D` IKs as `IKModifier3D` ([GH-110120](https://github.com/godotengine/godot/pull/110120)).
- Improve deselection in AnimationTree editors and inspector ([GH-110131](https://github.com/godotengine/godot/pull/110131)).
- Trim -loop & -cycle from animations during Godot 3 to 4 conversion ([GH-110188](https://github.com/godotengine/godot/pull/110188)).
- Fix Skeleton2D TwoBoneIK and LookAt mirroring ([GH-110298](https://github.com/godotengine/godot/pull/110298)).
- Add option to `BoneConstraint3D` to make reference target allow to set `Node3D` ([GH-110336](https://github.com/godotengine/godot/pull/110336)).
- Add option to keying modified transform by `SkeletonModifier3D` ([GH-110376](https://github.com/godotengine/godot/pull/110376)).
- Fix `_validate_property()` in `RetargetModifier3D` ([GH-110380](https://github.com/godotengine/godot/pull/110380)).
- Optimize `Animation::_track_update_hash` ([GH-110400](https://github.com/godotengine/godot/pull/110400)).
- Fix read-only state for Skeleton and Inspector ([GH-110487](https://github.com/godotengine/godot/pull/110487)).
- Change AnimationLibrary serialization to avoid using Dictionary ([GH-110502](https://github.com/godotengine/godot/pull/110502)).
- Fix Reset on Save corrupt poses if scene has multiple Skeletons ([GH-110506](https://github.com/godotengine/godot/pull/110506)).
- Ensure the AnimationPlayer emits `animation_finished` for every animation ([GH-110508](https://github.com/godotengine/godot/pull/110508)).
- Fix imported animation warning labeled as Imported Scene ([GH-110619](https://github.com/godotengine/godot/pull/110619)).
- Allow resizing the length of animations by dragging the timeline ([GH-110623](https://github.com/godotengine/godot/pull/110623)).
- Change list of Tweeners from Vector to LocalVector ([GH-110656](https://github.com/godotengine/godot/pull/110656)).
- Show marker lines/sections in the animation bezier editor ([GH-110676](https://github.com/godotengine/godot/pull/110676)).
- Fix AnimationPlayer to use StringName instead of String in the exposed API ([GH-110767](https://github.com/godotengine/godot/pull/110767)).
- Add solo/hide/lock/delete buttons to node groups in bezier track editor ([GH-110866](https://github.com/godotengine/godot/pull/110866)).
- Fix backward/pingpong root motion in AnimationTree ([GH-110982](https://github.com/godotengine/godot/pull/110982)).
- Make extended SkeletonModifiers retrieve interpolated global transform ([GH-110987](https://github.com/godotengine/godot/pull/110987)).
- Expose `is_valid()` from `AnimationPlayer` to make detecting paused animations possible ([GH-111178](https://github.com/godotengine/godot/pull/111178)).
- Add LimitAngularVelocityModifier3D ([GH-111184](https://github.com/godotengine/godot/pull/111184)).
- Fix incorrect AnimationNodeAnimation `timeline_length` description ([GH-111251](https://github.com/godotengine/godot/pull/111251)).
- Make StateMachinePlayback set `Start` state as default in constructor ([GH-111325](https://github.com/godotengine/godot/pull/111325)).
- Add relative option to LookAt/AimModifier3D ([GH-111367](https://github.com/godotengine/godot/pull/111367)).
- Change Vector to LocalVector in SpringBoneSimulator3D ([GH-111378](https://github.com/godotengine/godot/pull/111378)).
- Set step before set value, to fix animation length issue ([GH-111398](https://github.com/godotengine/godot/pull/111398)).
- Fix crash when rearranging filtered animation tracks ([GH-111427](https://github.com/godotengine/godot/pull/111427)).
- Seek to beginning of section if current playback position is after its end ([GH-111517](https://github.com/godotengine/godot/pull/111517)).
- Fix unwanted blend position movement ([GH-111803](https://github.com/godotengine/godot/pull/111803)).
- Allow Spring / IK to set mutable bone axes ([GH-111815](https://github.com/godotengine/godot/pull/111815)).
- Improve validation for adding transition in StateMachine ([GH-111935](https://github.com/godotengine/godot/pull/111935)).
- Remember animation snapping state ([GH-111952](https://github.com/godotengine/godot/pull/111952)).
- Separate branching ping-pong time and delta ([GH-112047](https://github.com/godotengine/godot/pull/112047)).
- Add "Abort on Reset" property to AnimationNodeOneShot ([GH-112054](https://github.com/godotengine/godot/pull/112054)).
- Track groups in Animation tab hover highlight ([GH-112148](https://github.com/godotengine/godot/pull/112148)).
- Improve Bezier Default Mode button in Animation dock ([GH-112231](https://github.com/godotengine/godot/pull/112231)).
- Remove default skeleton path in MeshInstance3D ([GH-112267](https://github.com/godotengine/godot/pull/112267)).
- Fix NodeOneShot doesn't reset correctly ([GH-112450](https://github.com/godotengine/godot/pull/112450)).
- Add Deterministic option to IterateIK3D ([GH-112524](https://github.com/godotengine/godot/pull/112524)).
- Fix custom audio track blend flag on reimport ([GH-112563](https://github.com/godotengine/godot/pull/112563)).
- Move the line of calling `animation_finished` signal to ensure stopping ([GH-112571](https://github.com/godotengine/godot/pull/112571)).
- Fix JacobianIK to apply gradient correctly ([GH-112573](https://github.com/godotengine/godot/pull/112573)).
- Make AnimationLibrary use RBMap instead of HashMap ([GH-112692](https://github.com/godotengine/godot/pull/112692)).
- Fix error in `BlendSpace2D` when selecting blend position tool ([GH-112710](https://github.com/godotengine/godot/pull/112710)).
- Move the line of importing JointLimitation3D to 3D from Physics3D ([GH-112856](https://github.com/godotengine/godot/pull/112856)).
- Add an argument `p_reset` to `SpringBoneSimulator3D::_make_joints_dirty()` ([GH-112867](https://github.com/godotengine/godot/pull/112867)).
- Fix mutable bone axes process in TwoBoneIK3D ([GH-113055](https://github.com/godotengine/godot/pull/113055)).
- Fix AnimationMixer error spam by respecting cache validity on invalid `root_node` ([GH-113140](https://github.com/godotengine/godot/pull/113140)).
- Fix empty 2D skeleton modification keeps printing error messages ([GH-113176](https://github.com/godotengine/godot/pull/113176)).
- Add BoneTwistDisperser3D to propagate IK target's twist ([GH-113284](https://github.com/godotengine/godot/pull/113284)).
- Remove `is_penetrated` check from IK as role overlap/excessive behavior ([GH-113285](https://github.com/godotengine/godot/pull/113285)).
- Add shortcuts in tooltips to the animation editor's play/pause buttons ([GH-113415](https://github.com/godotengine/godot/pull/113415)).
- Use physical key shortcuts for the animation editor's play/pause buttons ([GH-113416](https://github.com/godotengine/godot/pull/113416)).
- Fix truncation of node name in bezier animation editor ([GH-113500](https://github.com/godotengine/godot/pull/113500)).
- Fix Animation Editor erroring when animating SpriteAnimation3D `frame` but not `animation` ([GH-113786](https://github.com/godotengine/godot/pull/113786)).
- Fix the clipping of keys when moving keys ([GH-113903](https://github.com/godotengine/godot/pull/113903)).
- Fix Marker Name covered by AnimationPlayer track backgrounds ([GH-114056](https://github.com/godotengine/godot/pull/114056)).
- Return at invalid skeleton in ChainIK3D before updating mutable info ([GH-114062](https://github.com/godotengine/godot/pull/114062)).
- Fix AnimationMixer handling disabled track in RESET ([GH-114176](https://github.com/godotengine/godot/pull/114176)).
- Fix setter for readonly bone name in the joint array and add null check in IKModifier3D ([GH-114240](https://github.com/godotengine/godot/pull/114240)).
- Change `radius_range` to `angle` to indicate hole size of `JointLimitationCone3D` ([GH-114395](https://github.com/godotengine/godot/pull/114395)).
- Fix IKModifier/JointLimitation gizmo on root bone and dirty handling ([GH-114431](https://github.com/godotengine/godot/pull/114431)).
- Ensure `clear_animation_instances()` after blending frame result ([GH-114458](https://github.com/godotengine/godot/pull/114458)).
- Fix AnimationPlayerEditor failed to fetch AnimationTree's libraries ([GH-114482](https://github.com/godotengine/godot/pull/114482)).
- Fix discrete key is not processed by `advance_on_start` in AnimationNode ([GH-114487](https://github.com/godotengine/godot/pull/114487)).
- Make `base_height_adjustment` apply to global position & Fix false warning `Animated extra bone between mapped bones detected` ([GH-114543](https://github.com/godotengine/godot/pull/114543)).
- Tweak `SkeletonModifier3D` document for `_process_modification_with_delta()` and `JacobianIK3D` icon ([GH-114580](https://github.com/godotengine/godot/pull/114580)).
- Hide animation library properties in inspector ([GH-114582](https://github.com/godotengine/godot/pull/114582)).
- Fix animation editor sometimes not processing on scene change ([GH-114603](https://github.com/godotengine/godot/pull/114603)).
- Fix Skeleton3D edit mode usability issues ([GH-114752](https://github.com/godotengine/godot/pull/114752)).
- Fix animation library serialization compatibility for 4.5 projects ([GH-114844](https://github.com/godotengine/godot/pull/114844)).
- Remove dead definition `get_animation_libraries()` from AnimationMixer ([GH-114897](https://github.com/godotengine/godot/pull/114897)).
- Fix wrong play position for the `AnimationMarkerEdit` ([GH-114935](https://github.com/godotengine/godot/pull/114935)).
- Allow `ONE_SHOT_REQUEST_FIRE` to override OneShot abortion ([GH-115175](https://github.com/godotengine/godot/pull/115175)).
- Tweak IKModifier3D docs and comment ([GH-115303](https://github.com/godotengine/godot/pull/115303)).

#### Assetlib

- Fix author names not showing up in the AssetLib ([GH-112208](https://github.com/godotengine/godot/pull/112208)).
- Fix extra spacing in author names when opening the asset dialog ([GH-113017](https://github.com/godotengine/godot/pull/113017)).

#### Audio

- Replace `minimp3` with `dr_mp3` ([GH-96547](https://github.com/godotengine/godot/pull/96547)).
- Change the random pitch on the audio stream randomizer to be in semitones, not a frequency multiplier ([GH-103742](https://github.com/godotengine/godot/pull/103742)).
- Pause audio when game is paused ([GH-104420](https://github.com/godotengine/godot/pull/104420)).
- Ignore changes in "Master" bus while in the Audio Importer ([GH-106415](https://github.com/godotengine/godot/pull/106415)).
- Use 64-bit offset/loop points in `AudioStreamWAV` ([GH-107596](https://github.com/godotengine/godot/pull/107596)).
- AudioStreamOggVorbis: only show invalid comment warning in Editor builds ([GH-109844](https://github.com/godotengine/godot/pull/109844)).
- Add one padding frame to QOA buffer for short streams ([GH-110515](https://github.com/godotengine/godot/pull/110515)).
- Fix AudioStreamPolyphonic to honor `AudioStreamPlayer.pitch_scale` ([GH-110525](https://github.com/godotengine/godot/pull/110525)).
- Vorbis: Add details to warning about invalid comment header ([GH-110652](https://github.com/godotengine/godot/pull/110652)).
- macOS: Fix microphone issue ([GH-111691](https://github.com/godotengine/godot/pull/111691)).
- Statically protect `Object::cast_to` for unrelated `Object` types ([GH-111967](https://github.com/godotengine/godot/pull/111967)).
- Fix CoreAudio driver crash when starting input with uninitialized device ([GH-112404](https://github.com/godotengine/godot/pull/112404)).
- AudioServer to have function to access microphone buffer directly ([GH-113288](https://github.com/godotengine/godot/pull/113288)).
- Check if on tree before calling `can_process()` ([GH-114966](https://github.com/godotengine/godot/pull/114966)).

#### Buildsystem

- SCons: Integrate `annotations` where relevant ([GH-99640](https://github.com/godotengine/godot/pull/99640)).
- Add `profiler_path` option to `SCons` builds, with support for `tracy` and `perfetto` ([GH-104851](https://github.com/godotengine/godot/pull/104851)).
- Reduce cross project includes by rewriting `HashMapHasherDefault` ([GH-106434](https://github.com/godotengine/godot/pull/106434)).
- Add `STATIC_ASSERT_INCOMPLETE_TYPE` to enforce include minimality ([GH-107587](https://github.com/godotengine/godot/pull/107587)).
- Replace iOS/visionOS Xcode templates by new Apple embedded template ([GH-107789](https://github.com/godotengine/godot/pull/107789)).
- CI: Generate debug build for Android ([GH-108468](https://github.com/godotengine/godot/pull/108468)).
- SCons: Ensure `CPPDEFINES` is properly utilized ([GH-108613](https://github.com/godotengine/godot/pull/108613)).
- Add a Swappy installation script for easier Android builds ([GH-108674](https://github.com/godotengine/godot/pull/108674)).
- SwiftUI lifecycle for Apple embedded platforms ([GH-109974](https://github.com/godotengine/godot/pull/109974)).
- make_rst.py: Add missing rst-class to annotation descriptions ([GH-110276](https://github.com/godotengine/godot/pull/110276)).
- Linux: Allow unbundling libjpeg-turbo to use system package ([GH-110540](https://github.com/godotengine/godot/pull/110540)).
- Editor: Generate translation data in separate cpp files ([GH-110618](https://github.com/godotengine/godot/pull/110618)).
- CI: Bump Ruff version (0.12.0 → 0.13.1) ([GH-110664](https://github.com/godotengine/godot/pull/110664)).
- SCons: Fix Windows `silence_msvc` logfile encoding ([GH-110691](https://github.com/godotengine/godot/pull/110691)).
- Fix HashMap/HashSet in natvis after member renames ([GH-110882](https://github.com/godotengine/godot/pull/110882)).
- Windows: Migrate `godot.manifest` to `platform/windows`, include as dependency ([GH-110897](https://github.com/godotengine/godot/pull/110897)).
- CI: Bump `clang-format` and `clang-tidy` versions ([GH-110968](https://github.com/godotengine/godot/pull/110968)).
- Fix unreachable code warning in double-precision builds ([GH-111018](https://github.com/godotengine/godot/pull/111018)).
- CI: Add pre-commit hook for XML linting ([GH-111052](https://github.com/godotengine/godot/pull/111052)).
- Fix compiling SDL without DBus under Linux ([GH-111146](https://github.com/godotengine/godot/pull/111146)).
- System-provided ENet warning ([GH-111211](https://github.com/godotengine/godot/pull/111211)).
- CI: Fix `CODEOWNERS` inconsistencies ([GH-111222](https://github.com/godotengine/godot/pull/111222)).
- Replace `std::size` usage with `std_size` to avoid `<iterator>` include ([GH-111223](https://github.com/godotengine/godot/pull/111223)).
- CI: Bump SCons version [4.9.0→4.10.0] ([GH-111224](https://github.com/godotengine/godot/pull/111224)).
- Fix 2D debug templates linking ([GH-111242](https://github.com/godotengine/godot/pull/111242)).
- Remove `Array` include from `dictionary.h` and `ustring.h` ([GH-111244](https://github.com/godotengine/godot/pull/111244)).
- Make BasisUniversal `basisu_astc_hdr_6x6_enc.h` non-executable ([GH-111253](https://github.com/godotengine/godot/pull/111253)).
- Remove `rw_lock.h` and `rb_map.h` includes from `object.h` ([GH-111254](https://github.com/godotengine/godot/pull/111254)).
- Build: Fix container build path for swift ([GH-111299](https://github.com/godotengine/godot/pull/111299)).
- macOS: Move includes inside `#ifdef` so OpenGL can be disabled ([GH-111301](https://github.com/godotengine/godot/pull/111301)).
- Revert "SCons: Add `CPPEXTPATH` for external includes" ([GH-111331](https://github.com/godotengine/godot/pull/111331)).
- Scons: Remove system includes ([GH-111346](https://github.com/godotengine/godot/pull/111346)).
- Add `max()` to `Span`, replacing `<algorithm>` include from `rendering_device_commons.h` ([GH-111347](https://github.com/godotengine/godot/pull/111347)).
- Windows: Fix MinGW build ([GH-111368](https://github.com/godotengine/godot/pull/111368)).
- Fix Steam time tracker build ([GH-111396](https://github.com/godotengine/godot/pull/111396)).
- Remove `compositor.h` include from `world_3d.h` ([GH-111402](https://github.com/godotengine/godot/pull/111402)).
- Remove transitive rendering includes from `node.h` ([GH-111405](https://github.com/godotengine/godot/pull/111405)).
- SCons: Don't activate `fast_unsafe` automatically on `dev_build` ([GH-111411](https://github.com/godotengine/godot/pull/111411)).
- Remove circular unneeded `debug_adapter_protocol.h` include from `debug_adapter_parser.h` ([GH-111470](https://github.com/godotengine/godot/pull/111470)).
- Remove extraneous includes from `texture.h` ([GH-111481](https://github.com/godotengine/godot/pull/111481)).
- Fix 2D builds (again) ([GH-111487](https://github.com/godotengine/godot/pull/111487)).
- SCons: Enable MinGW big objects universally ([GH-111566](https://github.com/godotengine/godot/pull/111566)).
- Fix use of outdated macros in ObjectDBProfiler ([GH-111601](https://github.com/godotengine/godot/pull/111601)).
- Remove `display_server.h` transitive include from `node.h` ([GH-111620](https://github.com/godotengine/godot/pull/111620)).
- Fix some compilation errors ([GH-111621](https://github.com/godotengine/godot/pull/111621)).
- Remove `callable_bind.h` from `object.h` ([GH-111633](https://github.com/godotengine/godot/pull/111633)).
- Fix missing includes in headers ([GH-111696](https://github.com/godotengine/godot/pull/111696)).
- SCons: Remove transitive includes in `libc++` ([GH-111767](https://github.com/godotengine/godot/pull/111767)).
- Build: Update to Xcode 26.0.1 for Apple builds ([GH-111799](https://github.com/godotengine/godot/pull/111799)).
- SCons: Clean up hardcoded D3D12 driver workarounds ([GH-111800](https://github.com/godotengine/godot/pull/111800)).
- MSVC: Check `catalog_productSemanticVersion` instead of `catalog_productDisplayVersion` ([GH-111918](https://github.com/godotengine/godot/pull/111918)).
- Fix broken screenshot link in Appstream metadata ([GH-112004](https://github.com/godotengine/godot/pull/112004)).
- Add some keywords to desktop entry ([GH-112005](https://github.com/godotengine/godot/pull/112005)).
- Use pkg-config for recast flags ([GH-112030](https://github.com/godotengine/godot/pull/112030)).
- macOS: Update clang version check ([GH-112034](https://github.com/godotengine/godot/pull/112034)).
- Windows: Use separate resource files for export templates ([GH-112116](https://github.com/godotengine/godot/pull/112116)).
- macOS/iOS: Fix build with Xcode older than 26 ([GH-112185](https://github.com/godotengine/godot/pull/112185)).
- Update Android build tools to version 35.0.1 ([GH-112437](https://github.com/godotengine/godot/pull/112437)).
- Add `workflow_dispatch` triggers to platform CI ([GH-112594](https://github.com/godotengine/godot/pull/112594)).
- Fix tracy implementation when no callstack sampling is desired ([GH-112685](https://github.com/godotengine/godot/pull/112685)).
- Fix `GodotProfileZone` with tracy backend failing with shadowed variable name warnings ([GH-112823](https://github.com/godotengine/godot/pull/112823)).
- CI: Remove cache clean action ([GH-112924](https://github.com/godotengine/godot/pull/112924)).
- CI: Build Windows without D3D12 if install fails ([GH-113112](https://github.com/godotengine/godot/pull/113112)).
- SCons: Fix logic when passing `optimize=auto` explicitly from command-line ([GH-113120](https://github.com/godotengine/godot/pull/113120)).
- CODEOWNERS: Add 2D skeleton resources to the Animation team ([GH-113190](https://github.com/godotengine/godot/pull/113190)).
- Include xkb-compose in `wayland_thread.h` ([GH-113195](https://github.com/godotengine/godot/pull/113195)).
- Replace usage of Zstandard advanced API ([GH-113234](https://github.com/godotengine/godot/pull/113234)).
- Web: Bump js-yaml from 4.1.0 to 4.1.1 ([GH-113253](https://github.com/godotengine/godot/pull/113253)).
- Fix Android build regression ([GH-113388](https://github.com/godotengine/godot/pull/113388)).
- CI: Bump SCons version [4.10.0→4.10.1] ([GH-113403](https://github.com/godotengine/godot/pull/113403)).
- CI: Bump Ruff version (0.13.1 → 0.14.7) ([GH-113470](https://github.com/godotengine/godot/pull/113470)).
- Fix `sprite_frames_editor_plugin` compilation with `deprecated=no` ([GH-113527](https://github.com/godotengine/godot/pull/113527)).
- Move Multiplayer icons to the module ([GH-113723](https://github.com/godotengine/godot/pull/113723)).
- Check for unprefixed compilers when building on Windows ([GH-113814](https://github.com/godotengine/godot/pull/113814)).
- Fix build errors and warnings with LLVM-21 ([GH-113857](https://github.com/godotengine/godot/pull/113857)).
- Thirdparty: Make GH PR references URLs ([GH-113926](https://github.com/godotengine/godot/pull/113926)).
- Fix compiling Godot for Linux failing with `profiler_sample_callstack=yes` ([GH-114001](https://github.com/godotengine/godot/pull/114001)).
- CI: Fix executable perms for various files ([GH-114047](https://github.com/godotengine/godot/pull/114047)).
- Add missing `cstdlib` include for `EXIT_SUCCESS` and `free` ([GH-114072](https://github.com/godotengine/godot/pull/114072)).
- gitignore: Ignore GNU `patch` .orig and .rej backup files ([GH-114105](https://github.com/godotengine/godot/pull/114105)).
- Add Mesa version check ([GH-114142](https://github.com/godotengine/godot/pull/114142)).
- RequiredPtr: Fix template conditional for MSVC ([GH-114222](https://github.com/godotengine/godot/pull/114222)).
- Make Godot compile with 3D physics disabled again, again ([GH-114453](https://github.com/godotengine/godot/pull/114453)).
- BasisUniversal: Disable strict aliasing to fix GCC optimization issue ([GH-114839](https://github.com/godotengine/godot/pull/114839)).
- Avoid warning when compiling on visionOS 26 SDK ([GH-114904](https://github.com/godotengine/godot/pull/114904)).
- Windows: Add missing `extern "C"` for `hidsdi.h` on MinGW < 12.0.0 ([GH-115010](https://github.com/godotengine/godot/pull/115010)).

#### C#

- Add documentation for Interfaces and Attributes ([GH-81701](https://github.com/godotengine/godot/pull/81701)).
- Add c# translation parser support ([GH-99195](https://github.com/godotengine/godot/pull/99195)).
- Fix array span constructors in C# ([GH-105950](https://github.com/godotengine/godot/pull/105950)).
- Fix loading correct solution file for projects in subdirectories ([GH-106031](https://github.com/godotengine/godot/pull/106031)).
- Improve performance of `CSharpLanguage::reload_assemblies` ([GH-106299](https://github.com/godotengine/godot/pull/106299)).
- Add `ReadOnlySpan<Variant>` overload for `Callable.Call` ([GH-107800](https://github.com/godotengine/godot/pull/107800)).
- Remove EFS update on reloading assemblies ([GH-108487](https://github.com/godotengine/godot/pull/108487)).
- Fix various errors in bindings generator ([GH-108489](https://github.com/godotengine/godot/pull/108489)).
- Fix enum from/to Variant conversion ([GH-108527](https://github.com/godotengine/godot/pull/108527)).
- Use explicit public access modifier in C# code ([GH-108885](https://github.com/godotengine/godot/pull/108885)).
- Improve `IsNormalized()` in C# ([GH-108974](https://github.com/godotengine/godot/pull/108974)).
- Update GodotTools .NET version from 6.0 to 8.0 ([GH-110799](https://github.com/godotengine/godot/pull/110799)).
- Fix `IsStaticallyResolvable` ([GH-111523](https://github.com/godotengine/godot/pull/111523)).
- Update Godot.SourceGenerators packages ([GH-111524](https://github.com/godotengine/godot/pull/111524)).
- Fix source generation of statically imported members ([GH-111570](https://github.com/godotengine/godot/pull/111570)).
- Fix dotnet class lookup returning modified names instead of engine names ([GH-112023](https://github.com/godotengine/godot/pull/112023)).
- Add compat method for `DisplayServer.TtsSpeak` ([GH-112798](https://github.com/godotengine/godot/pull/112798)).
- Prevent C# source generators from fully qualifying members assigned to within an object initializer ([GH-112874](https://github.com/godotengine/godot/pull/112874)).
- Fix StringExtensions.SplitFloats incorrect float parsing ([GH-112897](https://github.com/godotengine/godot/pull/112897)).
- Ensure .NET editor supports Visual Studio 2026 ([GH-112961](https://github.com/godotengine/godot/pull/112961)).
- Change MSBuildPanel to EditorDock ([GH-113115](https://github.com/godotengine/godot/pull/113115)).
- Fix `FileAccess::create_temp()` not using `FileAccess::ModeFlags` ([GH-114053](https://github.com/godotengine/godot/pull/114053)).
- Hide signals prefixed by underscore ([GH-115199](https://github.com/godotengine/godot/pull/115199)).

#### Codestyle

- Improve usage of `String.split()` vs `get_slice()` ([GH-62083](https://github.com/godotengine/godot/pull/62083)).
- Move server files into their subfolders ([GH-89409](https://github.com/godotengine/godot/pull/89409)).
- Misc script editor code cleanup ([GH-94013](https://github.com/godotengine/godot/pull/94013)).
- Add `Memory::get_aligned_address` to simplify data offset constants ([GH-100145](https://github.com/godotengine/godot/pull/100145)).
- Add `is_instance()` helper method to Node ([GH-100437](https://github.com/godotengine/godot/pull/100437)).
- Delete `VariantGetInternalPtr` and `VariantImplicitConvert`, replace with `VariantInternalAccessor` ([GH-105254](https://github.com/godotengine/godot/pull/105254)).
- Don't hard-code hsplit count ([GH-106849](https://github.com/godotengine/godot/pull/106849)).
- Rename internal fields and variables in `AHashMap`, `HashMap` and `HashSet` ([GH-107045](https://github.com/godotengine/godot/pull/107045)).
- Rename server `free` functions to `free_rid` to match exposed API ([GH-107139](https://github.com/godotengine/godot/pull/107139)).
- Remove implicit conversions between `LocalVector` and `Vector` ([GH-107469](https://github.com/godotengine/godot/pull/107469)).
- Remove dependency of `variant.h` in `print_string.h` ([GH-107721](https://github.com/godotengine/godot/pull/107721)).
- Remove unused methods in `ResourceLoader` ([GH-108076](https://github.com/godotengine/godot/pull/108076)).
- Core: Handle disabled class detection in `ClassDB` ([GH-108121](https://github.com/godotengine/godot/pull/108121)).
- Replace repetitive meta/ctrl condition with a method ([GH-108314](https://github.com/godotengine/godot/pull/108314)).
- Remove empty constructors and destructors from `core/` ([GH-108340](https://github.com/godotengine/godot/pull/108340)).
- Remove unnecessary cpp files after cleanup ([GH-108516](https://github.com/godotengine/godot/pull/108516)).
- Reduce code duplication in material conversion ([GH-108672](https://github.com/godotengine/godot/pull/108672)).
- Copyright: Fix spelling of license ([GH-109339](https://github.com/godotengine/godot/pull/109339)).
- Refactor `_edit_current()` script check ([GH-109649](https://github.com/godotengine/godot/pull/109649)).
- Core: Integrate semantic constants in math structs ([GH-109744](https://github.com/godotengine/godot/pull/109744)).
- Fix inconsistent internal name of `get_resource_filesystem` ([GH-110156](https://github.com/godotengine/godot/pull/110156)).
- Misc cleanup in EditorExportPlatform ([GH-110248](https://github.com/godotengine/godot/pull/110248)).
- Remove overrun code duplication ([GH-110819](https://github.com/godotengine/godot/pull/110819)).
- Skip copying values constructed immediately before returning ([GH-110952](https://github.com/godotengine/godot/pull/110952)).
- Use const ref parameters in the Web modules ([GH-110977](https://github.com/godotengine/godot/pull/110977)).
- Remove unused `import_path` member from `Node` ([GH-111043](https://github.com/godotengine/godot/pull/111043)).
- Change `Memory` from a class into a namespace ([GH-111066](https://github.com/godotengine/godot/pull/111066)).
- Group together 2D camera override functions ([GH-111106](https://github.com/godotengine/godot/pull/111106)).
- Refactor `Array` iterators to be trivially copyable ([GH-111158](https://github.com/godotengine/godot/pull/111158)).
- Store `ThemeOwner` owner directly as `Node*` ([GH-111249](https://github.com/godotengine/godot/pull/111249)).
- Remove `timer.h` include from `control.h` ([GH-111270](https://github.com/godotengine/godot/pull/111270)).
- Remove `file_access.h` and `script_backtrace.h` includes from `logger.h` ([GH-111274](https://github.com/godotengine/godot/pull/111274)).
- Core: Clean up headers in `core/config`, forward-declare `MainLoop` in `OS` ([GH-111297](https://github.com/godotengine/godot/pull/111297)).
- Remove `VariantHasher` and `VariantComparator` in favor of specializing `HashMapHasherDefault` and `HashMapComparatorDefault` ([GH-111358](https://github.com/godotengine/godot/pull/111358)).
- Clean up `hashfuncs.h` ([GH-111361](https://github.com/godotengine/godot/pull/111361)).
- Fix wrong EditorSettings usage in 3D editor ([GH-111589](https://github.com/godotengine/godot/pull/111589)).
- Improvements to ProjectManager's `_update_theme()` ([GH-111649](https://github.com/godotengine/godot/pull/111649)).
- Use American spelling of "favorite" in Project Manager code for consistency ([GH-112787](https://github.com/godotengine/godot/pull/112787)).
- Remove unused private variables in `godot/scene` ([GH-113709](https://github.com/godotengine/godot/pull/113709)).
- Remove unused private variables in `expression.h` ([GH-113730](https://github.com/godotengine/godot/pull/113730)).
- Apply codespell to CHANGELOG.md ([GH-114051](https://github.com/godotengine/godot/pull/114051)).
- Fix wording in TileSet collision polygon error message ([GH-114385](https://github.com/godotengine/godot/pull/114385)).

#### Core

- Add `DUPLICATE_INTERNAL_STATE` flag ([GH-57121](https://github.com/godotengine/godot/pull/57121)).
- Fix resource shared when duplicating an instanced scene ([GH-64487](https://github.com/godotengine/godot/pull/64487)).
- Supplement the case of scene instantiation for "Editable Children" ([GH-81530](https://github.com/godotengine/godot/pull/81530)).
- Initialize `Quaternion` variant with identity ([GH-84658](https://github.com/godotengine/godot/pull/84658)).
- Add `change_scene_to_node()` ([GH-85762](https://github.com/godotengine/godot/pull/85762)).
- Change how ImageTexture's image is defined ([GH-89983](https://github.com/godotengine/godot/pull/89983)).
- Clean up `String::find` and similar functions to remove duplicate code, and speed up comparison ([GH-101247](https://github.com/godotengine/godot/pull/101247)).
- Add `Image.load_exr_from_buffer` ([GH-101255](https://github.com/godotengine/godot/pull/101255)).
- Round AtlasTexture size ([GH-101342](https://github.com/godotengine/godot/pull/101342)).
- Remove `load_steps` from `resource_format_text.cpp` ([GH-103352](https://github.com/godotengine/godot/pull/103352)).
- Optimize `vformat` by using `Span` in `sprintf` ([GH-103917](https://github.com/godotengine/godot/pull/103917)).
- Add `Span` equality (`==` and `!=`) operators ([GH-104280](https://github.com/godotengine/godot/pull/104280)).
- Add 'Find Sequence' to `Span`s, and consolidate negative indexing behavior ([GH-104332](https://github.com/godotengine/godot/pull/104332)).
- Fix non-tool script check when emitting signals ([GH-104340](https://github.com/godotengine/godot/pull/104340)).
- Expose missing `String` encoding conversion functions ([GH-104781](https://github.com/godotengine/godot/pull/104781)).
- Add `recording_signals` to MissingNode, and rename `MTVIRTUAL` to `DEBUG_VIRTUAL` ([GH-105449](https://github.com/godotengine/godot/pull/105449)).
- Make `MissingNode`/`MissingResource` non-virtual and hide from dialogs ([GH-105450](https://github.com/godotengine/godot/pull/105450)).
- Add initial architecture for first-class `Object` types. Optimize `is_class` ([GH-105793](https://github.com/godotengine/godot/pull/105793)).
- Add `reserve` function to `Array`, `Vector`, and `String` ([GH-105928](https://github.com/godotengine/godot/pull/105928)).
- Add `reserve_exact` to `CowData`, and change growth factor to 1.5x ([GH-106039](https://github.com/godotengine/godot/pull/106039)).
- Fix `Dictionary::operator[]` from C++ accidentally modifying `const` dictionaries ([GH-106636](https://github.com/godotengine/godot/pull/106636)).
- Add unique Node IDs to support base and instantiated scene refactorings ([GH-106837](https://github.com/godotengine/godot/pull/106837)).
- Fix `FixedVector` move and copy semantics ([GH-106997](https://github.com/godotengine/godot/pull/106997)).
- Add `Node::iterate_children` as a fast way to iterate a node's children ([GH-107369](https://github.com/godotengine/godot/pull/107369)).
- Use `LocalVector` for `Node3D` and `CanvasItem` children ([GH-107481](https://github.com/godotengine/godot/pull/107481)).
- Provide quick access to `Object` ancestry ([GH-107868](https://github.com/godotengine/godot/pull/107868)).
- Improve error message when UID main scene is not found ([GH-108075](https://github.com/godotengine/godot/pull/108075)).
- Simplify `varray` ([GH-108118](https://github.com/godotengine/godot/pull/108118)).
- Avoid unnecessary copy in `ClassDB::get_property_list` ([GH-108504](https://github.com/godotengine/godot/pull/108504)).
- Optimize scene tree groups ([GH-108507](https://github.com/godotengine/godot/pull/108507)).
- Simplify `ScriptServer::get_global_class_list` ([GH-108577](https://github.com/godotengine/godot/pull/108577)).
- Optimize and clean up `HashSet::clear` ([GH-108698](https://github.com/godotengine/godot/pull/108698)).
- Add project setting and build option to disable `override.cfg` and related CLI arguments ([GH-108818](https://github.com/godotengine/godot/pull/108818)).
- Use `num_scientific` (Grisu2) when stringifying JSON with full precision ([GH-108836](https://github.com/godotengine/godot/pull/108836)).
- Do not zero elements and perform fast clear in `HashMap` ([GH-108932](https://github.com/godotengine/godot/pull/108932)).
- Ensure all MovieWriter frames have the same resolution as the first frame ([GH-108954](https://github.com/godotengine/godot/pull/108954)).
- Make getting a path from UID cache slightly faster ([GH-108981](https://github.com/godotengine/godot/pull/108981)).
- Round gradient colors ([GH-109012](https://github.com/godotengine/godot/pull/109012)).
- Add `has_extension()` method to String ([GH-109433](https://github.com/godotengine/godot/pull/109433)).
- Fix `FileAccess::create_temp()` default args error ([GH-109843](https://github.com/godotengine/godot/pull/109843)).
- Geometry2D minor optimization ([GH-109897](https://github.com/godotengine/godot/pull/109897)).
- Make `Node::orphan_node_count` thread-safe ([GH-109900](https://github.com/godotengine/godot/pull/109900)).
- Perform per-line or per-rect blits in `blit_rect` ([GH-110058](https://github.com/godotengine/godot/pull/110058)).
- Optimize data flushing for `FileAccessCompressed` and `FileAccessEncrypted` ([GH-110169](https://github.com/godotengine/godot/pull/110169)).
- Remove unused parameter in `__constant_get_enum_name`/`__constant_get_bitfield_name` ([GH-110206](https://github.com/godotengine/godot/pull/110206)).
- Image: Support generating mipmaps for all uncompressed formats ([GH-110257](https://github.com/godotengine/godot/pull/110257)).
- Image: Optimize manual format conversion ([GH-110271](https://github.com/godotengine/godot/pull/110271)).
- Fix duplicate minus in print output ([GH-110354](https://github.com/godotengine/godot/pull/110354)).
- Prevent JNI Variant conversion stack overflow ([GH-110452](https://github.com/godotengine/godot/pull/110452)).
- Add reverse UID cache ([GH-110464](https://github.com/godotengine/godot/pull/110464)).
- Optimize NodePath to String by using cached path ([GH-110478](https://github.com/godotengine/godot/pull/110478)).
- Avoid repeated `_copy_on_write()` calls in `Array::resize()` ([GH-110535](https://github.com/godotengine/godot/pull/110535)).
- Check for `NUL` characters in string parsing functions ([GH-110556](https://github.com/godotengine/godot/pull/110556)).
- Improve `Node::get_children` performance ([GH-110571](https://github.com/godotengine/godot/pull/110571)).
- Apply `rtos_fix` hack for handling 32-bit floats on all calls to `rtos_fix` ([GH-110616](https://github.com/godotengine/godot/pull/110616)).
- X11 input: prevent non-printable keys from producing empty strings ([GH-110635](https://github.com/godotengine/godot/pull/110635)).
- Optimize children cache updates and refine special-case handling ([GH-110650](https://github.com/godotengine/godot/pull/110650)).
- Add `GDSOFTCLASS` to `NetSocket` ([GH-110694](https://github.com/godotengine/godot/pull/110694)).
- Add ability to get list of Project Settings changed, similar to Editor Settings functionality ([GH-110748](https://github.com/godotengine/godot/pull/110748)).
- Add `GDSOFTCLASS` to six inheritors of `Object` ([GH-110752](https://github.com/godotengine/godot/pull/110752)).
- Use `AncestralClass` to speed up `Object::cast_to` when possible ([GH-110763](https://github.com/godotengine/godot/pull/110763)).
- Change "reserve called with a capacity smaller than the current size" error message to a verbose message ([GH-110826](https://github.com/godotengine/godot/pull/110826)).
- Add `GDSOFTCLASS` to deeper inheritors of `Object` ([GH-110837](https://github.com/godotengine/godot/pull/110837)).
- Add comments to `String::size` to lead people to `length()` and explain the difference ([GH-110932](https://github.com/godotengine/godot/pull/110932)).
- Remove unused `multiplayer` member from `Node` ([GH-111067](https://github.com/godotengine/godot/pull/111067)).
- Make `CowData::reserve` warn message when new capacity < size verbose, like other `reserve` methods ([GH-111084](https://github.com/godotengine/godot/pull/111084)).
- Optimize initial `Node::get_path` call by avoiding `Vector::reverse` ([GH-111126](https://github.com/godotengine/godot/pull/111126)).
- Speed up `Node::is_greater_than` by avoiding `alloca` ([GH-111163](https://github.com/godotengine/godot/pull/111163)).
- Remove `hash_map.h` include from `a_hash_map.h`, and remove cross conversion operators ([GH-111221](https://github.com/godotengine/godot/pull/111221)).
- Remove unused members from `Viewport` ([GH-111304](https://github.com/godotengine/godot/pull/111304)).
- Improve type registration order in `register_core_types.cpp` ([GH-111318](https://github.com/godotengine/godot/pull/111318)).
- Remove `Object::script` ([GH-111323](https://github.com/godotengine/godot/pull/111323)).
- Simplify `gdvirtual.gen.inc` `_get_method_info` arguments with a helper function ([GH-111327](https://github.com/godotengine/godot/pull/111327)).
- Abstract `Object` virtual pointer init into a method instead of duplicating it across `gdvirtual.gen.inc` ([GH-111337](https://github.com/godotengine/godot/pull/111337)).
- Bitpack more `Object` booleans ([GH-111339](https://github.com/godotengine/godot/pull/111339)).
- Assert that `dictionary.h` does not include `String`, and that neither of the fundamental containers include `Object` ([GH-111342](https://github.com/godotengine/godot/pull/111342)).
- Register core singleton types before instantiating them ([GH-111383](https://github.com/godotengine/godot/pull/111383)).
- Fix `load_threaded_get` returning `null` when used with `CACHE_MODE_IGNORE` ([GH-111387](https://github.com/godotengine/godot/pull/111387)).
- Reorder registration of types, to register supertypes before subtypes ([GH-111431](https://github.com/godotengine/godot/pull/111431)).
- Handle NaN and Infinity in JSON stringify function ([GH-111498](https://github.com/godotengine/godot/pull/111498)).
- Fix missing includes in `type_info.h` ([GH-111561](https://github.com/godotengine/godot/pull/111561)).
- Add missing initialization for bitpacked object members ([GH-111617](https://github.com/godotengine/godot/pull/111617)).
- Consolidate typed container logic with `type_info.h` ([GH-111661](https://github.com/godotengine/godot/pull/111661)).
- Fix false positive warning with `FixedVector` array bounds in gcc ([GH-111761](https://github.com/godotengine/godot/pull/111761)).
- Sidestep GCC false-positive ([GH-111771](https://github.com/godotengine/godot/pull/111771)).
- Fix buffer over-read in `FileAccessMemory::get_buffer` ([GH-111772](https://github.com/godotengine/godot/pull/111772)).
- Improve determinism of UIDs ([GH-111858](https://github.com/godotengine/godot/pull/111858)).
- Disable some unsafe CLI arguments in template builds by default ([GH-111909](https://github.com/godotengine/godot/pull/111909)).
- Fix `memnew_placement` with `char *` arguments ([GH-112033](https://github.com/godotengine/godot/pull/112033)).
- Fix duplicating node references of custom node type properties ([GH-112076](https://github.com/godotengine/godot/pull/112076)).
- Main: Fix typo in `--gpu-profile` CLI argument ([GH-112113](https://github.com/godotengine/godot/pull/112113)).
- ClassDB: Use `AHashMap` for `property_setget` and `constant/signal_map` ([GH-112129](https://github.com/godotengine/godot/pull/112129)).
- Explain `Dictionary.set()` return value in docs ([GH-112261](https://github.com/godotengine/godot/pull/112261)).
- Avoid extra copy in `Vector`/`CowData` `push_back`/`insert` ([GH-112630](https://github.com/godotengine/godot/pull/112630)).
- Add a const version of `List::find` ([GH-112660](https://github.com/godotengine/godot/pull/112660)).
- Add memory profiling macros for tracy profiler option ([GH-112702](https://github.com/godotengine/godot/pull/112702)).
- Fix scene argument parsing ([GH-112716](https://github.com/godotengine/godot/pull/112716)).
- Add some comments in the `profiling.h` header ([GH-112725](https://github.com/godotengine/godot/pull/112725)).
- Add `permissions/manage_media` to Android export options ([GH-112819](https://github.com/godotengine/godot/pull/112819)).
- Add error message when trying to load project from CWD ([GH-112844](https://github.com/godotengine/godot/pull/112844)).
- Include key in `Dictionary::operator[]` error message ([GH-112853](https://github.com/godotengine/godot/pull/112853)).
- Fix bug where optional argument is not validated before use ([GH-112969](https://github.com/godotengine/godot/pull/112969)).
- Correctly mark frame start for profilers (Tracy/Perfetto) on Linux ([GH-113023](https://github.com/godotengine/godot/pull/113023)).
- Fix `String::rfindn` for strings with only one character ([GH-113044](https://github.com/godotengine/godot/pull/113044)).
- Only call `GodotProfileAlloc` when the allocation actually happened ([GH-113061](https://github.com/godotengine/godot/pull/113061)).
- Fix a thread warning ([GH-113064](https://github.com/godotengine/godot/pull/113064)).
- Allow `override.cfg` to add autoloads to the front of the list ([GH-113078](https://github.com/godotengine/godot/pull/113078)).
- Ensure paths in autoload info ([GH-113088](https://github.com/godotengine/godot/pull/113088)).
- ResourceLoader: Fix potential infinite recursion in progress reporting ([GH-113114](https://github.com/godotengine/godot/pull/113114)).
- Skip ResourceLoader's progress query if not requested ([GH-113117](https://github.com/godotengine/godot/pull/113117)).
- Reuse/optimize common `OperatorEvaluator*::evaluate` logic ([GH-113132](https://github.com/godotengine/godot/pull/113132)).
- Fix memory alignment on 32-bit Windows ([GH-113145](https://github.com/godotengine/godot/pull/113145)).
- Add back I/O error-handling to `FileAccessPack` constructor ([GH-113150](https://github.com/godotengine/godot/pull/113150)).
- Do not attempt deleting local cache in `Resource::_teardown_duplicate_from_variant` ([GH-113179](https://github.com/godotengine/godot/pull/113179)).
- Make `Variant::get_type_by_name` `HashMap` initialization thread-safe ([GH-113211](https://github.com/godotengine/godot/pull/113211)).
- Mention the called function name in thread group error messages ([GH-113218](https://github.com/godotengine/godot/pull/113218)).
- Fix loading old-style translation files ([GH-113322](https://github.com/godotengine/godot/pull/113322)).
- Add Apple Instruments support ([GH-113342](https://github.com/godotengine/godot/pull/113342)).
- Android: Add method to take persistable URI permission ([GH-113367](https://github.com/godotengine/godot/pull/113367)).
- Optimize NodePath ([GH-113447](https://github.com/godotengine/godot/pull/113447)).
- Fix crash in `command_queue_mt` due to destruction of wrong object ([GH-113525](https://github.com/godotengine/godot/pull/113525)).
- Make `!configured` checks in `profiling.cpp` soft checks instead of crashing ([GH-113526](https://github.com/godotengine/godot/pull/113526)).
- Unix: Remove leading `..` from absolute paths and apply `simplify_path` to Unix current directory path ([GH-113575](https://github.com/godotengine/godot/pull/113575)).
- Add support for profiling system calls from GDScript with the tracy integration ([GH-113632](https://github.com/godotengine/godot/pull/113632)).
- CommandQueueMT: Make re-entrant again + Fix multiple flushers case ([GH-113802](https://github.com/godotengine/godot/pull/113802)).
- Make memory profiling optional ([GH-113807](https://github.com/godotengine/godot/pull/113807)).
- Fix building with Perfetto profiler ([GH-113812](https://github.com/godotengine/godot/pull/113812)).
- macOS: Remove duplicate profiler init call ([GH-113813](https://github.com/godotengine/godot/pull/113813)).
- Vector4: Fix loss of precision with division ([GH-113848](https://github.com/godotengine/godot/pull/113848)).
- Remove underscore from parameter name in `FileAccess::set_extended_attribute_string` ([GH-113934](https://github.com/godotengine/godot/pull/113934)).
- Fix potential DAP crash at startup ([GH-114196](https://github.com/godotengine/godot/pull/114196)).
- Add inline documentation to `Vector::reserve` and `Vector::reserve_exact` ([GH-114563](https://github.com/godotengine/godot/pull/114563)).
- Fix description for `resize_uninitialized` ([GH-114688](https://github.com/godotengine/godot/pull/114688)).
- Auto-release static GDTypes at exit ([GH-114790](https://github.com/godotengine/godot/pull/114790)).
- Restore period in loaded node paths ([GH-115231](https://github.com/godotengine/godot/pull/115231)).

#### Documentation

- Document RIDs that will be freed automatically when freeing their deps ([GH-103113](https://github.com/godotengine/godot/pull/103113)).
- Fix ItemList docs for the focus Stylebox's draw order ([GH-103672](https://github.com/godotengine/godot/pull/103672)).
- Update color encoding documentation ([GH-104666](https://github.com/godotengine/godot/pull/104666)).
- Update EditorImportPlugin docs and clarify which methods are required ([GH-104740](https://github.com/godotengine/godot/pull/104740)).
- Add notes about `InputEventKey` property usage ([GH-105366](https://github.com/godotengine/godot/pull/105366)).
- Fix `typeof` example in @GlobalScope docs ([GH-106768](https://github.com/godotengine/godot/pull/106768)).
- Document typed dictionaries and arrays in the class reference ([GH-107071](https://github.com/godotengine/godot/pull/107071)).
- Improve Texture*RD, RenderData and LightmapperRD class documentation ([GH-107326](https://github.com/godotengine/godot/pull/107326)).
- Fix miscellaneous oddities around the class reference (part 6) ([GH-107536](https://github.com/godotengine/godot/pull/107536)).
- Web: Add notice about issues with setting custom cursor shape every frame ([GH-107586](https://github.com/godotengine/godot/pull/107586)).
- Add missing required qualifier for various classes ([GH-107989](https://github.com/godotengine/godot/pull/107989)).
- Docs: Fix typo in `Object.get_signal_list` ([GH-108417](https://github.com/godotengine/godot/pull/108417)).
- Add documentation about logging from `Logger` not being supported ([GH-109174](https://github.com/godotengine/godot/pull/109174)).
- Clarify truncation behavior in file open modes ([GH-109632](https://github.com/godotengine/godot/pull/109632)).
- OpenXRExtensionWrapper: Document how to safely work when rendering with "Separate" thread model ([GH-109753](https://github.com/godotengine/godot/pull/109753)).
- Fix typos and link tutorial in WebRTCPeerConnection docs ([GH-109907](https://github.com/godotengine/godot/pull/109907)).
- Clarify that velocity doesn't need delta multiplication in CharacterBody documentation ([GH-109925](https://github.com/godotengine/godot/pull/109925)).
- Image: Improve `AlphaMode` documentation ([GH-110213](https://github.com/godotengine/godot/pull/110213)).
- Document `PhysicsServer3D` shapes ([GH-110223](https://github.com/godotengine/godot/pull/110223)).
- Fix minor grammar error in CollisionPolygon2D, CollisionPolygon3D, CollisionShape2D, and CollisionShape3D docs ([GH-110370](https://github.com/godotengine/godot/pull/110370)).
- Document the interaction between Light3D cull mask and GI/volumetric fog ([GH-110423](https://github.com/godotengine/godot/pull/110423)).
- Fix `Basis.determinant()` doc: uniform scale determinant is `scale^3` ([GH-110424](https://github.com/godotengine/godot/pull/110424)).
- Improve docs for pitch and volume variation in AudioStreamRandomizer ([GH-110435](https://github.com/godotengine/godot/pull/110435)).
- Fix documentation for `embed_subwindows` project setting ([GH-110448](https://github.com/godotengine/godot/pull/110448)).
- Fix typo in control node `_make_custom_tooltip` description ([GH-110504](https://github.com/godotengine/godot/pull/110504)).
- Document Label performance caveats with huge amounts of text ([GH-110533](https://github.com/godotengine/godot/pull/110533)).
- Add `accordion` and `details` search keywords to FoldableContainer ([GH-110572](https://github.com/godotengine/godot/pull/110572)).
- Document `TileMapLayer.get_coords_for_body_rid()` precision depending on quadrant size ([GH-110575](https://github.com/godotengine/godot/pull/110575)).
- Rephrase `Logger` documentation to be more explicit about thread-safety ([GH-110614](https://github.com/godotengine/godot/pull/110614)).
- Document CanvasItem visibility layers not being inherited from parent nodes ([GH-110705](https://github.com/godotengine/godot/pull/110705)).
- Fix and improve `Node2D.move_local_{x,y}()` description ([GH-110878](https://github.com/godotengine/godot/pull/110878)).
- Fix `/tutorial` added twice in offline docs ([GH-110881](https://github.com/godotengine/godot/pull/110881)).
- Document `compress()` not being supported in exported builds in Image ([GH-111004](https://github.com/godotengine/godot/pull/111004)).
- Fix description about CharacterBody velocity and delta ([GH-111102](https://github.com/godotengine/godot/pull/111102)).
- Drop the experimental label for the Jolt Physics integration ([GH-111115](https://github.com/godotengine/godot/pull/111115)).
- Fix typo "blocker" to "block" in AESContext ([GH-111133](https://github.com/godotengine/godot/pull/111133)).
- Document link between `Node2D.look_at()` and `Node2D.get_angle_to()` ([GH-111139](https://github.com/godotengine/godot/pull/111139)).
- Fix incorrect docs example in `Dictionary.set` description ([GH-111216](https://github.com/godotengine/godot/pull/111216)).
- Add "Ragdoll System" Tutorial to `PhysicalBone3D` ([GH-111267](https://github.com/godotengine/godot/pull/111267)).
- Update tutorial link for calling Javascript from script ([GH-111310](https://github.com/godotengine/godot/pull/111310)).
- Improve documentation for the `Environment` glow effect ([GH-111332](https://github.com/godotengine/godot/pull/111332)).
- Document relationship between refresh rate and V-Sync in DisplayServer ([GH-111334](https://github.com/godotengine/godot/pull/111334)).
- Replace deprecated `Color8` ([GH-111426](https://github.com/godotengine/godot/pull/111426)).
- Add note for some usages of Plane in APIs ([GH-111459](https://github.com/godotengine/godot/pull/111459)).
- Fix `text_editor/script_list/show_members_overview` editor setting docs/tooltip ([GH-111556](https://github.com/godotengine/godot/pull/111556)).
- Fix description of `Viewport::set_input_as_handled` ([GH-111591](https://github.com/godotengine/godot/pull/111591)).
- Fix typo in mutex documentation ([GH-111672](https://github.com/godotengine/godot/pull/111672)).
- Update documentation for `Engine.physics_ticks_per_second` and its project setting ([GH-111774](https://github.com/godotengine/godot/pull/111774)).
- Update note for `rendering/rendering_device/vsync/swapchain_image_count` ([GH-111782](https://github.com/godotengine/godot/pull/111782)).
- Improve Window content scale documentation ([GH-111804](https://github.com/godotengine/godot/pull/111804)).
- Correct Array `remove_at()` class reference ([GH-111817](https://github.com/godotengine/godot/pull/111817)).
- Add multilevel notes to methods ([GH-111830](https://github.com/godotengine/godot/pull/111830)).
- TileSetAtlasSource: Fix and/an docstring typo ([GH-111852](https://github.com/godotengine/godot/pull/111852)).
- Fix `NOTIFICATION_OS_IME_UPDATE` docs on platform availability ([GH-111863](https://github.com/godotengine/godot/pull/111863)).
- Document color format caveats in `Image.set_pixel()` ([GH-111896](https://github.com/godotengine/godot/pull/111896)).
- Document TextMesh performance caveats ([GH-111962](https://github.com/godotengine/godot/pull/111962)).
- Document popups being invisible by default ([GH-111963](https://github.com/godotengine/godot/pull/111963)).
- Fix copyright documentation oversights ([GH-112006](https://github.com/godotengine/godot/pull/112006)).
- Fix typo in ResourceImporterImageFont docs ([GH-112063](https://github.com/godotengine/godot/pull/112063)).
- Improve `PROPERTY_USAGE_ARRAY` description ([GH-112066](https://github.com/godotengine/godot/pull/112066)).
- Add search keywords for project settings ([GH-112107](https://github.com/godotengine/godot/pull/112107)).
- Improve HeightMapShape3D documentation ([GH-112120](https://github.com/godotengine/godot/pull/112120)).
- Improve documentation for Vector2's angle-related methods ([GH-112140](https://github.com/godotengine/godot/pull/112140)).
- Document `CharacterBody.get_last_slide_collision()` returning `null` with no collision ([GH-112180](https://github.com/godotengine/godot/pull/112180)).
- Fix `StringName` not documented for enum hint ([GH-112318](https://github.com/godotengine/godot/pull/112318)).
- Mention that SSAO is supported in the Compatibility renderer ([GH-112451](https://github.com/godotengine/godot/pull/112451)).
- Fix `OS.get_cmdline_args` documentation ([GH-112466](https://github.com/godotengine/godot/pull/112466)).
- Fix GDScript code sample for `@GlobalScope.instance_from_id()` ([GH-112486](https://github.com/godotengine/godot/pull/112486)).
- Document `Object.connect()` not supporting persistent connections with lambda functions ([GH-112487](https://github.com/godotengine/godot/pull/112487)).
- Clarify notification call order ([GH-112642](https://github.com/godotengine/godot/pull/112642)).
- Tweak CanvasGroup description to be more explicit about its purpose ([GH-112693](https://github.com/godotengine/godot/pull/112693)).
- Fix typo in `Array` docs ([GH-112708](https://github.com/godotengine/godot/pull/112708)).
- Fix typo in `MouseBehaviorRecursive` enum description in Control class ([GH-112714](https://github.com/godotengine/godot/pull/112714)).
- Clarify that `Node.duplicate()` duplicates entire subtree recursively ([GH-112907](https://github.com/godotengine/godot/pull/112907)).
- Fix incorrect equivalent method reference in screen-space transform methods doc ([GH-112952](https://github.com/godotengine/godot/pull/112952)).
- Fix `display/window/size/initial_position_type` project setting description ([GH-112962](https://github.com/godotengine/godot/pull/112962)).
- Fix SkeletonProfileHumanoid bone count documentation ([GH-112986](https://github.com/godotengine/godot/pull/112986)).
- Update docs to describe new `use_hdr_2d` behavior with Mobile renderer ([GH-112990](https://github.com/godotengine/godot/pull/112990)).
- Fix documentation typos and broken links ([GH-113073](https://github.com/godotengine/godot/pull/113073)).
- Clarify the purpose of MeshInstance2D and MultiMeshInstance2D ([GH-113122](https://github.com/godotengine/godot/pull/113122)).
- Add better clarification for accelerator support on Popup Menu ([GH-113197](https://github.com/godotengine/godot/pull/113197)).
- Fix miscellaneous oddities around the class reference (part 7) ([GH-113261](https://github.com/godotengine/godot/pull/113261)).
- Docs: Fix ParticleProcessMaterial code snippet in `alpha_curve` description ([GH-113268](https://github.com/godotengine/godot/pull/113268)).
- Doc: Add missing `func` keyword to `EditorDock._update_layout` example ([GH-113381](https://github.com/godotengine/godot/pull/113381)).
- Fix typos in VectorNi docs (float division examples) ([GH-113782](https://github.com/godotengine/godot/pull/113782)).
- Update documentation for `DisplayServer::FEATURE_ICON` ([GH-113875](https://github.com/godotengine/godot/pull/113875)).
- Update EditorDock shortcut documentation ([GH-113888](https://github.com/godotengine/godot/pull/113888)).
- Rename hinting mode 'Full' to 'Normal' to keep consistency ([GH-113927](https://github.com/godotengine/godot/pull/113927)).
- Add "Threaded Loading Demo" link to `ResourceLoader` tutorials ([GH-114087](https://github.com/godotengine/godot/pull/114087)).
- Document suffix hint in `PROPERTY_HINT_RANGE` ([GH-114116](https://github.com/godotengine/godot/pull/114116)).
- Fix outdated comment in `CanvasItem.draw_string()` code sample ([GH-114225](https://github.com/godotengine/godot/pull/114225)).
- Add Link to the Owner Tutorial ([GH-114243](https://github.com/godotengine/godot/pull/114243)).
- Document `RegEx.create_from_string()` in RegEx class description ([GH-114253](https://github.com/godotengine/godot/pull/114253)).
- Add missing method reference in `ShaderMaterial.set_shader_parameter` documentation ([GH-114262](https://github.com/godotengine/godot/pull/114262)).
- Document runtime alternative to Default Theme Scale project setting ([GH-114291](https://github.com/godotengine/godot/pull/114291)).
- Clarify using local variables with drawing methods ([GH-114551](https://github.com/godotengine/godot/pull/114551)).
- Clarify `align()` behavior regarding `force_update_scroll()` ([GH-114638](https://github.com/godotengine/godot/pull/114638)).
- Fix `EditorDock` documentation code example ([GH-114706](https://github.com/godotengine/godot/pull/114706)).
- Specify units for angles in the LookAtModifier3D documentation ([GH-114774](https://github.com/godotengine/godot/pull/114774)).
- README: Minor tweaks and remove broken badge ([GH-114960](https://github.com/godotengine/godot/pull/114960)).
- Remove link for consoles in EditorExportPlatform ([GH-114979](https://github.com/godotengine/godot/pull/114979)).

#### Editor

- Show a warning toast when saving a large text-based scene ([GH-53679](https://github.com/godotengine/godot/pull/53679)).
- Add a border to tooltips when using the Draw Extra Borders editor setting ([GH-76267](https://github.com/godotengine/godot/pull/76267)).
- Add Ctrl + A and Ctrl + Shift + A to (de)select all projects in project manager ([GH-77292](https://github.com/godotengine/godot/pull/77292)).
- Rework icons of noise-related classes ([GH-80427](https://github.com/godotengine/godot/pull/80427)).
- Add icons to some editor classes ([GH-82121](https://github.com/godotengine/godot/pull/82121)).
- Allow editing editor settings from project manager ([GH-82212](https://github.com/godotengine/godot/pull/82212)).
- Move script name to top ([GH-86468](https://github.com/godotengine/godot/pull/86468)).
- Allow rearranging translation list via drag and drop ([GH-89367](https://github.com/godotengine/godot/pull/89367)).
- Refactor SceneTreeDock context menu separators ([GH-92390](https://github.com/godotengine/godot/pull/92390)).
- Store script states for built-in scripts ([GH-93713](https://github.com/godotengine/godot/pull/93713)).
- Add `EditorResourcePreviewGenerator::request_draw_and_wait` ([GH-96897](https://github.com/godotengine/godot/pull/96897)).
- Add an ObjectDB Profiling Tool ([GH-97210](https://github.com/godotengine/godot/pull/97210)).
- Fix various editor easing property issues ([GH-97753](https://github.com/godotengine/godot/pull/97753)).
- Fix scripts panel state not being saved when toggle button is used ([GH-98936](https://github.com/godotengine/godot/pull/98936)).
- Fix ProjectManager import dialog error ([GH-100197](https://github.com/godotengine/godot/pull/100197)).
- Remove prompt to restart editor after changing custom theme ([GH-100876](https://github.com/godotengine/godot/pull/100876)).
- Show file when FileSystem is searched with UID ([GH-102789](https://github.com/godotengine/godot/pull/102789)).
- Condense Inspector layout for Arrays ([GH-103257](https://github.com/godotengine/godot/pull/103257)).
- Add switch on hover to TabBar ([GH-103478](https://github.com/godotengine/godot/pull/103478)).
- Fix `Color` precision error in the documentation generated on M4 macOS ([GH-104112](https://github.com/godotengine/godot/pull/104112)).
- Support keeping results in results of `Find in Files` and `Replace in Files` ([GH-104676](https://github.com/godotengine/godot/pull/104676)).
- Fix pressed keys reset when hiding a window on Windows ([GH-104802](https://github.com/godotengine/godot/pull/104802)).
- Fix inspector spacing issues ([GH-105773](https://github.com/godotengine/godot/pull/105773)).
- Optimize the `callback` argument of `popup_create_dialog()` ([GH-106071](https://github.com/godotengine/godot/pull/106071)).
- Fix editing resources in the inspector when inside an array or dictionary ([GH-106099](https://github.com/godotengine/godot/pull/106099)).
- Refactor editor `EditorBottomPanel` to be a `TabContainer` ([GH-106164](https://github.com/godotengine/godot/pull/106164)).
- Add drag and drop export variables ([GH-106341](https://github.com/godotengine/godot/pull/106341)).
- Rework editor docks ([GH-106503](https://github.com/godotengine/godot/pull/106503)).
- Add "Distraction Free Mode" button to `EditorBottomPanel` when bottom panel is expanded ([GH-106780](https://github.com/godotengine/godot/pull/106780)).
- Allow Quick Open dialog to preview change in scene ([GH-106947](https://github.com/godotengine/godot/pull/106947)).
- Fix the extra arguments of type `NodePath` in the connection dialog do not work ([GH-107013](https://github.com/godotengine/godot/pull/107013)).
- Allow closing all scene tabs via shortcut ([GH-107065](https://github.com/godotengine/godot/pull/107065)).
- Make drag-and-dropped resources unique when holding Ctrl/Cmd in the editor ([GH-107237](https://github.com/godotengine/godot/pull/107237)).
- Add game speed controls to the embedded game window ([GH-107273](https://github.com/godotengine/godot/pull/107273)).
- Expose the signal when user select a file/folder in the FileSystemDock ([GH-107275](https://github.com/godotengine/godot/pull/107275)).
- Fix TabContainer Editor theming and remove Debugger style hacks ([GH-107395](https://github.com/godotengine/godot/pull/107395)).
- ShaderCompiler: Optimize compilation error printing ([GH-107547](https://github.com/godotengine/godot/pull/107547)).
- Show "No Translations Configured" message for empty translation preview menu ([GH-107649](https://github.com/godotengine/godot/pull/107649)).
- Add "Set as Main Scene" option to EditorSceneTabs context menu ([GH-107652](https://github.com/godotengine/godot/pull/107652)).
- Add checkbox for blender's "GPU Instances" option for exporting GLTF ([GH-107672](https://github.com/godotengine/godot/pull/107672)).
- Fix setting remote properties that take objects not working ([GH-107687](https://github.com/godotengine/godot/pull/107687)).
- Show description for editor setting overrides ([GH-107692](https://github.com/godotengine/godot/pull/107692)).
- Improve editor settings override display ([GH-107765](https://github.com/godotengine/godot/pull/107765)).
- Simplify Node Filter's placeholder in Scene dock ([GH-107942](https://github.com/godotengine/godot/pull/107942)).
- Replace Inspector `pending` stack usage with loop ([GH-107947](https://github.com/godotengine/godot/pull/107947)).
- Clean up numeric EditorProperty `setup()` methods ([GH-108065](https://github.com/godotengine/godot/pull/108065)).
- Add tab menu button to list currently opened scenes ([GH-108079](https://github.com/godotengine/godot/pull/108079)).
- Replace spaces and use lowercase automatically for project manager tags ([GH-108125](https://github.com/godotengine/godot/pull/108125)).
- Carry editor pseudolocalization CLI option across restarts ([GH-108129](https://github.com/godotengine/godot/pull/108129)).
- Change preview methods to take Callable ([GH-108162](https://github.com/godotengine/godot/pull/108162)).
- Allow moving nodes when they have different parents in SceneTreeDock ([GH-108168](https://github.com/godotengine/godot/pull/108168)).
- Use create script dialog for script-type resources ([GH-108180](https://github.com/godotengine/godot/pull/108180)).
- Hide property groups from the "Members" section in the remote inspector ([GH-108213](https://github.com/godotengine/godot/pull/108213)).
- EditorFileSystem: Simplify resource loading logic on startup ([GH-108236](https://github.com/godotengine/godot/pull/108236)).
- Add more `PROPERTY_HINT_GROUP_ENABLE` uses ([GH-108254](https://github.com/godotengine/godot/pull/108254)).
- Automatically open newly created script ([GH-108342](https://github.com/godotengine/godot/pull/108342)).
- Remove unused member variables in `EditorInspector` ([GH-108379](https://github.com/godotengine/godot/pull/108379)).
- Add expression history to evaluator ([GH-108391](https://github.com/godotengine/godot/pull/108391)).
- Remove unnecessary newlines from key tooltip ([GH-108404](https://github.com/godotengine/godot/pull/108404)).
- Make file part of errors/warnings clickable in Output panel ([GH-108473](https://github.com/godotengine/godot/pull/108473)).
- Make editor property clipboard static ([GH-108479](https://github.com/godotengine/godot/pull/108479)).
- Update Breeze dark theme colors ([GH-108534](https://github.com/godotengine/godot/pull/108534)).
- Improve Paste as Unique option ([GH-108551](https://github.com/godotengine/godot/pull/108551)).
- Do not require editor restart when changing editor inspector settings ([GH-108554](https://github.com/godotengine/godot/pull/108554)).
- Make bottom panel into available dock slot ([GH-108647](https://github.com/godotengine/godot/pull/108647)).
- Add hint range and capitalization for Path3D Tilt Disk Size editor setting ([GH-108677](https://github.com/godotengine/godot/pull/108677)).
- Do not poll for system theme changes ([GH-108705](https://github.com/godotengine/godot/pull/108705)).
- Allow concurrent unbinding and binding of signal arguments in editor ([GH-108741](https://github.com/godotengine/godot/pull/108741)).
- Move Material3D conversion editor plugins to their own folder ([GH-108766](https://github.com/godotengine/godot/pull/108766)).
- Fix bad text contrast on readonly EditorPropertyArray/Dict/Res ([GH-108872](https://github.com/godotengine/godot/pull/108872)).
- Reduce icon size in editor inspector NodePath properties to match design size ([GH-108882](https://github.com/godotengine/godot/pull/108882)).
- Add suffix to EditorSpinSlider tooltips ([GH-108929](https://github.com/godotengine/godot/pull/108929)).
- Clean up `EditorPluginList` ([GH-108987](https://github.com/godotengine/godot/pull/108987)).
- Add confirmation dialog to filesystem dock when moving or copying files ([GH-109017](https://github.com/godotengine/godot/pull/109017)).
- Remove unused member variables in EditorNode ([GH-109027](https://github.com/godotengine/godot/pull/109027)).
- View resource signals in the Connections Dock ([GH-109043](https://github.com/godotengine/godot/pull/109043)).
- Add a documentation link to the renderer selection dialog ([GH-109101](https://github.com/godotengine/godot/pull/109101)).
- Use a fixed-width font for the expression evaluator ([GH-109166](https://github.com/godotengine/godot/pull/109166)).
- Correct the order of Diagonal Mode in Add Property ([GH-109214](https://github.com/godotengine/godot/pull/109214)).
- Add Shortcut tooltip to Editor Main Screen Plugins ([GH-109234](https://github.com/godotengine/godot/pull/109234)).
- ThemeEditor: Reorganize/fix UI to make it fit in editor (at its minimum size in single-window mode) better ([GH-109237](https://github.com/godotengine/godot/pull/109237)).
- Improve EditorRunBar shortcut tooltips to be more informative ([GH-109306](https://github.com/godotengine/godot/pull/109306)).
- Deprecate `get_scene()` in `EditorScript` class ([GH-109331](https://github.com/godotengine/godot/pull/109331)).
- Add icon & clear button to Select Method dialog search bar ([GH-109384](https://github.com/godotengine/godot/pull/109384)).
- ProfilerAutostartWarning svg icon cleanup ([GH-109413](https://github.com/godotengine/godot/pull/109413)).
- Add indicator to linked resources ([GH-109458](https://github.com/godotengine/godot/pull/109458)).
- Fix scrolling to bottom panel selected button ([GH-109502](https://github.com/godotengine/godot/pull/109502)).
- Speed up deletion via the Scene Tree Dock in large trees ([GH-109511](https://github.com/godotengine/godot/pull/109511)).
- Miscellaneous editor optimizations for large scenes ([GH-109513](https://github.com/godotengine/godot/pull/109513)).
- Speed up large selections in the editor ([GH-109515](https://github.com/godotengine/godot/pull/109515)).
- Speed up signal disconnects in the editor ([GH-109517](https://github.com/godotengine/godot/pull/109517)).
- Show symlink target in the resource tooltip ([GH-109525](https://github.com/godotengine/godot/pull/109525)).
- Fix the text editor confusing resource files of class JSON with json files ([GH-109549](https://github.com/godotengine/godot/pull/109549)).
- Replace "local" `Vector` with `LocalVector` ([GH-109562](https://github.com/godotengine/godot/pull/109562)).
- Make FileSystemDock navigate to currently selected scene tab ([GH-109587](https://github.com/godotengine/godot/pull/109587)).
- Extend DAP to allow debugging main/current/specific scene/secondary editor and command-line arguments ([GH-109637](https://github.com/godotengine/godot/pull/109637)).
- Improve and reduce Game window sizing ([GH-109701](https://github.com/godotengine/godot/pull/109701)).
- FindInFiles: Allow replacing individual results ([GH-109727](https://github.com/godotengine/godot/pull/109727)).
- Update POT files when a file is moved or deleted ([GH-109802](https://github.com/godotengine/godot/pull/109802)).
- Add `Make_Unique_Recursive` option for `Resources` with `Arrays` and `Dictionaries` ([GH-109816](https://github.com/godotengine/godot/pull/109816)).
- Assign shortcuts to prev/next script buttons ([GH-109842](https://github.com/godotengine/godot/pull/109842)).
- Fix typos in BlendSpace2D editor's axis labels' accessibility names ([GH-109847](https://github.com/godotengine/godot/pull/109847)).
- Fix Audio bottom panel going under the taskbar on small displays ([GH-109915](https://github.com/godotengine/godot/pull/109915)).
- Show simple dialog when there are no Resources to duplicate ([GH-109919](https://github.com/godotengine/godot/pull/109919)).
- Refactor debugging on a device with DAP - now possible with all device types ([GH-109987](https://github.com/godotengine/godot/pull/109987)).
- Add column boundary check in the autocompletion ([GH-110017](https://github.com/godotengine/godot/pull/110017)).
- Fix folder color in FileSystem Dock when using light theme ([GH-110066](https://github.com/godotengine/godot/pull/110066)).
- Differentiate the suspend button in the Game tab with the Pause button in the editor run bar ([GH-110108](https://github.com/godotengine/godot/pull/110108)).
- Emit `scene_changed` event when opening a scene from an empty tab list ([GH-110135](https://github.com/godotengine/godot/pull/110135)).
- Fix `ScriptEditor::edit()` not jumping to the first line ([GH-110137](https://github.com/godotengine/godot/pull/110137)).
- Fix Clear option not visible when a Resource's `@export`-ed property is a Script ([GH-110189](https://github.com/godotengine/godot/pull/110189)).
- Fix `ScriptEditor::edit()` ignoring column parameter ([GH-110225](https://github.com/godotengine/godot/pull/110225)).
- Fix editor crash caused by `EditorFileSystem::get_singleton` access in theme initialization path ([GH-110242](https://github.com/godotengine/godot/pull/110242)).
- Properly inspect old remote selection ([GH-110251](https://github.com/godotengine/godot/pull/110251)).
- Add name info to EditorAutoloadSettings invalid name message ([GH-110259](https://github.com/godotengine/godot/pull/110259)).
- Defer checking for rendering device support until the new project dialog is opened ([GH-110269](https://github.com/godotengine/godot/pull/110269)).
- Enable objects stored as dictionary keys to be selected in inspector ([GH-110291](https://github.com/godotengine/godot/pull/110291)).
- Fix vertical alignment of Inspector category titles ([GH-110303](https://github.com/godotengine/godot/pull/110303)).
- Improve dependency editor warning ([GH-110307](https://github.com/godotengine/godot/pull/110307)).
- Open translation CSV in the text editor instead of printing errors ([GH-110323](https://github.com/godotengine/godot/pull/110323)).
- Set language encoding flag when using Pack Project as ZIP ([GH-110387](https://github.com/godotengine/godot/pull/110387)).
- Fix Open Editor Data/Settings Folder menu in self-contained mode ([GH-110413](https://github.com/godotengine/godot/pull/110413)).
- Fix favorite folders that are outside of the project being displayed in `FileSystemDock`'s file list ([GH-110415](https://github.com/godotengine/godot/pull/110415)).
- Fix crash due to null pointer dereference when moving/renaming folders in `FileSystemDock` ([GH-110420](https://github.com/godotengine/godot/pull/110420)).
- Fix AudioBus editor not updating layout path ([GH-110422](https://github.com/godotengine/godot/pull/110422)).
- Fix lost connections when saving branch as scene ([GH-110432](https://github.com/godotengine/godot/pull/110432)).
- Allow custom debug monitors to select desired type ([GH-110433](https://github.com/godotengine/godot/pull/110433)).
- Improve look of some buttons inside the inspector ([GH-110434](https://github.com/godotengine/godot/pull/110434)).
- Allow to use sliders for integers in `EditorSpinSlider` ([GH-110459](https://github.com/godotengine/godot/pull/110459)).
- Improve editor language selector ([GH-110492](https://github.com/godotengine/godot/pull/110492)).
- Optimize PNG assets ([GH-110566](https://github.com/godotengine/godot/pull/110566)).
- Fix the project file was not updated when some files were removed ([GH-110576](https://github.com/godotengine/godot/pull/110576)).
- Fix wrong color for timeline indicator in the light theme ([GH-110593](https://github.com/godotengine/godot/pull/110593)).
- Tweak the enum visual order for Sort Scripts By editor setting ([GH-110602](https://github.com/godotengine/godot/pull/110602)).
- Add Create Resource Hotkey ([GH-110641](https://github.com/godotengine/godot/pull/110641)).
- Expand `LineEdit` with metadata name in `AddMetadataDialog` ([GH-110647](https://github.com/godotengine/godot/pull/110647)).
- Fix DPITexture editor icon name ([GH-110661](https://github.com/godotengine/godot/pull/110661)).
- Keep shortcut selected when clearing filter ([GH-110690](https://github.com/godotengine/godot/pull/110690)).
- Don't emit `scene_changed` when restoring scenes ([GH-110731](https://github.com/godotengine/godot/pull/110731)).
- Fix selection of remote tree using the keyboard ([GH-110738](https://github.com/godotengine/godot/pull/110738)).
- FindInFiles: Show the number of matches for each file ([GH-110770](https://github.com/godotengine/godot/pull/110770)).
- Tweak macOS notarization export message in the editor ([GH-110793](https://github.com/godotengine/godot/pull/110793)).
- Ignore main scene UID error in editor ([GH-110810](https://github.com/godotengine/godot/pull/110810)).
- Cache editor setting queried in hot path in 2D editor ([GH-110814](https://github.com/godotengine/godot/pull/110814)).
- Fix regression with min size on nested inspectors ([GH-110827](https://github.com/godotengine/godot/pull/110827)).
- ProjectManager: Change favorite button tooltip to toggle ([GH-110855](https://github.com/godotengine/godot/pull/110855)).
- Fix "Region Editor" stuck in drag state when closing ([GH-110910](https://github.com/godotengine/godot/pull/110910)).
- Fix region folding not loading properly ([GH-110946](https://github.com/godotengine/godot/pull/110946)).
- GUI: Fix `nullptr` deref in TextServer ([GH-110970](https://github.com/godotengine/godot/pull/110970)).
- Fix editor log search ignoring BBCode formatting in messages ([GH-110972](https://github.com/godotengine/godot/pull/110972)).
- Move file filter when filesystem dock is in the bottom panel ([GH-111000](https://github.com/godotengine/godot/pull/111000)).
- Delete "Activate now?" button ([GH-111012](https://github.com/godotengine/godot/pull/111012)).
- Add splitter to "Create New Node" dialog ([GH-111017](https://github.com/godotengine/godot/pull/111017)).
- Fix Clear Inheritance issues ([GH-111025](https://github.com/godotengine/godot/pull/111025)).
- Fix incorrect usage of `Color::from_hsv()` exposed by newer compilers ([GH-111050](https://github.com/godotengine/godot/pull/111050)).
- Fix Quick Open history ([GH-111068](https://github.com/godotengine/godot/pull/111068)).
- Add a new editor theme ([GH-111118](https://github.com/godotengine/godot/pull/111118)).
- Fix enum strings losing space ([GH-111134](https://github.com/godotengine/godot/pull/111134)).
- Set correct saved history after clearing ([GH-111136](https://github.com/godotengine/godot/pull/111136)).
- Use Inter as the default editor font, features enabled ([GH-111140](https://github.com/godotengine/godot/pull/111140)).
- Fix switching back to local SceneTree ([GH-111150](https://github.com/godotengine/godot/pull/111150)).
- Remove side menu functionality in `EditorFileDialog` ([GH-111162](https://github.com/godotengine/godot/pull/111162)).
- Reset found version before checking again ([GH-111166](https://github.com/godotengine/godot/pull/111166)).
- Ensure correct metadata for enum items ([GH-111201](https://github.com/godotengine/godot/pull/111201)).
- Android Editor: Update suspend button icon in GameMenuBar ([GH-111204](https://github.com/godotengine/godot/pull/111204)).
- Project Manager: Prohibit duplicating a project into itself ([GH-111273](https://github.com/godotengine/godot/pull/111273)).
- Android Editor: Add game speed control options in game menu bar ([GH-111296](https://github.com/godotengine/godot/pull/111296)).
- Fix 'More Info…' link in Export/Encryption ([GH-111302](https://github.com/godotengine/godot/pull/111302)).
- Should expand root when `auto_expand` is on ([GH-111393](https://github.com/godotengine/godot/pull/111393)).
- Add source lines to file locations on POT generation ([GH-111419](https://github.com/godotengine/godot/pull/111419)).
- Use Title Case for shortcut names in SpriteFramesEditorPlugin ([GH-111448](https://github.com/godotengine/godot/pull/111448)).
- Enable maximize button for Editor/Project settings dialogs ([GH-111449](https://github.com/godotengine/godot/pull/111449)).
- Enable script templates by default ([GH-111454](https://github.com/godotengine/godot/pull/111454)).
- Fix some dragging operations in the editor breaking when tabbing out ([GH-111456](https://github.com/godotengine/godot/pull/111456)).
- Keep the bottom panel size separate ([GH-111499](https://github.com/godotengine/godot/pull/111499)).
- Fix editor inline color display of color from `Color.from_rgba8` ([GH-111527](https://github.com/godotengine/godot/pull/111527)).
- Allow keyboard echo for ScriptEditor tab manipulation events ([GH-111542](https://github.com/godotengine/godot/pull/111542)).
- Fix error when editing multifield values inside arrays and dictionaries ([GH-111606](https://github.com/godotengine/godot/pull/111606)).
- Don't show exported script variables twice in the remote inspector ([GH-111622](https://github.com/godotengine/godot/pull/111622)).
- Add "Show in File Manager" button to sidebar of Project Manager ([GH-111624](https://github.com/godotengine/godot/pull/111624)).
- Fix opening found lines in built-in scripts ([GH-111641](https://github.com/godotengine/godot/pull/111641)).
- Make remote debug elements ignore the canvas scaling ([GH-111700](https://github.com/godotengine/godot/pull/111700)).
- Enable Gradle builds on the Android editor via a dedicated build app ([GH-111732](https://github.com/godotengine/godot/pull/111732)).
- Add "with" stop word to the editor property name processor ([GH-111742](https://github.com/godotengine/godot/pull/111742)).
- Game View Plugin: Fix signal connected too early causing theme warning ([GH-111755](https://github.com/godotengine/godot/pull/111755)).
- Add OpenType feature settings to Main Font ([GH-111773](https://github.com/godotengine/godot/pull/111773)).
- Save editor settings when modified from code ([GH-111791](https://github.com/godotengine/godot/pull/111791)).
- Open source code errors in external editor ([GH-111805](https://github.com/godotengine/godot/pull/111805)).
- Fix switch to GameView when closing game window ([GH-111811](https://github.com/godotengine/godot/pull/111811)).
- Fix autoset of `text_editor/external/exec_flags` not working properly ([GH-111820](https://github.com/godotengine/godot/pull/111820)).
- Add Zed to External Editor exec flags autofill ([GH-111821](https://github.com/godotengine/godot/pull/111821)).
- Use ObjectID to store nodes in the editor selection ([GH-111837](https://github.com/godotengine/godot/pull/111837)).
- EditorRun: Load `override.cfg` to get window configuration for embedded mode ([GH-111847](https://github.com/godotengine/godot/pull/111847)).
- Change `Go to Line` default shortcut to `Ctrl+G` ([GH-111901](https://github.com/godotengine/godot/pull/111901)).
- Use `EditorSpinSlider` in the theme editor ([GH-111913](https://github.com/godotengine/godot/pull/111913)).
- Make editor remember the translation preview locale ([GH-111919](https://github.com/godotengine/godot/pull/111919)).
- Fix FindInFiles crash when changing language ([GH-111934](https://github.com/godotengine/godot/pull/111934)).
- Add donate button to project manager ([GH-111969](https://github.com/godotengine/godot/pull/111969)).
- Fix file duplication making random UID ([GH-112015](https://github.com/godotengine/godot/pull/112015)).
- Fix verbose running message ([GH-112016](https://github.com/godotengine/godot/pull/112016)).
- Fix FileSystem file list mode button visibility ([GH-112052](https://github.com/godotengine/godot/pull/112052)).
- Save project metadata less often ([GH-112064](https://github.com/godotengine/godot/pull/112064)).
- Improve error message when `_EDITOR_GET` fails ([GH-112069](https://github.com/godotengine/godot/pull/112069)).
- Fix missing setting error when starting the editor ([GH-112070](https://github.com/godotengine/godot/pull/112070)).
- Improve editing EditorDock node ([GH-112087](https://github.com/godotengine/godot/pull/112087)).
- Update documentation pages when switching themes ([GH-112141](https://github.com/godotengine/godot/pull/112141)).
- Allow reloading empty scenes ([GH-112156](https://github.com/godotengine/godot/pull/112156)).
- Fix layers property editor last bit value in tooltip ([GH-112173](https://github.com/godotengine/godot/pull/112173)).
- Allow drag setting flags in layers property editor ([GH-112174](https://github.com/godotengine/godot/pull/112174)).
- Stretch inline buttons & center text to full property header height ([GH-112176](https://github.com/godotengine/godot/pull/112176)).
- Allow fixing indirect missing dependencies manually ([GH-112187](https://github.com/godotengine/godot/pull/112187)).
- Fix error spam when dragging text in the script editor ([GH-112190](https://github.com/godotengine/godot/pull/112190)).
- Autoloads with UIDs ([GH-112193](https://github.com/godotengine/godot/pull/112193)).
- Fix FileSystem item color not updated after changing main scene ([GH-112201](https://github.com/godotengine/godot/pull/112201)).
- Fix hover state for game speed button in game window ([GH-112210](https://github.com/godotengine/godot/pull/112210)).
- Modern Style: Use a style box for Input Map actions ([GH-112233](https://github.com/godotengine/godot/pull/112233)).
- Modern style: switch to classic renderer name colors ([GH-112242](https://github.com/godotengine/godot/pull/112242)).
- Fix resource picker button style ([GH-112243](https://github.com/godotengine/godot/pull/112243)).
- Persist fullscreen setting on Android Editor ([GH-112246](https://github.com/godotengine/godot/pull/112246)).
- Fix canvas editor getting stuck on drag operations ([GH-112249](https://github.com/godotengine/godot/pull/112249)).
- Fix GraphEdit contrast in modern theme ([GH-112260](https://github.com/godotengine/godot/pull/112260)).
- Fix incorrect category size in `EditorInspector` on style switch ([GH-112264](https://github.com/godotengine/godot/pull/112264)).
- Fix contrast for light color presets in the classic theme ([GH-112268](https://github.com/godotengine/godot/pull/112268)).
- Fix warnings and error panel font not updating ([GH-112291](https://github.com/godotengine/godot/pull/112291)).
- Fix 2D viewport scrollbar contrast in modern theme ([GH-112296](https://github.com/godotengine/godot/pull/112296)).
- Fix EditorSpinSlider ignoring step ([GH-112298](https://github.com/godotengine/godot/pull/112298)).
- Make `EditorInspectorCategory`'s theme update happen via signal ([GH-112299](https://github.com/godotengine/godot/pull/112299)).
- Improve visibility of separators in modern theme ([GH-112313](https://github.com/godotengine/godot/pull/112313)).
- Add a style option button to quick settings ([GH-112316](https://github.com/godotengine/godot/pull/112316)).
- Fix transparent panel in Tilset polygon editor using Classic theme ([GH-112333](https://github.com/godotengine/godot/pull/112333)).
- Fix cannot edit property material for new Instance PackedScene ([GH-112334](https://github.com/godotengine/godot/pull/112334)).
- Fix crash for classes without an icon ([GH-112339](https://github.com/godotengine/godot/pull/112339)).
- Scene Dock: Simplify Filter Nodes related UI ([GH-112343](https://github.com/godotengine/godot/pull/112343)).
- Enhance contrast on Modern theme ([GH-112350](https://github.com/godotengine/godot/pull/112350)).
- Modern Style: Use a StyleBox in signals and groups ([GH-112360](https://github.com/godotengine/godot/pull/112360)).
- Allow previewing DPITexture in Inspector ([GH-112375](https://github.com/godotengine/godot/pull/112375)).
- Validate Resource type when pasting property ([GH-112386](https://github.com/godotengine/godot/pull/112386)).
- Fix crash on queue free scene node in editor ([GH-112401](https://github.com/godotengine/godot/pull/112401)).
- Add extra panels to some areas of the editor ([GH-112448](https://github.com/godotengine/godot/pull/112448)).
- Fix overbrightened GraphEdit overlays in light version of modern theme ([GH-112499](https://github.com/godotengine/godot/pull/112499)).
- Reduce outer inspector margins ([GH-112504](https://github.com/godotengine/godot/pull/112504)).
- Prevent emitting signals when previewing resource ([GH-112547](https://github.com/godotengine/godot/pull/112547)).
- Android editor: Fix editor crash on exit ([GH-112556](https://github.com/godotengine/godot/pull/112556)).
- Add error message to Quick Open dialog if callback is invalid ([GH-112559](https://github.com/godotengine/godot/pull/112559)).
- Fix crash during POT generation due to scene dependency issues ([GH-112587](https://github.com/godotengine/godot/pull/112587)).
- Correctly handle discarding of saved redo ([GH-112597](https://github.com/godotengine/godot/pull/112597)).
- FileSystem dock: Use plural prompt message when moving/copying files ([GH-112600](https://github.com/godotengine/godot/pull/112600)).
- Fix issues with property height in the inspector ([GH-112615](https://github.com/godotengine/godot/pull/112615)).
- Change prev/next button theme variation to FlatButton for FileSystem and Inspector dock ([GH-112621](https://github.com/godotengine/godot/pull/112621)).
- Fix incorrect bottom panel theming ([GH-112627](https://github.com/godotengine/godot/pull/112627)).
- Add missing warning about copying packed arrays to `EditorHelpBit` ([GH-112638](https://github.com/godotengine/godot/pull/112638)).
- Fix 2D ruler visibility in modern theme ([GH-112659](https://github.com/godotengine/godot/pull/112659)).
- `ScriptEditor::reload_scripts`: Only call deferred if not main thread ([GH-112663](https://github.com/godotengine/godot/pull/112663)).
- Remove padding columns from plugin settings ([GH-112691](https://github.com/godotengine/godot/pull/112691)).
- Remove unnecessary theme settings when constructing FindInFilesContainer ([GH-112704](https://github.com/godotengine/godot/pull/112704)).
- Fix `ProjectManager` UI going below window ([GH-112717](https://github.com/godotengine/godot/pull/112717)).
- Fix error when changing language in `FindInFilesPanel` ([GH-112719](https://github.com/godotengine/godot/pull/112719)).
- Fix find in files auto search when changing theme ([GH-112728](https://github.com/godotengine/godot/pull/112728)).
- Allow editing groups on multiple nodes ([GH-112729](https://github.com/godotengine/godot/pull/112729)).
- Add a right click menu to the project manager ([GH-112733](https://github.com/godotengine/godot/pull/112733)).
- Android Editor: Adjust script editor size for virtual keyboard ([GH-112766](https://github.com/godotengine/godot/pull/112766)).
- Don't expose underscored signals ([GH-112770](https://github.com/godotengine/godot/pull/112770)).
- Fix not being able to set project path ([GH-112824](https://github.com/godotengine/godot/pull/112824)).
- Don't save editor settings on startup ([GH-112825](https://github.com/godotengine/godot/pull/112825)).
- Fix modified editor shortcuts being erased ([GH-112831](https://github.com/godotengine/godot/pull/112831)).
- Fix modifying shortcuts in project manager causing crash ([GH-112857](https://github.com/godotengine/godot/pull/112857)).
- Fix crash in `EditorFileDialog` by checking for null pointer ([GH-112859](https://github.com/godotengine/godot/pull/112859)).
- Android Editor: Fix padding for display cutout in fullscreen mode ([GH-112881](https://github.com/godotengine/godot/pull/112881)).
- Hide mouse focus from project list ([GH-112895](https://github.com/godotengine/godot/pull/112895)).
- Fix input map editor (action map editor) items unable to be renamed ([GH-112903](https://github.com/godotengine/godot/pull/112903)).
- Fix `Scene > Export As...` being incorrectly disabled ([GH-112904](https://github.com/godotengine/godot/pull/112904)).
- Assign explicit ID to Export As menu ([GH-112912](https://github.com/godotengine/godot/pull/112912)).
- Fix compilation errors with `deprecated=no` ([GH-112953](https://github.com/godotengine/godot/pull/112953)).
- DAP: Enable showing errors to users ([GH-112972](https://github.com/godotengine/godot/pull/112972)).
- Move History dock to the bottom left by default ([GH-112996](https://github.com/godotengine/godot/pull/112996)).
- Fix visual glitch in the quick settings on the classic theme ([GH-112997](https://github.com/godotengine/godot/pull/112997)).
- Add dedicated icon for Quick Load ([GH-112999](https://github.com/godotengine/godot/pull/112999)).
- Add "Undo Close" & "Close All" options for `EditorSceneTabs` out-of-tabs context menu ([GH-113014](https://github.com/godotengine/godot/pull/113014)).
- Fully hide preset settings when no preset is found in the export dialog ([GH-113026](https://github.com/godotengine/godot/pull/113026)).
- Use new dock system for TileMap and TileSet ([GH-113034](https://github.com/godotengine/godot/pull/113034)).
- Add bottom dock tab style setting ([GH-113065](https://github.com/godotengine/godot/pull/113065)).
- Remove extra `NOTIFICATION_VISIBILITY_CHANGED` notifications in docks ([GH-113070](https://github.com/godotengine/godot/pull/113070)).
- Always enable Make Unique for previewed overrides ([GH-113075](https://github.com/godotengine/godot/pull/113075)).
- Fix the returned controls of `EditorHelpBitTooltip::show_tooltip()` were not freed in `ScriptTextEditor` ([GH-113080](https://github.com/godotengine/godot/pull/113080)).
- Change Theme to EditorDock and add `closable` property ([GH-113108](https://github.com/godotengine/godot/pull/113108)).
- Use new dock system for Debugger ([GH-113133](https://github.com/godotengine/godot/pull/113133)).
- Fix "ERROR: Cannot get class" on scripts without `class_name` ([GH-113160](https://github.com/godotengine/godot/pull/113160)).
- Update dock tabs on setting change ([GH-113167](https://github.com/godotengine/godot/pull/113167)).
- Fix error message when closing the project manager on Wayland ([GH-113193](https://github.com/godotengine/godot/pull/113193)).
- Resize right panel back to previous width ([GH-113221](https://github.com/godotengine/godot/pull/113221)).
- Fix initial dock tabs ([GH-113232](https://github.com/godotengine/godot/pull/113232)).
- PopupMenu: Fix redundant attempts to connect popup hidden signal on submenu ([GH-113237](https://github.com/godotengine/godot/pull/113237)).
- Fix bottom dock offsets and change Audio to EditorDock ([GH-113241](https://github.com/godotengine/godot/pull/113241)).
- Fix stale error highlighting when navigating script history ([GH-113246](https://github.com/godotengine/godot/pull/113246)).
- Use new dock system for Animation and AnimationTree dock ([GH-113255](https://github.com/godotengine/godot/pull/113255)).
- Improvements to ResourcePreloader editor ([GH-113257](https://github.com/godotengine/godot/pull/113257)).
- Fix Editor Docks not updating tab styles when loading layout ([GH-113262](https://github.com/godotengine/godot/pull/113262)).
- Disable embedded mode, if `--headless` is in the main instance argument list ([GH-113269](https://github.com/godotengine/godot/pull/113269)).
- Use new dock system for SpriteFrames Dock ([GH-113275](https://github.com/godotengine/godot/pull/113275)).
- Assign layout key to Debugger ([GH-113293](https://github.com/godotengine/godot/pull/113293)).
- Fix dock opening focus ([GH-113296](https://github.com/godotengine/godot/pull/113296)).
- Fix various problems with the credits roll ([GH-113298](https://github.com/godotengine/godot/pull/113298)).
- MacOS: Fix focus grab warning on macOS when running game in embedded mode ([GH-113300](https://github.com/godotengine/godot/pull/113300)).
- Fix infinite appending of docks without slots to config ([GH-113306](https://github.com/godotengine/godot/pull/113306)).
- Use EditorDock for Polygon2D editor ([GH-113338](https://github.com/godotengine/godot/pull/113338)).
- Fix bottom panel dock layout popup position ([GH-113339](https://github.com/godotengine/godot/pull/113339)).
- Add missing icons to QuickOpen context menu ([GH-113352](https://github.com/godotengine/godot/pull/113352)).
- Prevent double counting and cyclical error when gathering Resources ([GH-113353](https://github.com/godotengine/godot/pull/113353)).
- Fix missing trailing dots in script editor search menu ([GH-113365](https://github.com/godotengine/godot/pull/113365)).
- Fix `GameStateSnapshot`s not being freed ([GH-113366](https://github.com/godotengine/godot/pull/113366)).
- Improve accessibility in Create New Project dialog ([GH-113392](https://github.com/godotengine/godot/pull/113392)).
- Unassign scene root before freeing ([GH-113393](https://github.com/godotengine/godot/pull/113393)).
- Fix crash when capturing ObjectDB snapshot ([GH-113395](https://github.com/godotengine/godot/pull/113395)).
- Fix MovieWriter checking wrong directory for disk space ([GH-113398](https://github.com/godotengine/godot/pull/113398)).
- EmbeddedProcess: Fix invalid deferred call ([GH-113407](https://github.com/godotengine/godot/pull/113407)).
- Use Unicode arrow symbols throughout the editor ([GH-113420](https://github.com/godotengine/godot/pull/113420)).
- Expand Hide button in `EditorHelp` search ([GH-113430](https://github.com/godotengine/godot/pull/113430)).
- EditorHelp: Scroll to the only result found every time ([GH-113433](https://github.com/godotengine/godot/pull/113433)).
- Use EditorDock for Search Results ([GH-113450](https://github.com/godotengine/godot/pull/113450)).
- Make OpenXRActionMapEditor into EditorDock ([GH-113457](https://github.com/godotengine/godot/pull/113457)).
- Allow maximizing sprite related dialogs ([GH-113464](https://github.com/godotengine/godot/pull/113464)).
- Hide "Open documentation" context menu button in project manager ([GH-113477](https://github.com/godotengine/godot/pull/113477)).
- Disable "Override for Project" in project manager ([GH-113492](https://github.com/godotengine/godot/pull/113492)).
- Fix DistractionFreeMode and BottomPanel ([GH-113494](https://github.com/godotengine/godot/pull/113494)).
- Fix CreateDialog returning wrong type ([GH-113510](https://github.com/godotengine/godot/pull/113510)).
- Make dock tabs switch on button release ([GH-113521](https://github.com/godotengine/godot/pull/113521)).
- Remove "None" option in Version Control Editor ([GH-113522](https://github.com/godotengine/godot/pull/113522)).
- Fix unexpected name when favoriting nodes from keyword matches ([GH-113546](https://github.com/godotengine/godot/pull/113546)).
- VCS: Properly use IDs for OptionButton after #113522 ([GH-113554](https://github.com/godotengine/godot/pull/113554)).
- Fix signal order for directory selection in `file_dialog` ([GH-113564](https://github.com/godotengine/godot/pull/113564)).
- Increase PopupMenu vertical separation to improve touch usability ([GH-113587](https://github.com/godotengine/godot/pull/113587)).
- Fix built-in script live reloading ([GH-113598](https://github.com/godotengine/godot/pull/113598)).
- Fix property height in the inspector for control layout ([GH-113601](https://github.com/godotengine/godot/pull/113601)).
- Fix missing "+" in the bunch of tooltips ([GH-113611](https://github.com/godotengine/godot/pull/113611)).
- Fix center buttons offset ([GH-113612](https://github.com/godotengine/godot/pull/113612)).
- EditorHelpBit: Open online documentation if script editor is not available ([GH-113615](https://github.com/godotengine/godot/pull/113615)).
- Use new dock system for ShaderFile Dock ([GH-113616](https://github.com/godotengine/godot/pull/113616)).
- Ensure correct unlocking of script editor history ([GH-113619](https://github.com/godotengine/godot/pull/113619)).
- Fix enable/disable for Close Tabs Below in Script editor's File menu ([GH-113626](https://github.com/godotengine/godot/pull/113626)).
- Fix properties for container sizing not clipping in the inspector ([GH-113630](https://github.com/godotengine/godot/pull/113630)).
- Make movie mode button be dark when enabled on the modern theme ([GH-113633](https://github.com/godotengine/godot/pull/113633)).
- Prevent ObjectDB snapshots being overwritten ([GH-113637](https://github.com/godotengine/godot/pull/113637)).
- Use ObjectID in ProgressDialog Window list ([GH-113642](https://github.com/godotengine/godot/pull/113642)).
- Make Output dock global ([GH-113643](https://github.com/godotengine/godot/pull/113643)).
- Fix `EditorSpinSlider` overriding the custom minimum size ([GH-113649](https://github.com/godotengine/godot/pull/113649)).
- Increase Tree vertical separation to improve touch usability ([GH-113666](https://github.com/godotengine/godot/pull/113666)).
- Improve style changed signal in EditorDock ([GH-113690](https://github.com/godotengine/godot/pull/113690)).
- Defer updating dock tabs ([GH-113692](https://github.com/godotengine/godot/pull/113692)).
- Fix Debugger Dock not opening and unused BottomPanel code ([GH-113701](https://github.com/godotengine/godot/pull/113701)).
- Codestyle: Remove unused private variables in `godot/editor` ([GH-113706](https://github.com/godotengine/godot/pull/113706)).
- Fix project tags check for empty strings ([GH-113711](https://github.com/godotengine/godot/pull/113711)).
- Fix "Make Unique" button only working with left mouse click ([GH-113740](https://github.com/godotengine/godot/pull/113740)).
- Fix unique button for `EditorAudioStreamPicker` ([GH-113753](https://github.com/godotengine/godot/pull/113753)).
- Fix opening errors from built-in scripts ([GH-113773](https://github.com/godotengine/godot/pull/113773)).
- Make indirectly inherited `EditorScript`s appear in the command palette ([GH-113774](https://github.com/godotengine/godot/pull/113774)).
- Fix bottom panel pinning ([GH-113775](https://github.com/godotengine/godot/pull/113775)).
- Fix broken state of bottom panel on the right-to-left layout ([GH-113776](https://github.com/godotengine/godot/pull/113776)).
- Use `ObjectID` in `SceneTreeEditor` to compare the old and new scene roots ([GH-113789](https://github.com/godotengine/godot/pull/113789)).
- Propagate errors from `EditorFileSystem::_copy_file` through `EditorFileSystem::copy_file` ([GH-113790](https://github.com/godotengine/godot/pull/113790)).
- Fix broken VisualShader icons ([GH-113801](https://github.com/godotengine/godot/pull/113801)).
- Fix wrong size for "File" button in the shader editor ([GH-113804](https://github.com/godotengine/godot/pull/113804)).
- Clean up editor inspector plugins when closing Project Manager ([GH-113815](https://github.com/godotengine/godot/pull/113815)).
- Add leftover scroll hints, and panels for scrollables without hints ([GH-113816](https://github.com/godotengine/godot/pull/113816)).
- Add shortcuts to dock tooltips ([GH-113818](https://github.com/godotengine/godot/pull/113818)).
- Fix distraction-free mode changing split offsets ([GH-113822](https://github.com/godotengine/godot/pull/113822)).
- Show actual class name in resource picker tooltips ([GH-113828](https://github.com/godotengine/godot/pull/113828)).
- Fix crash on quit when `settings_changed` signal is emitted during exit ([GH-113830](https://github.com/godotengine/godot/pull/113830)).
- Add missing hover indication to movie maker button ([GH-113835](https://github.com/godotengine/godot/pull/113835)).
- Fix non-scene Resources "Save as" ([GH-113859](https://github.com/godotengine/godot/pull/113859)).
- Fix blurry icons in the editor inspector ([GH-113871](https://github.com/godotengine/godot/pull/113871)).
- Fix cutoff root creation buttons in new scenes ([GH-113890](https://github.com/godotengine/godot/pull/113890)).
- Improve EditorDock shortcut property ([GH-113896](https://github.com/godotengine/godot/pull/113896)).
- Half icon saturation when using the light color preset ([GH-113912](https://github.com/godotengine/godot/pull/113912)).
- Prevent locked and child nodes of selection groups from being selected in the Game view ([GH-113915](https://github.com/godotengine/godot/pull/113915)).
- Fix shader editor minimum size ([GH-113916](https://github.com/godotengine/godot/pull/113916)).
- Tweak Quick Settings dialog to ensure labels and dropdowns are aligned ([GH-113917](https://github.com/godotengine/godot/pull/113917)).
- Fix incorrect bottom panel theming ([GH-113922](https://github.com/godotengine/godot/pull/113922)).
- Add null verification to avoid background theme error in texture shader properties ([GH-113939](https://github.com/godotengine/godot/pull/113939)).
- Disable tool button for multiple nodes ([GH-113944](https://github.com/godotengine/godot/pull/113944)).
- Enable scroll hints and background panel in the AssetLib ([GH-113957](https://github.com/godotengine/godot/pull/113957)).
- Don't use selection list as reference ([GH-113986](https://github.com/godotengine/godot/pull/113986)).
- Fix editor settings parsing regression on Android ([GH-114032](https://github.com/godotengine/godot/pull/114032)).
- Add and adjust more scroll hints in the editor ([GH-114054](https://github.com/godotengine/godot/pull/114054)).
- Fix different separations across different code editors ([GH-114079](https://github.com/godotengine/godot/pull/114079)).
- Make `display_server` enums non-editable ([GH-114084](https://github.com/godotengine/godot/pull/114084)).
- Fix `null` value when picking the empty item on editable enums ([GH-114086](https://github.com/godotengine/godot/pull/114086)).
- Fix object icon in the resource picker not being visible when it should ([GH-114091](https://github.com/godotengine/godot/pull/114091)).
- Accessibility: Fix `LinkButton` name processing ([GH-114141](https://github.com/godotengine/godot/pull/114141)).
- Touch-up the Owners dialog ([GH-114159](https://github.com/godotengine/godot/pull/114159)).
- Finalize colors of modern theme ([GH-114162](https://github.com/godotengine/godot/pull/114162)).
- Fix incorrect corner radii in EditorHelpBitTitle in modern theme ([GH-114163](https://github.com/godotengine/godot/pull/114163)).
- macOS: Fix editor settings shortcut with global menu ([GH-114167](https://github.com/godotengine/godot/pull/114167)).
- Fix icon resizing for `NodePath` properties not working ([GH-114169](https://github.com/godotengine/godot/pull/114169)).
- Fix error when break scriptless scene ([GH-114190](https://github.com/godotengine/godot/pull/114190)).
- Fix export dialog icon for empty types ([GH-114202](https://github.com/godotengine/godot/pull/114202)).
- Fix tree line editor corners ([GH-114231](https://github.com/godotengine/godot/pull/114231)).
- Improve editor inspector main container spacing in modern theme ([GH-114234](https://github.com/godotengine/godot/pull/114234)).
- Disable native file dialog on Android Editor ([GH-114237](https://github.com/godotengine/godot/pull/114237)).
- Make focus visibility when renaming in the scene/file dock consistent ([GH-114249](https://github.com/godotengine/godot/pull/114249)).
- Fix docks grabbing too much focus ([GH-114252](https://github.com/godotengine/godot/pull/114252)).
- Prevent tooltips from showing in empty space of FileSystem Dock ([GH-114266](https://github.com/godotengine/godot/pull/114266)).
- Fix reopening rootless scenes ([GH-114315](https://github.com/godotengine/godot/pull/114315)).
- Ensure scene paths in autoload settings ([GH-114325](https://github.com/godotengine/godot/pull/114325)).
- `CONNECT_APPEND_SOURCE_OBJECT` on signal emission ([GH-114328](https://github.com/godotengine/godot/pull/114328)).
- ProjectDialog: Fix invalid button state when selecting renderer with invalid project path ([GH-114330](https://github.com/godotengine/godot/pull/114330)).
- Add background panels to the TileSet/Map editors ([GH-114348](https://github.com/godotengine/godot/pull/114348)).
- Fix `CreateDialog::get_selected_typed()` ignoring the custom types created from `EditorPlugin::add_custom_type()` ([GH-114364](https://github.com/godotengine/godot/pull/114364)).
- Add EditorDock's own DockSlot enum ([GH-114366](https://github.com/godotengine/godot/pull/114366)).
- Prevent crash when adding null Shortcut ([GH-114425](https://github.com/godotengine/godot/pull/114425)).
- Fix crash after calling `EditorUndoRedoManager.clear_history()` and then interacting with history dock entries ([GH-114439](https://github.com/godotengine/godot/pull/114439)).
- Improve visibility of toaster notifications ([GH-114497](https://github.com/godotengine/godot/pull/114497)).
- Fix the UID in the owner file changed when overwriting files in editor ([GH-114499](https://github.com/godotengine/godot/pull/114499)).
- Fix folder crash in Project Manager ([GH-114507](https://github.com/godotengine/godot/pull/114507)).
- Fix SplitContainer set desired size infinite loop ([GH-114541](https://github.com/godotengine/godot/pull/114541)).
- Preserve selections when filtering nodes in scene tree ([GH-114569](https://github.com/godotengine/godot/pull/114569)).
- Improve interaction feedback in modern theme ([GH-114571](https://github.com/godotengine/godot/pull/114571)).
- Fix switching visual shader type draws focus ([GH-114578](https://github.com/godotengine/godot/pull/114578)).
- Don't open new scene when double-clicking tabs ([GH-114579](https://github.com/godotengine/godot/pull/114579)).
- Fix crash when selecting "Unwrap UV2 for Lightmap/AO" after undo ([GH-114593](https://github.com/godotengine/godot/pull/114593)).
- Fix incorrectly disabled project import confirmation button ([GH-114621](https://github.com/godotengine/godot/pull/114621)).
- More scroll hint work around the editor ([GH-114634](https://github.com/godotengine/godot/pull/114634)).
- Fix inconsistent MenuButton styles ([GH-114635](https://github.com/godotengine/godot/pull/114635)).
- Fix crash when trying to open Favorites externally ([GH-114636](https://github.com/godotengine/godot/pull/114636)).
- Fix theming issues with the ObjectDB profiler ([GH-114665](https://github.com/godotengine/godot/pull/114665)).
- Prevent the dock from stealing focus when running the project ([GH-114680](https://github.com/godotengine/godot/pull/114680)).
- Fix editor toasters on the right-to-left layout ([GH-114682](https://github.com/godotengine/godot/pull/114682)).
- Adjust tree cells to account for new inner margins logic ([GH-114734](https://github.com/godotengine/godot/pull/114734)).
- Fix codeblocks inside docs not updating with theme changes ([GH-114740](https://github.com/godotengine/godot/pull/114740)).
- Reduce opacity of scroll hints in light theme ([GH-114753](https://github.com/godotengine/godot/pull/114753)).
- Fix animation track group hover color in modern theme ([GH-114759](https://github.com/godotengine/godot/pull/114759)).
- Improve animation player header spacing in modern theme ([GH-114770](https://github.com/godotengine/godot/pull/114770)).
- Add type variations for editor help in tooltips ([GH-114793](https://github.com/godotengine/godot/pull/114793)).
- Fix incorrect margin variations for group editors ([GH-114797](https://github.com/godotengine/godot/pull/114797)).
- Keep the node as an edited object when attaching and detaching scripts through the SceneTree ([GH-114802](https://github.com/godotengine/godot/pull/114802)).
- Fix and improve the theme editor ([GH-114807](https://github.com/godotengine/godot/pull/114807)).
- Use more specific check for dragging wait setting ([GH-114829](https://github.com/godotengine/godot/pull/114829)).
- Fix opening macOS folder in Terminal spawns new process ([GH-114838](https://github.com/godotengine/godot/pull/114838)).
- Fix gray bar of embed game window in Windows ([GH-114852](https://github.com/godotengine/godot/pull/114852)).
- Fix right clicking on a project draws focus outline ([GH-114855](https://github.com/godotengine/godot/pull/114855)).
- Improve spacing in trees showing table data in modern theme ([GH-114862](https://github.com/godotengine/godot/pull/114862)).
- Restore accent color text for main screen buttons in the modern theme ([GH-114866](https://github.com/godotengine/godot/pull/114866)).
- Fix inspector draws focus on click when editing EditorPropertyTextEnum ([GH-114879](https://github.com/godotengine/godot/pull/114879)).
- Fix quick open dialog recursive problem ([GH-114881](https://github.com/godotengine/godot/pull/114881)).
- Fix modified editor shortcuts being erased on MacOS ([GH-114885](https://github.com/godotengine/godot/pull/114885)).
- Fix sizing problems with `EditorSpinSlider` ([GH-114886](https://github.com/godotengine/godot/pull/114886)).
- Fix Make Unique for external sub-resources ([GH-114901](https://github.com/godotengine/godot/pull/114901)).
- Fix Make Unique for built-in scripts ([GH-114902](https://github.com/godotengine/godot/pull/114902)).
- Tweak quick open recursion error ([GH-114916](https://github.com/godotengine/godot/pull/114916)).
- Minor fixes for the project list item UI ([GH-114927](https://github.com/godotengine/godot/pull/114927)).
- Fix speed being reset when it shouldn't in the game editor ([GH-114928](https://github.com/godotengine/godot/pull/114928)).
- Fix inner tabs outer panel corners at zero radius ([GH-114929](https://github.com/godotengine/godot/pull/114929)).
- Fix dock tab styles not updating when changed in Editor Settings ([GH-114932](https://github.com/godotengine/godot/pull/114932)).
- Fix descriptions of custom types in CreateDialog ([GH-114934](https://github.com/godotengine/godot/pull/114934)).
- Limit maximum luminance for elevated surfaces in modern theme ([GH-114950](https://github.com/godotengine/godot/pull/114950)).
- Remove checkbox icon tint in Create Scene popup ([GH-114956](https://github.com/godotengine/godot/pull/114956)).
- Split `EmbeddedProcess::reset` to allow stopping timers without full reset ([GH-114978](https://github.com/godotengine/godot/pull/114978)).
- Fix TileSet dock becoming focused when switching TileMapLayers ([GH-114994](https://github.com/godotengine/godot/pull/114994)).
- Fix quick open history not always recorded ([GH-115029](https://github.com/godotengine/godot/pull/115029)).
- Fix size issues with inspector editors ([GH-115041](https://github.com/godotengine/godot/pull/115041)).
- Add inner tab styling to Manage Theme Items dialog ([GH-115067](https://github.com/godotengine/godot/pull/115067)).
- Combine dock focus methods to prevent inconsistencies ([GH-115084](https://github.com/godotengine/godot/pull/115084)).
- Fix favorite files handling ([GH-115128](https://github.com/godotengine/godot/pull/115128)).
- Fix EditorFileDialog icon scale in list mode ([GH-115145](https://github.com/godotengine/godot/pull/115145)).
- Do not update script editor before scene root init ([GH-115161](https://github.com/godotengine/godot/pull/115161)).
- Fix colors of code editor in modern theme ([GH-115316](https://github.com/godotengine/godot/pull/115316)).
- Fix not being able to remove empty theme overrides in the editor ([GH-115348](https://github.com/godotengine/godot/pull/115348)).

#### Export

- Add a property range hint to `bake_fps` in the scene glTF export dialog ([GH-98268](https://github.com/godotengine/godot/pull/98268)).
- Fix typo in MacOS and iOS export settings ([GH-103953](https://github.com/godotengine/godot/pull/103953)).
- Add "Show Encryption Key" toggle ([GH-106146](https://github.com/godotengine/godot/pull/106146)).
- Use ScriptExportMode enum in EditorExportPreset ([GH-107167](https://github.com/godotengine/godot/pull/107167)).
- linux/bsd/mac: Use pkill to stop remote instance over SSH ([GH-108412](https://github.com/godotengine/godot/pull/108412)).
- EditorExportPlatform: Move initialization to a dedicated method ([GH-108658](https://github.com/godotengine/godot/pull/108658)).
- Android: Add export option to use "scrcpy" to run project from editor ([GH-108737](https://github.com/godotengine/godot/pull/108737)).
- macOS: Add support for exporting macOS 26 Liquid Glass icons ([GH-108794](https://github.com/godotengine/godot/pull/108794)).
- Move advanced toggle state out of export presets ([GH-109356](https://github.com/godotengine/godot/pull/109356)).
- Android: Only validate keystore relevant to current export mode ([GH-109568](https://github.com/godotengine/godot/pull/109568)).
- Android: Ensure proper cleanup of the fragment ([GH-109764](https://github.com/godotengine/godot/pull/109764)).
- Fix iOS/visionOS export plugin crash on exit ([GH-110485](https://github.com/godotengine/godot/pull/110485)).
- Metal: Fix Metal compiler version inspection ([GH-110873](https://github.com/godotengine/godot/pull/110873)).
- Scons option to enable CVTT and Betsy compression in export templates ([GH-111015](https://github.com/godotengine/godot/pull/111015)).
- Automatically include text server data if project includes translations requiring it ([GH-111062](https://github.com/godotengine/godot/pull/111062)).
- Renderer: Fix missing `shader_name`; use forward declarations ([GH-111141](https://github.com/godotengine/godot/pull/111141)).
- Windows: Fix application manifest in exported projects with modified resources ([GH-111316](https://github.com/godotengine/godot/pull/111316)).
- Update embedded PCK virtual address ([GH-111674](https://github.com/godotengine/godot/pull/111674)).
- Fix custom icon in Android export ([GH-111688](https://github.com/godotengine/godot/pull/111688)).
- macOS: Prevent error spam when iOS device is paired but sleeping ([GH-111758](https://github.com/godotengine/godot/pull/111758)).
- Metal: Stable argument buffers; GPU rendering crashes; visionOS exports ([GH-111976](https://github.com/godotengine/godot/pull/111976)).
- Add support for delta encoding to patch PCKs ([GH-112011](https://github.com/godotengine/godot/pull/112011)).
- Change API 21 references to API 24 ([GH-112036](https://github.com/godotengine/godot/pull/112036)).
- Disable shader baker when exporting as dedicated server ([GH-112361](https://github.com/godotengine/godot/pull/112361)).
- Shader Baker: Fix Linux export warning ([GH-112465](https://github.com/godotengine/godot/pull/112465)).
- Fix editor preset names not being validated ([GH-112698](https://github.com/godotengine/godot/pull/112698)).
- Fix shader baker freezing if there are errors in the shader compilation process ([GH-112803](https://github.com/godotengine/godot/pull/112803)).
- Disable Android devices mirroring for the Android editor ([GH-113383](https://github.com/godotengine/godot/pull/113383)).
- Android editor: Fix apk install after gradle build ([GH-113389](https://github.com/godotengine/godot/pull/113389)).
- Reduce export dialog minimum size ([GH-113578](https://github.com/godotengine/godot/pull/113578)).
- macOS/iOS: Escape .plist strings on export ([GH-113645](https://github.com/godotengine/godot/pull/113645)).
- iOS: Automatically enable `iphone-ipad-minimum-performance-a12` if project is using Forward+/Mobile renderer ([GH-114098](https://github.com/godotengine/godot/pull/114098)).
- Fix export preset not duplicating selected files ([GH-114164](https://github.com/godotengine/godot/pull/114164)).
- Android editor: Fix AAB file not copied to export path ([GH-114382](https://github.com/godotengine/godot/pull/114382)).
- Misc Android export fixes ([GH-114384](https://github.com/godotengine/godot/pull/114384)).
- Fix Android export with multiple architectures failing when GDExtension includes native dependencies ([GH-114483](https://github.com/godotengine/godot/pull/114483)).
- Android/Gradle: Do not ignore asset folders starting with `_` ([GH-114537](https://github.com/godotengine/godot/pull/114537)).

#### GDExtension

- Add `RequiredParam<T>` and `RequiredResult<T>` to mark `Object *` arguments and return values as required ([GH-86079](https://github.com/godotengine/godot/pull/86079)).
- Improve `to_string()` and add it to Resource ([GH-94047](https://github.com/godotengine/godot/pull/94047)).
- Expand `GDType` to cover GDExtension types as well ([GH-106016](https://github.com/godotengine/godot/pull/106016)).
- Allow editor plugins to modify run arguments ([GH-107671](https://github.com/godotengine/godot/pull/107671)).
- Store source of `gdextension_interface.h` in JSON ([GH-107845](https://github.com/godotengine/godot/pull/107845)).
- Fall back to parent class icon by default for GDExtension ([GH-108607](https://github.com/godotengine/godot/pull/108607)).
- Add `mem_alloc2` (and friends) so padding can be requested ([GH-108725](https://github.com/godotengine/godot/pull/108725)).
- Expose `Thread::is_main_thread()` ([GH-109779](https://github.com/godotengine/godot/pull/109779)).
- Update warning about `gdextension_special_compat_hashes.cpp` to prevent confusion ([GH-110537](https://github.com/godotengine/godot/pull/110537)).
- Update `GODOT_CPP_BRANCH` after Godot v4.5-stable release ([GH-110539](https://github.com/godotengine/godot/pull/110539)).
- Fix `--dump-extension-api-with-docs` indentation ([GH-110557](https://github.com/godotengine/godot/pull/110557)).
- LibGodot: Core - Build Godot Engine as a Library ([GH-110863](https://github.com/godotengine/godot/pull/110863)).
- Free script and extension instance before object deconstructing ([GH-110907](https://github.com/godotengine/godot/pull/110907)).
- Prevent breaking compatibility for unexposed classes that can only be created once ([GH-111090](https://github.com/godotengine/godot/pull/111090)).
- Move deprecated `has_named_classes` from `ScriptLanguage` to `ScriptLanguageExtension` ([GH-111289](https://github.com/godotengine/godot/pull/111289)).
- Fix LibGodot build errors on Linux ([GH-111432](https://github.com/godotengine/godot/pull/111432)).
- Add system for builtin method compatibility ([GH-112290](https://github.com/godotengine/godot/pull/112290)).
- Add missing method flag ([GH-112351](https://github.com/godotengine/godot/pull/112351)).
- Make `Vector` `bsearch` method const ([GH-112539](https://github.com/godotengine/godot/pull/112539)).
- iOS: Fix loading of xcframework dynamic libraries ([GH-112784](https://github.com/godotengine/godot/pull/112784)).
- Support extension icons in Script Editor ([GH-112925](https://github.com/godotengine/godot/pull/112925)).
- Update `libgodot.h` to use `gdextension_interface.gen.h` ([GH-113126](https://github.com/godotengine/godot/pull/113126)).
- Use `RequiredParam`/`RequiredResult` in some high value places ([GH-113282](https://github.com/godotengine/godot/pull/113282)).
- Split GDExtension validations files to avoid constant git conflicts ([GH-113489](https://github.com/godotengine/godot/pull/113489)).
- Synchronize the names for `RequiredParam<T>` arguments in header files ([GH-113493](https://github.com/godotengine/godot/pull/113493)).
- Unmark `Node::is_editable_instance()` parameter as required ([GH-113511](https://github.com/godotengine/godot/pull/113511)).
- Optimize `RequiredParam` to not increase and decrease refcounts on call ([GH-113514](https://github.com/godotengine/godot/pull/113514)).
- Add special compat methods for EditorFileDialog enum functions ([GH-113524](https://github.com/godotengine/godot/pull/113524)).
- Use structured data for "deprecated" in `gdextension_interface.json` ([GH-113697](https://github.com/godotengine/godot/pull/113697)).
- Tweaks to `gdextension_interface.json` format ([GH-113754](https://github.com/godotengine/godot/pull/113754)).
- CI: Ignore `gdextension_interface.json` ([GH-113851](https://github.com/godotengine/godot/pull/113851)).
- Ensure `LIBGODOT_API` is always defined ([GH-114626](https://github.com/godotengine/godot/pull/114626)).
- Omit `return_value` in `gdextension_interface.json` for `void` functions ([GH-114684](https://github.com/godotengine/godot/pull/114684)).
- Core: Don't strip data in `ClassDB::class_get_method_list` ([GH-114893](https://github.com/godotengine/godot/pull/114893)).
- Fix crash when converting `Variant` to incompatible `RequiredPtr<T>` ([GH-115198](https://github.com/godotengine/godot/pull/115198)).

#### GDScript

- Make check for exposed classes more consistent ([GH-91617](https://github.com/godotengine/godot/pull/91617)).
- Add `debug/gdscript/warnings/directory_rules` project setting ([GH-93889](https://github.com/godotengine/godot/pull/93889)).
- Optimize `GDScriptInstance::notification` for better performance ([GH-94118](https://github.com/godotengine/godot/pull/94118)).
- Add step out to script debugger ([GH-97758](https://github.com/godotengine/godot/pull/97758)).
- Remove some unnecessary booleans ([GH-98061](https://github.com/godotengine/godot/pull/98061)).
- Autocompletion: Use correct completion type for argument options ([GH-101092](https://github.com/godotengine/godot/pull/101092)).
- LSP: Rework management of client owned files ([GH-105236](https://github.com/godotengine/godot/pull/105236)).
- Add opt-in GDScript warning for when calling coroutine without `await` ([GH-107936](https://github.com/godotengine/godot/pull/107936)).
- Autocompletion: Remove duplicate code ([GH-109298](https://github.com/godotengine/godot/pull/109298)).
- Prevent shallow scripts from leaking into the `ResourceCache` ([GH-109345](https://github.com/godotengine/godot/pull/109345)).
- Add checks for integer vectors for integer division warning ([GH-110240](https://github.com/godotengine/godot/pull/110240)).
- Don't reset color if the previous token is a number ending with a dot ([GH-110397](https://github.com/godotengine/godot/pull/110397)).
- Add `reserve()` to `Dictionary`, apply to constructors on GDScript VM ([GH-110709](https://github.com/godotengine/godot/pull/110709)).
- Elide unnecessary copies in `CONSTRUCT_TYPED_*` opcodes ([GH-110717](https://github.com/godotengine/godot/pull/110717)).
- Fix drag and drop `@export` variable assignment when script has errors ([GH-110761](https://github.com/godotengine/godot/pull/110761)).
- Allow trailing comma in `preload` ([GH-110775](https://github.com/godotengine/godot/pull/110775)).
- Remove unused `GDScript::subclass_count` ([GH-111172](https://github.com/godotengine/godot/pull/111172)).
- Autocompletion: Filter ClassDB argument options ([GH-111266](https://github.com/godotengine/godot/pull/111266)).
- LSP: Fix repeated restart attempts ([GH-111290](https://github.com/godotengine/godot/pull/111290)).
- Fix GDScript translation parser for `FileDialog.add_filter()` two-parameter format ([GH-111298](https://github.com/godotengine/godot/pull/111298)).
- LSP: Fix goto native declaration ([GH-111478](https://github.com/godotengine/godot/pull/111478)).
- Remove raw base pointer from `GDScript` ([GH-111490](https://github.com/godotengine/godot/pull/111490)).
- LSP: Use safe methods to get data from dictionaries ([GH-111684](https://github.com/godotengine/godot/pull/111684)).
- Add Variant to type autocompletion ([GH-111878](https://github.com/godotengine/godot/pull/111878)).
- LSP: Fix remaining unsafe dict access ([GH-112128](https://github.com/godotengine/godot/pull/112128)).
- Add string placeholder syntax highlighting ([GH-112575](https://github.com/godotengine/godot/pull/112575)).
- Fix GDScript extends path recursion to itself ([GH-112923](https://github.com/godotengine/godot/pull/112923)).
- LSP: Improve insertion algorithm for resolving completion options ([GH-113031](https://github.com/godotengine/godot/pull/113031)).
- GDScript LSP: Rework and extend BBCode to markdown docstring conversion ([GH-113099](https://github.com/godotengine/godot/pull/113099)).
- Add support for profiling GDScript with tracy ([GH-113279](https://github.com/godotengine/godot/pull/113279)).
- Correctly set GDScript internal path for shallow scripts ([GH-113580](https://github.com/godotengine/godot/pull/113580)).
- Ensure correct caching of cyclic references ([GH-113600](https://github.com/godotengine/godot/pull/113600)).
- Fix incorrect default `transfer_mode` in `@rpc` documentation ([GH-114269](https://github.com/godotengine/godot/pull/114269)).
- LSP: Fix infinite recursion in symbol calculation ([GH-114401](https://github.com/godotengine/godot/pull/114401)).
- Cache invalid scripts ([GH-114695](https://github.com/godotengine/godot/pull/114695)).
- LSP: Reuse stale parsers in request ([GH-114791](https://github.com/godotengine/godot/pull/114791)).
- Don't clean up other scripts ([GH-114801](https://github.com/godotengine/godot/pull/114801)).
- Core: Fix implicit conversions in `ContainerTypeValidate` ([GH-114808](https://github.com/godotengine/godot/pull/114808)).

#### GUI

- Allow customization of TabContainer tabs in editor ([GH-58749](https://github.com/godotengine/godot/pull/58749)).
- Add `pivot_offset_ratio` property to Control ([GH-70646](https://github.com/godotengine/godot/pull/70646)).
- Allow SplitContainer to have more than two children ([GH-90411](https://github.com/godotengine/godot/pull/90411)).
- Use multiple children in dock SplitContainers to make resizing consistent ([GH-90439](https://github.com/godotengine/godot/pull/90439)).
- Remove code duplication in Button ([GH-93389](https://github.com/godotengine/godot/pull/93389)).
- Fix update order for `exclusive` child window ([GH-94488](https://github.com/godotengine/godot/pull/94488)).
- Implement dynamic scaling of the LineEdit right icon based on control size and scale factor ([GH-95817](https://github.com/godotengine/godot/pull/95817)).
- Fix `ColorPickerButton` close popup on mouse click ([GH-98428](https://github.com/godotengine/godot/pull/98428)).
- Improve Project Manager UI navigation ([GH-101129](https://github.com/godotengine/godot/pull/101129)).
- Separate Node editor dock ([GH-101787](https://github.com/godotengine/godot/pull/101787)).
- Fix preset cache usage in ColorPicker ([GH-104496](https://github.com/godotengine/godot/pull/104496)).
- Add auto-scroll behavior when selecting text outside the visible area in RichTextLabel ([GH-104715](https://github.com/godotengine/godot/pull/104715)).
- Add support for custom font colors in the TabBar ([GH-106263](https://github.com/godotengine/godot/pull/106263)).
- Add support for closing dialog windows with Cmd+W on macOS ([GH-107303](https://github.com/godotengine/godot/pull/107303)).
- Allow `tab_rmb_clicked` to always work ([GH-107440](https://github.com/godotengine/godot/pull/107440)).
- Fix `mouse_entered` and `mouse_exited` Signals being emitted too early ([GH-107955](https://github.com/godotengine/godot/pull/107955)).
- Expose methods to access FileDialog's favorite/recent lists ([GH-108146](https://github.com/godotengine/godot/pull/108146)).
- Expose FileDialog callbacks for getting custom icons ([GH-108147](https://github.com/godotengine/godot/pull/108147)).
- SpinBox: Add a property to set whether `custom_arrow_step` rounds value ([GH-108335](https://github.com/godotengine/godot/pull/108335)).
- macOS: Use "file" icon for bundles in the file dialogs ([GH-108804](https://github.com/godotengine/godot/pull/108804)).
- Include `SPACING_SPACE` in tab stops calculation ([GH-109031](https://github.com/godotengine/godot/pull/109031)).
- Fix TextEdit clips children and focus style ([GH-109078](https://github.com/godotengine/godot/pull/109078)).
- Add metadata for slots in `GraphNode` ([GH-109322](https://github.com/godotengine/godot/pull/109322)).
- Adjust StyleBoxFlat antialiasing to account for Viewport oversampling ([GH-109358](https://github.com/godotengine/godot/pull/109358)).
- Fix LineEdit icon position in right-to-left layout ([GH-109363](https://github.com/godotengine/godot/pull/109363)).
- Android: Add method to set root window color at runtime ([GH-109491](https://github.com/godotengine/godot/pull/109491)).
- Speed up very large `Trees` ([GH-109512](https://github.com/godotengine/godot/pull/109512)).
- Optimize CPU text shaping ([GH-109516](https://github.com/godotengine/godot/pull/109516)).
- `find_*_valid_focus`: Check all tested neighbors to prevent loops ([GH-109590](https://github.com/godotengine/godot/pull/109590)).
- Remove meta usage in Tree ([GH-109938](https://github.com/godotengine/godot/pull/109938)).
- Fix tree to update size with scrollbars disabled ([GH-109943](https://github.com/godotengine/godot/pull/109943)).
- Make POT generation use `tooltip_auto_translate_mode` ([GH-109977](https://github.com/godotengine/godot/pull/109977)).
- Clamp menus at the bottom of the screen ([GH-109981](https://github.com/godotengine/godot/pull/109981)).
- Reinstate `const` parameter in `Tree`'s `draw_item_rect` ([GH-110012](https://github.com/godotengine/godot/pull/110012)).
- Fix child relationship lines not being drawn when selecting cells other than first ([GH-110024](https://github.com/godotengine/godot/pull/110024)).
- Add helper methods to convert right-to-left `Rect2i` and `Point2i` in `Tree`'s `draw_item` ([GH-110055](https://github.com/godotengine/godot/pull/110055)).
- GraphEdit: Do not scale popup menus in the graph elements when zoomed ([GH-110080](https://github.com/godotengine/godot/pull/110080)).
- Fix `Tree` relationship lines do not apply `h_separation` and `item_margin` correctly ([GH-110089](https://github.com/godotengine/godot/pull/110089)).
- Add horizontal scrolling to `TabBar` ([GH-110151](https://github.com/godotengine/godot/pull/110151)).
- Use placeholder instead of value for tooltips of `PROPERTY_HINT_PASSWORD` properties ([GH-110164](https://github.com/godotengine/godot/pull/110164)).
- TextServer: Shape emojis as separate runs ([GH-110194](https://github.com/godotengine/godot/pull/110194)).
- Fix SpinBox value change when held down on separation between buttons ([GH-110212](https://github.com/godotengine/godot/pull/110212)).
- Allow all ColorPicker Shapes to expand horizontally ([GH-110218](https://github.com/godotengine/godot/pull/110218)).
- Make minimum drag distance configurable for gui elements ([GH-110245](https://github.com/godotengine/godot/pull/110245)).
- Hide `Control` focus when given via mouse input ([GH-110250](https://github.com/godotengine/godot/pull/110250)).
- PopupMenu: Fix submenu item not popping on mouse enter ([GH-110256](https://github.com/godotengine/godot/pull/110256)).
- Redraw shape controls when ColorPicker theme changes ([GH-110278](https://github.com/godotengine/godot/pull/110278)).
- TextServer: Check if texture cache is valid when loading glyph ([GH-110310](https://github.com/godotengine/godot/pull/110310)).
- TextServer: Do not add extra spacing to zero-width glyphs ([GH-110317](https://github.com/godotengine/godot/pull/110317)).
- RTL: Use separate paragraph copy for the partially visible paragraphs ([GH-110340](https://github.com/godotengine/godot/pull/110340)).
- Make text-related nodes translation domain aware ([GH-110378](https://github.com/godotengine/godot/pull/110378)).
- Move ColorPicker shaders to ColorPickerShape class ([GH-110385](https://github.com/godotengine/godot/pull/110385)).
- Shader Editor: Show "File" menu when no shaders are opened ([GH-110404](https://github.com/godotengine/godot/pull/110404)).
- TextServer: Use a separate flag to disable min. string length for adding ellipsis ([GH-110408](https://github.com/godotengine/godot/pull/110408)).
- RTL: Fix `outline_size=0` and `font`/`otf` tags with invalid arguments breaking tag stack and spamming errors ([GH-110444](https://github.com/godotengine/godot/pull/110444)).
- Fix FileDialog's `root_subfolder` on Windows ([GH-110524](https://github.com/godotengine/godot/pull/110524)).
- Fix TextEdit `read_only` drawing ([GH-110527](https://github.com/godotengine/godot/pull/110527)).
- Add ThemeCache to EditorProperty ([GH-110542](https://github.com/godotengine/godot/pull/110542)).
- Deprecate TextEdit `background_color` ([GH-110543](https://github.com/godotengine/godot/pull/110543)).
- Fix color picker shape minimum size ([GH-110581](https://github.com/godotengine/godot/pull/110581)).
- Editor: Do not embolden the Main Font if it's variable ([GH-110737](https://github.com/godotengine/godot/pull/110737)).
- ColorPicker: Fix preset button order after calling `add_preset()` ([GH-110750](https://github.com/godotengine/godot/pull/110750)).
- Update SpinBox arrows on constrain change ([GH-110817](https://github.com/godotengine/godot/pull/110817)).
- FoldableContainer: Override `has_point` to use title rect when folded ([GH-110847](https://github.com/godotengine/godot/pull/110847)).
- Reduce repetitive code in FoldableContainer ([GH-110871](https://github.com/godotengine/godot/pull/110871)).
- Fix LineEdit's placeholder text being selected when double clicking ([GH-110886](https://github.com/godotengine/godot/pull/110886)).
- Fix SpinBox stepper grabbing focus state on mouse input ([GH-110894](https://github.com/godotengine/godot/pull/110894)).
- Add setting for when to show the focus state for mouse input ([GH-110895](https://github.com/godotengine/godot/pull/110895)).
- Unfold tree items on hover while drag-n-dropping ([GH-110904](https://github.com/godotengine/godot/pull/110904)).
- Fix Script editor state types ([GH-110942](https://github.com/godotengine/godot/pull/110942)).
- Use const Array ref in `set_structured_text_bidi_override_options` ([GH-110951](https://github.com/godotengine/godot/pull/110951)).
- X11: Fix minimization of maximized windows ([GH-110990](https://github.com/godotengine/godot/pull/110990)).
- Fix text servers build with disabled FreeType ([GH-111001](https://github.com/godotengine/godot/pull/111001)).
- TextServer: Enforce zero width spaces and joiners to actually be zero width and not fallback to regular space ([GH-111014](https://github.com/godotengine/godot/pull/111014)).
- Fix tag name focus ([GH-111085](https://github.com/godotengine/godot/pull/111085)).
- Visualize MarginContainer margins when selected ([GH-111095](https://github.com/godotengine/godot/pull/111095)).
- Label: Add MSDF pixel range/outline configuration warning ([GH-111111](https://github.com/godotengine/godot/pull/111111)).
- Unify FileDialog context menus ([GH-111116](https://github.com/godotengine/godot/pull/111116)).
- Fix cases where `LineEdit` can still show focus with mouse events ([GH-111117](https://github.com/godotengine/godot/pull/111117)).
- Fix bottom panel being unintentionally draggable ([GH-111121](https://github.com/godotengine/godot/pull/111121)).
- Group `virtual keyboard` and `word separators` properties in the inspector ([GH-111156](https://github.com/godotengine/godot/pull/111156)).
- Remaining FileDialog changes before unification ([GH-111159](https://github.com/godotengine/godot/pull/111159)).
- Add icon color theme items for `TabBar` and `TabContainer` ([GH-111169](https://github.com/godotengine/godot/pull/111169)).
- Fix LineEdit Unicode code-point/control character insertion failing to emit `text_changed` ([GH-111190](https://github.com/godotengine/godot/pull/111190)).
- Add missing ItemListSecondary and TreeSecondary theme type variations ([GH-111194](https://github.com/godotengine/godot/pull/111194)).
- Make EditorFileDialog inherit FileDialog ([GH-111212](https://github.com/godotengine/godot/pull/111212)).
- Fix color text's tooltip not being updated when the intensity is more than 0 ([GH-111230](https://github.com/godotengine/godot/pull/111230)).
- Check that ColorPickerButton popup is currently open in `_modal_closed()` ([GH-111248](https://github.com/godotengine/godot/pull/111248)).
- Fix RichTextLabel Focus Box ([GH-111250](https://github.com/godotengine/godot/pull/111250)).
- RichTextLabel: Fix bullet list font color and formatting issues ([GH-111258](https://github.com/godotengine/godot/pull/111258)).
- Fix Tree column title tooltip crash ([GH-111292](https://github.com/godotengine/godot/pull/111292)).
- Enforce zero width spaces and joiners with missing font. Do not warn about missing non-visual characters ([GH-111355](https://github.com/godotengine/godot/pull/111355)).
- Fix UI focus being shown when it shouldn't ([GH-111369](https://github.com/godotengine/godot/pull/111369)).
- Fix incorrect margins in `ScrollContainer` with focus border enabled ([GH-111386](https://github.com/godotengine/godot/pull/111386)).
- Add MIME argument to the `FileDialog.add_filter` ([GH-111439](https://github.com/godotengine/godot/pull/111439)).
- Rework FileDialog shortcuts ([GH-111460](https://github.com/godotengine/godot/pull/111460)).
- Use HarfBuzz to fix variant hinting in `TextServerAdvanced` ([GH-111461](https://github.com/godotengine/godot/pull/111461)).
- Remove unused `Window::debugger_stop_shortcut` ([GH-111484](https://github.com/godotengine/godot/pull/111484)).
- Update OpenSans SemiBold ([GH-111516](https://github.com/godotengine/godot/pull/111516)).
- Fix Windows native FileDialog filters not showing descriptions ([GH-111529](https://github.com/godotengine/godot/pull/111529)).
- Fix TextEdit selecting when closing popup ([GH-111535](https://github.com/godotengine/godot/pull/111535)).
- Fix scrollbar render with RTL scroll following visible enabled ([GH-111552](https://github.com/godotengine/godot/pull/111552)).
- Fix favorites icon size in FileSystem dock ([GH-111586](https://github.com/godotengine/godot/pull/111586)).
- CodeEdit: Use flag to recalculate characteristics ([GH-111597](https://github.com/godotengine/godot/pull/111597)).
- Fix indented line wrap with no spaces ([GH-111648](https://github.com/godotengine/godot/pull/111648)).
- PopupMenu: Update global menu shortcuts when shortcut is externally changed ([GH-111711](https://github.com/godotengine/godot/pull/111711)).
- TextEdit: Make `wrap_right_offset` adjustable theme constant ([GH-111744](https://github.com/godotengine/godot/pull/111744)).
- Improve performance of SpinBox creation ([GH-111766](https://github.com/godotengine/godot/pull/111766)).
- Allow double-clicking icons of non-editable Tree items ([GH-111780](https://github.com/godotengine/godot/pull/111780)).
- Fix scale factor applied twice ([GH-111797](https://github.com/godotengine/godot/pull/111797)).
- Make `PopupMenu` respect `max_size` ([GH-111801](https://github.com/godotengine/godot/pull/111801)).
- Fix crash when operating on newly created font RIDs ([GH-111810](https://github.com/godotengine/godot/pull/111810)).
- TextServer: Do not add empty lines if space trimming flag is set ([GH-111839](https://github.com/godotengine/godot/pull/111839)).
- Fix IME input in multiple windows at once ([GH-111865](https://github.com/godotengine/godot/pull/111865)).
- Fix `Control.pivot_offset` missing `PROPERTY_USAGE_STORAGE` flag ([GH-111921](https://github.com/godotengine/godot/pull/111921)).
- Show the arrow cursor on disabled `LinkButton`s ([GH-111926](https://github.com/godotengine/godot/pull/111926)).
- TextServer: Fix range for zero-width glyphs extra spacing ([GH-111964](https://github.com/godotengine/godot/pull/111964)).
- Add `h`/`v_separation` theme properties to ScrollContainer ([GH-111975](https://github.com/godotengine/godot/pull/111975)).
- Add text trimming in `LinkButton` ([GH-112019](https://github.com/godotengine/godot/pull/112019)).
- Fix embedded window frame oversampling, fix DPITexture using uninitialized size in some conditions ([GH-112031](https://github.com/godotengine/godot/pull/112031)).
- Move localized number formatting methods to `TranslationServer` ([GH-112092](https://github.com/godotengine/godot/pull/112092)).
- Fix `PopupMenu` losing item highlight when hovering submenus ([GH-112095](https://github.com/godotengine/godot/pull/112095)).
- CodeEdit: Add line number gutter minimum digits ([GH-112115](https://github.com/godotengine/godot/pull/112115)).
- Fix error when deleting trailing lines removed breakpoints ([GH-112168](https://github.com/godotengine/godot/pull/112168)).
- Make possible to change the ellipsis character in `LinkButton` ([GH-112220](https://github.com/godotengine/godot/pull/112220)).
- Fix MenuButton's PopupMenu is clipped ([GH-112239](https://github.com/godotengine/godot/pull/112239)).
- Fix drawing of slot icons in `GraphNode` when slots are not continuous ([GH-112245](https://github.com/godotengine/godot/pull/112245)).
- Fix `grab_focus` incorrectly handling `FOCUS_ACCESSIBILITY` ([GH-112251](https://github.com/godotengine/godot/pull/112251)).
- Fix LinkButton color in Modern theme ([GH-112255](https://github.com/godotengine/godot/pull/112255)).
- Fix icon colors in light color preset of modern theme ([GH-112277](https://github.com/godotengine/godot/pull/112277)).
- RTL: Do not apply scroll offset to empty RTL ([GH-112295](https://github.com/godotengine/godot/pull/112295)).
- Add custom `StyleBox` to `TreeItem` ([GH-112371](https://github.com/godotengine/godot/pull/112371)).
- PopupMenu: Fix minimum size for items with icons ([GH-112377](https://github.com/godotengine/godot/pull/112377)).
- Update VisualShader on theme changes ([GH-112382](https://github.com/godotengine/godot/pull/112382)).
- Make ScrollContainer scrollbar margins affect minimum size ([GH-112396](https://github.com/godotengine/godot/pull/112396)).
- RTL: Fix meta hover signals not emitted ([GH-112428](https://github.com/godotengine/godot/pull/112428)).
- TextServer: Fix `FontPriorityList` returning duplicate fonts ([GH-112435](https://github.com/godotengine/godot/pull/112435)).
- TextServer: Improve font fallback for emojis ([GH-112436](https://github.com/godotengine/godot/pull/112436)).
- Allow to add padding to `ScrollBar`s ([GH-112441](https://github.com/godotengine/godot/pull/112441)).
- Modern style: Fix `prop_subsection_stylebox` color not scaling with luminance ([GH-112443](https://github.com/godotengine/godot/pull/112443)).
- Modern style: Use stylebox setter for Action Map `TreeItem`s ([GH-112444](https://github.com/godotengine/godot/pull/112444)).
- Fix tree item editable area missing icon max width bug ([GH-112475](https://github.com/godotengine/godot/pull/112475)).
- Add scroll hints to `ScrollContainer` and `Tree` ([GH-112491](https://github.com/godotengine/godot/pull/112491)).
- PopupMenu: Add theme option for merging icon and checkbox gutters ([GH-112545](https://github.com/godotengine/godot/pull/112545)).
- Default preset container to minimum size in Export dialog ([GH-112590](https://github.com/godotengine/godot/pull/112590)).
- Label: Account for max visible lines when trimming text ([GH-112602](https://github.com/godotengine/godot/pull/112602)).
- Update rect after `_pre_popup` in `popup_centered_*` ([GH-112604](https://github.com/godotengine/godot/pull/112604)).
- Fix tree vertical line width bug ([GH-112625](https://github.com/godotengine/godot/pull/112625)).
- TextServer: Fix some emoji sequences and add missing ICU emoji property data ([GH-112636](https://github.com/godotengine/godot/pull/112636)).
- Improve language selection when shaping text ([GH-112661](https://github.com/godotengine/godot/pull/112661)).
- Fix cursor shape in the quick open dialog ([GH-112665](https://github.com/godotengine/godot/pull/112665)).
- Fix visual shader error when editing theme settings ([GH-112673](https://github.com/godotengine/godot/pull/112673)).
- Fix blurry items on `PopupMenu` when `v_separation` has an odd value ([GH-112676](https://github.com/godotengine/godot/pull/112676)).
- Stop drawing of MarginContainer margins if not in tree ([GH-112687](https://github.com/godotengine/godot/pull/112687)).
- Use event position for mouse over when event come from the same window ([GH-112712](https://github.com/godotengine/godot/pull/112712)).
- Fix tree relationship lines are squeezed together ([GH-112791](https://github.com/godotengine/godot/pull/112791)).
- Fix bottom panel not being able to resize on startup ([GH-112792](https://github.com/godotengine/godot/pull/112792)).
- Fix TreeItem icon overflows column boundary ([GH-112805](https://github.com/godotengine/godot/pull/112805)).
- Fix clicking the tree edge is ineffective ([GH-112830](https://github.com/godotengine/godot/pull/112830)).
- TextServer: Remove negative offset from the first char when shaping substrings ([GH-112858](https://github.com/godotengine/godot/pull/112858)).
- RTL: Fix `line_separation` not being applied between paragraphs ([GH-112882](https://github.com/godotengine/godot/pull/112882)).
- Fix disabled tabs in TabBar are selectable ([GH-112935](https://github.com/godotengine/godot/pull/112935)).
- TextServer: Track emoji subruns separately from parentheses stack ([GH-112940](https://github.com/godotengine/godot/pull/112940)).
- Fix error when double-clicking nothing on scene tree ([GH-112941](https://github.com/godotengine/godot/pull/112941)).
- Fix cut off columns in the advanced font import dialog ([GH-112945](https://github.com/godotengine/godot/pull/112945)).
- PopupMenu: Fix error spam and skip submenu hidden signals on native menus ([GH-112967](https://github.com/godotengine/godot/pull/112967)).
- 2D: Fix nine-patch rendering ([GH-112978](https://github.com/godotengine/godot/pull/112978)).
- Fix completion popup placement and adjust lines to available space ([GH-112991](https://github.com/godotengine/godot/pull/112991)).
- Fix tab bar offset ([GH-113084](https://github.com/godotengine/godot/pull/113084)).
- Update native menu icons after Node dock split ([GH-113134](https://github.com/godotengine/godot/pull/113134)).
- Fix SplitContainer crash on change type ([GH-113164](https://github.com/godotengine/godot/pull/113164)).
- Editor: Simplify native menu icon generation ([GH-113252](https://github.com/godotengine/godot/pull/113252)).
- PopupMenu: Fix accelerator incorrect highlighting when mouse moves toward submenu ([GH-113320](https://github.com/godotengine/godot/pull/113320)).
- Fix `TextEdit` does not auto scroll properly on certain vertical sizes ([GH-113390](https://github.com/godotengine/godot/pull/113390)).
- Accessibility: Fix text field character count and line navigation ([GH-113459](https://github.com/godotengine/godot/pull/113459)).
- Add non-public `{Line,Text}Edit::_set_text()` to fix `text_submitted` signal emission on Web ([GH-113461](https://github.com/godotengine/godot/pull/113461)).
- Editor: Add accessibility label to project favorite button ([GH-113473](https://github.com/godotengine/godot/pull/113473)).
- Editor: Set initial focus for screen reader users ([GH-113475](https://github.com/godotengine/godot/pull/113475)).
- Fix `ScrollContainer` ignoring internal nodes added externally ([GH-113503](https://github.com/godotengine/godot/pull/113503)).
- Add new monospace related hint strings ([GH-113512](https://github.com/godotengine/godot/pull/113512)).
- Round `ProgressBar` percentage instead of truncating ([GH-113531](https://github.com/godotengine/godot/pull/113531)).
- Accessibility: Re-apply stored name when recreating nodes ([GH-113533](https://github.com/godotengine/godot/pull/113533)).
- Fix the issue of no scan after dir creation and/or deletion ([GH-113541](https://github.com/godotengine/godot/pull/113541)).
- RTL: Fix relative index getting out of sync ([GH-113550](https://github.com/godotengine/godot/pull/113550)).
- Fix wrong file thumbnails icon ([GH-113572](https://github.com/godotengine/godot/pull/113572)).
- Fix memory management for ColorPalette in save file dialog ([GH-113573](https://github.com/godotengine/godot/pull/113573)).
- Enable scroll hints for several parts of the editor ([GH-113574](https://github.com/godotengine/godot/pull/113574)).
- FileDialog: Use base dir instead of ".." when going up ([GH-113581](https://github.com/godotengine/godot/pull/113581)).
- Hide arrows when they go past the column titles on `Tree`s ([GH-113591](https://github.com/godotengine/godot/pull/113591)).
- FileDialog: Filter drive list when root folder is set ([GH-113608](https://github.com/godotengine/godot/pull/113608)).
- Fix SplitContainer incorrect child shrink logic ([GH-113648](https://github.com/godotengine/godot/pull/113648)).
- Restore `FileDialog::_popup_base` ([GH-113742](https://github.com/godotengine/godot/pull/113742)).
- Fix native FileDialogs popping up when `use_native_dialog` is modified ([GH-113746](https://github.com/godotengine/godot/pull/113746)).
- Fix scrollbar separation being at the wrong side in `ScrollContainer`with a RTL layout ([GH-113755](https://github.com/godotengine/godot/pull/113755)).
- Unset submenu index when popup menu is hidden ([GH-113794](https://github.com/godotengine/godot/pull/113794)).
- Reorganize editor menu setup, allow switching global menu without restart ([GH-113800](https://github.com/godotengine/godot/pull/113800)).
- TextServer: Fix `duplicated` losing span info, and RID leak ([GH-113908](https://github.com/godotengine/godot/pull/113908)).
- Fix MSDF batching flag for StyleBoxTexture ([GH-113924](https://github.com/godotengine/godot/pull/113924)).
- Fix file thumbnails not using theme scale ([GH-113985](https://github.com/godotengine/godot/pull/113985)).
- TextServer: Do not skip non-color font if system fallback is disabled ([GH-114027](https://github.com/godotengine/godot/pull/114027)).
- Fix FileDialog icon scale in editor ([GH-114035](https://github.com/godotengine/godot/pull/114035)).
- Fix `ScrollContainer`'s bottom scroll hint ignoring margins ([GH-114037](https://github.com/godotengine/godot/pull/114037)).
- Fix save dialog clearing filename when navigating folders ([GH-114039](https://github.com/godotengine/godot/pull/114039)).
- Fix `TabContainer`'s minimum size ignoring the popup button ([GH-114115](https://github.com/godotengine/godot/pull/114115)).
- Fix FileDialog relative paths ([GH-114120](https://github.com/godotengine/godot/pull/114120)).
- Revert Tree item drawing changes ([GH-114122](https://github.com/godotengine/godot/pull/114122)).
- Fix changing directory in FileDialog ([GH-114177](https://github.com/godotengine/godot/pull/114177)).
- Use EditorFileDialog everywhere in the editor ([GH-114178](https://github.com/godotengine/godot/pull/114178)).
- Remove leftover print line from `TextServer` ([GH-114183](https://github.com/godotengine/godot/pull/114183)).
- Fix `PopupMenu::_pre_popup` crash outside the tree ([GH-114187](https://github.com/godotengine/godot/pull/114187)).
- TextServer: Fix line wrapping underflow ([GH-114189](https://github.com/godotengine/godot/pull/114189)).
- Automatically Resample CanvasItems in Scene Editor ([GH-114200](https://github.com/godotengine/godot/pull/114200)).
- Fix content margins of the editor runbar in modern theme ([GH-114259](https://github.com/godotengine/godot/pull/114259)).
- Fix background color of complex dialog windows in modern theme ([GH-114290](https://github.com/godotengine/godot/pull/114290)).
- Improve the look of inner tabs in modern theme ([GH-114392](https://github.com/godotengine/godot/pull/114392)).
- Fix background color of EditorInspectorArray ([GH-114394](https://github.com/godotengine/godot/pull/114394)).
- Fix `ScrollBar` not accepting `InputEventPanGesture` ([GH-114398](https://github.com/godotengine/godot/pull/114398)).
- Fix TextEdit moving caret word left/right can hide the caret ([GH-114404](https://github.com/godotengine/godot/pull/114404)).
- Fix binary BMFont flags handling ([GH-114412](https://github.com/godotengine/godot/pull/114412)).
- Make PopupMenu shrinking configurable ([GH-114438](https://github.com/godotengine/godot/pull/114438)).
- a11y: Only support blur and focus actions on widgets that are actually focusable ([GH-114444](https://github.com/godotengine/godot/pull/114444)).
- a11y: Add accessible name to resizable splitters ([GH-114445](https://github.com/godotengine/godot/pull/114445)).
- Fix visibility of shader node separators in modern theme ([GH-114501](https://github.com/godotengine/godot/pull/114501)).
- Fix color picker mode tabs in modern theme ([GH-114506](https://github.com/godotengine/godot/pull/114506)).
- Use dedicated canvas item to properly cull tree items ([GH-114572](https://github.com/godotengine/godot/pull/114572)).
- Fix `Tree` items ignoring inner margins ([GH-114703](https://github.com/godotengine/godot/pull/114703)).
- Fix incorrect position of icons in `ItemList` when on top mode ([GH-114709](https://github.com/godotengine/godot/pull/114709)).
- Accessibility: Force keyboard focus to the exclusive child ([GH-114722](https://github.com/godotengine/godot/pull/114722)).
- Fix text in `ItemList` being cutoff when it shouldn't ([GH-114741](https://github.com/godotengine/godot/pull/114741)).
- Fix PopupMenu size scaling again ([GH-114744](https://github.com/godotengine/godot/pull/114744)).
- Add color theme for scroll hints ([GH-114751](https://github.com/godotengine/godot/pull/114751)).
- Fix problems with popup menus for `Tree`'s range items ([GH-114760](https://github.com/godotengine/godot/pull/114760)).
- Fix TextEdit Shift+Click selection start position ([GH-114772](https://github.com/godotengine/godot/pull/114772)).
- Fix GraphFrame titlebar incorrect sizing with custom stylebox ([GH-114783](https://github.com/godotengine/godot/pull/114783)).
- Fix accessibility name when right slot is enabled in `GraphNode` ([GH-114789](https://github.com/godotengine/godot/pull/114789)).
- Fix OptionButton PopupMenu not shrinking after item changes ([GH-114806](https://github.com/godotengine/godot/pull/114806)).
- Scene: Fix `LineEdit.set_editable` to capture text focus when enabled ([GH-114847](https://github.com/godotengine/godot/pull/114847)).
- Add missing mirrored button styles in modern theme ([GH-114871](https://github.com/godotengine/godot/pull/114871)).
- Don't tint menu button icons in context toolbar ([GH-114874](https://github.com/godotengine/godot/pull/114874)).
- Fix VCS plugin icons ([GH-114882](https://github.com/godotengine/godot/pull/114882)).
- Fix editor ColorPicker icon scale ([GH-114938](https://github.com/godotengine/godot/pull/114938)).
- Fix wrong offset for `TabBar` with hidden tabs ([GH-114952](https://github.com/godotengine/godot/pull/114952)).
- Remove clip ignore from Tree background ([GH-115074](https://github.com/godotengine/godot/pull/115074)).
- Process system events during boot splash wait time ([GH-115118](https://github.com/godotengine/godot/pull/115118)).
- Remove experimental flags from graph nodes ([GH-115181](https://github.com/godotengine/godot/pull/115181)).
- Don't force list icon size in EditorFileDialog ([GH-115330](https://github.com/godotengine/godot/pull/115330)).

#### I18n

- Improve auto-translation of the rendering method selector ([GH-107795](https://github.com/godotengine/godot/pull/107795)).
- Clean up editor translation related methods ([GH-107999](https://github.com/godotengine/godot/pull/107999)).
- Improve auto-translation of Debugger ([GH-108457](https://github.com/godotengine/godot/pull/108457)).
- Move context and plural support to `Translation` ([GH-108862](https://github.com/godotengine/godot/pull/108862)).
- Improve auto-translation of the replication editor ([GH-109153](https://github.com/godotengine/godot/pull/109153)).
- Use `language` command line argument to override editor locale ([GH-110318](https://github.com/godotengine/godot/pull/110318)).
- Improve auto-translation of `SpriteFramesEditor` ([GH-111284](https://github.com/godotengine/godot/pull/111284)).
- Improve POT generator ([GH-111285](https://github.com/godotengine/godot/pull/111285)).
- Fix some easing presets not translated ([GH-111473](https://github.com/godotengine/godot/pull/111473)).
- Use more practical default plural rules ([GH-112026](https://github.com/godotengine/godot/pull/112026)).
- Improve CSV translations ([GH-112073](https://github.com/godotengine/godot/pull/112073)).
- Add CSV translation template generation ([GH-112149](https://github.com/godotengine/godot/pull/112149)).
- Make editor language setting default to Auto ([GH-112317](https://github.com/godotengine/godot/pull/112317)).
- Allow localizing the application name with project translations ([GH-112415](https://github.com/godotengine/godot/pull/112415)).
- Add methods for querying loaded `Translation` instances ([GH-112577](https://github.com/godotengine/godot/pull/112577)).
- Remove `TranslationPO` ([GH-112793](https://github.com/godotengine/godot/pull/112793)).
- Prevent the main locale from being set to an empty string ([GH-112899](https://github.com/godotengine/godot/pull/112899)).
- Fix dock window titles not being translated ([GH-113688](https://github.com/godotengine/godot/pull/113688)).
- Translate error names when displayed in dialogs ([GH-114152](https://github.com/godotengine/godot/pull/114152)).
- Fix some invalid translation usages ([GH-114405](https://github.com/godotengine/godot/pull/114405)).
- Editor: Disable auto translation for layer names in EditorPropertyLayers ([GH-114647](https://github.com/godotengine/godot/pull/114647)).

#### Import

- Tweak physics property hints in the 3D Advanced Import Settings dialog ([GH-73688](https://github.com/godotengine/godot/pull/73688)).
- Blender import: Correct exit code on Python exception ([GH-94873](https://github.com/godotengine/godot/pull/94873)).
- Default mjpeg avi movie writer to 16 bit audio and add an editor option so it can still write 32 bit ([GH-104951](https://github.com/godotengine/godot/pull/104951)).
- Fix texture atlas import deadlock by keeping `group_file=` on failed `import_file()` attempts ([GH-106532](https://github.com/godotengine/godot/pull/106532)).
- GLTF: Allow parsing glTF files without nodes ([GH-107836](https://github.com/godotengine/godot/pull/107836)).
- Remove ResourceImporterScene singletons in favor of local usage ([GH-107855](https://github.com/godotengine/godot/pull/107855)).
- Improve the cubemap preview ([GH-107975](https://github.com/godotengine/godot/pull/107975)).
- GLTF: Move accessor and buffer view Dictionary conversion into those classes ([GH-108320](https://github.com/godotengine/godot/pull/108320)).
- GLTF: Move accessor encoding functions to GLTFAccessor ([GH-108853](https://github.com/godotengine/godot/pull/108853)).
- GLTF: Move accessor decoding functions to GLTFAccessor ([GH-109103](https://github.com/godotengine/godot/pull/109103)).
- Material Conversion Error Handling ([GH-109369](https://github.com/godotengine/godot/pull/109369)).
- GLTF: Preserve mesh names on export ([GH-109421](https://github.com/godotengine/godot/pull/109421)).
- GLTF: Make handle binary image mode enum type-safe ([GH-109446](https://github.com/godotengine/godot/pull/109446)).
- Preserve mesh, material, and texture names in GLTF export ([GH-109475](https://github.com/godotengine/godot/pull/109475)).
- Betsy: Generate BC1 table cache during compression ([GH-109725](https://github.com/godotengine/godot/pull/109725)).
- Fix hang when importing blender files in headless mode ([GH-109944](https://github.com/godotengine/godot/pull/109944)).
- Update meshoptimizer to v0.25 ([GH-109990](https://github.com/godotengine/godot/pull/109990)).
- Use regularization flag for LODs of deformable objects to improve appearance post deformation ([GH-109992](https://github.com/godotengine/godot/pull/109992)).
- Switch LOD generation to use iterative simplification ([GH-110027](https://github.com/godotengine/godot/pull/110027)).
- Enable component pruning during mesh simplification ([GH-110028](https://github.com/godotengine/godot/pull/110028)).
- Betsy: Convert RGB to RGBA on the GPU for faster compression ([GH-110060](https://github.com/godotengine/godot/pull/110060)).
- Image: Fix normalization of mipmaps for half and float formats ([GH-110308](https://github.com/godotengine/godot/pull/110308)).
- OBJ importer: Support bump multiplier (normal scale) ([GH-110925](https://github.com/godotengine/godot/pull/110925)).
- Use const ref parameters in the GLTF module ([GH-110949](https://github.com/godotengine/godot/pull/110949)).
- GLTF: Support animating node visibility ([GH-111341](https://github.com/godotengine/godot/pull/111341)).
- Fix segfault in `GLTFDocument::export_object_model_property` ([GH-111389](https://github.com/godotengine/godot/pull/111389)).
- Scene importer: Fix skeleton path when physics body type is dynamic ([GH-111507](https://github.com/godotengine/godot/pull/111507)).
- GLTF: Write integer min/max for integer accessors ([GH-111612](https://github.com/godotengine/godot/pull/111612)).
- GLTF: Determine the component type when encoding object model properties ([GH-111613](https://github.com/godotengine/godot/pull/111613)).
- GLTF: Enforce `STEP` interpolation for integer and boolean animations ([GH-111615](https://github.com/godotengine/godot/pull/111615)).
- GLTF: Don't serialize empty material extensions ([GH-112137](https://github.com/godotengine/godot/pull/112137)).
- Don't assign a uid when copying resource file whose `importer` name is `keep` or `skip` ([GH-112337](https://github.com/godotengine/godot/pull/112337)).
- Check if scale/offset values are provided in gltf `KHR_texture_transform` ([GH-112852](https://github.com/godotengine/godot/pull/112852)).
- GLTF: Use `const Vector` internally instead of `TypedArray` copies ([GH-113172](https://github.com/godotengine/godot/pull/113172)).
- Allow converting from Mesh to ImporterMesh ([GH-113202](https://github.com/godotengine/godot/pull/113202)).
- Support MultiMesh objects in the scene Advanced Import Settings dialog ([GH-113206](https://github.com/godotengine/godot/pull/113206)).
- GLTF: Fix order of operations for buffers and accessors ([GH-113245](https://github.com/godotengine/godot/pull/113245)).
- Write to animation import settings only when needed to prevent bloating the .import file ([GH-114015](https://github.com/godotengine/godot/pull/114015)).
- GLTF: Fix emissive texture import when `emissiveFactor` is absent ([GH-114033](https://github.com/godotengine/godot/pull/114033)).
- GLTF: Duplicate images during serialization to prevent segfaults ([GH-114354](https://github.com/godotengine/godot/pull/114354)).
- Fix setting mesh blend shape properties in dummy mesh storage ([GH-114356](https://github.com/godotengine/godot/pull/114356)).
- Fix importing projects with PNG assets freezes Web Editor ([GH-114410](https://github.com/godotengine/godot/pull/114410)).
- GLTF: Fix getting animation track path ([GH-114581](https://github.com/godotengine/godot/pull/114581)).
- Default 3D model importer naming versions to the latest version ([GH-114659](https://github.com/godotengine/godot/pull/114659)).

#### Input

- Clean up and simplify camera override API ([GH-52285](https://github.com/godotengine/godot/pull/52285)).
- Add shortcuts to reset position, rotation and scale in Spatial and Canvas Item Editor ([GH-102888](https://github.com/godotengine/godot/pull/102888)).
- Add ability to add new EditorSettings shortcuts ([GH-102889](https://github.com/godotengine/godot/pull/102889)).
- Fix cannot input Chinese after restarting the input method on X11 ([GH-103749](https://github.com/godotengine/godot/pull/103749)).
- Remove the need to have a display name for built-in action overrides ([GH-107487](https://github.com/godotengine/godot/pull/107487)).
- Fix modifier order in keycode string generation ([GH-108260](https://github.com/godotengine/godot/pull/108260)).
- Use safe ObjectID for mouse over controls ([GH-109063](https://github.com/godotengine/godot/pull/109063)).
- Fix Android back gesture failing after keyboard dismissal ([GH-110127](https://github.com/godotengine/godot/pull/110127)).
- Fix out of control area mouse events crash, if nothing have mouse focus ([GH-110162](https://github.com/godotengine/godot/pull/110162)).
- macOS: Remove old embedded window joystick init code ([GH-110491](https://github.com/godotengine/godot/pull/110491)).
- macOS: Use `productCategory` instead of `vendorName` for joypad name in SDL ([GH-110500](https://github.com/godotengine/godot/pull/110500)).
- Fix the bug causing `java.lang.StringIndexOutOfBoundsException` crashes when showing the virtual keyboard ([GH-110611](https://github.com/godotengine/godot/pull/110611)).
- Allow all gamepad devices for built-in `ui_*` input actions ([GH-110823](https://github.com/godotengine/godot/pull/110823)).
- Fix weak and strong joypad vibration being swapped ([GH-111191](https://github.com/godotengine/godot/pull/111191)).
- Fix invalid reported joypad presses ([GH-111192](https://github.com/godotengine/godot/pull/111192)).
- Fix `Input.is_joy_known` response for SDL joypads ([GH-111503](https://github.com/godotengine/godot/pull/111503)).
- Add support for setting a joypad's LED light color ([GH-111681](https://github.com/godotengine/godot/pull/111681)).
- Support adding advanced joypad features ([GH-111707](https://github.com/godotengine/godot/pull/111707)).
- Fix not releasing action when actions are erased ([GH-111747](https://github.com/godotengine/godot/pull/111747)).
- X11: Fix `keyboard_get_label_from_physical` errors when used on key without label ([GH-111795](https://github.com/godotengine/godot/pull/111795)).
- macOS: Fix mouse enter events sent to wrong popup window ([GH-112383](https://github.com/godotengine/godot/pull/112383)).
- Android: Fix crash when gamepad connects immediately upon app startup ([GH-112760](https://github.com/godotengine/godot/pull/112760)).
- Android: Improve D-pad support for Default Android Gamepad ([GH-112762](https://github.com/godotengine/godot/pull/112762)).
- Fix emulated touch events using the incorrect window ID ([GH-112995](https://github.com/godotengine/godot/pull/112995)).
- Fix assertions against buffer overruns in `input_event_codec.cpp` ([GH-113028](https://github.com/godotengine/godot/pull/113028)).
- Avoid nested parentheses in physical/Unicode InputEventKey text conversion ([GH-113418](https://github.com/godotengine/godot/pull/113418)).
- X11: Fix input delay regression ([GH-113537](https://github.com/godotengine/godot/pull/113537)).
- Do not show `Physical` in the special key names ([GH-113553](https://github.com/godotengine/godot/pull/113553)).
- Fix Android fingerprint scanners being recognized as joypads ([GH-114334](https://github.com/godotengine/godot/pull/114334)).
- Fix Android joypad triggers range ([GH-114363](https://github.com/godotengine/godot/pull/114363)).
- Change return type for `Input.set_joy_light()` from `bool` to `void` ([GH-114851](https://github.com/godotengine/godot/pull/114851)).
- Wayland: Fix IME ([GH-115090](https://github.com/godotengine/godot/pull/115090)).

#### Multiplayer

- Improve RPC Error messages ([GH-109216](https://github.com/godotengine/godot/pull/109216)).
- Remove `_spawn_custom` from error message ([GH-111983](https://github.com/godotengine/godot/pull/111983)).

#### Navigation

- Make NavigationServer backend engine selectable ([GH-106290](https://github.com/godotengine/godot/pull/106290)).
- Navigation 2D: Fix sign of cross product ([GH-110815](https://github.com/godotengine/godot/pull/110815)).
- Make navmesh rasterization errors more lenient ([GH-110841](https://github.com/godotengine/godot/pull/110841)).
- Fix build error when Navigation 2D is disabled ([GH-113471](https://github.com/godotengine/godot/pull/113471)).
- Fix `AStar`s to return empty path for disabled `from` point ([GH-113988](https://github.com/godotengine/godot/pull/113988)).
- Preserve winding order for transformed tiles' navigation polygons ([GH-114742](https://github.com/godotengine/godot/pull/114742)).

#### Network

- Make HTTPRequest 301 and 302 redirects standards-compliant ([GH-91199](https://github.com/godotengine/godot/pull/91199)).
- Add unit tests for `StreamPeerTCP` ([GH-102064](https://github.com/godotengine/godot/pull/102064)).
- Add Core UNIX domain socket support ([GH-107954](https://github.com/godotengine/godot/pull/107954)).
- Unix: Don't print an error if `bind` fails ([GH-111300](https://github.com/godotengine/godot/pull/111300)).
- mbedTLS: Update to version 3.6.5 ([GH-111845](https://github.com/godotengine/godot/pull/111845)).
- Fix HTTPRequest timeout being scaled with `Engine.time_scale` ([GH-112686](https://github.com/godotengine/godot/pull/112686)).
- Normalize IP parsing, fix IPv6, tests ([GH-114827](https://github.com/godotengine/godot/pull/114827)).

#### Particles

- Change curve range for particle multipliers ([GH-91556](https://github.com/godotengine/godot/pull/91556)).
- Add emission shape ring for CPUParticles2D ([GH-94929](https://github.com/godotengine/godot/pull/94929)).
- Fix NaN populating ParticleProcessMaterial Transform ([GH-97871](https://github.com/godotengine/godot/pull/97871)).
- Improve 2D Particle Emission Mask dialog ([GH-101165](https://github.com/godotengine/godot/pull/101165)).
- Push pipeline compilation of various effects to the worker thread pool ([GH-111129](https://github.com/godotengine/godot/pull/111129)).
- Fix CPUParticle3D not randomizing ([GH-112514](https://github.com/godotengine/godot/pull/112514)).

#### Physics

- Add MeshInstance3D primitive conversion options ([GH-101521](https://github.com/godotengine/godot/pull/101521)).
- Use Jolt Physics by default in newly created projects ([GH-105737](https://github.com/godotengine/godot/pull/105737)).
- Add MultiMesh physics interpolation for 2D transforms (MultiMeshInstance2D) ([GH-107666](https://github.com/godotengine/godot/pull/107666)).
- Tweak property hints for SoftBody3D mass and SkeletonModification2DJiggle ([GH-108758](https://github.com/godotengine/godot/pull/108758)).
- JoltPhysics: Fix orphan StringName ([GH-110329](https://github.com/godotengine/godot/pull/110329)).
- Fix bug in ManifoldBetweenTwoFaces ([GH-110507](https://github.com/godotengine/godot/pull/110507)).
- Fix ancestry constructors ([GH-110805](https://github.com/godotengine/godot/pull/110805)).
- Fix CCD bodies adding multiple contact manifolds when using Jolt ([GH-110914](https://github.com/godotengine/godot/pull/110914)).
- Fix crash when calling `move_and_collide` with a null `jolt_body` ([GH-110964](https://github.com/godotengine/godot/pull/110964)).
- Jolt: Update to 5.4.0 ([GH-110965](https://github.com/godotengine/godot/pull/110965)).
- JoltPhysics: Fix Generic6DOFJoint3D not respecting angular limits ([GH-111087](https://github.com/godotengine/godot/pull/111087)).
- Fix crash in Jolt when doing incremental builds ([GH-111408](https://github.com/godotengine/godot/pull/111408)).
- Fix crash when box selecting remote 3D physics nodes ([GH-111960](https://github.com/godotengine/godot/pull/111960)).
- Jolt: Add null checks to `jolt_free` and `jolt_aligned_free` ([GH-112363](https://github.com/godotengine/godot/pull/112363)).
- Fix `SoftBody3D`'s position influences its physics in Jolt ([GH-112483](https://github.com/godotengine/godot/pull/112483)).
- Jolt Physics: Remove sharing shared soft body settings from SoftBody3D ([GH-112623](https://github.com/godotengine/godot/pull/112623)).
- Remove call to `PhysicsServer3D` from Jolt Physics implementation ([GH-113622](https://github.com/godotengine/godot/pull/113622)).

#### Platforms

- Silence warnings about DisplayServer icons on iOS and visionOS ([GH-94542](https://github.com/godotengine/godot/pull/94542)).
- Windows: Simplify ANGLE fallback list and remove ID checks ([GH-95853](https://github.com/godotengine/godot/pull/95853)).
- Wayland: Add environment variable to disable libdecor loading ([GH-96825](https://github.com/godotengine/godot/pull/96825)).
- FileAccess: Implement support for reading and writing extended file attributes/alternate data streams ([GH-102232](https://github.com/godotengine/godot/pull/102232)).
- Wayland: Emulate frame event for old `wl_seat` versions ([GH-105587](https://github.com/godotengine/godot/pull/105587)).
- Workaround X11 crash issue ([GH-106798](https://github.com/godotengine/godot/pull/106798)).
- Wayland: Implement the xdg-toplevel-icon-v1 protocol ([GH-107096](https://github.com/godotengine/godot/pull/107096)).
- Wayland: Implement game embedding ([GH-107435](https://github.com/godotengine/godot/pull/107435)).
- Add `null` and range checks to `DisplayServerMacOSBase::clipboard_get()` ([GH-108372](https://github.com/godotengine/godot/pull/108372)).
- macOS: Fix disabling native menu items in system menus ([GH-108596](https://github.com/godotengine/godot/pull/108596)).
- Support XDG Inhibit portal ([GH-108704](https://github.com/godotengine/godot/pull/108704)).
- iOS/macOS: Improve `OS.get_memory_info` ([GH-109112](https://github.com/godotengine/godot/pull/109112)).
- macOS: Add option for renaming system menus ([GH-109138](https://github.com/godotengine/godot/pull/109138)).
- Windows: Try reading GPU driver information directly from registry ([GH-109346](https://github.com/godotengine/godot/pull/109346)).
- Add Stretch Modes for Splash Screen ([GH-109596](https://github.com/godotengine/godot/pull/109596)).
- macOS: Always use "Regular" activation policy for GUI, and headless main loop for command line only tools ([GH-109795](https://github.com/godotengine/godot/pull/109795)).
- macOS: Move system theme properties to the `DisplayServerMacOSBase` ([GH-109980](https://github.com/godotengine/godot/pull/109980)).
- macOS: Fix keyboard mapping init in embedded display server ([GH-110078](https://github.com/godotengine/godot/pull/110078)).
- iOS: Add device SOC list, update DPI list ([GH-110192](https://github.com/godotengine/godot/pull/110192)).
- Configure SDL assuming we, in fact, have a libc ([GH-110198](https://github.com/godotengine/godot/pull/110198)).
- macOS: Make embedded window focus behavior more similar to Windows/X11 ([GH-110219](https://github.com/godotengine/godot/pull/110219)).
- Windows: Try reading GPU IDs directly from registry ([GH-110268](https://github.com/godotengine/godot/pull/110268)).
- Windows: Expand full screen border in the direction with no adjacent display, or display with min refresh rate difference ([GH-110375](https://github.com/godotengine/godot/pull/110375)).
- Web: Fix clipboard text encoding in `update_clipboard_callback` ([GH-110544](https://github.com/godotengine/godot/pull/110544)).
- Wayland: Inhibit idle in `DisplayServerWayland::screen_set_keep_on` ([GH-110875](https://github.com/godotengine/godot/pull/110875)).
- Change `macos.permission.RECORD_SCREEN` version check from 10.15 to 11.0 ([GH-110936](https://github.com/godotengine/godot/pull/110936)).
- Fix permission handling for write backup files (`FileAccessUnix`) ([GH-110943](https://github.com/godotengine/godot/pull/110943)).
- Unix: Fix retrieval of PID exit code ([GH-111058](https://github.com/godotengine/godot/pull/111058)).
- Suppress SIGPIPE when writing to a pipe ([GH-111114](https://github.com/godotengine/godot/pull/111114)).
- Window: Add unfiltered input handler signal for custom decorations ([GH-111288](https://github.com/godotengine/godot/pull/111288)).
- Fix editor embedded windows partially resizing ([GH-111313](https://github.com/godotengine/godot/pull/111313)).
- Fix editor auto display scale on Windows ([GH-111326](https://github.com/godotengine/godot/pull/111326)).
- MacOS: Improve crash handler performance ([GH-111425](https://github.com/godotengine/godot/pull/111425)).
- Wayland: Defer event thread initialization to late initialization ([GH-111493](https://github.com/godotengine/godot/pull/111493)).
- X11: Fix fullscreen exit behavior ([GH-111580](https://github.com/godotengine/godot/pull/111580)).
- X11: Fix memory leak in `screen_get_refresh_rate()` ([GH-111639](https://github.com/godotengine/godot/pull/111639)).
- macOS: Fix ~500ms hang on transparent OpenGL window creation on macOS 26 ([GH-111657](https://github.com/godotengine/godot/pull/111657)).
- Wayland: Set window parent before commit ([GH-111874](https://github.com/godotengine/godot/pull/111874)).
- Increase stack size for all secondary threads on Apple platforms ([GH-112094](https://github.com/godotengine/godot/pull/112094)).
- X11: Fix minimize/maximize buttons can't be hidden ([GH-112142](https://github.com/godotengine/godot/pull/112142)).
- Fix 64-bit integers being truncated to 32-bit in JNI ([GH-112192](https://github.com/godotengine/godot/pull/112192)).
- Android: Implement Storage Access Framework (SAF) support ([GH-112215](https://github.com/godotengine/godot/pull/112215)).
- macOS/Embedded: Release/recapture mouse on window focus change and exit ([GH-112236](https://github.com/godotengine/godot/pull/112236)).
- Linux: Add SSE4.2 support runtime check ([GH-112279](https://github.com/godotengine/godot/pull/112279)).
- Windows: Fix legacy border when toggling borderless while fullscreen ([GH-112297](https://github.com/godotengine/godot/pull/112297)).
- Make `utterance_id` 64-bit ([GH-112379](https://github.com/godotengine/godot/pull/112379)).
- Fix compile error with android export plugin ([GH-112398](https://github.com/godotengine/godot/pull/112398)).
- Fix "Unexpected NUL character" errors on Wine ([GH-112496](https://github.com/godotengine/godot/pull/112496)).
- D3D12: Fall back to HWND if DComp init failed ([GH-112497](https://github.com/godotengine/godot/pull/112497)).
- Android: Fix loading sparse `.pck` from `assets://` ([GH-112507](https://github.com/godotengine/godot/pull/112507)).
- Windows: Fix `window_get_size_with_decorations` returning an invalid size when restoring from minimize ([GH-112534](https://github.com/godotengine/godot/pull/112534)).
- Android: Fix root window shrinking when keyboard appears ([GH-112585](https://github.com/godotengine/godot/pull/112585)).
- Fix Chinese characters in DBusMessage were not displayed correctly ([GH-112629](https://github.com/godotengine/godot/pull/112629)).
- Android: Make use of `activity-alias` as the primary launcher mechanism ([GH-112679](https://github.com/godotengine/godot/pull/112679)).
- Fix crash when using ANGLE OpenGL on Windows ([GH-112720](https://github.com/godotengine/godot/pull/112720)).
- Windows: Fix EnumDevices stall using IAT hooks ([GH-113013](https://github.com/godotengine/godot/pull/113013)).
- Wayland: Fix compiling with `libdecor=no` ([GH-113041](https://github.com/godotengine/godot/pull/113041)).
- Wayland: Implement compose and dead key support ([GH-113068](https://github.com/godotengine/godot/pull/113068)).
- Wayland: Fix trailing garbage error while using the embedder on Jay ([GH-113135](https://github.com/godotengine/godot/pull/113135)).
- Wayland: Fix Wayland driver in export templates ([GH-113138](https://github.com/godotengine/godot/pull/113138)).
- Android: Fix memory issues in `_variant_to_jvalue()` ([GH-113159](https://github.com/godotengine/godot/pull/113159)).
- macOS: Add missing "move" system cursor ([GH-113186](https://github.com/godotengine/godot/pull/113186)).
- Prevent deadlock on Android camera ([GH-113209](https://github.com/godotengine/godot/pull/113209)).
- Windows: Make Direct3D 12 the default RD driver for new projects ([GH-113213](https://github.com/godotengine/godot/pull/113213)).
- X11: Skip Motif function hints when borderless ([GH-113235](https://github.com/godotengine/godot/pull/113235)).
- Wayland: Misc keyboard touchups ([GH-113256](https://github.com/godotengine/godot/pull/113256)).
- macOS: Do not use `openApplicationAtURL` for headless instances ([GH-113267](https://github.com/godotengine/godot/pull/113267)).
- Add platform lifecycle callbacks to CameraServer base class ([GH-113297](https://github.com/godotengine/godot/pull/113297)).
- LinuxBSD: Fixes a formatting error when running Godot editor with Wayland prefer enabled ([GH-113302](https://github.com/godotengine/godot/pull/113302)).
- Implement XFCE `exo-open` support in Linux `OS.shell_open` ([GH-113341](https://github.com/godotengine/godot/pull/113341)).
- Wayland: Unify key handling logic ([GH-113346](https://github.com/godotengine/godot/pull/113346)).
- iOS: Fix use of `godot_path` ([GH-113455](https://github.com/godotengine/godot/pull/113455)).
- macOS: Fix profiler cleanup ([GH-113547](https://github.com/godotengine/godot/pull/113547)).
- Wayland: Work around window scale ambiguity ([GH-113656](https://github.com/godotengine/godot/pull/113656)).
- Fix laggy window resize on Wayland ([GH-113714](https://github.com/godotengine/godot/pull/113714)).
- Wayland: Bump to 1.24.0 ([GH-113733](https://github.com/godotengine/godot/pull/113733)).
- macOS: Prefer user specified file extensions over OS preferred one ([GH-113757](https://github.com/godotengine/godot/pull/113757)).
- Wayland: Implement `keyboard_get_label_from_physical` ([GH-113837](https://github.com/godotengine/godot/pull/113837)).
- Fix storage scope for the obb directory ([GH-113878](https://github.com/godotengine/godot/pull/113878)).
- wayland-protocols: Update to 1.46 ([GH-113940](https://github.com/godotengine/godot/pull/113940)).
- Wayland: Fix accidental copy during global remove ([GH-113946](https://github.com/godotengine/godot/pull/113946)).
- Wayland: Add missing destroy calls for text input and tablet ([GH-113947](https://github.com/godotengine/godot/pull/113947)).
- Wayland: Remove `GODOT_DEBUG_EMBEDDER_SINGLE_INSTANCE` debug option ([GH-113949](https://github.com/godotengine/godot/pull/113949)).
- Wayland: Ignore IME events without a valid window ([GH-113950](https://github.com/godotengine/godot/pull/113950)).
- macOS: Disable window embedding code in export templates ([GH-113966](https://github.com/godotengine/godot/pull/113966)).
- Ensure that the permission requests results are dispatched on the render thread ([GH-113969](https://github.com/godotengine/godot/pull/113969)).
- Wayland: Silence `window_get_wl_surface` on invalid window ([GH-113977](https://github.com/godotengine/godot/pull/113977)).
- Wayland: Allow non-interactive window resizing ([GH-114082](https://github.com/godotengine/godot/pull/114082)).
- Android: Fix ANRs when shutting down the engine due to the render thread ([GH-114207](https://github.com/godotengine/godot/pull/114207)).
- Fix camera module error handling and remove unnecessary transform ([GH-114400](https://github.com/godotengine/godot/pull/114400)).
- Android: Trigger save of the RD pipeline cache on application pause ([GH-114463](https://github.com/godotengine/godot/pull/114463)).
- macOS: Fix non-focusable window order ([GH-114495](https://github.com/godotengine/godot/pull/114495)).
- Windows: Fix icon leak ([GH-114525](https://github.com/godotengine/godot/pull/114525)).
- Wayland: Track popup menu mouse mask properly ([GH-114574](https://github.com/godotengine/godot/pull/114574)).
- Fix Project Manager `ProjectDialog` install dialog OK button ([GH-114705](https://github.com/godotengine/godot/pull/114705)).
- WaylandEmbedder: Fix `-Wduplicated-branches` warning ([GH-114756](https://github.com/godotengine/godot/pull/114756)).
- Do not apply "*" as preferred extension ([GH-114781](https://github.com/godotengine/godot/pull/114781)).
- X11: Allow moving a fullscreen/maximized window to another screen/display ([GH-114820](https://github.com/godotengine/godot/pull/114820)).
- Wayland: Update popup scale information on creation ([GH-115242](https://github.com/godotengine/godot/pull/115242)).
- Process events during splash on macOS only ([GH-115249](https://github.com/godotengine/godot/pull/115249)).

#### Plugin

- Expose `set_edited` and `is_edited` on `EditorInterface` ([GH-91703](https://github.com/godotengine/godot/pull/91703)).
- EditorPlugin: Allow instance base type inheriting EditorPlugin ([GH-93296](https://github.com/godotengine/godot/pull/93296)).
- Expose 3D editor snap settings to EditorInterface ([GH-103608](https://github.com/godotengine/godot/pull/103608)).
- Android: `JavaClassWrapper` bug fixes ([GH-107075](https://github.com/godotengine/godot/pull/107075)).
- Relocate `add_root_node` method to `EditorInterface` from `EditorScript` and deprecate old method ([GH-109049](https://github.com/godotengine/godot/pull/109049)).
- Android: Minor updates to the `GodotPlugin` APIs ([GH-111135](https://github.com/godotengine/godot/pull/111135)).
- Fix potential conflicts in FileSystem context menu plugins ([GH-112048](https://github.com/godotengine/godot/pull/112048)).
- Fix editor crash attempting to generate preview for invalid BitMap ([GH-114247](https://github.com/godotengine/godot/pull/114247)).

#### Rendering

- Resolve depth buffer in mobile renderer when required ([GH-78598](https://github.com/godotengine/godot/pull/78598)).
- Add methods to draw ellipses ([GH-85080](https://github.com/godotengine/godot/pull/85080)).
- Don't redraw invisible CanvasItems ([GH-90401](https://github.com/godotengine/godot/pull/90401)).
- Use Viewport's 3D Scaling in the 3D editor's Half Resolution option ([GH-93436](https://github.com/godotengine/godot/pull/93436)).
- Implement motion vectors in compatibility renderer ([GH-97151](https://github.com/godotengine/godot/pull/97151)).
- Fix Sprite3D texture bleed when not wrapping ([GH-98122](https://github.com/godotengine/godot/pull/98122)).
- Image: Implement 16-bit unorm and uint formats ([GH-106200](https://github.com/godotengine/godot/pull/106200)).
- DirectX DescriptorsHeap pooling on CPU ([GH-106809](https://github.com/godotengine/godot/pull/106809)).
- Add `white`, `contrast`, and future HDR support to the AgX tonemapper ([GH-106940](https://github.com/godotengine/godot/pull/106940)).
- Implement DirectionalLight3D cull masks in Compatibility ([GH-107384](https://github.com/godotengine/godot/pull/107384)).
- Cache lightprobe generation for lightmap baking ([GH-107400](https://github.com/godotengine/godot/pull/107400)).
- Apply sun scatter from lights with shadows in compatibility ([GH-107740](https://github.com/godotengine/godot/pull/107740)).
- Add missing `vpv.push_back(pv);` in `render_target_get_sdf_texture` ([GH-107763](https://github.com/godotengine/godot/pull/107763)).
- Minor Optimization to Occlusion Culling ([GH-107839](https://github.com/godotengine/godot/pull/107839)).
- Rewrite Radiance and Reflection probes to use Octahedral maps ([GH-107902](https://github.com/godotengine/godot/pull/107902)).
- Use Mat3x4 for model and view transforms to save bandwidth and ALUs ([GH-107923](https://github.com/godotengine/godot/pull/107923)).
- FTI: - Add `multimesh_instances_reset_physics_interpolation()` ([GH-108114](https://github.com/godotengine/godot/pull/108114)).
- Disable unsupported SSR, SSS, DoF on transparent viewports ([GH-108206](https://github.com/godotengine/godot/pull/108206)).
- Metal: Fix `texture_get_data` other linear formats ([GH-108422](https://github.com/godotengine/godot/pull/108422)).
- Compatibility: Set `GL_TEXTURE_MAX_LEVEL` to the number of mipmaps ([GH-108528](https://github.com/godotengine/godot/pull/108528)).
- Add depth resolve to the mobile renderer ([GH-108636](https://github.com/godotengine/godot/pull/108636)).
- Fix clear color being incorrect in `Environment` background with HDR 2D ([GH-108682](https://github.com/godotengine/godot/pull/108682)).
- Compatibility: Explicitly use BC1's RGB variant ([GH-108826](https://github.com/godotengine/godot/pull/108826)).
- Move D3D12's automatic texture clears to RenderingDevice ([GH-108871](https://github.com/godotengine/godot/pull/108871)).
- Add material debanding for use in Mobile rendering method ([GH-109084](https://github.com/godotengine/godot/pull/109084)).
- Add and enable default textures for other samplers ([GH-109143](https://github.com/godotengine/godot/pull/109143)).
- Prompt editor restart when reflection probe size is updated ([GH-109186](https://github.com/godotengine/godot/pull/109186)).
- Compatibility: Fix cubemap faces order when setting texture data ([GH-109299](https://github.com/godotengine/godot/pull/109299)).
- Add ubershader support to material and SDF variants in Forward+ ([GH-109401](https://github.com/godotengine/godot/pull/109401)).
- Make `OpenXRCompositionLayer` and its children safe for multithreaded rendering ([GH-109431](https://github.com/godotengine/godot/pull/109431)).
- Implement a very simple SSAO in GLES3 ([GH-109447](https://github.com/godotengine/godot/pull/109447)).
- Fix spotlight's shadow peter-panning with volumetric fog ([GH-109567](https://github.com/godotengine/godot/pull/109567)).
- Compatibility: Improve ASTC extension detecting ([GH-109778](https://github.com/godotengine/godot/pull/109778)).
- Compatibility: Fix backface culling gets ignored when double-sided shadows are used ([GH-109793](https://github.com/godotengine/godot/pull/109793)).
- Use half float precision buffer for 3D when HDR2D is enabled ([GH-109971](https://github.com/godotengine/godot/pull/109971)).
- LightmapGI: Pack L1 SH coefficients before denoising ([GH-109972](https://github.com/godotengine/godot/pull/109972)).
- OpenXR: Fix ViewportTextures not displaying correct texture (OpenGL) ([GH-110002](https://github.com/godotengine/godot/pull/110002)).
- Divide screen texture by luminance multiplier in compatibility ([GH-110004](https://github.com/godotengine/godot/pull/110004)).
- Overhaul and optimize Glow in the mobile renderer ([GH-110077](https://github.com/godotengine/godot/pull/110077)).
- Fix rounding error in clustered vertex light culling ([GH-110184](https://github.com/godotengine/godot/pull/110184)).
- Clamp minimum size of 3D texture view in D3D12 ([GH-110203](https://github.com/godotengine/godot/pull/110203)).
- Fix `CompositorEffect` not setting post-transparent callback on init ([GH-110249](https://github.com/godotengine/godot/pull/110249)).
- Fix reflection probes not recreating downsampled textures when mode changes ([GH-110330](https://github.com/godotengine/godot/pull/110330)).
- Rename `RDD::MemoryBarrier` to avoid conflicts with the Windows headers ([GH-110360](https://github.com/godotengine/godot/pull/110360)).
- Increase precision of SpotLight attenuation calculation to avoid driver bug on Intel devices ([GH-110363](https://github.com/godotengine/godot/pull/110363)).
- Tweak draw command label names for consistency ([GH-110505](https://github.com/godotengine/godot/pull/110505)).
- Fix Viewport VRS Mode property listing unimplemented Depth buffer option ([GH-110520](https://github.com/godotengine/godot/pull/110520)).
- Fix `TileMapLayer` tiles displaying incorrectly with `y_sort` based on visibility layer ([GH-110550](https://github.com/godotengine/godot/pull/110550)).
- Move check for sky cubemap array back into the SkyRD initializer ([GH-110627](https://github.com/godotengine/godot/pull/110627)).
- Blend glow before tonemapping and change default to screen ([GH-110671](https://github.com/godotengine/godot/pull/110671)).
- Use correct scaling type when falling back to bilinear ([GH-110672](https://github.com/godotengine/godot/pull/110672)).
- Use correct screen-space to ndc equation in Compatibility refraction ([GH-110684](https://github.com/godotengine/godot/pull/110684)).
- Use an array instead of `TightLocalVector` in `RasterizerSceneGLES3::_render_uv2`, to avoid allocation ([GH-110781](https://github.com/godotengine/godot/pull/110781)).
- Fix glow intensity not showing in compatibility renderer ([GH-110843](https://github.com/godotengine/godot/pull/110843)).
- Ensure reflection atlas is valid before rendering ([GH-110853](https://github.com/godotengine/godot/pull/110853)).
- Fix OpenXR with D3D12 using the wrong clip space projection matrix ([GH-110865](https://github.com/godotengine/godot/pull/110865)).
- Use correct AABB for SpotLight3Ds when `spot_angle > 90` ([GH-110884](https://github.com/godotengine/godot/pull/110884)).
- Clear intermediate buffers when not in use in Compatibility ([GH-110915](https://github.com/godotengine/godot/pull/110915)).
- Show centiseconds in LightmapGI bake time printout in the editor ([GH-110937](https://github.com/godotengine/godot/pull/110937)).
- Renderer: Move `reflect_spirv` to `RenderingShaderContainer` ([GH-111013](https://github.com/godotengine/godot/pull/111013)).
- Fix d3d12 stencil buffer not clearing ([GH-111032](https://github.com/godotengine/godot/pull/111032)).
- Sort render list correctly in RD renderers ([GH-111054](https://github.com/godotengine/godot/pull/111054)).
- Always show settings to enable DOF near + far ([GH-111060](https://github.com/godotengine/godot/pull/111060)).
- Fix LightmapGI not being correctly applied to objects ([GH-111125](https://github.com/godotengine/godot/pull/111125)).
- Add Persistent Buffers utilizing UMA ([GH-111183](https://github.com/godotengine/godot/pull/111183)).
- FTI - Optimize non-interpolated 2D items ([GH-111198](https://github.com/godotengine/godot/pull/111198)).
- Overhaul screen-space reflections ([GH-111210](https://github.com/godotengine/godot/pull/111210)).
- Fix scene shader crash due to rename of view matrix and inverse view matrix ([GH-111227](https://github.com/godotengine/godot/pull/111227)).
- Fix warning spam in Compatibility when using depth texture ([GH-111234](https://github.com/godotengine/godot/pull/111234)).
- Always use RenderSceneBuffers to manage backbuffer in Compatibility 3D ([GH-111240](https://github.com/godotengine/godot/pull/111240)).
- Add null check when getting motion vector fbo ([GH-111260](https://github.com/godotengine/godot/pull/111260)).
- Use resolved depth texture for DOF with MSAA in Mobile ([GH-111303](https://github.com/godotengine/godot/pull/111303)).
- Fix D3D12 not checking for fullscreen clear region correctly ([GH-111321](https://github.com/godotengine/godot/pull/111321)).
- Add all PowerVR devices to the transform feedback shader cache ban list ([GH-111329](https://github.com/godotengine/godot/pull/111329)).
- Fix specialization constant patching on D3D12 ([GH-111356](https://github.com/godotengine/godot/pull/111356)).
- Fix incorrect transform calculation in `Camera2D` when using a custom viewport ([GH-111384](https://github.com/godotengine/godot/pull/111384)).
- Fix wrong indices used for transform & UBO matrix for double precision build ([GH-111403](https://github.com/godotengine/godot/pull/111403)).
- Use correct ndc for proximity fade in Compatibility ([GH-111437](https://github.com/godotengine/godot/pull/111437)).
- FTI - Fix `SceneTreeFTI` depth limit behavior ([GH-111444](https://github.com/godotengine/godot/pull/111444)).
- Use re-spirv in the Vulkan driver to optimize shaders ([GH-111452](https://github.com/godotengine/godot/pull/111452)).
- Ensure `uv2_attrib(_input)` is available when rendering lightmap ([GH-111466](https://github.com/godotengine/godot/pull/111466)).
- Apply luminance multiplier in `copy_cubemap_to_panorama` ([GH-111577](https://github.com/godotengine/godot/pull/111577)).
- Use correct shadow material in some cases in Mobile ([GH-111578](https://github.com/godotengine/godot/pull/111578)).
- Fix `CAMERA_VISIBLE_LAYERS` in multiview camera (VR) not aligning with the camera's cull mask ([GH-111596](https://github.com/godotengine/godot/pull/111596)).
- Organize render surface sorting key for optimizing API performance ([GH-111652](https://github.com/godotengine/godot/pull/111652)).
- Fix D3D12 rendering device driver returning pointers to internal types for `get_resource_native_handle` instead of proper D3D12 primitives ([GH-111658](https://github.com/godotengine/godot/pull/111658)).
- Do not begin a new frame during RenderingDevice's shutdown ([GH-111733](https://github.com/godotengine/godot/pull/111733)).
- Fix the LODs array returned by `mesh_get_surface` ([GH-111745](https://github.com/godotengine/godot/pull/111745)).
- Document occlusion debugging in the SDFGI debug probes draw mode in the editor ([GH-111748](https://github.com/godotengine/godot/pull/111748)).
- D3D12: Greatly reduce shader conversion time & fix spec constant bitmasking ([GH-111762](https://github.com/godotengine/godot/pull/111762)).
- Make all unsupported renderer message features consistently warnings ([GH-111806](https://github.com/godotengine/godot/pull/111806)).
- Use `GL_FRAMEBUFFER` instead of `GL_DRAW_FRAMEBUFFER` when doing final blit to the screen framebuffer to work around OBS bug ([GH-111834](https://github.com/godotengine/godot/pull/111834)).
- Round values after renormalization when generating mipmaps ([GH-111841](https://github.com/godotengine/godot/pull/111841)).
- Fix incorrect failure code in `screen_get_framebuffer_format` ([GH-111883](https://github.com/godotengine/godot/pull/111883)).
- Improve `Environment` adjustments (favor old behavior and quality) ([GH-111897](https://github.com/godotengine/godot/pull/111897)).
- Force disable SPIRV debug info on D3D12 ([GH-111912](https://github.com/godotengine/godot/pull/111912)).
- Refactor rendering driver copy APIs to fix D3D12 issues ([GH-111954](https://github.com/godotengine/godot/pull/111954)).
- Sync final frame after finalizing RD to ensure that nothing is in use on the GPU when we free the RD ([GH-111957](https://github.com/godotengine/godot/pull/111957)).
- Insert barriers between subpasses when using enhanced barriers on D3D12 ([GH-111988](https://github.com/godotengine/godot/pull/111988)).
- Revise fog blending to fix over-darkening/borders ([GH-111998](https://github.com/godotengine/godot/pull/111998)).
- 2D: Fix incorrect 2D rendering ([GH-112131](https://github.com/godotengine/godot/pull/112131)).
- Set `DONT_PREFER_SMALL_BUFFERS_COMMITTED` when initializing D3D12MA ([GH-112152](https://github.com/godotengine/godot/pull/112152)).
- Implement point size emulation in the forward shader for D3D12 ([GH-112191](https://github.com/godotengine/godot/pull/112191)).
- TAA adjustment to reduce ghosting ([GH-112196](https://github.com/godotengine/godot/pull/112196)).
- Fix Light2D none shadow filter to use nearest sampling ([GH-112212](https://github.com/godotengine/godot/pull/112212)).
- OpenXR: Fix resizing viewports used by `OpenXRCompositionLayer` ([GH-112227](https://github.com/godotengine/godot/pull/112227)).
- Use proper bitshift for tonemap srgb flag in Forward+ renderer ([GH-112272](https://github.com/godotengine/godot/pull/112272)).
- Create HWND swap chain when window transparency is disabled on D3D12 ([GH-112344](https://github.com/godotengine/godot/pull/112344)).
- Apply viewport oversampling to Polygon2D ([GH-112352](https://github.com/godotengine/godot/pull/112352)).
- Improve rendering driver fallback on Windows ([GH-112384](https://github.com/godotengine/godot/pull/112384)).
- Fix glow visual compatibility regression ([GH-112471](https://github.com/godotengine/godot/pull/112471)).
- Massively optimize canvas 2D rendering by using vertex buffers ([GH-112481](https://github.com/godotengine/godot/pull/112481)).
- Clean up Volumetric Fog blending behavior ([GH-112494](https://github.com/godotengine/godot/pull/112494)).
- CommandQueueMT: Reduce contention + Fix race conditions ([GH-112506](https://github.com/godotengine/godot/pull/112506)).
- Fix incorrect material and mesh thumbnails ([GH-112537](https://github.com/godotengine/godot/pull/112537)).
- Sanitize INF/NaN when copying last frame texture for SSIL/SSR ([GH-112732](https://github.com/godotengine/godot/pull/112732)).
- Reorganize canvas shader varyings in RD renderer ([GH-112800](https://github.com/godotengine/godot/pull/112800)).
- Implement `XR_META_foveation_eye_tracked` ([GH-112888](https://github.com/godotengine/godot/pull/112888)).
- Fix D3D12 renderer crash on Wine ([GH-112911](https://github.com/godotengine/godot/pull/112911)).
- Fix buffer creation on old D3D12 runtimes ([GH-112914](https://github.com/godotengine/godot/pull/112914)).
- Allow reflection probes to only recreate the atlas when switching to real time ([GH-112916](https://github.com/godotengine/godot/pull/112916)).
- Fix inconsistent color clamping between Mobile and Forward+ ([GH-112927](https://github.com/godotengine/godot/pull/112927)).
- 2D: Fix clip children ([GH-112930](https://github.com/godotengine/godot/pull/112930)).
- Add missing mipmaps to `RB_TEX_BACK_COLOR` ([GH-112932](https://github.com/godotengine/godot/pull/112932)).
- Check for Typed UAV Load Additional Formats capability when creating D3D12 device ([GH-112989](https://github.com/godotengine/godot/pull/112989)).
- OpenXR: Fix Vulkan validation errors and get `XR_META_foveation_eye_tracked` working on Meta Quest devices ([GH-112994](https://github.com/godotengine/godot/pull/112994)).
- Fix corruption of D3D12 CPU descriptor heap free blocks ([GH-113000](https://github.com/godotengine/godot/pull/113000)).
- Persistently map staging buffers ([GH-113010](https://github.com/godotengine/godot/pull/113010)).
- Fix all D3D12 object memory leaks ([GH-113106](https://github.com/godotengine/godot/pull/113106)).
- Ensure usage of `DATA_FORMAT_R32_SFLOAT` for depth resolve on Forward+ ([GH-113130](https://github.com/godotengine/godot/pull/113130)).
- Fix `SHADER_UNIFORM_NAMES` for error messages ([GH-113194](https://github.com/godotengine/godot/pull/113194)).
- Fix GLES3 `buffer_free_data` error ([GH-113220](https://github.com/godotengine/godot/pull/113220)).
- Check for pending clears in every RD texture function ([GH-113236](https://github.com/godotengine/godot/pull/113236)).
- Refactor descriptor heaps in D3D12 driver ([GH-113244](https://github.com/godotengine/godot/pull/113244)).
- Fix framebuffers getting cleared multiple times on D3D12 ([GH-113277](https://github.com/godotengine/godot/pull/113277)).
- Fix VoxelGI glossy reflection artifacts ([GH-113334](https://github.com/godotengine/godot/pull/113334)).
- D3D12: Convert non-critical startup warnings to verbose prints ([GH-113372](https://github.com/godotengine/godot/pull/113372)).
- Set shader path before compilation ([GH-113432](https://github.com/godotengine/godot/pull/113432)).
- Add Adreno workaround to Mobile post process shader ([GH-113467](https://github.com/godotengine/godot/pull/113467)).
- Use AABB center instead of origin for visibility fade ([GH-113486](https://github.com/godotengine/godot/pull/113486)).
- Fix radiance/reflection fallback texture types ([GH-113507](https://github.com/godotengine/godot/pull/113507)).
- Update re-spirv with bugfix for function result decorations ([GH-113582](https://github.com/godotengine/godot/pull/113582)).
- Fix bad D3D12 SRV breaking MSAA with OpenXR ([GH-113585](https://github.com/godotengine/godot/pull/113585)).
- Change `environment_get_glow_hdr_bleed_threshold` error handling ([GH-113599](https://github.com/godotengine/godot/pull/113599)).
- Check if sun scatter is enabled when using `SKY_MODE_AUTOMATIC` ([GH-113609](https://github.com/godotengine/godot/pull/113609)).
- Update Mesa NIR to 25.3.1 + Make each SPIR-V -> DXIL conversion thread allocate from its own heap ([GH-113618](https://github.com/godotengine/godot/pull/113618)).
- Check pipeline validity before freeing pipelines in PipelineDeferredRD ([GH-113660](https://github.com/godotengine/godot/pull/113660)).
- Fix re-spirv null pointer crash on invalid SPIR-V parsing ([GH-113708](https://github.com/godotengine/godot/pull/113708)).
- Fix Vulkan failing to initialize when compiling without D3D12 ([GH-113741](https://github.com/godotengine/godot/pull/113741)).
- Fix D3D12 looking blurry in the editor at fullscreen ([GH-113744](https://github.com/godotengine/godot/pull/113744)).
- Clear depth stencil textures on first use if the RDD requires it ([GH-113842](https://github.com/godotengine/godot/pull/113842)).
- Mobile: Fix clearcoat shader compilation error ([GH-113844](https://github.com/godotengine/godot/pull/113844)).
- Fix `SYNC_ALL` bit getting masked out on D3D12 ([GH-113893](https://github.com/godotengine/godot/pull/113893)).
- Fix D3D12 device not getting created with Agility SDK ([GH-114040](https://github.com/godotengine/godot/pull/114040)).
- Upgrade Agility SDK & DirectX Headers ([GH-114043](https://github.com/godotengine/godot/pull/114043)).
- RenderingDevice: Add null checks when retrieving uniform sets ([GH-114073](https://github.com/godotengine/godot/pull/114073)).
- Fix incorrect resource state when discarding MSAA textures in D3D12 ([GH-114146](https://github.com/godotengine/godot/pull/114146)).
- OpenGL: Split the ubos for motion vectors into separate uniforms ([GH-114175](https://github.com/godotengine/godot/pull/114175)).
- Skip MSAA2D when OpenXR is used ([GH-114180](https://github.com/godotengine/godot/pull/114180)).
- Pass consistent viewport and screen sizes to fix point size emulation ([GH-114194](https://github.com/godotengine/godot/pull/114194)).
- Fix OpenGL motion vector regression ([GH-114227](https://github.com/godotengine/godot/pull/114227)).
- Avoid singularity during sky filtering ([GH-114279](https://github.com/godotengine/godot/pull/114279)).
- Fix real time reflection probes being constantly recreated ([GH-114281](https://github.com/godotengine/godot/pull/114281)).
- Create new pools when they become fragmented on Vulkan ([GH-114313](https://github.com/godotengine/godot/pull/114313)).
- Fall back to octmap raster path on certain devices & fix issues with the shaders ([GH-114314](https://github.com/godotengine/godot/pull/114314)).
- Implement workaround for GPU driver crash on Adreno 5XX ([GH-114416](https://github.com/godotengine/godot/pull/114416)).
- Handle `RGB10_A2` storage format in octmap shaders ([GH-114419](https://github.com/godotengine/godot/pull/114419)).
- Create separate graphics queue instead of reusing the main queue when transfer queue family is unsupported ([GH-114476](https://github.com/godotengine/godot/pull/114476)).
- Remove amplification & mesh shader deny flags on D3D12 ([GH-114615](https://github.com/godotengine/godot/pull/114615)).
- Fix DXIL view instancing workaround not getting applied correctly ([GH-114645](https://github.com/godotengine/godot/pull/114645)).
- Always add Vulkan descriptor count for immutable samplers to descriptor pool ([GH-114657](https://github.com/godotengine/godot/pull/114657)).
- Prevent SSR from getting affected by specular occlusion ([GH-114727](https://github.com/godotengine/godot/pull/114727)).
- Workaround crash in pipeline creation on Intel Mesa devices by avoiding using half floats in derivative functions ([GH-114765](https://github.com/godotengine/godot/pull/114765)).
- Metal: Fix dynamic uniform buffer offset corruption when rebinding sets ([GH-114778](https://github.com/godotengine/godot/pull/114778)).
- Fix MSAA crashing Mali GPUs when using subpasses ([GH-114785](https://github.com/godotengine/godot/pull/114785)).
- Use luminance multiplier for sky background when using mobile renderer with HDR2D ([GH-114804](https://github.com/godotengine/godot/pull/114804)).
- Fix downsampled radiance map generation ([GH-114907](https://github.com/godotengine/godot/pull/114907)).
- Overhaul compute shader based environment roughness calculation to improve performance and quality ([GH-114908](https://github.com/godotengine/godot/pull/114908)).
- Fix buffers in D3D12 not getting cleared with the right usage ([GH-114982](https://github.com/godotengine/godot/pull/114982)).
- Do not store SPIR-V in memory unless pipeline statistics are used ([GH-115049](https://github.com/godotengine/godot/pull/115049)).
- Increase precision of ninepatch source rect to ensure pixel perfect alignment ([GH-115152](https://github.com/godotengine/godot/pull/115152)).
- Add Fossilize to the disabled Vulkan layer list for the editor ([GH-115166](https://github.com/godotengine/godot/pull/115166)).
- Fix stale reference bug in FramebufferCache ([GH-115299](https://github.com/godotengine/godot/pull/115299)).

#### Shaders

- Optimize the custom doc for shaders ([GH-97616](https://github.com/godotengine/godot/pull/97616)).
- Visual Shader: Fix nodes' relative positions changed in a different display scale ([GH-97620](https://github.com/godotengine/godot/pull/97620)).
- Focus shader text editor when opened with quick open dialog ([GH-102193](https://github.com/godotengine/godot/pull/102193)).
- Tweak high-end mark in the visual shader editor's node creation dialog ([GH-103340](https://github.com/godotengine/godot/pull/103340)).
- Don't save code property of VisualShader ([GH-109021](https://github.com/godotengine/godot/pull/109021)).
- Fix VisualShader conversion failing with subresources ([GH-109375](https://github.com/godotengine/godot/pull/109375)).
- Clean up ShaderEditor shortcuts ([GH-109775](https://github.com/godotengine/godot/pull/109775)).
- Organize toggle files button logic in shader editor ([GH-109998](https://github.com/godotengine/godot/pull/109998)).
- Clean up some things in shader editor code ([GH-109999](https://github.com/godotengine/godot/pull/109999)).
- Fix invalid suggested file name when saving resource from a scene that hasn't been saved yet ([GH-110231](https://github.com/godotengine/godot/pull/110231)).
- Fix shader compilation errors in Compatibility when using `depth_texture` ([GH-110241](https://github.com/godotengine/godot/pull/110241)).
- Fix ternary expression for structs in shaders ([GH-111277](https://github.com/godotengine/godot/pull/111277)).
- Fix error when compute shaders contain Unicode comment ([GH-111703](https://github.com/godotengine/godot/pull/111703)).
- Fix ParameterRef connection through reroute in visual shaders ([GH-112058](https://github.com/godotengine/godot/pull/112058)).
- Separate visual shader code out of shader editor plugin and dialog ([GH-112100](https://github.com/godotengine/godot/pull/112100)).
- Few fixes for expression node in visual shaders ([GH-112124](https://github.com/godotengine/godot/pull/112124)).
- Add `instance_index` option to parameters in visual shaders ([GH-112538](https://github.com/godotengine/godot/pull/112538)).
- Fix false positive `discard` and `frag_only` errors in gdshaderinc files ([GH-112551](https://github.com/godotengine/godot/pull/112551)).
- Apply `PREMUL_ALPHA_FACTOR` only in non-split-specular shader variants ([GH-112801](https://github.com/godotengine/godot/pull/112801)).
- Use new dock system for Shader Editor Dock ([GH-113181](https://github.com/godotengine/godot/pull/113181)).
- Move initialization check for CanvasMaterial ([GH-113650](https://github.com/godotengine/godot/pull/113650)).
- Fix shader editor filename not updating after file rename ([GH-113703](https://github.com/godotengine/godot/pull/113703)).
- VisualShader: Fix the eta input from the refract node ([GH-113728](https://github.com/godotengine/godot/pull/113728)).
- VisualShader: Fix new node spawning position with display scaling ([GH-113974](https://github.com/godotengine/godot/pull/113974)).
- VisualShader: Fix refract node setup ([GH-114063](https://github.com/godotengine/godot/pull/114063)).
- Add compatibility handler to `RADIANCE` in sky shaders ([GH-114773](https://github.com/godotengine/godot/pull/114773)).

#### Tests

- Add unit tests for `Decal` ([GH-93463](https://github.com/godotengine/godot/pull/93463)).
- Remove stress unit tests ([GH-104793](https://github.com/godotengine/godot/pull/104793)).
- Use ProjectSettings path functions instead of hard-coded folder names in tests ([GH-108170](https://github.com/godotengine/godot/pull/108170)).
- Add more `Array` tests ([GH-110097](https://github.com/godotengine/godot/pull/110097)).
- Image: Make `fill` method also fill the mipmaps ([GH-110247](https://github.com/godotengine/godot/pull/110247)).
- Add Android instrumented tests to the `app` module ([GH-110829](https://github.com/godotengine/godot/pull/110829)).
- Core: Remove `skip_cr` argument from `String` ([GH-110867](https://github.com/godotengine/godot/pull/110867)).
- Fix compilation failure in resource test file ([GH-111345](https://github.com/godotengine/godot/pull/111345)).
- Core: Support `INF`/`NAN` in JSON from/to native ([GH-111522](https://github.com/godotengine/godot/pull/111522)).
- Add more `Dictionary` tests ([GH-112259](https://github.com/godotengine/godot/pull/112259)).
- Fix profiler cleanup with `--test` ([GH-113557](https://github.com/godotengine/godot/pull/113557)).

#### Thirdparty

- access-kit: Update to 0.18.0 ([GH-113990](https://github.com/godotengine/godot/pull/113990)).
- basis_universal: Sync with latest Git to solve more warnings ([GH-111445](https://github.com/godotengine/godot/pull/111445)).
- brotli: Update to 1.2.0 ([GH-113935](https://github.com/godotengine/godot/pull/113935)).
- certs: Sync with Mozilla bundle as of Dec 4, 2025 ([GH-113936](https://github.com/godotengine/godot/pull/113936)).
- freetype: Update missing info from FreeType 2.14.1 ([GH-111572](https://github.com/godotengine/godot/pull/111572)).
- freetype: Update to 2.14.1 ([GH-112411](https://github.com/godotengine/godot/pull/112411)).
- grisu2: Rediff patch and sync with latest upstream commit ([GH-113982](https://github.com/godotengine/godot/pull/113982)).
- harfbuzz: Update to 12.2.0 ([GH-112408](https://github.com/godotengine/godot/pull/112408)).
- icu: Update to 78.1 ([GH-112410](https://github.com/godotengine/godot/pull/112410)).
- libdecor: Regenerate dynamic wrapper ([GH-114081](https://github.com/godotengine/godot/pull/114081)).
- libjpeg-turbo: Update to 3.1.3 ([GH-113945](https://github.com/godotengine/godot/pull/113945)).
- libktx: Update to 4.4.2 ([GH-113960](https://github.com/godotengine/godot/pull/113960)).
- libogg: Update to 1.3.6 ([GH-108224](https://github.com/godotengine/godot/pull/108224)).
- libpng: Update to 1.6.53 ([GH-113961](https://github.com/godotengine/godot/pull/113961)).
- libwebp: Update to 1.6.0 ([GH-113963](https://github.com/godotengine/godot/pull/113963)).
- manifold: Update to 3.3.2 ([GH-113964](https://github.com/godotengine/godot/pull/113964)).
- meshoptimizer: Update to 1.0 ([GH-113983](https://github.com/godotengine/godot/pull/113983)).
- msdfgen: Update to 1.13 ([GH-113965](https://github.com/godotengine/godot/pull/113965)).
- openxr: Update to 1.1.54 ([GH-114026](https://github.com/godotengine/godot/pull/114026)).
- pcre2: Update to 10.47 ([GH-113967](https://github.com/godotengine/godot/pull/113967)).
- sdl: Update to 3.2.28 ([GH-113968](https://github.com/godotengine/godot/pull/113968)).
- thorvg: Update to 0.15.16 ([GH-109651](https://github.com/godotengine/godot/pull/109651)).
- wayland-protocols: Update to 1.45 ([GH-107693](https://github.com/godotengine/godot/pull/107693)).
- zlib/minizip: Update to version 1.3.1.2 ([GH-113933](https://github.com/godotengine/godot/pull/113933)).

#### XR

- Expose `CameraFeed::set_ycbcr_images` ([GH-106237](https://github.com/godotengine/godot/pull/106237)).
- OpenXR: Add core support for Khronos loader ([GH-106891](https://github.com/godotengine/godot/pull/106891)).
- OpenXR: Add support for spatial entities extension ([GH-107391](https://github.com/godotengine/godot/pull/107391)).
- Use of `XrSwapchainCreateFlags` for `OpenXRCompositionLayer` ([GH-108644](https://github.com/godotengine/godot/pull/108644)).
- Add OpenXR 1.1 support ([GH-109302](https://github.com/godotengine/godot/pull/109302)).
- OpenXR: Safely set environment blend mode when rendering on a separate thread ([GH-109532](https://github.com/godotengine/godot/pull/109532)).
- OpenXR: Prevent adding/removing extension wrappers after session start ([GH-109533](https://github.com/godotengine/godot/pull/109533)).
- Add `XR_META_hand_tracking_microgestures` action paths ([GH-109611](https://github.com/godotengine/godot/pull/109611)).
- OpenXR: Add support for frame synthesis ([GH-109803](https://github.com/godotengine/godot/pull/109803)).
- OpenXR: Fix errors reported by `XrApiLayer_core_validation` ([GH-109969](https://github.com/godotengine/godot/pull/109969)).
- Add `quest3s` to the list of supported devices ([GH-110465](https://github.com/godotengine/godot/pull/110465)).
- Fix XR tracker name changing at runtime ([GH-110703](https://github.com/godotengine/godot/pull/110703)).
- Android: Handle `YUV_420_888` strides correctly in CameraFeed ([GH-110720](https://github.com/godotengine/godot/pull/110720)).
- Fix late destruction access violation with OpenXRAPIExtension object ([GH-110868](https://github.com/godotengine/godot/pull/110868)).
- Use const ref parameters in the OpenXR module ([GH-110948](https://github.com/godotengine/godot/pull/110948)).
- More XR disable for Viewport and export ([GH-111185](https://github.com/godotengine/godot/pull/111185)).
- Emit `format_changed` on CameraFeed datatype change ([GH-111206](https://github.com/godotengine/godot/pull/111206)).
- Fix small code layout issue in persistence scope initialization ([GH-111307](https://github.com/godotengine/godot/pull/111307)).
- Ensure `XrRenderModelPropertiesEXT::type` is initialized ([GH-111434](https://github.com/godotengine/godot/pull/111434)).
- Make `XRPose` only set name on creation instead of on pose update ([GH-111538](https://github.com/godotengine/godot/pull/111538)).
- Fix compilation errors when `disable_xr=yes` ([GH-111663](https://github.com/godotengine/godot/pull/111663)).
- Android: Deprecate and remove vendors specific XR APIs ([GH-111870](https://github.com/godotengine/godot/pull/111870)).
- Android: Stabilize camera lifecycle handling ([GH-111871](https://github.com/godotengine/godot/pull/111871)).
- Android editor: Add support for Android XR devices to the Godot XR Editor ([GH-112777](https://github.com/godotengine/godot/pull/112777)).
- Support reading available OpenXR runtimes from Windows registry ([GH-112884](https://github.com/godotengine/godot/pull/112884)).
- Implement `XR_KHR_android_thread_settings` ([GH-112889](https://github.com/godotengine/godot/pull/112889)).
- OpenXR: Add `OpenXRAPIExtension::update_main_swapchain_size()` ([GH-112890](https://github.com/godotengine/godot/pull/112890)).
- OpenXR: Add profiling macro for process, `xrWaitFrame()` and acquiring swapchain ([GH-112893](https://github.com/godotengine/godot/pull/112893)).
- Android editor: Ensure that the Android editor properly passes hybrid data when switching mode ([GH-112928](https://github.com/godotengine/godot/pull/112928)).
- OpenXR: Implement `play_area_changed` signal ([GH-113062](https://github.com/godotengine/godot/pull/113062)).
- Check if OpenXR is enabled with feature tags of export preset ([GH-113161](https://github.com/godotengine/godot/pull/113161)).
- Fix `OpenXRExportPlugin::_get_name() must be overridden` error ([GH-113191](https://github.com/godotengine/godot/pull/113191)).
- Update the shortcuts to play current / specific scene based on the last selected XR run mode option ([GH-113387](https://github.com/godotengine/godot/pull/113387)).
- OpenXR: Fix building with `vulkan=no` ([GH-113460](https://github.com/godotengine/godot/pull/113460)).
- Update the version of the OpenXR Vendors plugin to the latest stable version ([GH-113639](https://github.com/godotengine/godot/pull/113639)).
- Fix OpenXR build failure when glTF module is disabled ([GH-113713](https://github.com/godotengine/godot/pull/113713)).
- OpenXR: Add Valve Frame controller support ([GH-113785](https://github.com/godotengine/godot/pull/113785)).
- OpenXR: Only obtain `xrCreateSwapchainAndroidSurfaceKHR` extension if available ([GH-113788](https://github.com/godotengine/godot/pull/113788)).
- Add Steam to the description of the Steam Frame controller ([GH-113820](https://github.com/godotengine/godot/pull/113820)).
- OpenXR: Use the DPAD extension constant ([GH-113824](https://github.com/godotengine/godot/pull/113824)).
- Add XROrigin3D scale warning ([GH-113979](https://github.com/godotengine/godot/pull/113979)).
- Hide properties on XRCamera3D that are managed by XRInterface ([GH-114057](https://github.com/godotengine/godot/pull/114057)).
- OpenXR: Remove version hack to workaround Meta aim pose issue that is now fixed ([GH-114132](https://github.com/godotengine/godot/pull/114132)).
- OpenXR: Don't create a visibility mask mesh without data ([GH-114181](https://github.com/godotengine/godot/pull/114181)).
- Android editor: Restrict Android editor support for hybrid app projects to XR devices ([GH-114465](https://github.com/godotengine/godot/pull/114465)).
- Reword OpenXR initialization failure alert message ([GH-114630](https://github.com/godotengine/godot/pull/114630)).
- Fix OpenXR depth submission data dropped ([GH-114697](https://github.com/godotengine/godot/pull/114697)).
- OpenXR: Change profile name for Valve Frame Controller ([GH-114784](https://github.com/godotengine/godot/pull/114784)).
- Fix XROrigin3D scale warning ([GH-114931](https://github.com/godotengine/godot/pull/114931)).
- OpenXR: Allow setting a specific version of OpenXR to initialize ([GH-115022](https://github.com/godotengine/godot/pull/115022)).
- Android: Fix XR build regression when vendor plugin overrides the same feature ([GH-115148](https://github.com/godotengine/godot/pull/115148)).

## Past releases

- [4.5](https://github.com/godotengine/godot/blob/4.5-stable/CHANGELOG.md)
- [4.4](https://github.com/godotengine/godot/blob/4.4-stable/CHANGELOG.md)
- [4.3](https://github.com/godotengine/godot/blob/4.3-stable/CHANGELOG.md)
- [4.2](https://github.com/godotengine/godot/blob/4.2-stable/CHANGELOG.md)
- [4.1](https://github.com/godotengine/godot/blob/4.1-stable/CHANGELOG.md)
- [4.0](https://github.com/godotengine/godot/blob/4.0-stable/CHANGELOG.md)
- [3.5](https://github.com/godotengine/godot/blob/3.5-stable/CHANGELOG.md)
- [3.4](https://github.com/godotengine/godot/blob/3.4-stable/CHANGELOG.md)
- [3.3](https://github.com/godotengine/godot/blob/3.3-stable/CHANGELOG.md)
- [3.2](https://github.com/godotengine/godot/blob/3.2-stable/CHANGELOG.md)
- [3.1](https://github.com/godotengine/godot/blob/3.1-stable/CHANGELOG.md)
- [3.0](https://github.com/godotengine/godot/blob/f2e19a26f556c42b7202072296dc072aaac2007c/CHANGELOG.md)
