// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetTrialReader is a Reader for the GetTrial structure.
type GetTrialReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetTrialReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetTrialOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetTrialDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetTrialOK creates a GetTrialOK with default headers values
func NewGetTrialOK() *GetTrialOK {
	return &GetTrialOK{}
}

/*
GetTrialOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetTrialOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215GetTrialResponse
}

// IsSuccess returns true when this get trial o k response has a 2xx status code
func (o *GetTrialOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get trial o k response has a 3xx status code
func (o *GetTrialOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get trial o k response has a 4xx status code
func (o *GetTrialOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get trial o k response has a 5xx status code
func (o *GetTrialOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get trial o k response a status code equal to that given
func (o *GetTrialOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get trial o k response
func (o *GetTrialOK) Code() int {
	return 200
}

func (o *GetTrialOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{organization_id}/trial][%d] getTrialOK  %+v", 200, o.Payload)
}

func (o *GetTrialOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{organization_id}/trial][%d] getTrialOK  %+v", 200, o.Payload)
}

func (o *GetTrialOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215GetTrialResponse {
	return o.Payload
}

func (o *GetTrialOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215GetTrialResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTrialDefault creates a GetTrialDefault with default headers values
func NewGetTrialDefault(code int) *GetTrialDefault {
	return &GetTrialDefault{
		_statusCode: code,
	}
}

/*
GetTrialDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetTrialDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get trial default response has a 2xx status code
func (o *GetTrialDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get trial default response has a 3xx status code
func (o *GetTrialDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get trial default response has a 4xx status code
func (o *GetTrialDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get trial default response has a 5xx status code
func (o *GetTrialDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get trial default response a status code equal to that given
func (o *GetTrialDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get trial default response
func (o *GetTrialDefault) Code() int {
	return o._statusCode
}

func (o *GetTrialDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{organization_id}/trial][%d] GetTrial default  %+v", o._statusCode, o.Payload)
}

func (o *GetTrialDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{organization_id}/trial][%d] GetTrial default  %+v", o._statusCode, o.Payload)
}

func (o *GetTrialDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetTrialDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
