// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetServiceSummariesParams creates a new GetServiceSummariesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetServiceSummariesParams() *GetServiceSummariesParams {
	return &GetServiceSummariesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetServiceSummariesParamsWithTimeout creates a new GetServiceSummariesParams object
// with the ability to set a timeout on a request.
func NewGetServiceSummariesParamsWithTimeout(timeout time.Duration) *GetServiceSummariesParams {
	return &GetServiceSummariesParams{
		timeout: timeout,
	}
}

// NewGetServiceSummariesParamsWithContext creates a new GetServiceSummariesParams object
// with the ability to set a context for a request.
func NewGetServiceSummariesParamsWithContext(ctx context.Context) *GetServiceSummariesParams {
	return &GetServiceSummariesParams{
		Context: ctx,
	}
}

// NewGetServiceSummariesParamsWithHTTPClient creates a new GetServiceSummariesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetServiceSummariesParamsWithHTTPClient(client *http.Client) *GetServiceSummariesParams {
	return &GetServiceSummariesParams{
		HTTPClient: client,
	}
}

/*
GetServiceSummariesParams contains all the parameters to send to the API endpoint

	for the get service summaries operation.

	Typically these are written to a http.Request.
*/
type GetServiceSummariesParams struct {

	/* FilterClusters.

	   clusters matches summaries on the cluster name
	*/
	FilterClusters []string

	/* FilterKinds.

	    kinds matches service kind. If empty, this defaults to all kinds

	- KIND_UNSPECIFIED: The default, unspecified service kind. Kind unknown.
	- KIND_TYPICAL: A typical, classic Consul service.
	- KIND_CONNECT_PROXY: A Connect proxy instance.
	- KIND_MESH_GATEWAY: A mesh gateway service instance.
	- KIND_TERMINATING_GATEWAY: A terminating gateway service instance.
	- KIND_INGRESS_GATEWAY: An ingress gateway service instance.
	- KIND_DESTINATION: A Destination  for the Connect feature.
	- KIND_API_GATEWAY: An API gateway service instance
	*/
	FilterKinds []string

	/* FilterNameSubstr.

	   name_substr matches summaries that contain a case-insensitive substring in their service name
	*/
	FilterNameSubstr *string

	/* FilterNamespaces.

	   namespaces matches summaries on the namespace name
	*/
	FilterNamespaces []string

	/* FilterPartitions.

	   partitions matches summaries on the partition name
	*/
	FilterPartitions []string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this parameter to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The maximum number of results per page to return. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned, which you can use to get the next page of results in subsequent
	requests. A value of zero causes `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this parameter to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get service summaries params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceSummariesParams) WithDefaults() *GetServiceSummariesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get service summaries params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceSummariesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get service summaries params
func (o *GetServiceSummariesParams) WithTimeout(timeout time.Duration) *GetServiceSummariesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get service summaries params
func (o *GetServiceSummariesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get service summaries params
func (o *GetServiceSummariesParams) WithContext(ctx context.Context) *GetServiceSummariesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get service summaries params
func (o *GetServiceSummariesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get service summaries params
func (o *GetServiceSummariesParams) WithHTTPClient(client *http.Client) *GetServiceSummariesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get service summaries params
func (o *GetServiceSummariesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilterClusters adds the filterClusters to the get service summaries params
func (o *GetServiceSummariesParams) WithFilterClusters(filterClusters []string) *GetServiceSummariesParams {
	o.SetFilterClusters(filterClusters)
	return o
}

// SetFilterClusters adds the filterClusters to the get service summaries params
func (o *GetServiceSummariesParams) SetFilterClusters(filterClusters []string) {
	o.FilterClusters = filterClusters
}

// WithFilterKinds adds the filterKinds to the get service summaries params
func (o *GetServiceSummariesParams) WithFilterKinds(filterKinds []string) *GetServiceSummariesParams {
	o.SetFilterKinds(filterKinds)
	return o
}

// SetFilterKinds adds the filterKinds to the get service summaries params
func (o *GetServiceSummariesParams) SetFilterKinds(filterKinds []string) {
	o.FilterKinds = filterKinds
}

// WithFilterNameSubstr adds the filterNameSubstr to the get service summaries params
func (o *GetServiceSummariesParams) WithFilterNameSubstr(filterNameSubstr *string) *GetServiceSummariesParams {
	o.SetFilterNameSubstr(filterNameSubstr)
	return o
}

// SetFilterNameSubstr adds the filterNameSubstr to the get service summaries params
func (o *GetServiceSummariesParams) SetFilterNameSubstr(filterNameSubstr *string) {
	o.FilterNameSubstr = filterNameSubstr
}

// WithFilterNamespaces adds the filterNamespaces to the get service summaries params
func (o *GetServiceSummariesParams) WithFilterNamespaces(filterNamespaces []string) *GetServiceSummariesParams {
	o.SetFilterNamespaces(filterNamespaces)
	return o
}

// SetFilterNamespaces adds the filterNamespaces to the get service summaries params
func (o *GetServiceSummariesParams) SetFilterNamespaces(filterNamespaces []string) {
	o.FilterNamespaces = filterNamespaces
}

// WithFilterPartitions adds the filterPartitions to the get service summaries params
func (o *GetServiceSummariesParams) WithFilterPartitions(filterPartitions []string) *GetServiceSummariesParams {
	o.SetFilterPartitions(filterPartitions)
	return o
}

// SetFilterPartitions adds the filterPartitions to the get service summaries params
func (o *GetServiceSummariesParams) SetFilterPartitions(filterPartitions []string) {
	o.FilterPartitions = filterPartitions
}

// WithLocationOrganizationID adds the locationOrganizationID to the get service summaries params
func (o *GetServiceSummariesParams) WithLocationOrganizationID(locationOrganizationID string) *GetServiceSummariesParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get service summaries params
func (o *GetServiceSummariesParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get service summaries params
func (o *GetServiceSummariesParams) WithLocationProjectID(locationProjectID string) *GetServiceSummariesParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get service summaries params
func (o *GetServiceSummariesParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get service summaries params
func (o *GetServiceSummariesParams) WithLocationRegionProvider(locationRegionProvider *string) *GetServiceSummariesParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get service summaries params
func (o *GetServiceSummariesParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get service summaries params
func (o *GetServiceSummariesParams) WithLocationRegionRegion(locationRegionRegion *string) *GetServiceSummariesParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get service summaries params
func (o *GetServiceSummariesParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the get service summaries params
func (o *GetServiceSummariesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *GetServiceSummariesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the get service summaries params
func (o *GetServiceSummariesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the get service summaries params
func (o *GetServiceSummariesParams) WithPaginationPageSize(paginationPageSize *int64) *GetServiceSummariesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the get service summaries params
func (o *GetServiceSummariesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the get service summaries params
func (o *GetServiceSummariesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *GetServiceSummariesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the get service summaries params
func (o *GetServiceSummariesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WriteToRequest writes these params to a swagger request
func (o *GetServiceSummariesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.FilterClusters != nil {

		// binding items for filter.clusters
		joinedFilterClusters := o.bindParamFilterClusters(reg)

		// query array param filter.clusters
		if err := r.SetQueryParam("filter.clusters", joinedFilterClusters...); err != nil {
			return err
		}
	}

	if o.FilterKinds != nil {

		// binding items for filter.kinds
		joinedFilterKinds := o.bindParamFilterKinds(reg)

		// query array param filter.kinds
		if err := r.SetQueryParam("filter.kinds", joinedFilterKinds...); err != nil {
			return err
		}
	}

	if o.FilterNameSubstr != nil {

		// query param filter.name_substr
		var qrFilterNameSubstr string

		if o.FilterNameSubstr != nil {
			qrFilterNameSubstr = *o.FilterNameSubstr
		}
		qFilterNameSubstr := qrFilterNameSubstr
		if qFilterNameSubstr != "" {

			if err := r.SetQueryParam("filter.name_substr", qFilterNameSubstr); err != nil {
				return err
			}
		}
	}

	if o.FilterNamespaces != nil {

		// binding items for filter.namespaces
		joinedFilterNamespaces := o.bindParamFilterNamespaces(reg)

		// query array param filter.namespaces
		if err := r.SetQueryParam("filter.namespaces", joinedFilterNamespaces...); err != nil {
			return err
		}
	}

	if o.FilterPartitions != nil {

		// binding items for filter.partitions
		joinedFilterPartitions := o.bindParamFilterPartitions(reg)

		// query array param filter.partitions
		if err := r.SetQueryParam("filter.partitions", joinedFilterPartitions...); err != nil {
			return err
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetServiceSummaries binds the parameter filter.clusters
func (o *GetServiceSummariesParams) bindParamFilterClusters(formats strfmt.Registry) []string {
	filterClustersIR := o.FilterClusters

	var filterClustersIC []string
	for _, filterClustersIIR := range filterClustersIR { // explode []string

		filterClustersIIV := filterClustersIIR // string as string
		filterClustersIC = append(filterClustersIC, filterClustersIIV)
	}

	// items.CollectionFormat: "multi"
	filterClustersIS := swag.JoinByFormat(filterClustersIC, "multi")

	return filterClustersIS
}

// bindParamGetServiceSummaries binds the parameter filter.kinds
func (o *GetServiceSummariesParams) bindParamFilterKinds(formats strfmt.Registry) []string {
	filterKindsIR := o.FilterKinds

	var filterKindsIC []string
	for _, filterKindsIIR := range filterKindsIR { // explode []string

		filterKindsIIV := filterKindsIIR // string as string
		filterKindsIC = append(filterKindsIC, filterKindsIIV)
	}

	// items.CollectionFormat: "multi"
	filterKindsIS := swag.JoinByFormat(filterKindsIC, "multi")

	return filterKindsIS
}

// bindParamGetServiceSummaries binds the parameter filter.namespaces
func (o *GetServiceSummariesParams) bindParamFilterNamespaces(formats strfmt.Registry) []string {
	filterNamespacesIR := o.FilterNamespaces

	var filterNamespacesIC []string
	for _, filterNamespacesIIR := range filterNamespacesIR { // explode []string

		filterNamespacesIIV := filterNamespacesIIR // string as string
		filterNamespacesIC = append(filterNamespacesIC, filterNamespacesIIV)
	}

	// items.CollectionFormat: "multi"
	filterNamespacesIS := swag.JoinByFormat(filterNamespacesIC, "multi")

	return filterNamespacesIS
}

// bindParamGetServiceSummaries binds the parameter filter.partitions
func (o *GetServiceSummariesParams) bindParamFilterPartitions(formats strfmt.Registry) []string {
	filterPartitionsIR := o.FilterPartitions

	var filterPartitionsIC []string
	for _, filterPartitionsIIR := range filterPartitionsIR { // explode []string

		filterPartitionsIIV := filterPartitionsIIR // string as string
		filterPartitionsIC = append(filterPartitionsIC, filterPartitionsIIV)
	}

	// items.CollectionFormat: "multi"
	filterPartitionsIS := swag.JoinByFormat(filterPartitionsIC, "multi")

	return filterPartitionsIS
}
