//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegate?language=objc)
#[doc(alias = "CTRunDelegateRef")]
#[repr(C)]
pub struct CTRunDelegate {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTRunDelegate {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTRunDelegate"> for CTRunDelegate {}
);

unsafe impl ConcreteType for CTRunDelegate {
    /// Returns the CFType of CTRunDelegate objects.
    #[doc(alias = "CTRunDelegateGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTRunDelegateGetTypeID() -> CFTypeID;
        }
        unsafe { CTRunDelegateGetTypeID() }
    }
}

/// The callback invoked when a CTRunDelegate is deallocated.
///
///
/// Parameter `refCon`: The value supplied to CTRunDelegateCreate.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegatedeallocatecallback?language=objc)
pub type CTRunDelegateDeallocateCallback = Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>;

/// The callback used to determine typographic ascent.
///
///
/// Parameter `refCon`: The value supplied to CTRunDelegateCreate.
///
///
/// Returns: A CGFloat value indicating the typographic ascent of glyphs to
/// which a run delegate pertains.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegategetascentcallback?language=objc)
pub type CTRunDelegateGetAscentCallback =
    Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> CGFloat>;

/// The callback used to determine typographic descent.
///
///
/// Parameter `refCon`: The value supplied to CTRunDelegateCreate.
///
///
/// Returns: A CGFloat value indicating the typographic descent of glyphs to
/// which a run delegate pertains.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegategetdescentcallback?language=objc)
pub type CTRunDelegateGetDescentCallback =
    Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> CGFloat>;

/// The callback used to determine width.
///
///
/// Parameter `refCon`: The value supplied to CTRunDelegateCreate.
///
///
/// Returns: A CGFloat value indicating the width of glyphs to which a run
/// delegate pertains. A value of 0.0 indicates that the glyphs
/// should not be drawn.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegategetwidthcallback?language=objc)
pub type CTRunDelegateGetWidthCallback =
    Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> CGFloat>;

/// Structure containing the callbacks of a CTRunDelegate.
///
///
/// These callbacks are provided by the owner of a run delegate and
/// are used to modify glyph metrics during layout. The values
/// returned by a delegate are applied to each glyph in the run(s)
/// corresponding to the attribute containing that delegate.
///
/// Field: version
/// The version number of the callbacks being passed in as a
/// parameter to CTRunDelegateCreate. This field should always
/// be set to kCTRunDelegateCurrentVersion.
///
/// Field: dealloc
/// The callback used when a CTRunDelegate's retain count reaches
/// 0 and the CTRunDelegate is deallocated. This callback may be
/// NULL.
///
/// Field: getAscent
/// The callback used to indicate the ascent of the
/// CTRunDelegate. This callback may be NULL, which is equivalent
/// to a getAscent callback that always returns 0.
///
/// Field: getDescent
/// The callback used to indicate the descent of the
/// CTRunDelegate. This callback may be NULL, which is equivalent
/// to a getDescent callback that always returns 0.
///
/// Field: getWidth
/// The callback used to indicate the width of the
/// CTRunDelegate. This callback may be NULL, which is equivalent
/// to a getWidth callback that always returns 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrundelegatecallbacks?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CTRunDelegateCallbacks {
    pub version: CFIndex,
    pub dealloc: CTRunDelegateDeallocateCallback,
    pub getAscent: CTRunDelegateGetAscentCallback,
    pub getDescent: CTRunDelegateGetDescentCallback,
    pub getWidth: CTRunDelegateGetWidthCallback,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTRunDelegateCallbacks {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <CTRunDelegateDeallocateCallback>::ENCODING,
            <CTRunDelegateGetAscentCallback>::ENCODING,
            <CTRunDelegateGetDescentCallback>::ENCODING,
            <CTRunDelegateGetWidthCallback>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTRunDelegateCallbacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctrundelegateversion1?language=objc)
pub const kCTRunDelegateVersion1: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctrundelegatecurrentversion?language=objc)
pub const kCTRunDelegateCurrentVersion: c_uint = kCTRunDelegateVersion1;

impl CTRunDelegate {
    /// Creates an immutable instance of a run delegate.
    ///
    ///
    /// This function creates an immutable instance of a run delegate
    /// that can be used for reserving space in a line or for eliding the
    /// glyphs for a range of text altogether.
    ///
    ///
    /// Parameter `callbacks`: The callbacks for this run delegate.
    ///
    ///
    /// Returns: If run delegate creation was successful, this function will
    /// return a valid reference to an immutable CTRunDelegate
    /// object. Otherwise, this function will return NULL.
    ///
    /// # Safety
    ///
    /// - `callbacks` must be a valid pointer.
    /// - `ref_con` must be a valid pointer or null.
    #[doc(alias = "CTRunDelegateCreate")]
    #[inline]
    pub unsafe fn new(
        callbacks: NonNull<CTRunDelegateCallbacks>,
        ref_con: *mut c_void,
    ) -> Option<CFRetained<CTRunDelegate>> {
        extern "C-unwind" {
            fn CTRunDelegateCreate(
                callbacks: NonNull<CTRunDelegateCallbacks>,
                ref_con: *mut c_void,
            ) -> Option<NonNull<CTRunDelegate>>;
        }
        let ret = unsafe { CTRunDelegateCreate(callbacks, ref_con) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a run delegate's refCon value.
    ///
    ///
    /// This function returns the refCon value that a run delegate was
    /// created with.
    ///
    ///
    /// Parameter `runDelegate`: The run delegate to be queried.
    ///
    ///
    /// Returns: The refCon value of the supplied run delegate.
    #[doc(alias = "CTRunDelegateGetRefCon")]
    #[inline]
    pub unsafe fn ref_con(&self) -> NonNull<c_void> {
        extern "C-unwind" {
            fn CTRunDelegateGetRefCon(run_delegate: &CTRunDelegate) -> Option<NonNull<c_void>>;
        }
        let ret = unsafe { CTRunDelegateGetRefCon(self) };
        ret.expect("function was marked as returning non-null, but actually returned NULL")
    }
}

#[cfg(feature = "objc2")]
extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctadaptiveimageproviding?language=objc)
    #[cfg(feature = "objc2")]
    pub unsafe trait CTAdaptiveImageProviding {
        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// - `out_image_offset` must be a valid pointer.
        /// - `out_image_size` must be a valid pointer.
        #[unsafe(method(imageForProposedSize:scaleFactor:imageOffset:imageSize:))]
        #[unsafe(method_family = none)]
        unsafe fn imageForProposedSize_scaleFactor_imageOffset_imageSize(
            &self,
            proposed_size: CGSize,
            scale_factor: CGFloat,
            out_image_offset: NonNull<CGPoint>,
            out_image_size: NonNull<CGSize>,
        ) -> Option<Retained<CGImage>>;
    }
);

#[deprecated = "renamed to `CTRunDelegate::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRunDelegateCreate(
    callbacks: NonNull<CTRunDelegateCallbacks>,
    ref_con: *mut c_void,
) -> Option<CFRetained<CTRunDelegate>> {
    extern "C-unwind" {
        fn CTRunDelegateCreate(
            callbacks: NonNull<CTRunDelegateCallbacks>,
            ref_con: *mut c_void,
        ) -> Option<NonNull<CTRunDelegate>>;
    }
    let ret = unsafe { CTRunDelegateCreate(callbacks, ref_con) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTRunDelegate::ref_con`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRunDelegateGetRefCon(
    run_delegate: &CTRunDelegate,
) -> NonNull<c_void> {
    extern "C-unwind" {
        fn CTRunDelegateGetRefCon(run_delegate: &CTRunDelegate) -> Option<NonNull<c_void>>;
    }
    let ret = unsafe { CTRunDelegateGetRefCon(run_delegate) };
    ret.expect("function was marked as returning non-null, but actually returned NULL")
}
