% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-batch.R
\name{record_batch}
\alias{record_batch}
\title{Create a RecordBatch}
\usage{
record_batch(..., schema = NULL)
}
\arguments{
\item{...}{A \code{data.frame} or a named set of Arrays or vectors. If given a
mixture of data.frames and vectors, the inputs will be autospliced together
(see examples). Alternatively, you can provide a single Arrow IPC
\code{InputStream}, \code{Message}, \code{Buffer}, or R \code{raw} object containing a \code{Buffer}.}

\item{schema}{a \link{Schema}, or \code{NULL} (the default) to infer the schema from
the data in \code{...}. When providing an Arrow IPC buffer, \code{schema} is required.}
}
\description{
Create a RecordBatch
}
\examples{
batch <- record_batch(name = rownames(mtcars), mtcars)
dim(batch)
dim(head(batch))
names(batch)
batch$mpg
batch[["cyl"]]
as.data.frame(batch[4:8, c("gear", "hp", "wt")])
}
