// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals all --version 6
// REQUIRES: amdgpu-registered-target

// RUN: %clang_cc1 -fopenmp -x c -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -o - | FileCheck %s --check-prefix=HOST
// RUN: %clang_cc1 -fopenmp -x c -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=DEVICE

//.
// HOST: @__One_var = global i32 1, align 4
// HOST: @__Two_var = global i32 2, align 4
// HOST: @__Three_var = global i32 3, align 4
// HOST: @.offloading.entry_name = internal unnamed_addr constant [10 x i8] c"__Two_var\00", section ".llvm.rodata.offloading", align 1
// HOST: @.offloading.entry.__Two_var = weak constant %struct.__tgt_offload_entry { i64 0, i16 1, i16 1, i32 0, ptr @__Two_var, ptr @.offloading.entry_name, i64 4, i64 0, ptr null }, section "llvm_offload_entries", align 8
// HOST: @.offloading.entry_name.1 = internal unnamed_addr constant [12 x i8] c"__Three_var\00", section ".llvm.rodata.offloading", align 1
// HOST: @.offloading.entry.__Three_var = weak constant %struct.__tgt_offload_entry { i64 0, i16 1, i16 1, i32 0, ptr @__Three_var, ptr @.offloading.entry_name.1, i64 4, i64 0, ptr null }, section "llvm_offload_entries", align 8
// HOST: @One = weak alias i32 (), ptr @__One
// HOST: @One_ = alias i32 (), ptr @__One
// HOST: @One_var = weak alias i32, ptr @__One_var
// HOST: @One_var_ = alias i32, ptr @__One_var
// HOST: @Two = weak alias i32 (), ptr @__Two
// HOST: @Two_ = alias i32 (), ptr @__Two
// HOST: @Two_var = weak alias i32, ptr @__Two_var
// HOST: @Two_var_ = alias i32, ptr @__Two_var
// HOST: @Three = weak alias i32 (), ptr @__Three
// HOST: @Three_ = alias i32 (), ptr @__Three
// HOST: @Three_var = weak alias i32, ptr @__Three_var
// HOST: @Three_var_ = alias i32, ptr @__Three_var
//.
// DEVICE: @__Two_var = addrspace(1) global i32 2, align 4
// DEVICE: @__Three_var = addrspace(1) global i32 3, align 4
// DEVICE: @Two = weak hidden alias i32 (), ptr @__Two
// DEVICE: @Two_ = hidden alias i32 (), ptr @__Two
// DEVICE: @Two_var = weak alias i32, addrspacecast (ptr addrspace(1) @__Two_var to ptr)
// DEVICE: @Two_var_ = alias i32, addrspacecast (ptr addrspace(1) @__Two_var to ptr)
// DEVICE: @Three = weak hidden alias i32 (), ptr @__Three
// DEVICE: @Three.1 = weak hidden alias i32 (), ptr @__Three
// DEVICE: @Three_ = hidden alias i32 (), ptr @__Three
// DEVICE: @Three_.2 = hidden alias i32 (), ptr @__Three
// DEVICE: @Three_var = weak alias i32, addrspacecast (ptr addrspace(1) @__Three_var to ptr)
// DEVICE: @Three_var_ = alias i32, addrspacecast (ptr addrspace(1) @__Three_var to ptr)
//.
// HOST-LABEL: define dso_local i32 @__One(
// HOST-SAME: ) #[[ATTR0:[0-9]+]] {
// HOST-NEXT:  [[ENTRY:.*:]]
// HOST-NEXT:    ret i32 1
//
int __One(void) { return 1; }
int One(void) __attribute__ ((weak, alias("__One")));
int One_(void) __attribute__ ((alias("__One")));

int __One_var = 1;
extern int __attribute__((weak, alias("__One_var"))) One_var;
extern int __attribute__((alias("__One_var"))) One_var_;

#pragma omp declare target
// HOST-LABEL: define dso_local i32 @__Two(
// HOST-SAME: ) #[[ATTR0]] {
// HOST-NEXT:  [[ENTRY:.*:]]
// HOST-NEXT:    ret i32 2
//
// DEVICE-LABEL: define hidden i32 @__Two(
// DEVICE-SAME: ) #[[ATTR0:[0-9]+]] {
// DEVICE-NEXT:  [[ENTRY:.*:]]
// DEVICE-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4, addrspace(5)
// DEVICE-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// DEVICE-NEXT:    ret i32 2
//
int __Two(void) { return 2; }
int Two(void) __attribute__ ((weak, alias("__Two")));
int Two_(void) __attribute__ ((alias("__Two")));

int __Two_var = 2;
extern int __attribute__((weak, alias("__Two_var"))) Two_var;
extern int __attribute__((alias("__Two_var"))) Two_var_;
#pragma omp end declare target

#pragma omp declare target
// HOST-LABEL: define dso_local i32 @__Three(
// HOST-SAME: ) #[[ATTR0]] {
// HOST-NEXT:  [[ENTRY:.*:]]
// HOST-NEXT:    ret i32 3
//
// DEVICE-LABEL: define hidden i32 @__Three(
// DEVICE-SAME: ) #[[ATTR0]] {
// DEVICE-NEXT:  [[ENTRY:.*:]]
// DEVICE-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4, addrspace(5)
// DEVICE-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// DEVICE-NEXT:    ret i32 3
//
int __Three(void) { return 3; }
int __Three_var = 3;
#pragma omp end declare target
int Three(void) __attribute__ ((weak, alias("__Three")));
int Three_(void) __attribute__ ((alias("__Three")));
extern int __attribute__((weak, alias("__Three_var"))) Three_var;
extern int __attribute__((alias("__Three_var"))) Three_var_;
