/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.DB2Messages;

public enum DB2TableTruncateOptions {
    dropStorage(DB2Messages.dialog_table_tools_truncate_drop_storage, "DROP STORAGE"),
    reuseStorage(DB2Messages.dialog_table_tools_truncate_reuse_storage, "REUSE STORAGE"),
    ignoreDeleteTriggers(DB2Messages.dialog_table_tools_truncate_ignore_delete_triggers, "IGNORE DELETE TRIGGERS"),
    restrictWhenDeleteTriggers(DB2Messages.dialog_table_tools_truncate_restrict_when_delete_triggers, "RESTRICT WHEN DELETE TRIGGERS");

    private final String desc;
    private final String ddlString;

    private DB2TableTruncateOptions(String desc, String ddl) {
        this.desc = desc;
        this.ddlString = ddl;
    }

    public static DB2TableTruncateOptions getOption(String description) {
        if (description != null) {
            DB2TableTruncateOptions[] dB2TableTruncateOptionsArray = DB2TableTruncateOptions.values();
            int n = dB2TableTruncateOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DB2TableTruncateOptions option = dB2TableTruncateOptionsArray[n2];
                if (option.desc.equals(description)) {
                    return option;
                }
                ++n2;
            }
        }
        return null;
    }

    @NotNull
    public String getDesc() {
        return this.desc;
    }

    @NotNull
    public String getDdlString() {
        return this.ddlString;
    }
}

