/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.CIDA;
import org.eclipse.swt.internal.win32.DROPFILES;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String CF_HDROP = "CF_HDROP";
    private static final int CF_HDROPID = 15;
    private static final String CFSTR_SHELLIDLIST = "Shell IDList Array";
    private static final int CFSTR_SHELLIDLISTID = FileTransfer.registerType("Shell IDList Array");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] fileNames = (String[])object;
        long newPtr = 0L;
        if (transferData.type == 15) {
            StringBuilder allFiles = new StringBuilder();
            for (String fileName : fileNames) {
                allFiles.append(fileName);
                allFiles.append('\u0000');
            }
            allFiles.append('\u0000');
            char[] buffer = new char[allFiles.length()];
            allFiles.getChars(0, allFiles.length(), buffer, 0);
            DROPFILES dropfiles = new DROPFILES();
            dropfiles.pFiles = DROPFILES.sizeof;
            dropfiles.pt_y = 0;
            dropfiles.pt_x = 0;
            dropfiles.fNC = 0;
            dropfiles.fWide = 1;
            int byteCount = buffer.length * 2;
            newPtr = OS.GlobalAlloc(64, DROPFILES.sizeof + byteCount);
            if (newPtr != 0L) {
                OS.MoveMemory(newPtr, dropfiles, DROPFILES.sizeof);
                OS.MoveMemory(newPtr + (long)DROPFILES.sizeof, buffer, byteCount);
            }
        } else if (transferData.type == CFSTR_SHELLIDLISTID) {
            newPtr = this.generateCidaFromFilepaths(fileNames);
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = newPtr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = newPtr != 0L ? 0 : -2147467259;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject dataObject = new IDataObject(transferData.pIDataObject);
        dataObject.AddRef();
        FORMATETC formatetc = new FORMATETC();
        formatetc.cfFormat = 15;
        formatetc.ptd = 0L;
        formatetc.dwAspect = 1;
        formatetc.lindex = -1;
        formatetc.tymed = 1;
        STGMEDIUM stgmedium = new STGMEDIUM();
        stgmedium.tymed = 1;
        transferData.result = this.getData(dataObject, formatetc, stgmedium);
        dataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int count = OS.DragQueryFile(stgmedium.unionField, -1, null, 0);
        String[] fileNames = new String[count];
        for (int i = 0; i < count; ++i) {
            int size = OS.DragQueryFile(stgmedium.unionField, i, null, 0);
            char[] lpszFile = new char[size + 1];
            OS.DragQueryFile(stgmedium.unionField, i, lpszFile, size + 1);
            fileNames[i] = new String(lpszFile, 0, size);
        }
        OS.DragFinish(stgmedium.unionField);
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateCidaFromFilepaths(String[] fileNames) {
        int n = fileNames.length;
        long[] pidls = new long[n];
        try {
            int cidaSize;
            CIDA cida = new CIDA();
            cida.cidl = n;
            cida.aoffset = cidaSize = CIDA.sizeof + 4 * n;
            int[] pidlOffsets = new int[n];
            int[] pidlSizes = new int[n];
            int pidlSizeSum = 2;
            for (int i = 0; i < n; ++i) {
                TCHAR szfileName = new TCHAR(0, fileNames[i], true);
                long[] ppv = new long[1];
                int hr = COM.PathToPIDL(szfileName.chars, ppv);
                if (hr != 0) {
                    long l = 0L;
                    return l;
                }
                pidls[i] = ppv[0];
                pidlSizes[i] = OS.ILGetSize(pidls[i]);
                pidlSizeSum += pidlSizes[i];
                if (i == 0) {
                    pidlOffsets[0] = cidaSize + 2;
                    continue;
                }
                pidlOffsets[i] = pidlOffsets[i - 1] + pidlSizes[i - 1];
            }
            long newPtr = OS.GlobalAlloc(64, cidaSize + pidlSizeSum);
            if (newPtr != 0L) {
                OS.MoveMemory(newPtr, cida, CIDA.sizeof);
                OS.MoveMemory(newPtr + (long)CIDA.sizeof, pidlOffsets, 4 * cida.cidl);
                for (int i = 0; i < n; ++i) {
                    OS.MoveMemory(newPtr + (long)pidlOffsets[i], pidls[i], pidlSizes[i]);
                }
            }
            long l = newPtr;
            return l;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                if (pidls[i] == 0L) continue;
                OS.CoTaskMemFree(pidls[i]);
            }
        }
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData != null && transferData.pIDataObject != 0L && transferData.type == CFSTR_SHELLIDLISTID) {
            return false;
        }
        return super.isSupportedType(transferData);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{15, CFSTR_SHELLIDLISTID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_HDROP, CFSTR_SHELLIDLIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        for (String string : (String[])object) {
            if (string != null && string.length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

