/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.em;

import com.thaiopensource.xml.tok.InvalidTokenException;
import com.thaiopensource.xml.tok.TextDecl;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncodingDetectInputStream
extends InputStream {
    private final InputStream in;
    private byte[] buf;
    private int avail = 0;
    private int start = 0;
    private static final short[] detectProg = new short[]{4, 0, 0, 254, 255, 3, 4, 4, 0, 4, 255, 254, 0, 0, 0, 4, 4, 0, 4, 0, 0, 255, 254, 2, 4, 4, 0, 4, 254, 255, 0, 0, 1, 4, 4, 0, 2, 254, 255, 1, 2, 2, 0, 2, 255, 254, 0, 2, 2, 0, 3, 239, 187, 191, 0, 1, 3, 0, 4, 0, 0, 0, 60, 3, 4, 0, 0, 4, 60, 0, 0, 0, 0, 4, 0, 0, 4, 0, 0, 60, 0, 2, 4, 0, 0, 4, 0, 60, 0, 0, 1, 4, 0, 0, 4, 0, 60, 0, 63, 1, 2, 0, 0, 4, 60, 0, 63, 0, 0, 2, 0, 0, 4, 60, 63, 120, 109, 0, 1, 0, 0, 4, 76, 111, 167, 148, 0, 1, 0, 1};
    static final int NPARMS = 4;
    private static final String OPEN = "<?xml";
    static final String EBCDIC_ENCODING = "Cp037";
    private static final int INIT_BUF_SIZE = 80;

    public EncodingDetectInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public String detectEncoding() throws IOException {
        int n;
        boolean bl;
        int n2;
        this.makeAvailable(4);
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < detectProg.length; i += n2 + 4) {
            if (this.avail < (n2 = detectProg[i++])) continue;
            bl = true;
            for (n = 0; n < n2; ++n) {
                if ((this.buf[this.start + n] & 0xFF) == detectProg[i + n]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            i += n2;
            n4 = detectProg[i++];
            n3 = detectProg[i++];
            n5 = detectProg[i++];
            n6 = detectProg[i++];
            break;
        }
        n2 = 0;
        bl = false;
        n = 0;
        while (this.makeAvailable((n2 + 1) * n3 + n5)) {
            int n7;
            byte by = this.buf[this.start + n5 + n2 * n3 + n4];
            for (n7 = 0; n7 < n3; ++n7) {
                if (n7 == n4 || this.buf[this.start + n5 + n2 * n3 + n7] == 0) continue;
                throw new CharConversionException("non-ASCII character in encoding declaration");
            }
            n7 = EncodingDetectInputStream.convertByte(by, n6);
            if (n7 >= 128) {
                throw new CharConversionException("non-ASCII character in encoding declaration");
            }
            if (n2 < OPEN.length()) {
                if (n7 != OPEN.charAt(n2)) {
                    break;
                }
            } else if (n7 == 63) {
                bl = true;
            } else {
                if (n7 == 62 && bl) {
                    n = 1;
                    ++n2;
                    break;
                }
                bl = false;
            }
            ++n2;
        }
        String string = null;
        if (n != 0) {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = EncodingDetectInputStream.convertByte(this.buf[this.start + n5 + i * n3 + n4], n6);
            }
            try {
                TextDecl textDecl = new TextDecl(cArray, 0, cArray.length);
                string = textDecl.getEncoding();
            }
            catch (InvalidTokenException invalidTokenException) {
                throw new CharConversionException("invalid text declaration");
            }
        }
        if (n3 == 1) {
            this.start += n5;
            this.avail -= n5;
        }
        if (string == null) {
            if (n3 == 2 && n5 == 0 || n3 > 2 || n6 != 0) {
                throw new CharConversionException("missing encoding declaration");
            }
            if (n3 == 2) {
                return "UTF-16";
            }
            return "UTF-8";
        }
        return string;
    }

    private static char convertByte(byte by, int n) throws IOException {
        if (n == 1) {
            String string = new String(new byte[]{by}, EBCDIC_ENCODING);
            if (string.length() != 1) {
                throw new CharConversionException();
            }
            return string.charAt(0);
        }
        return (char)(by & 0xFF);
    }

    private boolean makeAvailable(int n) throws IOException {
        int n2;
        if (this.avail >= n) {
            return true;
        }
        if (this.buf == null) {
            this.buf = new byte[n > 80 ? n : 80];
        } else if (n > this.buf.length - this.start) {
            if (this.buf.length >= n) {
                for (n2 = 0; n2 < this.avail; ++n2) {
                    this.buf[n2] = this.buf[n2 + this.start];
                }
                this.start = 0;
            } else {
                n2 = this.buf.length * 2;
                n2 = n > n2 ? n : n2;
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buf, this.start, byArray, 0, this.avail);
                this.buf = byArray;
            }
        }
        do {
            if ((n2 = this.in.read(this.buf, this.start + this.avail, this.buf.length - this.start - this.avail)) == -1) {
                return false;
            }
            this.avail += n2;
        } while (this.avail < n);
        return true;
    }

    public int read() throws IOException {
        if (this.avail > 0) {
            --this.avail;
            return this.buf[this.start++] & 0xFF;
        }
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.avail > 0) {
            int n3;
            if (this.avail >= n2) {
                if (byArray != null) {
                    System.arraycopy(this.buf, this.start, byArray, n, n2);
                }
                this.start += n2;
                this.avail -= n2;
                return n2;
            }
            if (byArray != null) {
                System.arraycopy(this.buf, this.start, byArray, n, this.avail);
            }
            n3 = (n3 = this.read(byArray, n + this.avail, n2 - this.avail)) < 0 ? this.avail : (n3 += this.avail);
            this.avail = 0;
            return n3;
        }
        return this.in.read(byArray, n, n2);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(new EncodingDetectInputStream(new FileInputStream(stringArray[0])).detectEncoding());
    }
}

