/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.context.handler;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ProcessingContext;
import com.intellij.vcs.github.ultimate.features.context.ContextElementResolver;
import com.intellij.vcs.github.ultimate.features.context.ReferenceContext;
import com.intellij.vcs.github.ultimate.features.context.handler.MatrixContext$MatrixResolver$getReferenceCandidates$;
import com.intellij.vcs.github.ultimate.features.context.handler.MatrixContext$MatrixResolver$getReferenceCandidates$lambda$1$;
import com.intellij.vcs.github.ultimate.features.workflow.GitHubWorkflowUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.context.YamlPatternsKt;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/github/ultimate/features/context/handler/MatrixContext;", "Lcom/intellij/vcs/github/ultimate/features/context/ReferenceContext;", "<init>", "()V", "referencePrefixRegex", "Lkotlin/text/Regex;", "getReferencePrefixRegex", "()Lkotlin/text/Regex;", "completePrefixRegex", "getCompletePrefixRegex", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "resolver", "Lcom/intellij/vcs/github/ultimate/features/context/ContextElementResolver;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getResolver", "()Lcom/intellij/vcs/github/ultimate/features/context/ContextElementResolver;", "calculateRange", "Lcom/intellij/openapi/util/TextRange;", "matchResult", "Lkotlin/text/MatchResult;", "MatrixResolver", "intellij.vcs.github.ultimate.features"})
public final class MatrixContext
extends ReferenceContext {
    @NotNull
    public static final MatrixContext INSTANCE = new MatrixContext();
    @NotNull
    private static final Regex referencePrefixRegex = new Regex("(matrix)\\.([a-zA-Z0-9_-]+)");
    @NotNull
    private static final Regex completePrefixRegex = new Regex("matrix");
    @NotNull
    private static final Icon icon;
    @NotNull
    private static final ContextElementResolver<? extends YAMLPsiElement> resolver;

    private MatrixContext() {
    }

    @Override
    @NotNull
    protected Regex getReferencePrefixRegex() {
        return referencePrefixRegex;
    }

    @Override
    @NotNull
    protected Regex getCompletePrefixRegex() {
        return completePrefixRegex;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public ContextElementResolver<? extends YAMLPsiElement> getResolver() {
        return resolver;
    }

    @Override
    @NotNull
    protected TextRange calculateRange(@NotNull MatchResult matchResult) {
        MatchGroup matchGroup;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        MatchGroup matchGroup2 = matchResult.getGroups().get(2);
        return new TextRange(matchGroup2 != null && (matchGroup2 = matchGroup2.getRange()) != null ? matchGroup2.getFirst() : matchResult.getRange().getFirst(), ((matchGroup = matchResult.getGroups().get(2)) != null && (matchGroup = matchGroup.getRange()) != null ? matchGroup.getEndInclusive().intValue() : matchResult.getRange().getLast()) + 1);
    }

    static {
        Icon icon = AllIcons.Actions.GroupByModuleGroup;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GroupByModuleGroup");
        MatrixContext.icon = icon;
        resolver = new MatrixResolver();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/github/ultimate/features/context/handler/MatrixContext$MatrixResolver;", "Lcom/intellij/vcs/github/ultimate/features/context/ContextElementResolver;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "<init>", "()V", "resolvePsiElement", "Lcom/intellij/psi/PsiElement;", "reference", "Lcom/intellij/psi/PsiReference;", "getReferenceCandidates", "Lkotlin/sequences/Sequence;", "scope", "calculateResolveScope", "element", "intellij.vcs.github.ultimate.features"})
    @SourceDebugExtension(value={"SMAP\nMatrixContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatrixContext.kt\ncom/intellij/vcs/github/ultimate/features/context/handler/MatrixContext$MatrixResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ActionYamlPatterns.kt\ncom/intellij/vcs/github/ultimate/features/context/ActionYamlPatternsKt\n+ 4 YamlPatterns.kt\norg/jetbrains/yaml/context/YamlPatternsKt\n*L\n1#1,52:1\n183#2,2:53\n477#2:55\n22#3:56\n14#3,7:57\n22#4,8:64\n*S KotlinDebug\n*F\n+ 1 MatrixContext.kt\ncom/intellij/vcs/github/ultimate/features/context/handler/MatrixContext$MatrixResolver\n*L\n37#1:53,2\n42#1:55\n43#1:56\n43#1:57,7\n43#1:64,8\n*E\n"})
    public static final class MatrixResolver
    implements ContextElementResolver<YAMLKeyValue> {
        @Override
        @Nullable
        public PsiElement resolvePsiElement(@NotNull PsiReference reference) {
            Object v2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String string = reference.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                String text = string;
                PsiElement psiElement = reference.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                PsiElement scope = this.calculateResolveScope(psiElement);
                Sequence<YAMLKeyValue> $this$firstOrNull$iv = this.getReferenceCandidates(scope);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    YAMLKeyValue it = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKeyText(), (Object)text)) continue;
                    v2 = element$iv;
                    break block1;
                }
                v2 = null;
            }
            return v2;
        }

        @Override
        @NotNull
        public Sequence<YAMLKeyValue> getReferenceCandidates(@NotNull PsiElement scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)scope);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)syntaxTraverser));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)MatrixResolver$getReferenceCandidates$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return SequencesKt.filter((Sequence)sequence, MatrixResolver::getReferenceCandidates$lambda$1);
        }

        @Override
        @NotNull
        public PsiElement calculateResolveScope(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            YAMLKeyValue yAMLKeyValue = GitHubWorkflowUtilKt.getParentJob(element);
            if (yAMLKeyValue == null || (yAMLKeyValue = yAMLKeyValue.getValue()) == null) {
                return element;
            }
            return (PsiElement)yAMLKeyValue;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean getReferenceCandidates$lambda$1(YAMLKeyValue psiElement) {
            void keyTextValue$iv;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            String[] stringArray = new String[]{"jobs\\.[a-zA-Z_][a-zA-Z0-9_-]*\\.strategy\\.matrix\\.[a-zA-Z_][a-zA-Z0-9_-]*"};
            boolean $i$f$yamlKeysPattern = false;
            List keys$iv$iv = ArraysKt.toList((Object[])keyTextValue$iv);
            boolean $i$f$yamlKeysPattern2 = false;
            List keys$iv$iv$iv = keys$iv$iv;
            boolean $i$f$yamlKeysPatternCondition = false;
            ObjectPattern objectPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(){

                public boolean accepts(PsiElement element, ProcessingContext context) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    return GithubYamlFileDetectionKt.isGithubActionsFile(element.getContainingFile());
                }
            })).with((PatternCondition)new PatternCondition<PsiElement>(keys$iv$iv$iv){
                private final List<Regex> regexList;
                {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = $keys;
                    MatrixResolver$getReferenceCandidates$lambda$1$$inlined$yamlKeysPattern$1 var3_3 = this;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new Regex((String)it));
                    }
                    var3_3.regexList = (List)destination$iv$iv;
                }

                public final List<Regex> getRegexList() {
                    return this.regexList;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accepts(PsiElement element, ProcessingContext context) {
                    CharSequence charSequence;
                    Regex it;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (!(element instanceof YAMLKeyValue)) return false;
                    Iterable $this$any$iv = this.regexList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator<T> iterator = $this$any$iv.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        T element$iv = iterator.next();
                        it = (Regex)element$iv;
                        boolean bl = false;
                        charSequence = StringUtil.newBombedCharSequence((CharSequence)YamlPatternsKt.fullYamlKey((PsiElement)element), (long)1000L);
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
                    } while (!it.matches(charSequence));
                    return true;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
            return ((PsiElementPattern.Capture)objectPattern).accepts((Object)psiElement);
        }
    }
}

