/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.utils.PatternsKt;
import com.intellij.docker.dockerFile.utils.UtilsKt;
import com.intellij.docker.image.DockerPullIntentionHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/dockerFile/DockerFilePullIntentionHelper;", "Lcom/intellij/docker/image/DockerPullIntentionHelper;", "<init>", "()V", "pattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "getDockerRepoTag", "Lcom/intellij/docker/agent/DockerRepoTag;", "intellij.clouds.docker.file"})
public final class DockerFilePullIntentionHelper
implements DockerPullIntentionHelper {
    @NotNull
    private final PsiElementPattern.Capture<PsiElement> pattern = PatternsKt.isDockerImagePsiElementPattern();

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.pattern.accepts((Object)element);
    }

    @NotNull
    public DockerRepoTag getDockerRepoTag(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        DockerFileFromCommand from;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DockerFileFromCommand dockerFileFromCommand = from = UtilsKt.findFromCommand(element);
        List<Object> nodes = dockerFileFromCommand != null ? UtilsKt.findImageNodes(dockerFileFromCommand) : null;
        List<PsiElement> list = nodes;
        if (list == null || (list = UtilsKt.getText(list)) == null) {
            list = "";
        }
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString((String)((Object)list));
        Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
        return dockerRepoTag;
    }
}

