/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;

class HijackingHttpRequestExecutor
extends HttpRequestExecutor {
    static final String HIJACKED_INPUT_ATTRIBUTE = "com.github.docker-java.hijackedInput";

    HijackingHttpRequestExecutor(ConnectionReuseStrategy connectionReuseStrategy) {
        super(connectionReuseStrategy);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request2, HttpClientConnection conn, HttpResponseInformationCallback informationCallback, HttpContext context) throws IOException, HttpException {
        Objects.requireNonNull(request2, "HTTP request");
        Objects.requireNonNull(conn, "Client connection");
        Objects.requireNonNull(context, "HTTP context");
        InputStream hijackedInput = (InputStream)context.getAttribute(HIJACKED_INPUT_ATTRIBUTE);
        if (hijackedInput != null) {
            return HijackingHttpRequestExecutor.executeHijacked(request2, conn, context, hijackedInput);
        }
        return super.execute(request2, conn, informationCallback, context);
    }

    private static ClassicHttpResponse executeHijacked(ClassicHttpRequest request2, HttpClientConnection conn, HttpContext context, InputStream hijackedInput) throws HttpException, IOException {
        try {
            context.setAttribute("http.ssl-session", (Object)conn.getSSLSession());
            context.setAttribute("http.connection-endpoint", (Object)conn.getEndpointDetails());
            ProtocolVersion transportVersion = request2.getVersion();
            if (transportVersion != null) {
                context.setProtocolVersion(transportVersion);
            }
            conn.sendRequestHeader(request2);
            conn.sendRequestEntity(request2);
            conn.flush();
            ClassicHttpResponse response = conn.receiveResponseHeader();
            if (response.getCode() != 101) {
                conn.terminateRequest(request2);
                throw new ProtocolException("Expected 101 Switching Protocols, got: " + String.valueOf(new StatusLine((HttpResponse)response)));
            }
            Thread thread = new Thread(() -> {
                try {
                    BasicClassicHttpRequest fakeRequest = new BasicClassicHttpRequest("POST", "/");
                    fakeRequest.setHeader("Content-Length", (Object)Long.MAX_VALUE);
                    fakeRequest.setEntity((HttpEntity)new HijackedEntity(hijackedInput));
                    conn.sendRequestEntity((ClassicHttpRequest)fakeRequest);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, "docker-via-ssh-httpclient5-hijacking-stream-" + System.identityHashCode(request2));
            thread.setDaemon(true);
            thread.start();
            response.setCode(200);
            conn.receiveResponseEntity(response);
            return response;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            Closer.closeQuietly((Closeable)conn);
            throw ex;
        }
    }

    private static class HijackedEntity
    extends AbstractHttpEntity {
        private final InputStream inStream;

        HijackedEntity(InputStream inStream) {
            super((String)null, null, false);
            this.inStream = inStream;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            int read2;
            byte[] buffer = new byte[1024];
            while ((read2 = this.inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, read2);
                outStream.flush();
            }
        }

        public InputStream getContent() {
            return this.inStream;
        }

        public boolean isStreaming() {
            return true;
        }

        public void close() throws IOException {
            this.inStream.close();
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

