/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGLightingElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.Light;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.SpecularLightingRable8Bit;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeSpecularLightingElementBridge
extends AbstractSVGLightingElementBridge {
    @Override
    public String getLocalName() {
        return "feSpecularLighting";
    }

    @Override
    public Filter createFilter(BridgeContext ctx2, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        float surfaceScale = SVGFeSpecularLightingElementBridge.convertNumber(filterElement, "surfaceScale", 1.0f, ctx2);
        float specularConstant = SVGFeSpecularLightingElementBridge.convertNumber(filterElement, "specularConstant", 1.0f, ctx2);
        float specularExponent = SVGFeSpecularLightingElementBridge.convertSpecularExponent(filterElement, ctx2);
        Light light = SVGFeSpecularLightingElementBridge.extractLight(filterElement, ctx2);
        double[] kernelUnitLength = SVGFeSpecularLightingElementBridge.convertKernelUnitLength(filterElement, ctx2);
        Filter in = SVGFeSpecularLightingElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx2);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx2);
        SpecularLightingRable8Bit filter2 = new SpecularLightingRable8Bit(in, primitiveRegion, light, specularConstant, specularExponent, surfaceScale, kernelUnitLength);
        SVGFeSpecularLightingElementBridge.handleColorInterpolationFilters(filter2, filterElement);
        SVGFeSpecularLightingElementBridge.updateFilterMap(filterElement, filter2, filterMap);
        return filter2;
    }

    protected static float convertSpecularExponent(Element filterElement, BridgeContext ctx2) {
        String s = filterElement.getAttributeNS(null, "specularExponent");
        if (s.length() == 0) {
            return 1.0f;
        }
        try {
            float v = SVGUtilities.convertSVGNumber(s);
            if (v < 1.0f || v > 128.0f) {
                throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"specularConstant", s});
            }
            return v;
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx2, filterElement, nfEx, "attribute.malformed", new Object[]{"specularConstant", s, nfEx});
        }
    }
}

