/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintInspection;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TsLintConfiguration", storages={@Storage(value="jsLinters/tslint.xml")})
public class TsLintConfiguration
extends JSLinterConfiguration<TsLintState> {
    private static final String TSLINT_ELEMENT_NAME = "tslint";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String RULES = "rules";
    private static final String ALLOW_JS = "allowJs";
    private final JSLinterPackage myPackage;

    public TsLintConfiguration(@NotNull Project project) {
        if (project == null) {
            TsLintConfiguration.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPackage = new JSLinterPackage(project, TSLINT_ELEMENT_NAME, true);
    }

    @NotNull
    public static TsLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            TsLintConfiguration.$$$reportNull$$$0(1);
        }
        TsLintConfiguration tsLintConfiguration = (TsLintConfiguration)JSLinterConfiguration.getInstance((Project)project, TsLintConfiguration.class);
        if (tsLintConfiguration == null) {
            TsLintConfiguration.$$$reportNull$$$0(2);
        }
        return tsLintConfiguration;
    }

    protected void savePrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(3);
        }
        this.storeLinterLocalPaths(state);
    }

    @NotNull
    protected TsLintState loadPrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(4);
        }
        TsLintState.Builder builder = new TsLintState.Builder(state);
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(5);
        }
        return tsLintState;
    }

    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return TsLintInspection.class;
    }

    @Nullable
    protected Element toXml(@NotNull TsLintState state) {
        String rulesDirectory;
        String customConfigFilePath;
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(6);
        }
        Element root = new Element(TSLINT_ELEMENT_NAME);
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!StringUtil.isEmptyOrSpaces((String)(customConfigFilePath = state.getCustomConfigFilePath()))) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, customConfigFilePath);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(rulesDirectory = state.getRulesDirectory()))) {
            root.setAttribute(RULES, rulesDirectory);
        }
        if (state.isAllowJs()) {
            root.setAttribute(ALLOW_JS, String.valueOf(true));
        }
        this.storeLinterLocalPaths(state);
        return root;
    }

    @NotNull
    protected TsLintState fromXml(@NotNull Element element) {
        if (element == null) {
            TsLintConfiguration.$$$reportNull$$$0(7);
        }
        TsLintState.Builder builder = new TsLintState.Builder();
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(customConfigFilePath);
        String rulesDirectory = element.getAttributeValue(RULES);
        if (!StringUtil.isEmptyOrSpaces((String)rulesDirectory)) {
            builder.setRulesDirectory(rulesDirectory);
        }
        builder.setAllowJs(Boolean.parseBoolean(element.getAttributeValue(ALLOW_JS)));
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(8);
        }
        return tsLintState;
    }

    private void restoreLinterLocalPaths(TsLintState.Builder builder) {
        this.myPackage.readOrDetect();
        builder.setNodePackageRef(this.myPackage.getPackage());
    }

    private void storeLinterLocalPaths(TsLintState state) {
        this.myPackage.force(state.getNodePackageRef());
    }

    @NotNull
    protected TsLintState getDefaultState() {
        TsLintState tsLintState = TsLintState.DEFAULT;
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(9);
        }
        return tsLintState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 9 -> new IllegalStateException(string);
        };
    }
}

