/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwitchToCssDialectQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final CssDialect myToDialect;

    public SwitchToCssDialectQuickFix(CssDialect toDialect) {
        this.myToDialect = toDialect;
    }

    @NotNull
    public String getName() {
        String string = CssBundle.message("switch.to.css.dialect.quickfix.name", this.myToDialect.getDisplayName());
        if (string == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("switch.to.css.dialect.quickfix.fanily.name", new Object[0]);
        if (string == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(4);
        }
        this.doApplyFix(project, (PsiElement)psiFile);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            SwitchToCssDialectQuickFix.$$$reportNull$$$0(6);
        }
        this.doApplyFix(project, descriptor.getPsiElement());
    }

    private void doApplyFix(final Project project, PsiElement element) {
        final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        CssDialectMappings mappings = CssDialectMappings.getInstance(project);
        final String oldDialectName = (String)mappings.getMapping(virtualFile);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                CssDialectMappings.getInstance(project).setMapping(virtualFile, oldDialectName);
            }

            public void redo() {
                CssDialectMappings.getInstance(project).setMapping(virtualFile, SwitchToCssDialectQuickFix.this.myToDialect.getName());
            }
        });
        mappings.setMapping(virtualFile, this.myToDialect.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

