/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SliderKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.uml.utils.DiagramBundle;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myShowFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$ClusteringType;", "myViewModel", "Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog$MyViewModel;", "showAsync", "doOKAction", "", "doCancelAction", "getOKAction", "Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "MyViewModel", "intellij.diagram.impl"})
@SourceDebugExtension(value={"SMAP\nDiagramAutoClusteringDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagramAutoClusteringDialog.kt\ncom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,101:1\n27#2:102\n*S KotlinDebug\n*F\n+ 1 DiagramAutoClusteringDialog.kt\ncom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog\n*L\n97#1:102\n*E\n"})
public final class DiagramAutoClusteringDialog
extends DialogWrapper {
    @NotNull
    private final CompletableFuture<DiagramAlgorithmsService.ClusteringType> myShowFuture;
    @NotNull
    private final MyViewModel myViewModel;

    public DiagramAutoClusteringDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myShowFuture = new CompletableFuture();
        this.myViewModel = new MyViewModel(null, 0, 0, 7, null);
        this.init();
        this.setTitle(DiagramBundle.message("dialog.diagram.auto.clustering", new Object[0]));
    }

    @NotNull
    public final CompletableFuture<DiagramAlgorithmsService.ClusteringType> showAsync() {
        ApplicationManager.getApplication().invokeLater(() -> DiagramAutoClusteringDialog.showAsync$lambda$0(this));
        return this.myShowFuture;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myShowFuture.complete(this.myViewModel.getClustering());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myShowFuture.cancel(true);
    }

    @NotNull
    protected Action getOKAction() {
        Action action;
        Action action2 = super.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"getOKAction(...)");
        Action $this$getOKAction_u24lambda_u241 = action = action2;
        boolean bl = false;
        $this$getOKAction_u24lambda_u241.putValue("Name", DiagramBundle.message("dialog.diagram.auto.clustering.button.title", new Object[0]));
        return action;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel contentPanel2 = BuilderKt.panel(arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12(this, arg_0));
        return (JComponent)contentPanel2;
    }

    private static final void showAsync$lambda$0(DiagramAutoClusteringDialog this$0) {
        this$0.show();
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.auto.clustering.biconnected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.ClusteringType.Biconnected.class), (String)DiagramBundle.message("dialog.diagram.auto.clustering.biconnected.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.auto.clustering.edge.betweenness", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.ClusteringType.EdgeBetweenness.class), (String)DiagramBundle.message("dialog.diagram.auto.clustering.edge.betweenness.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$5$lambda$4(DiagramAutoClusteringDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SliderKt.bindValue((Cell)$this$row.slider(1, 10, 1, 1), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.myViewModel){

            public Object get() {
                return ((MyViewModel)this.receiver).getEdgeBetweennessQualityTimeRatio();
            }

            public void set(Object value) {
                ((MyViewModel)this.receiver).setEdgeBetweennessQualityTimeRatio(((Number)value).intValue());
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$5(DiagramAutoClusteringDialog this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = DiagramBundle.message("dialog.diagram.auto.clustering.quality.time.ratio", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final int createCenterPanel$lambda$12$lambda$9$lambda$8$lambda$6(DiagramAutoClusteringDialog this$0) {
        return this$0.myViewModel.getKMeansBound();
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$8$lambda$7(DiagramAutoClusteringDialog this$0, int it) {
        this$0.myViewModel.setKMeansBound(it);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9$lambda$8(DiagramAutoClusteringDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.auto.clustering.kmeans", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell button = Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.ClusteringType.KMeans.class), (String)DiagramBundle.message("dialog.diagram.auto.clustering.kmeans.description", new Object[0]), (int)0, null, (int)6, null);
        TextFieldKt.bindIntText((Cell)$this$row.intTextField(new IntRange(1, 100), Integer.valueOf(1)).enabledIf(ButtonKt.getSelected((Cell)button)), () -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9$lambda$8$lambda$6(this$0), arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9$lambda$8$lambda$7(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$9(DiagramAutoClusteringDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, DiagramAutoClusteringDialog::createCenterPanel$lambda$12$lambda$9$lambda$2, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, DiagramAutoClusteringDialog::createCenterPanel$lambda$12$lambda$9$lambda$3, (int)1, null);
        $this$buttonsGroup.indent(arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9$lambda$5(this$0, arg_0));
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9$lambda$8(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Class createCenterPanel$lambda$12$lambda$10(DiagramAutoClusteringDialog this$0) {
        return this$0.myViewModel.getClusteringType();
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11(DiagramAutoClusteringDialog this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.myViewModel.setClusteringType(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$12(DiagramAutoClusteringDialog this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)DiagramBundle.message("dialog.diagram.auto.clustering", new Object[0]), (boolean)false, arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$9(this$0, arg_0), (int)2, null);
        Function0 function0 = () -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$10(this$0);
        Function1 setter$iv = arg_0 -> DiagramAutoClusteringDialog.createCenterPanel$lambda$12$lambda$11(this$0, arg_0);
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Class.class);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\r\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J+\u0010\u0018\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramAutoClusteringDialog$MyViewModel;", "", "clusteringType", "Ljava/lang/Class;", "edgeBetweennessQualityTimeRatio", "", "kMeansBound", "<init>", "(Ljava/lang/Class;II)V", "getClusteringType", "()Ljava/lang/Class;", "setClusteringType", "(Ljava/lang/Class;)V", "getEdgeBetweennessQualityTimeRatio", "()I", "setEdgeBetweennessQualityTimeRatio", "(I)V", "getKMeansBound", "setKMeansBound", "getClustering", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$ClusteringType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.diagram.impl"})
    private static final class MyViewModel {
        @NotNull
        private Class<?> clusteringType;
        private int edgeBetweennessQualityTimeRatio;
        private int kMeansBound;

        public MyViewModel(@NotNull Class<?> clusteringType, int edgeBetweennessQualityTimeRatio, int kMeansBound) {
            Intrinsics.checkNotNullParameter(clusteringType, (String)"clusteringType");
            this.clusteringType = clusteringType;
            this.edgeBetweennessQualityTimeRatio = edgeBetweennessQualityTimeRatio;
            this.kMeansBound = kMeansBound;
        }

        public /* synthetic */ MyViewModel(Class clazz, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                clazz = DiagramAlgorithmsService.ClusteringType.EdgeBetweenness.class;
            }
            if ((n3 & 2) != 0) {
                n = 10;
            }
            if ((n3 & 4) != 0) {
                n2 = 5;
            }
            this(clazz, n, n2);
        }

        @NotNull
        public final Class<?> getClusteringType() {
            return this.clusteringType;
        }

        public final void setClusteringType(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
            this.clusteringType = clazz;
        }

        public final int getEdgeBetweennessQualityTimeRatio() {
            return this.edgeBetweennessQualityTimeRatio;
        }

        public final void setEdgeBetweennessQualityTimeRatio(int n) {
            this.edgeBetweennessQualityTimeRatio = n;
        }

        public final int getKMeansBound() {
            return this.kMeansBound;
        }

        public final void setKMeansBound(int n) {
            this.kMeansBound = n;
        }

        @NotNull
        public final DiagramAlgorithmsService.ClusteringType getClustering() {
            DiagramAlgorithmsService.ClusteringType clusteringType;
            Class<?> clazz = this.clusteringType;
            if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.Biconnected.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.Biconnected();
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.EdgeBetweenness.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.EdgeBetweenness((double)this.edgeBetweennessQualityTimeRatio / 10.0);
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.ClusteringType.KMeans.class)) {
                clusteringType = new DiagramAlgorithmsService.ClusteringType.KMeans(this.kMeansBound);
            } else {
                throw new IllegalStateException(("Unknown clustering type: " + this.clusteringType).toString());
            }
            return clusteringType;
        }

        @NotNull
        public final Class<?> component1() {
            return this.clusteringType;
        }

        public final int component2() {
            return this.edgeBetweennessQualityTimeRatio;
        }

        public final int component3() {
            return this.kMeansBound;
        }

        @NotNull
        public final MyViewModel copy(@NotNull Class<?> clusteringType, int edgeBetweennessQualityTimeRatio, int kMeansBound) {
            Intrinsics.checkNotNullParameter(clusteringType, (String)"clusteringType");
            return new MyViewModel(clusteringType, edgeBetweennessQualityTimeRatio, kMeansBound);
        }

        public static /* synthetic */ MyViewModel copy$default(MyViewModel myViewModel, Class clazz, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                clazz = myViewModel.clusteringType;
            }
            if ((n3 & 2) != 0) {
                n = myViewModel.edgeBetweennessQualityTimeRatio;
            }
            if ((n3 & 4) != 0) {
                n2 = myViewModel.kMeansBound;
            }
            return myViewModel.copy(clazz, n, n2);
        }

        @NotNull
        public String toString() {
            return "MyViewModel(clusteringType=" + this.clusteringType + ", edgeBetweennessQualityTimeRatio=" + this.edgeBetweennessQualityTimeRatio + ", kMeansBound=" + this.kMeansBound + ")";
        }

        public int hashCode() {
            int result = this.clusteringType.hashCode();
            result = result * 31 + Integer.hashCode(this.edgeBetweennessQualityTimeRatio);
            result = result * 31 + Integer.hashCode(this.kMeansBound);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyViewModel)) {
                return false;
            }
            MyViewModel myViewModel = (MyViewModel)other;
            if (!Intrinsics.areEqual(this.clusteringType, myViewModel.clusteringType)) {
                return false;
            }
            if (this.edgeBetweennessQualityTimeRatio != myViewModel.edgeBetweennessQualityTimeRatio) {
                return false;
            }
            return this.kMeansBound == myViewModel.kMeansBound;
        }

        public MyViewModel() {
            this(null, 0, 0, 7, null);
        }
    }
}

