/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.mouseProcessing;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.settings.SwSettingsChangedListener;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionsService;
import com.intellij.swagger.core.visualEditing.mouseProcessing.SwEditorMouseListener;
import com.intellij.swagger.core.visualEditing.mouseProcessing.SwEditorMouseReleaseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\t"}, d2={"addSwaggerSettingsListener", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "addMouseListeners", "removeMouseListeners", "restartHighlightingForSwaggerFiles", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwVisualEditingMouseListenerSetupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwVisualEditingMouseListenerSetupActivity.kt\ncom/intellij/swagger/core/visualEditing/mouseProcessing/SwVisualEditingMouseListenerSetupActivityKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n30#2,2:75\n11546#3,9:77\n13472#3:86\n13473#3:88\n11555#3:89\n1#4:87\n774#5:90\n865#5,2:91\n1869#5,2:93\n*S KotlinDebug\n*F\n+ 1 SwVisualEditingMouseListenerSetupActivity.kt\ncom/intellij/swagger/core/visualEditing/mouseProcessing/SwVisualEditingMouseListenerSetupActivityKt\n*L\n53#1:75,2\n71#1:77,9\n71#1:86\n71#1:88\n71#1:89\n71#1:87\n72#1:90\n72#1:91,2\n73#1:93,2\n*E\n"})
public final class SwVisualEditingMouseListenerSetupActivityKt {
    private static final void addSwaggerSettingsListener(Project project, CoroutineScope coroutineScope) {
        project.getMessageBus().connect(coroutineScope).subscribe(SwSettingsChangedListener.TOPIC, (Object)new SwSettingsChangedListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void settingsChanged(SwaggerSettings settings) {
                Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
                if (((SwaggerSettingsState)settings.getState()).getVisualEditingEnabled()) {
                    SwVisualEditingMouseListenerSetupActivityKt.access$addMouseListeners(this.$project);
                } else {
                    SwVisualEditingMouseListenerSetupActivityKt.access$removeMouseListeners();
                }
                SwVisualEditingMouseListenerSetupActivityKt.access$restartHighlightingForSwaggerFiles(this.$project);
            }
        });
    }

    private static final void addMouseListeners(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SwVisualEditingActionsService> serviceClass$iv = SwVisualEditingActionsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        SwVisualEditingActionsService swActionsService = (SwVisualEditingActionsService)object;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        eventMulticaster.addEditorMouseListener((EditorMouseListener)SwEditorMouseReleaseListener.INSTANCE, (Disposable)swActionsService);
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)SwEditorMouseListener.INSTANCE, (Disposable)swActionsService);
    }

    private static final void removeMouseListeners() {
        EditorEventMulticaster editorEventMulticaster;
        EditorEventMulticaster $this$removeMouseListeners_u24lambda_u240 = editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        boolean bl = false;
        $this$removeMouseListeners_u24lambda_u240.removeEditorMouseListener((EditorMouseListener)SwEditorMouseReleaseListener.INSTANCE);
        $this$removeMouseListeners_u24lambda_u240.removeEditorMouseMotionListener((EditorMouseMotionListener)SwEditorMouseListener.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final void restartHighlightingForSwaggerFiles(Project project) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiFile it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            VirtualFile p0 = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl = false;
            if (!(SwSpecificationDetectionKt.detectSpecificationType(it) instanceof SwSpecificationType.SwaggerLikeRestAPI)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiFile p0 = (PsiFile)element$iv;
            boolean bl = false;
            codeAnalyzer.restart(p0);
        }
    }

    public static final /* synthetic */ void access$addSwaggerSettingsListener(Project project, CoroutineScope coroutineScope) {
        SwVisualEditingMouseListenerSetupActivityKt.addSwaggerSettingsListener(project, coroutineScope);
    }

    public static final /* synthetic */ void access$addMouseListeners(Project project) {
        SwVisualEditingMouseListenerSetupActivityKt.addMouseListeners(project);
    }

    public static final /* synthetic */ void access$removeMouseListeners() {
        SwVisualEditingMouseListenerSetupActivityKt.removeMouseListeners();
    }

    public static final /* synthetic */ void access$restartHighlightingForSwaggerFiles(Project project) {
        SwVisualEditingMouseListenerSetupActivityKt.restartHighlightingForSwaggerFiles(project);
    }
}

