/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.index.SwReferenceData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/swagger/core/index/SwReferenceDataWithSource;", "", "sourcePsiFile", "Lcom/intellij/psi/PsiFile;", "isPrimarySpec", "", "referenceData", "Lcom/intellij/swagger/core/index/SwReferenceData;", "<init>", "(Lcom/intellij/psi/PsiFile;ZLcom/intellij/swagger/core/index/SwReferenceData;)V", "getSourcePsiFile", "()Lcom/intellij/psi/PsiFile;", "()Z", "getReferenceData", "()Lcom/intellij/swagger/core/index/SwReferenceData;", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "intellij.swagger.core"})
public final class SwReferenceDataWithSource
implements Comparable<SwReferenceDataWithSource> {
    @NotNull
    private final PsiFile sourcePsiFile;
    private final boolean isPrimarySpec;
    @NotNull
    private final SwReferenceData referenceData;

    public SwReferenceDataWithSource(@NotNull PsiFile sourcePsiFile, boolean isPrimarySpec, @NotNull SwReferenceData referenceData) {
        Intrinsics.checkNotNullParameter((Object)sourcePsiFile, (String)"sourcePsiFile");
        Intrinsics.checkNotNullParameter((Object)referenceData, (String)"referenceData");
        this.sourcePsiFile = sourcePsiFile;
        this.isPrimarySpec = isPrimarySpec;
        this.referenceData = referenceData;
    }

    @NotNull
    public final PsiFile getSourcePsiFile() {
        return this.sourcePsiFile;
    }

    public final boolean isPrimarySpec() {
        return this.isPrimarySpec;
    }

    @NotNull
    public final SwReferenceData getReferenceData() {
        return this.referenceData;
    }

    @Override
    public int compareTo(@NotNull SwReferenceDataWithSource other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.isPrimarySpec && !other.isPrimarySpec) {
            n = 1;
        } else if (!this.isPrimarySpec && other.isPrimarySpec) {
            n = -1;
        } else {
            String string = this.sourcePsiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = other.sourcePsiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            n = StringsKt.compareTo((String)string, (String)string2, (boolean)true);
        }
        return n;
    }

    @NotNull
    public final PsiFile component1() {
        return this.sourcePsiFile;
    }

    public final boolean component2() {
        return this.isPrimarySpec;
    }

    @NotNull
    public final SwReferenceData component3() {
        return this.referenceData;
    }

    @NotNull
    public final SwReferenceDataWithSource copy(@NotNull PsiFile sourcePsiFile, boolean isPrimarySpec, @NotNull SwReferenceData referenceData) {
        Intrinsics.checkNotNullParameter((Object)sourcePsiFile, (String)"sourcePsiFile");
        Intrinsics.checkNotNullParameter((Object)referenceData, (String)"referenceData");
        return new SwReferenceDataWithSource(sourcePsiFile, isPrimarySpec, referenceData);
    }

    public static /* synthetic */ SwReferenceDataWithSource copy$default(SwReferenceDataWithSource swReferenceDataWithSource, PsiFile psiFile, boolean bl, SwReferenceData swReferenceData, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = swReferenceDataWithSource.sourcePsiFile;
        }
        if ((n & 2) != 0) {
            bl = swReferenceDataWithSource.isPrimarySpec;
        }
        if ((n & 4) != 0) {
            swReferenceData = swReferenceDataWithSource.referenceData;
        }
        return swReferenceDataWithSource.copy(psiFile, bl, swReferenceData);
    }

    @NotNull
    public String toString() {
        return "SwReferenceDataWithSource(sourcePsiFile=" + this.sourcePsiFile + ", isPrimarySpec=" + this.isPrimarySpec + ", referenceData=" + this.referenceData + ")";
    }

    public int hashCode() {
        int result2 = this.sourcePsiFile.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isPrimarySpec);
        result2 = result2 * 31 + this.referenceData.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwReferenceDataWithSource)) {
            return false;
        }
        SwReferenceDataWithSource swReferenceDataWithSource = (SwReferenceDataWithSource)other;
        if (!Intrinsics.areEqual((Object)this.sourcePsiFile, (Object)swReferenceDataWithSource.sourcePsiFile)) {
            return false;
        }
        if (this.isPrimarySpec != swReferenceDataWithSource.isPrimarySpec) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.referenceData, (Object)swReferenceDataWithSource.referenceData);
    }
}

