/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.grid.scripting.impl.IvyLocalRepository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "initConfig", "", "grapeDir", "Ljava/nio/file/Path;", "generateFileSystemResolver", "", "repPath", "intellij.grid.scripting.impl"})
@SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,357:1\n58#2:358\n36#2,2:359\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManagerKt\n*L\n55#1:358\n55#1:359,2\n*E\n"})
public final class DataLoaderManagerKt {
    @NotNull
    private static final Logger logger;

    private static final void initConfig(Path grapeDir) {
        Path config = grapeDir.resolve("grapeConfig.xml");
        String settings = StringsKt.trimMargin$default((String)("\n    |<ivysettings>\n    |  <settings defaultResolver=\"downloadGrapes\"/>\n    |  <resolvers>\n    |    <chain name=\"downloadGrapes\" returnFirst=\"true\">\n    " + CollectionsKt.joinToString$default((Iterable)IvyLocalRepository.Companion.getAllProviders(), (CharSequence)"\n", (CharSequence)"\n", (CharSequence)"\n", (int)0, null, DataLoaderManagerKt::initConfig$lambda$0, (int)24, null) + "\n    |      <ibiblio name=\"ibiblio\" m2compatible=\"true\"/>\n    |      <ibiblio name=\"jcenter\" root=\"https://jcenter.bintray.com/\" m2compatible=\"true\"/>\n    |    </chain>\n    |  </resolvers>\n    |</ivysettings>\n  "), null, (int)1, null);
        FileUtil.writeToFile((File)config.toFile(), (String)settings);
    }

    private static final String generateFileSystemResolver(Path repPath) {
        String string = StringUtil.escapeStringCharacters((String)FileUtil.toSystemIndependentName((String)((Object)repPath.toAbsolutePath()).toString()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeStringCharacters(...)");
        String escapedPath = string;
        return StringsKt.trimMargin$default((String)("\n    |      <filesystem name=\"" + UUID.randomUUID() + "\">\n    |        <ivy pattern=\"" + escapedPath + "/grapes/[organisation]/[module]/ivy-[revision].xml\"/>\n    |        <artifact pattern=\"" + escapedPath + "/grapes/[organisation]/[module]/[type]s/[artifact]-[revision](-[classifier]).[ext]\"/>\n    |      </filesystem>\n  "), null, (int)1, null);
    }

    private static final CharSequence initConfig$lambda$0(IvyLocalRepository rep) {
        Intrinsics.checkNotNullParameter((Object)rep, (String)"rep");
        return DataLoaderManagerKt.generateFileSystemResolver(rep.getPath());
    }

    public static final /* synthetic */ void access$initConfig(Path grapeDir) {
        DataLoaderManagerKt.initConfig(grapeDir);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DataLoaderManagerKt.logger = logger;
    }
}

