/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSDocCommentCachedDataBuilder
implements JSDocCommentVisitor {
    @NotNull
    private final JSDocCommentCachedData myCachedData;
    private String myNameTag;
    private String myMemberOfTag;

    JSDocCommentCachedDataBuilder(@NotNull JSDocCommentCachedData cachedData) {
        if (cachedData == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(0);
        }
        this.myCachedData = cachedData;
    }

    @Override
    public void visitTypedefTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(1);
        }
        this.myCachedData.addTypedef(tag.getNamepathText(), tag.getTypeText());
        this.myCachedData.setIsInterface();
    }

    @Override
    public void visitTypeTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(2);
        }
        this.myCachedData.setType(tag.getTypeText());
    }

    @Override
    public void visitAliasTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(3);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = namepath;
            this.myCachedData.setAlias(namepath);
        }
    }

    @Override
    public void visitNameTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(4);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = namepath;
        }
    }

    @Override
    public void visitExternalTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(5);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = namepath;
        }
    }

    @Override
    public void visitCallbackTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(6);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = namepath;
        }
        this.myCachedData.setIsInterface();
        this.myCachedData.setSeemsToBeFunction();
        this.myCachedData.addTypedef(namepath, "Function");
    }

    @Override
    public void visitFunctionTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(7);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = namepath;
        }
        this.myCachedData.setSeemsToBeFunction();
    }

    @Override
    public void visitMethodTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(8);
        }
        this.visitFunctionTag(tag);
        this.myCachedData.setIsMember(true);
    }

    @Override
    public void visitMemberOfTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(9);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myMemberOfTag = namepath;
        }
    }

    @Override
    public void visitClassTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(10);
        }
        if ((namepath = tag.getTypeText()) != null) {
            this.myCachedData.setClassName(JSQualifiedNameImpl.fromNamepath(namepath));
        }
        this.myCachedData.setIsClassExplicitly();
        this.myCachedData.setHasConstructorLikeTag(true);
    }

    @Override
    public void visitNamespaceTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(11);
        }
        String namepath = tag.getNamepathText();
        this.myCachedData.setHasNamespaceTag();
        if (namepath != null) {
            JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromNamepath(namepath);
            this.myCachedData.setExplicitName(qName.getName());
            this.myCachedData.setNamespace(qName.getParent());
        }
    }

    @Override
    public void visitTemplateTag(@NotNull JSDocTag tag) {
        JSDocTagNamepath[] generics;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(12);
        }
        if ((generics = (JSDocTagNamepath[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JSDocTagNamepath.class)) != null) {
            String type2 = tag.getTypeText();
            for (JSDocTagNamepath generic : generics) {
                this.myCachedData.addGenericParameter(generic.getNamepathText(), type2);
            }
        }
    }

    @Override
    public void visitPrivateTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(13);
        }
        String type2 = tag.getTypeText();
        this.myCachedData.setAccessType(JSAttributeList.AccessType.PRIVATE);
        if (type2 != null) {
            this.myCachedData.setType(type2);
        }
    }

    @Override
    public void visitPublicTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(14);
        }
        String type2 = tag.getTypeText();
        this.myCachedData.setAccessType(JSAttributeList.AccessType.PUBLIC);
        if (type2 != null) {
            this.myCachedData.setType(type2);
        }
    }

    @Override
    public void visitProtectedTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(15);
        }
        String type2 = tag.getTypeText();
        this.myCachedData.setAccessType(JSAttributeList.AccessType.PROTECTED);
        if (type2 != null) {
            this.myCachedData.setType(type2);
        }
    }

    @Override
    public void visitPackageTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(16);
        }
        String type2 = tag.getTypeText();
        this.myCachedData.setAccessType(JSAttributeList.AccessType.PACKAGE_LOCAL);
        if (type2 != null) {
            this.myCachedData.setType(type2);
        }
    }

    @Override
    public void visitStaticTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(17);
        }
        this.myCachedData.setContext(JSContext.STATIC);
    }

    @Override
    public void visitExtendsTag(@NotNull JSDocTag tag) {
        String type2;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(18);
        }
        if ((type2 = tag.getTypeText()) != null) {
            this.myCachedData.addBaseType(type2);
        }
        this.myCachedData.setIsClassExplicitly();
    }

    @Override
    public void visitImplementsTag(@NotNull JSDocTag tag) {
        String type2;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(19);
        }
        if ((type2 = tag.getTypeText()) != null) {
            this.myCachedData.addBaseType(type2);
        }
        this.myCachedData.setIsClassExplicitly();
    }

    @Override
    public void visitMixesTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(20);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            String instanceType = JSBaseTypesIndex.serializeHierarchyElement(JSQualifiedNameImpl.fromQualifiedName(namepath), JSContext.INSTANCE);
            String staticType = JSBaseTypesIndex.serializeHierarchyElement(JSQualifiedNameImpl.fromQualifiedName(namepath), JSContext.STATIC);
            this.myCachedData.addBaseType(instanceType);
            this.myCachedData.addBaseType(staticType);
            this.myCachedData.addStaticBaseType(instanceType);
            this.myCachedData.addStaticBaseType(staticType);
        }
        this.myCachedData.setIsClassExplicitly();
    }

    @Override
    public void visitEnumTag(@NotNull JSDocTag tag) {
        String type2;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(21);
        }
        this.myCachedData.setEnumType((type2 = tag.getTypeText()) == null || type2.isEmpty() ? "number" : type2);
        this.myCachedData.setIsClassExplicitly();
    }

    @Override
    public void visitLendsTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(22);
        }
        String namepath = tag.getNamepathText();
        this.myCachedData.setLendsTagValue(namepath);
    }

    @Override
    public void visitInterfaceTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(23);
        }
        String name = tag.getNamepathText();
        this.myCachedData.setIsInterface();
        if (name != null) {
            this.applyNamepath(name);
        }
        this.myCachedData.setHasConstructorLikeTag(true);
    }

    @Override
    public void visitMixinTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(24);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.applyNamepath(namepath);
        }
    }

    @Override
    public void visitDeprecatedTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(25);
        }
        this.myCachedData.setHasDeprecatedTag();
        this.myCachedData.setDeprecationMessage(tag.getDescriptionText());
    }

    @Override
    public void visitSinceTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(26);
        }
        String since = tag.getDescriptionText();
        this.myCachedData.setSinceMessage(since);
    }

    @Override
    public void visitConstructsTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(27);
        }
        if (tag.getNamepath() == null) {
            this.myCachedData.setHasConstructsTag();
            this.myCachedData.setHasConstructorLikeTag(true);
        }
    }

    @Override
    public void visitReturnsTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(28);
        }
        String type2 = tag.getTypeText();
        this.myCachedData.setReturnType(type2);
        this.myCachedData.setSeemsToBeFunction();
    }

    @Override
    public void visitBrowserTag(@NotNull JSDocTag tag) {
        String browser;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(29);
        }
        if ("ie".equalsIgnoreCase(browser = tag.getDescriptionText())) {
            this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.IE);
        } else if ("gecko".equalsIgnoreCase(browser)) {
            this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.GECKO);
        } else if ("opera".equalsIgnoreCase(browser)) {
            this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.OPERA);
        }
    }

    @Override
    public void visitGlobalTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(30);
        }
        this.myCachedData.setNamespace(null);
        this.myCachedData.setHasGlobalTag();
    }

    @Override
    public void visitMemberTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(31);
        }
        String namepath = tag.getNamepathText();
        String type2 = tag.getTypeText();
        if (namepath != null) {
            this.myNameTag = namepath;
        }
        this.myCachedData.setType(type2);
        this.myCachedData.setIsMember(true);
    }

    private void visitPropertyOrParam(@NotNull JSDocTag tag, BiConsumer<JSQualifiedName, String> register2) {
        JSDocTagNamepath namepathPsi;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(32);
        }
        if ((namepathPsi = tag.getNamepath()) != null) {
            String defaultValue;
            String namepath = namepathPsi.getNamepathText();
            String type2 = tag.getTypeText();
            JSQualifiedNameImpl name = JSQualifiedNameImpl.fromNamepath(namepath);
            register2.accept(name, type2);
            if (namepathPsi.isOptional()) {
                this.myCachedData.setOptional(name);
            }
            if ((defaultValue = namepathPsi.getDefaultValue()) != null) {
                this.myCachedData.addDefaultValue(name, defaultValue);
            }
        }
    }

    @Override
    public void visitPropertyTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(33);
        }
        this.visitPropertyOrParam(tag, this.myCachedData::addProperty);
    }

    @Override
    public void visitParamTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(34);
        }
        this.visitPropertyOrParam(tag, this.myCachedData::addParameter);
        this.myCachedData.setSeemsToBeFunction();
    }

    @Override
    public void visitThisTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(35);
        }
        this.myCachedData.setThisType(tag.getTypeText());
    }

    @Override
    public void visitAbstractTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(36);
        }
        this.myCachedData.setHasAbstractTag();
    }

    @Override
    public void visitConstantTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(37);
        }
        String namepath = tag.getNamepathText();
        this.myCachedData.setHasConstTag();
        if (namepath != null) {
            this.myNameTag = namepath;
        }
    }

    @Override
    public void visitEventTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(38);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = JSDocumentationUtils.appendPrefixToName(namepath, "event:");
        }
    }

    @Override
    public void visitExportsTag(@NotNull JSDocTag tag) {
        String namepath;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(39);
        }
        if ((namepath = tag.getNamepathText()) != null) {
            this.myNameTag = JSDocumentationUtils.appendPrefixToName(namepath, "module:");
        }
    }

    @Override
    public void visitModuleTag(@NotNull JSDocTag tag) {
        boolean looksLikeYuiModuleTag;
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(40);
        }
        String namepath = tag.getNamepathText();
        boolean looksLikeAngularRequiredModuleTag = this.myNameTag != null;
        boolean bl = looksLikeYuiModuleTag = this.myCachedData.getClassName() != null;
        if (namepath != null && !looksLikeAngularRequiredModuleTag && !looksLikeYuiModuleTag) {
            this.myNameTag = JSDocumentationUtils.appendPrefixToName(namepath, "module:");
        }
    }

    @Override
    public void visitInstanceTag(@NotNull JSDocTag tag) {
        if (tag == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(41);
        }
        this.myCachedData.setContext(JSContext.INSTANCE);
        this.myCachedData.setHasInstanceTag();
    }

    private void applyNamepath(@NotNull String matchName) {
        if (matchName == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(42);
        }
        JSNamespace namespace = JSNamedTypeFactory.fromNamepath(matchName, true);
        JSQualifiedName qName = namespace.getQualifiedName();
        assert (qName != null);
        this.myCachedData.setExplicitName(qName.getName());
        JSQualifiedName parent = qName.getParent();
        this.myCachedData.setNamespace(parent);
        this.myCachedData.setContext(namespace.getJSContext());
    }

    @Override
    public void finishVisiting(@Nullable JSDocTag lastTag) {
        if (this.myNameTag != null || this.myMemberOfTag != null) {
            JSContext context2 = this.myMemberOfTag != null ? JSContext.STATIC : JSContext.UNKNOWN;
            JSQualifiedName namespace = null;
            if (this.myNameTag != null) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromNamepath(this.myNameTag);
                String name = qName.getName();
                this.myCachedData.setExplicitName(name);
                namespace = qName.getParent();
                if (this.myNameTag.length() > name.length()) {
                    char lastSeparator = this.myNameTag.charAt(this.myNameTag.length() - name.length() - 1);
                    if (lastSeparator == '#') {
                        context2 = JSContext.INSTANCE;
                    } else if (lastSeparator == '~') {
                        context2 = JSContext.UNKNOWN;
                    }
                }
            }
            if (this.myMemberOfTag != null) {
                String memberOf = this.myMemberOfTag;
                if (memberOf.endsWith("#")) {
                    context2 = JSContext.INSTANCE;
                    memberOf = memberOf.substring(0, memberOf.length() - 1);
                }
                namespace = JSQualifiedNameImpl.fromNamepath(memberOf);
            }
            this.myCachedData.setNamespace(namespace);
            if (this.myCachedData.getContext() == JSContext.UNKNOWN) {
                this.myCachedData.setContext(context2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypedefTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeTag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAliasTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExternalTag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallbackTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunctionTag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodTag";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMemberOfTag";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassTag";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNamespaceTag";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTemplateTag";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrivateTag";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPublicTag";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitProtectedTag";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPackageTag";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitStaticTag";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExtendsTag";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitImplementsTag";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMixesTag";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumTag";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLendsTag";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInterfaceTag";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMixinTag";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDeprecatedTag";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSinceTag";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstructsTag";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnsTag";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBrowserTag";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGlobalTag";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMemberTag";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPropertyOrParam";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPropertyTag";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParamTag";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisTag";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAbstractTag";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstantTag";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEventTag";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExportsTag";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "visitModuleTag";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceTag";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNamepath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

