/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNumberLiteralType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralTypeBase;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralTypeStub;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptNumberLiteralTypeImpl
extends TypeScriptLiteralTypeBase
implements TypeScriptNumberLiteralType {
    public TypeScriptNumberLiteralTypeImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptNumberLiteralTypeImpl(TypeScriptLiteralTypeStub<? extends TypeScriptLiteralType> stub, IElementType type2) {
        super(stub, type2);
    }

    @Override
    @NotNull
    public JSType calculateType() {
        String literal = this.getInnerText();
        if (literal != null) {
            BigInteger bigInt = JSNumberParser.tryParseBigInt(literal);
            if (bigInt != null) {
                return new JSBigIntLiteralTypeImpl(bigInt, false, JSTypeSourceFactory.createTypeSource((PsiElement)this, true), literal);
            }
            Double parsedLiteral = JSNumberParser.tryParseNumericValue(literal, true);
            if (parsedLiteral != null) {
                return new JSNumberLiteralTypeImpl(parsedLiteral, false, JSTypeSourceFactory.createTypeSource((PsiElement)this, true), literal);
            }
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)this);
        if (jSAnyType == null) {
            TypeScriptNumberLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        return jSAnyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptNumberLiteralTypeImpl", "calculateType"));
    }
}

