/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.modules.remote.JSRemoteModule;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesDownloadManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoteModulesDownloader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JSRemoteModulesDownloader.class);
    private final Project myProject;
    private final ExecutorService myDownloadExecutor;
    private final Set<String> myRunningOperations;

    public static JSRemoteModulesDownloader getInstance(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(0);
        }
        return (JSRemoteModulesDownloader)project.getService(JSRemoteModulesDownloader.class);
    }

    public JSRemoteModulesDownloader(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(1);
        }
        this.myDownloadExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"JS Remote Modules Downloader Pool", (int)Runtime.getRuntime().availableProcessors());
        this.myRunningOperations = ConcurrentHashMap.newKeySet();
        this.myProject = project;
    }

    @RequiresBackgroundThread
    @Nullable
    public JSRemoteModuleDownloadResult downloadModule(@NotNull String url, @Nullable ProgressIndicator indicator) {
        if (url == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertBackgroundThread();
        String modulesRoot = JSUrlImportsUtil.getRemoteModulesDirPath();
        DownloadingSession session = new DownloadingSession(modulesRoot, indicator);
        ModuleDownloadingSession moduleSession = session.createChildSessionForModule(url);
        assert (moduleSession != null);
        boolean isStarted = this.runModuleOperation(url, () -> {
            long start = System.nanoTime();
            this.downloadModule(url, moduleSession);
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            LOG.info(String.format("Downloading module from %s is completed in %d ms", url, elapsedMs));
        });
        if (!isStarted) {
            return null;
        }
        Map<String, Throwable> failedRequests = session.getFailedRequests();
        if (!failedRequests.isEmpty()) {
            for (Map.Entry<String, Throwable> failedRequest : failedRequests.entrySet()) {
                LOG.info("Download exception: " + failedRequest.getKey(), failedRequest.getValue());
            }
        }
        List<JSRemoteModule> modules = JSRemoteModulesDownloader.getModulesList(session);
        return new JSRemoteModuleDownloadResult(modules, session);
    }

    @NotNull
    private static List<JSRemoteModule> getModulesList(@NotNull DownloadingSession rootSession) {
        if (rootSession == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(3);
        }
        ArrayList<JSRemoteModule> modules = new ArrayList<JSRemoteModule>();
        VirtualFile rootDirectory = JSUrlImportsUtil.findFileByPath(rootSession.getRootDir());
        if (rootDirectory == null || !rootDirectory.isValid()) {
            LOG.warn(String.format("Root directory is invalid: %s", rootDirectory != null ? rootDirectory.getPath() : null));
            List<JSRemoteModule> list = Collections.emptyList();
            if (list == null) {
                JSRemoteModulesDownloader.$$$reportNull$$$0(4);
            }
            return list;
        }
        rootSession.traverseModules(session -> {
            String moduleUrl = session.getModuleUrl();
            VirtualFile entry = session.getModuleEntryByUrl(moduleUrl);
            if (entry == null) {
                return;
            }
            VirtualFile root = VfsUtil.getCommonAncestor(session.getModuleEntries());
            if (root == null) {
                LOG.warn(String.format("Root is not found for URL: %s", moduleUrl));
                return;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)rootDirectory, (VirtualFile)root, (boolean)true)) {
                LOG.warn(String.format("Invalid root found for URL: %s, root: %s", moduleUrl, root.getPath()));
                return;
            }
            Set<String> dependencies = session.getModuleDependencies();
            ContainerUtil.addIfNotNull((Collection)modules, (Object)JSRemoteModule.create(moduleUrl, entry, root, dependencies));
        });
        ArrayList<JSRemoteModule> arrayList = modules;
        if (arrayList == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void downloadModule(@NotNull String moduleUrl, @NotNull ModuleDownloadingSession session) {
        if (moduleUrl == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(6);
        }
        if (session == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(7);
        }
        Set<String> urls = Collections.singleton(moduleUrl);
        while (!urls.isEmpty()) {
            ProgressManager.checkCanceled();
            Map<String, String> urlToPath = this.downloadFiles(new ArrayList<String>(urls), session);
            Map<String, VirtualFile> urlToFile = this.addEntries(urlToPath, session);
            Collection<JSRemoteModuleUrlDescriptor> urlDescriptors = this.collectImportedUrls(urlToFile);
            HashSet<String> imports = new HashSet<String>();
            for (JSRemoteModuleUrlDescriptor urlDescriptor : urlDescriptors) {
                if (urlDescriptor.isDependentModule()) {
                    session.addModuleDependency(urlDescriptor.myUrl);
                    continue;
                }
                imports.add(urlDescriptor.myUrl);
            }
            imports.removeAll(session.getRequestedUrls());
            imports.removeAll(session.getModuleDependencies());
            urls = imports;
        }
        for (String moduleDependency : session.getModuleDependencies()) {
            ModuleDownloadingSession moduleSession = session.getDownloadingSession().createChildSessionForModule(moduleDependency);
            if (moduleSession == null) continue;
            this.downloadModule(moduleDependency, moduleSession);
        }
    }

    @NotNull
    private Map<String, String> downloadFiles(@NotNull List<String> urls, @NotNull ModuleDownloadingSession session) {
        if (urls == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(8);
        }
        if (session == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(9);
        }
        List futures = ContainerUtil.map(urls, url -> this.myDownloadExecutor.submit(() -> (String)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> this.downloadFileWorker((String)url, session), (ProgressIndicator)session.getDownloadingSession().createSubTaskProgressIndicator())));
        HashMap<String, String> urlToPath = new HashMap<String, String>(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            String url2 = urls.get(i);
            try {
                String path2 = (String)future.get();
                if (StringUtil.isEmpty((String)path2)) continue;
                urlToPath.put(url2, path2);
                continue;
            }
            catch (CancellationException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                JSRemoteModulesDownloader.cancelTasks(futures);
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    JSRemoteModulesDownloader.cancelTasks(futures);
                    throw (ProcessCanceledException)e.getCause();
                }
                session.getDownloadingSession().requestFailed(url2, e.getCause());
            }
        }
        HashMap<String, String> hashMap = urlToPath;
        if (hashMap == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static void cancelTasks(@NotNull Collection<? extends Future<?>> futures) {
        if (futures == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(11);
        }
        futures.forEach(f -> f.cancel(false));
    }

    @Nullable
    private String downloadFileWorker(@Nullable String url, @NotNull ModuleDownloadingSession session) {
        if (session == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(12);
        }
        ProgressManager.checkCanceled();
        if (this.myProject.isDisposed() || StringUtil.isEmpty((String)url)) {
            return null;
        }
        DownloadingSession downloadingSession = session.getDownloadingSession();
        if (!session.markAsRequested(url)) {
            return downloadingSession.getCachedRequestResult(url);
        }
        String cached = downloadingSession.getCachedRequestResult(url);
        if (cached != null) {
            return cached;
        }
        if (downloadingSession.isRequestFailed(url)) {
            return null;
        }
        LOG.info("Downloading URL: " + url);
        JSDownloadManager downloadManager = this.createDownloadManager(downloadingSession);
        downloadManager.setProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        String path2 = downloadManager.downloadLibrary(url, ".js");
        if (downloadManager.getLastException() != null) {
            downloadingSession.requestFailed(url, downloadManager.getLastException());
            return null;
        }
        if (path2 != null) {
            downloadingSession.cacheRequestResult(url, path2);
        }
        return path2;
    }

    @NotNull
    private Map<String, VirtualFile> addEntries(@NotNull Map<String, String> urlToPath, @NotNull ModuleDownloadingSession session) {
        if (urlToPath == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(13);
        }
        if (session == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(14);
        }
        Map map2 = (Map)WriteAction.computeAndWait(() -> {
            ProgressManager.checkCanceled();
            if (this.myProject.isDisposed()) {
                return Collections.emptyMap();
            }
            HashMap<String, VirtualFile> result2 = new HashMap<String, VirtualFile>();
            for (Map.Entry entry : urlToPath.entrySet()) {
                String url = (String)entry.getKey();
                String path2 = (String)entry.getValue();
                VirtualFile file = JSRemoteModulesDownloader.refreshAndFindFile(path2);
                if (file == null) continue;
                session.addModuleEntry(url, file);
                result2.put(url, file);
            }
            return result2;
        });
        if (map2 == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @Nullable
    private static VirtualFile refreshAndFindFile(@Nullable String path2) {
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (file == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().refreshAndFindFileByPath(path2);
        }
        return file;
    }

    @NotNull
    private Collection<JSRemoteModuleUrlDescriptor> collectImportedUrls(@NotNull Map<String, VirtualFile> urlToFile) {
        if (urlToFile == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(16);
        }
        ArrayList<JSRemoteModuleUrlDescriptor> dependencyUrls = new ArrayList<JSRemoteModuleUrlDescriptor>();
        for (Map.Entry<String, VirtualFile> entry : urlToFile.entrySet()) {
            dependencyUrls.addAll(this.collectImportedUrls(entry.getKey(), entry.getValue()));
        }
        ArrayList<JSRemoteModuleUrlDescriptor> arrayList = dependencyUrls;
        if (arrayList == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private Collection<JSRemoteModuleUrlDescriptor> collectImportedUrls(@NotNull String remoteUrl, @NotNull VirtualFile file) {
        if (remoteUrl == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(18);
        }
        if (file == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(19);
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            ProgressManager.checkCanceled();
            if (this.myProject.isDisposed()) {
                return Collections.emptySet();
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null || !psiFile.isValid() || !(psiFile instanceof JSFile)) {
                return Collections.emptySet();
            }
            URI baseUrl = JSRemoteModulesDownloader.parseUriSafe(remoteUrl);
            if (baseUrl == null) {
                return Collections.emptySet();
            }
            Set<String> referencedPaths = JSUrlImportsUtil.collectAllImportReferences((JSFile)psiFile);
            return ContainerUtil.mapNotNull(referencedPaths, path2 -> JSRemoteModulesDownloader.importPathToUrl(baseUrl, path2));
        });
        if (collection == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Nullable
    private static JSRemoteModuleUrlDescriptor importPathToUrl(@NotNull URI baseUrl, @NotNull String path2) {
        if (baseUrl == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(21);
        }
        if (path2 == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmptyOrSpaces((String)path2)) {
            return null;
        }
        URI url = null;
        boolean isDependentModuleUrl = JSUrlImportsUtil.isSupportedRemoteModuleUrl(path2);
        if (isDependentModuleUrl) {
            url = JSRemoteModulesDownloader.parseUriSafe(path2);
        } else if (JSRemoteModulesDownloader.isSupportedImportPath(path2)) {
            try {
                url = baseUrl.resolve(path2);
            }
            catch (IllegalArgumentException e) {
                LOG.info((Throwable)e);
            }
        }
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        if (StringUtil.isEmpty((String)urlPath)) {
            return null;
        }
        String extension = PathUtil.getFileExtension((String)urlPath);
        if (extension == null) {
            return null;
        }
        if (!ArrayUtil.contains((String)("." + extension), (String[])JSUrlImportsUtil.EXTENSIONS)) {
            return null;
        }
        return new JSRemoteModuleUrlDescriptor(url.toString(), isDependentModuleUrl);
    }

    @Nullable
    private static URI parseUriSafe(@NotNull String url) {
        if (url == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(23);
        }
        try {
            return URI.create(url);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static boolean isSupportedImportPath(@NotNull String path2) {
        if (path2 == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(24);
        }
        return path2.startsWith("./") || path2.startsWith("../");
    }

    @NotNull
    protected JSDownloadManager createDownloadManager(@NotNull DownloadingSession session) {
        if (session == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(25);
        }
        return new JSRemoteModulesDownloadManager(session.getRootDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runModuleOperation(@NotNull String moduleUrl, @NotNull Runnable runnable) {
        if (moduleUrl == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(26);
        }
        if (runnable == null) {
            JSRemoteModulesDownloader.$$$reportNull$$$0(27);
        }
        if (!this.myRunningOperations.add(moduleUrl)) {
            return false;
        }
        try {
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.myRunningOperations.remove(moduleUrl);
        }
    }

    public void dispose() {
        this.myDownloadExecutor.shutdownNow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 15, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSession";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleUrl";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlToPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlToFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addEntries";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModulesList";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 15: 
            case 17: 
            case 20: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cancelTasks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileWorker";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addEntries";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectImportedUrls";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "importPathToUrl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseUriSafe";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedImportPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDownloadManager";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runModuleOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 15, 17, 20 -> new IllegalStateException(string);
        };
    }

    public static class DownloadingSession {
        private final ProgressIndicator myProgressIndicator;
        private final String myRootDir;
        private final Map<String, String> myCompletedRequests;
        private final Map<String, Throwable> myFailedRequests;
        private final Map<String, ModuleDownloadingSession> myChildSessions;

        private DownloadingSession(@NotNull String rootDir, @Nullable ProgressIndicator indicator) {
            if (rootDir == null) {
                DownloadingSession.$$$reportNull$$$0(0);
            }
            this.myCompletedRequests = new ConcurrentHashMap<String, String>();
            this.myFailedRequests = new ConcurrentHashMap<String, Throwable>();
            this.myChildSessions = new ConcurrentHashMap<String, ModuleDownloadingSession>();
            this.myRootDir = rootDir;
            this.myProgressIndicator = indicator;
        }

        private void cacheRequestResult(@NotNull String url, @NotNull String path2) {
            if (url == null) {
                DownloadingSession.$$$reportNull$$$0(1);
            }
            if (path2 == null) {
                DownloadingSession.$$$reportNull$$$0(2);
            }
            String previousPath = this.myCompletedRequests.putIfAbsent(url, path2);
            assert (previousPath == null);
        }

        @Nullable
        public String getCachedRequestResult(@NotNull String url) {
            if (url == null) {
                DownloadingSession.$$$reportNull$$$0(3);
            }
            return this.myCompletedRequests.get(url);
        }

        private void requestFailed(@NotNull String url, @NotNull Throwable exception) {
            if (url == null) {
                DownloadingSession.$$$reportNull$$$0(4);
            }
            if (exception == null) {
                DownloadingSession.$$$reportNull$$$0(5);
            }
            this.myFailedRequests.putIfAbsent(url, exception);
        }

        @NotNull
        public Map<String, Throwable> getFailedRequests() {
            Map<String, Throwable> map2 = this.myFailedRequests;
            if (map2 == null) {
                DownloadingSession.$$$reportNull$$$0(6);
            }
            return map2;
        }

        public boolean isRequestFailed(@NotNull String url) {
            if (url == null) {
                DownloadingSession.$$$reportNull$$$0(7);
            }
            return this.myFailedRequests.containsKey(url);
        }

        @NotNull
        public String getRootDir() {
            String string = this.myRootDir;
            if (string == null) {
                DownloadingSession.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        private ModuleDownloadingSession createChildSessionForModule(@NotNull String moduleUrl) {
            ModuleDownloadingSession session;
            ModuleDownloadingSession existing;
            if (moduleUrl == null) {
                DownloadingSession.$$$reportNull$$$0(9);
            }
            return (existing = this.myChildSessions.putIfAbsent(moduleUrl, session = new ModuleDownloadingSession(this, moduleUrl))) == null ? session : null;
        }

        public boolean traverseModules(@NotNull Consumer<? super ModuleDownloadingSession> consumer) {
            if (consumer == null) {
                DownloadingSession.$$$reportNull$$$0(10);
            }
            for (ModuleDownloadingSession session : this.myChildSessions.values()) {
                consumer.accept(session);
            }
            return true;
        }

        @Nullable
        private ProgressIndicator createSubTaskProgressIndicator() {
            ProgressIndicator parent = this.myProgressIndicator;
            if (parent == null) {
                return null;
            }
            return new ProgressWrapper(parent){

                public void setFraction(double fraction) {
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootDir";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$DownloadingSession";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleUrl";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$DownloadingSession";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailedRequests";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheRequestResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCachedRequestResult";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFailed";
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isRequestFailed";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildSessionForModule";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "traverseModules";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class ModuleDownloadingSession {
        private final DownloadingSession myDownloadingSession;
        private final String myModuleUrl;
        private final Set<String> myRequestedUrls;
        private final Map<String, VirtualFile> myModuleEntries;
        private final Set<String> myModuleDependencies;

        private ModuleDownloadingSession(@NotNull DownloadingSession parent, @NotNull String moduleUrl) {
            if (parent == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(0);
            }
            if (moduleUrl == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(1);
            }
            this.myRequestedUrls = ConcurrentHashMap.newKeySet();
            this.myModuleEntries = new ConcurrentHashMap<String, VirtualFile>();
            this.myModuleDependencies = ConcurrentHashMap.newKeySet();
            this.myDownloadingSession = parent;
            this.myModuleUrl = moduleUrl;
        }

        @NotNull
        public DownloadingSession getDownloadingSession() {
            DownloadingSession downloadingSession = this.myDownloadingSession;
            if (downloadingSession == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(2);
            }
            return downloadingSession;
        }

        @NotNull
        public String getModuleUrl() {
            String string = this.myModuleUrl;
            if (string == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(3);
            }
            return string;
        }

        private boolean markAsRequested(@NotNull String url) {
            if (url == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(4);
            }
            return this.myRequestedUrls.add(url);
        }

        @NotNull
        public Set<String> getRequestedUrls() {
            Set<String> set = this.myRequestedUrls;
            if (set == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(5);
            }
            return set;
        }

        @NotNull
        public Set<String> getModuleDependencies() {
            Set<String> set = this.myModuleDependencies;
            if (set == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(6);
            }
            return set;
        }

        public void addModuleDependency(@NotNull String moduleDependency) {
            if (moduleDependency == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(7);
            }
            this.myModuleDependencies.add(moduleDependency);
        }

        private void addModuleEntry(@NotNull String url, @NotNull VirtualFile file) {
            if (url == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(8);
            }
            if (file == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(9);
            }
            this.myModuleEntries.put(url, file);
        }

        @NotNull
        public Set<VirtualFile> getModuleEntries() {
            return new HashSet<VirtualFile>(this.myModuleEntries.values());
        }

        @Nullable
        public VirtualFile getModuleEntryByUrl(@NotNull String url) {
            if (url == null) {
                ModuleDownloadingSession.$$$reportNull$$$0(10);
            }
            return this.myModuleEntries.get(url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleUrl";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$ModuleDownloadingSession";
                    break;
                }
                case 4: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDependency";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$ModuleDownloadingSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDownloadingSession";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestedUrls";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "markAsRequested";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addModuleDependency";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addModuleEntry";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleEntryByUrl";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class JSRemoteModuleDownloadResult {
        private final Collection<JSRemoteModule> myModules;
        private final DownloadingSession mySession;

        public JSRemoteModuleDownloadResult(@NotNull Collection<JSRemoteModule> modules, @NotNull DownloadingSession session) {
            if (modules == null) {
                JSRemoteModuleDownloadResult.$$$reportNull$$$0(0);
            }
            if (session == null) {
                JSRemoteModuleDownloadResult.$$$reportNull$$$0(1);
            }
            this.myModules = modules;
            this.mySession = session;
        }

        @NotNull
        public Collection<JSRemoteModule> getModules() {
            Collection<JSRemoteModule> collection = this.myModules;
            if (collection == null) {
                JSRemoteModuleDownloadResult.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public Map<String, Throwable> getFailedRequests() {
            Map<String, Throwable> map2 = this.mySession.getFailedRequests();
            if (map2 == null) {
                JSRemoteModuleDownloadResult.$$$reportNull$$$0(3);
            }
            return map2;
        }

        public boolean hasErrors() {
            return !this.getFailedRequests().isEmpty();
        }

        @NotNull
        public DownloadingSession getSession() {
            DownloadingSession downloadingSession = this.mySession;
            if (downloadingSession == null) {
                JSRemoteModuleDownloadResult.$$$reportNull$$$0(4);
            }
            return downloadingSession;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$JSRemoteModuleDownloadResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$JSRemoteModuleDownloadResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailedRequests";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class JSRemoteModuleUrlDescriptor {
        private final String myUrl;
        private final boolean myIsDependentModule;

        private JSRemoteModuleUrlDescriptor(@NotNull String url, boolean isDependentModule) {
            if (url == null) {
                JSRemoteModuleUrlDescriptor.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
            this.myIsDependentModule = isDependentModule;
        }

        private boolean isDependentModule() {
            return this.myIsDependentModule;
        }

        public String toString() {
            return "JSRemoteModuleUrlDescriptor{myUrl='" + this.myUrl + "', myIsDependentModule=" + this.myIsDependentModule + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/modules/remote/JSRemoteModulesDownloader$JSRemoteModuleUrlDescriptor", "<init>"));
        }
    }
}

