/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element2) {
        VirtualFile oldBuildfile = PsiUtilBase.asVirtualFile((PsiElement)element2);
        if (oldBuildfile != null) {
            Project project = element2.getProject();
            for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
                JsbtService service = applicationService.getProjectService(project);
                JsbtFileManager fileManager = service.getFileManager();
                if (oldBuildfile.isDirectory()) {
                    if (!JsbtRefactoringElementListenerProvider.areBuildfilesFilesInside(fileManager, oldBuildfile)) continue;
                    return new DirectoryRefactoringElementAdapter(oldBuildfile);
                }
                if (!fileManager.containsBuildfile(oldBuildfile)) continue;
                return new FileRefactoringElementAdapter(oldBuildfile);
            }
        }
        return null;
    }

    private static boolean areBuildfilesFilesInside(@NotNull JsbtFileManager manager, @NotNull VirtualFile dir) {
        if (manager == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(1);
        }
        for (VirtualFile file : manager.getBuildfiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static void update(@NotNull Project project, @NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
        if (project == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(2);
        }
        if (oldBuildfile == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(3);
        }
        if (newBuildfile == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(4);
        }
        for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
            JsbtService service = applicationService.getProjectService(project);
            JsbtFileManager fileManager = service.getFileManager();
            if (!fileManager.containsBuildfile(oldBuildfile)) continue;
            fileManager.changeBuildfile(oldBuildfile, newBuildfile);
        }
    }

    private static void updateOnDirectoryRenameOrMove(@NotNull Project project, @NotNull VirtualFile newDir) {
        if (project == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(5);
        }
        if (newDir == null) {
            JsbtRefactoringElementListenerProvider.$$$reportNull$$$0(6);
        }
        for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
            JsbtService service = applicationService.getProjectService(project);
            JsbtFileManager fileManager = service.getFileManager();
            for (VirtualFile buildfile : fileManager.getBuildfiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)newDir, (VirtualFile)buildfile, (boolean)true)) continue;
                fileManager.changeBuildfile(buildfile, buildfile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBuildfile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuildfile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areBuildfilesFilesInside";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOnDirectoryRenameOrMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DirectoryRefactoringElementAdapter
    extends RefactoringElementAdapter {
        private final VirtualFile myOldDir;

        DirectoryRefactoringElementAdapter(@NotNull VirtualFile oldDir) {
            if (oldDir == null) {
                DirectoryRefactoringElementAdapter.$$$reportNull$$$0(0);
            }
            this.myOldDir = oldDir;
        }

        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            VirtualFile newDir;
            if (newElement == null) {
                DirectoryRefactoringElementAdapter.$$$reportNull$$$0(1);
            }
            if ((newDir = PsiUtilBase.asVirtualFile((PsiElement)newElement)) != null) {
                JsbtRefactoringElementListenerProvider.updateOnDirectoryRenameOrMove(newElement.getProject(), newDir);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            VirtualFile newDir;
            if (newElement == null) {
                DirectoryRefactoringElementAdapter.$$$reportNull$$$0(2);
            }
            if (oldQualifiedName == null) {
                DirectoryRefactoringElementAdapter.$$$reportNull$$$0(3);
            }
            if ((newDir = PsiUtilBase.asVirtualFile((PsiElement)newElement)) != null) {
                JsbtRefactoringElementListenerProvider.updateOnDirectoryRenameOrMove(newElement.getProject(), this.myOldDir);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldDir";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$DirectoryRefactoringElementAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileRefactoringElementAdapter
    extends RefactoringElementAdapter {
        private final VirtualFile myOldBuildfile;

        FileRefactoringElementAdapter(@NotNull VirtualFile oldBuildfile) {
            if (oldBuildfile == null) {
                FileRefactoringElementAdapter.$$$reportNull$$$0(0);
            }
            this.myOldBuildfile = oldBuildfile;
        }

        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            VirtualFile newBuildfile;
            if (newElement == null) {
                FileRefactoringElementAdapter.$$$reportNull$$$0(1);
            }
            if ((newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement)) != null) {
                JsbtRefactoringElementListenerProvider.update(newElement.getProject(), this.myOldBuildfile, newBuildfile);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            VirtualFile newBuildfile;
            if (newElement == null) {
                FileRefactoringElementAdapter.$$$reportNull$$$0(2);
            }
            if (oldQualifiedName == null) {
                FileRefactoringElementAdapter.$$$reportNull$$$0(3);
            }
            if ((newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement)) != null) {
                JsbtRefactoringElementListenerProvider.update(newElement.getProject(), newBuildfile, this.myOldBuildfile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldBuildfile";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$FileRefactoringElementAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

