/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.express;

import com.intellij.javascript.microservices.express.ExpressFrameworkUrlPathSpecification;
import com.intellij.javascript.microservices.express.ExpressModel;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.UriUtil;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u0014J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J%\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressMapping;", "", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "parent", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/javascript/microservices/express/ExpressMapping;)V", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getParent", "()Lcom/intellij/javascript/microservices/express/ExpressMapping;", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "path$delegate", "Lkotlin/Lazy;", "methods", "", "", "getMethods", "()Ljava/util/Set;", "methods$delegate", "source", "getSource", "()Ljava/lang/String;", "getFullPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.langInjection"})
public final class ExpressMapping {
    @NotNull
    private final SmartPsiElementPointer<JSLiteralExpression> pointer;
    @Nullable
    private final ExpressMapping parent;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy methods$delegate;
    @NotNull
    private final String source;

    public ExpressMapping(@NotNull SmartPsiElementPointer<JSLiteralExpression> pointer, @Nullable ExpressMapping parent) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        this.pointer = pointer;
        this.parent = parent;
        this.path$delegate = LazyKt.lazy(() -> ExpressMapping.path_delegate$lambda$0(this));
        this.methods$delegate = LazyKt.lazy(() -> ExpressMapping.methods_delegate$lambda$1(this));
        Object object = this.pointer.getContainingFile();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        this.source = object;
    }

    public /* synthetic */ ExpressMapping(SmartPsiElementPointer smartPsiElementPointer, ExpressMapping expressMapping, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            expressMapping = null;
        }
        this((SmartPsiElementPointer<JSLiteralExpression>)smartPsiElementPointer, expressMapping);
    }

    @NotNull
    public final SmartPsiElementPointer<JSLiteralExpression> getPointer() {
        return this.pointer;
    }

    @Nullable
    public final ExpressMapping getParent() {
        return this.parent;
    }

    @NotNull
    public final UrlPath getPath() {
        Lazy lazy = this.path$delegate;
        return (UrlPath)lazy.getValue();
    }

    @NotNull
    public final Set<String> getMethods() {
        Lazy lazy = this.methods$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getFullPath() {
        UrlMappingBuilder urlBuilder = new UrlMappingBuilder("/");
        if (this.parent != null) {
            urlBuilder.appendSegment(this.parent.getFullPath());
        }
        JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)this.pointer.getElement();
        urlBuilder.appendSegment(jSLiteralExpression != null ? jSLiteralExpression.getStringValue() : null);
        String fullPath = urlBuilder.build();
        if (Intrinsics.areEqual((Object)fullPath, (Object)"/")) {
            return fullPath;
        }
        String string = UriUtil.trimTrailingSlashes((String)fullPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTrailingSlashes(...)");
        return string;
    }

    @NotNull
    public final SmartPsiElementPointer<JSLiteralExpression> component1() {
        return this.pointer;
    }

    @Nullable
    public final ExpressMapping component2() {
        return this.parent;
    }

    @NotNull
    public final ExpressMapping copy(@NotNull SmartPsiElementPointer<JSLiteralExpression> pointer, @Nullable ExpressMapping parent) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        return new ExpressMapping(pointer, parent);
    }

    public static /* synthetic */ ExpressMapping copy$default(ExpressMapping expressMapping, SmartPsiElementPointer smartPsiElementPointer, ExpressMapping expressMapping2, int n, Object object) {
        if ((n & 1) != 0) {
            smartPsiElementPointer = expressMapping.pointer;
        }
        if ((n & 2) != 0) {
            expressMapping2 = expressMapping.parent;
        }
        return expressMapping.copy(smartPsiElementPointer, expressMapping2);
    }

    @NotNull
    public String toString() {
        return "ExpressMapping(pointer=" + this.pointer + ", parent=" + this.parent + ")";
    }

    public int hashCode() {
        int result2 = this.pointer.hashCode();
        result2 = result2 * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpressMapping)) {
            return false;
        }
        ExpressMapping expressMapping = (ExpressMapping)other;
        if (!Intrinsics.areEqual(this.pointer, expressMapping.pointer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.parent, (Object)expressMapping.parent);
    }

    private static final UrlPath path_delegate$lambda$0(ExpressMapping this$0) {
        return ExpressFrameworkUrlPathSpecification.INSTANCE.parsePath(this$0.getFullPath());
    }

    private static final Set methods_delegate$lambda$1(ExpressMapping this$0) {
        return ExpressModel.INSTANCE.getMappingMethods$intellij_javascript_langInjection(this$0);
    }
}

