/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.customization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.python.django.customization.DjangoFacetConfiguratorService;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.ultimate.PluginVerifier;
import com.jetbrains.django.facet.DjangoFacet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/django/customization/DjangoFacetConfigurator;", "Lcom/intellij/platform/DirectoryProjectConfigurator;", "<init>", "()V", "configureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "", "Companion", "intellij.python.django"})
public final class DjangoFacetConfigurator
implements DirectoryProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DJANGO_LIBRARY_NAME = "Django Lib";

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(moduleRef, (String)"moduleRef");
        PluginVerifier.verifyUltimatePlugin();
        Ref.ObjectRef moduleToConfigureDjangoFacet = new Ref.ObjectRef();
        Module[] modules = ModuleManager.Companion.getInstance(project).getModules();
        if (modules.length > 0) {
            Module module = modules[0];
            if (DjangoFacet.getInstance((Module)module) == null) {
                moduleToConfigureDjangoFacet.element = module;
            }
            DjangoFacetConfigurator.Companion.detectDjango(module, baseDir);
        }
        if (moduleToConfigureDjangoFacet.element != null) {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DjangoFacetConfigurator.configureProject$lambda$0(project, moduleToConfigureDjangoFacet, baseDir));
        }
    }

    private static final void configureProject$lambda$0(Project $project, Ref.ObjectRef $moduleToConfigureDjangoFacet, VirtualFile $baseDir) {
        ((DjangoFacetConfiguratorService)$project.getService(DjangoFacetConfiguratorService.class)).detectDjangoFacetAsync((Module)$moduleToConfigureDjangoFacet.element, $baseDir);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/django/customization/DjangoFacetConfigurator$Companion;", "", "<init>", "()V", "DJANGO_LIBRARY_NAME", "", "detectDjango", "", "module", "Lcom/intellij/openapi/module/Module;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "fillLib", "djangoRootPackage", "lib", "Lcom/intellij/openapi/roots/libraries/Library;", "findDjangoOrderEntry", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "model", "Lcom/intellij/openapi/roots/ModuleRootModel;", "intellij.python.django"})
    public static final class Companion {
        private Companion() {
        }

        private final void detectDjango(Module module, VirtualFile baseDir) {
            VirtualFile djangoRootPackage = DjangoUtil.findDjango((VirtualFile)baseDir);
            if (djangoRootPackage != null && !Intrinsics.areEqual((Object)baseDir, (Object)djangoRootPackage.getParent())) {
                ApplicationManager.getApplication().runWriteAction(() -> Companion.detectDjango$lambda$0(module, djangoRootPackage));
            }
        }

        private final void fillLib(VirtualFile djangoRootPackage, Library lib) {
            Library.ModifiableModel modifiableModel = lib.getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
            Library.ModifiableModel libModel = modifiableModel;
            String string = djangoRootPackage.getParent().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String djangoUrl = string;
            boolean flag = false;
            for (String url : libModel.getUrls(OrderRootType.CLASSES)) {
                if (!Intrinsics.areEqual((Object)djangoUrl, (Object)url)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                libModel.addRoot(djangoUrl, OrderRootType.CLASSES);
                libModel.commit();
            }
        }

        private final LibraryOrderEntry findDjangoOrderEntry(ModuleRootModel model) {
            return OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)DjangoFacetConfigurator.DJANGO_LIBRARY_NAME);
        }

        private static final void detectDjango$lambda$0(Module $module, VirtualFile $djangoRootPackage) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"getInstance(...)");
            LibraryOrderEntry entry = Companion.findDjangoOrderEntry((ModuleRootModel)moduleRootManager);
            if (entry != null) {
                Library lib = entry.getLibrary();
                if (lib != null) {
                    Companion.fillLib($djangoRootPackage, lib);
                }
            } else {
                Library library = LibraryTablesRegistrar.getInstance().getLibraryTable($module.getProject()).createLibrary(DjangoFacetConfigurator.DJANGO_LIBRARY_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"createLibrary(...)");
                Library lib = library;
                Companion.fillLib($djangoRootPackage, lib);
                ModuleRootModificationUtil.addDependency((Module)$module, (Library)lib);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

