/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.AuthType;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.ssh.SshMultistagePanelContext;
import com.jetbrains.gateway.ssh.panels.ChooseHostPanel;
import com.jetbrains.gateway.ssh.panels.LocateRemoteSshProjectPanel;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenSelectTabTopicKt;
import com.jetbrains.gateway.welcomeScreen.MultistagePanel;
import com.jetbrains.gateway.welcomeScreen.MultistagePanelContainer;
import com.jetbrains.gateway.welcomeScreen.MultistagePanelDelegate;
import com.jetbrains.gateway.welcomeScreen.WelcomeScreenTabSelectionListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/gateway/ssh/SshDeployView;", "Lcom/jetbrains/gateway/api/GatewayConnectorView;", "Lcom/jetbrains/gateway/welcomeScreen/MultistagePanelDelegate;", "Lcom/jetbrains/gateway/ssh/SshMultistagePanelContext;", "<init>", "()V", "component", "Lcom/jetbrains/gateway/welcomeScreen/MultistagePanelContainer;", "getComponent", "()Lcom/jetbrains/gateway/welcomeScreen/MultistagePanelContainer;", "onMultistagePanelDone", "", "context", "onMultistagePanelBack", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshDeployView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshDeployView.kt\ncom/jetbrains/gateway/ssh/SshDeployView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,48:1\n14#2:49\n*S KotlinDebug\n*F\n+ 1 SshDeployView.kt\ncom/jetbrains/gateway/ssh/SshDeployView\n*L\n18#1:49\n*E\n"})
public final class SshDeployView
implements GatewayConnectorView,
MultistagePanelDelegate<SshMultistagePanelContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultistagePanelContainer<SshMultistagePanelContext> component;
    @NotNull
    private static final Logger LOG;

    public SshDeployView() {
        SshMultistagePanelContext sshMultistagePanelContext = new SshMultistagePanelContext(null, 1, null);
        Object[] objectArray = new MultistagePanel[]{new ChooseHostPanel(), new LocateRemoteSshProjectPanel()};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this.component = new MultistagePanelContainer<SshMultistagePanelContext>(list, sshMultistagePanelContext, this);
    }

    @NotNull
    public MultistagePanelContainer<SshMultistagePanelContext> getComponent() {
        return this.component;
    }

    @Override
    public void onMultistagePanelDone(@NotNull SshMultistagePanelContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.info("Wizard is done. Starting SSH deployment flow");
        SshConfig sshConfig = context.getConfig();
        if (sshConfig != null) {
            SshConfig it = sshConfig;
            boolean bl = false;
            AuthType authType = it.getAuthType();
            Intrinsics.checkNotNullExpressionValue((Object)authType, (String)"getAuthType(...)");
            GatewayUsagesCollector.INSTANCE.onSshAuthTypeSelected(authType);
        }
        GatewayUI.Companion.getInstance().connect(context.toParameters(), (Function0<Unit>)((Function0)SshDeployView::onMultistagePanelDone$lambda$1));
    }

    @Override
    public void onMultistagePanelBack(@NotNull SshMultistagePanelContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GatewayUI.Companion.getInstance().reset();
        String lastVisited = GatewayUI.Companion.getInstance().getLastConnectorId();
        if (lastVisited != null) {
            ((WelcomeScreenTabSelectionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GatewayWelcomeScreenSelectTabTopicKt.getWELCOME_SCREEN_SELECT_TAB_TOPIC())).selectRecentConnectionsTab(lastVisited);
        }
    }

    private static final Unit onMultistagePanelDone$lambda$1() {
        GatewayUI.Companion.getInstance().reset();
        ((WelcomeScreenTabSelectionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GatewayWelcomeScreenSelectTabTopicKt.getWELCOME_SCREEN_SELECT_TAB_TOPIC())).selectRecentConnectionsTab("Gateway.SSH.Recent.Connections");
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshDeployView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/SshDeployView$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

